/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FillSmartTicketingFlagTaskConfiguration;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.tasks.BaseEntityUpdateTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.statistics.CollectStatisticsFlagPublisher;
import com.gridnine.xtrip.server.model.statistics.SendProductStatisticsInterceptor;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Element;

public class FillSmartTicketingFlagTask
extends BaseLongRunningTask<FillSmartTicketingFlagTaskConfiguration> {
    private final FillSmartTicketingFlagTaskDelegate delegate = new FillSmartTicketingFlagTaskDelegate();

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        AssetsStorage.get().save((BaseAsset)this.createTemporalObject("STARTED"));
        try {
            String licenseKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
            this.delegate.setLicenseKey(licenseKey);
            if (TextUtil.isBlank((String)licenseKey) || !CollectStatisticsFlagPublisher.isCollectStatistics()) {
                this.log.debug("statistics collection is disabled");
                AssetsStorage.get().save((BaseAsset)this.createTemporalObject("DISABLED"));
                callback.updateProgress((byte)100);
                callback.taskFinished();
                return;
            }
            this.delegate.doJob(callback);
        }
        catch (Exception e) {
            AssetsStorage.get().save((BaseAsset)this.createTemporalObject("ERROR\n" + TextUtil.getExceptionStackTrace((Throwable)e)));
            callback.updateProgress((byte)100);
            callback.taskFinished();
            return;
        }
        AssetsStorage.get().save((BaseAsset)this.createTemporalObject("FINISHED"));
    }

    private TemporalObject createTemporalObject(String status) {
        TemporalObject result = new TemporalObject();
        result.setUid("SMART_TICKETING_TASK_STATUS");
        result.setExpired(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(60L)));
        result.setTag("SMART_TICKETING_TASK_STATUS");
        result.setData(status.getBytes());
        return result;
    }

    @Override
    public void configure(FillSmartTicketingFlagTaskConfiguration configuration) throws Exception {
        BaseEntityUpdateTaskConfiguration delegateConfig = new BaseEntityUpdateTaskConfiguration();
        delegateConfig.setDate(new SimpleDateFormat("yyyy-MM-dd").parse("2020-03-31"));
        delegateConfig.setDescOrder(false);
        delegateConfig.setHours(24);
        delegateConfig.setStopOnError(false);
        delegateConfig.setThreadCount(3);
        delegateConfig.setUsedCreateDate(false);
        delegateConfig.getTypeList().add(BookingFile.class.getName());
        this.delegate.configure(delegateConfig);
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435: \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0444\u043b\u0430\u0433\u0430 Smart Ticketing 2", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        this.delegate.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.delegate.fromXML(elm);
    }

    static class FillSmartTicketingFlagTaskDelegate
    extends BaseEntityUpdateTask<BaseEntityUpdateTaskConfiguration> {
        private String licenseKey;

        FillSmartTicketingFlagTaskDelegate() {
        }

        void setLicenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
        }

        @Override
        protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
            super.doJob(callback);
        }

        @Override
        protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object data) throws Exception {
            BaseEntity ett = ctr.getEntity();
            if (ett instanceof BookingFile) {
                Product product;
                BookingFile bookingFile = (BookingFile)ett;
                boolean needUpdate = false;
                Boolean smartTicketing = null;
                for (Object res : bookingFile.getReservations()) {
                    if (!CommonReservationGdsNameInfoHelper.containsGds((Reservation)res, (GdsName)GdsName.valueOf((String)"AMADEUS"))) continue;
                    for (BaseProduct prod : res.getProducts()) {
                        if (!(prod instanceof BaseProduct)) continue;
                        product = (Product)prod;
                        if (product.getCreatedInSmartTicketing() == null) {
                            needUpdate = true;
                        }
                        if (product.getCreatedInSmartTicketing() == null) continue;
                        smartTicketing = product.getCreatedInSmartTicketing();
                    }
                }
                if (needUpdate) {
                    if (smartTicketing == null) {
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)ctr.toReference()));
                        query.getPreferredProperties().add(BasicDocumentIndex.Property.name.name());
                        for (BasicDocumentIndex idx : EntityStorage.get().search(BasicDocumentIndex.class, query).getData()) {
                            if (idx.getName() == null || !idx.getName().matches("[0-9]*_[A-Z,a-z]{2}.air")) continue;
                            smartTicketing = true;
                            break;
                        }
                    }
                    if (smartTicketing == null) {
                        smartTicketing = false;
                    }
                    for (Object res : bookingFile.getReservations()) {
                        if (!CommonReservationGdsNameInfoHelper.containsGds((Reservation)res, (GdsName)GdsName.valueOf((String)"AMADEUS"))) continue;
                        for (BaseProduct prod : res.getProducts()) {
                            if (!(prod instanceof BaseProduct)) continue;
                            product = (Product)prod;
                            product.setCreatedInSmartTicketing(smartTicketing);
                        }
                    }
                    ctr.getVersionInfo().setDataSource("server");
                    ctr.getVersionInfo().setVersionNotes("Fill SmartTicketing Flag task");
                    EntityStorage.get().save(ctr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                    SendProductStatisticsInterceptor.sendBookingSavedRequest(ctr, null, new Date(), this.licenseKey, false, null);
                }
            }
        }

        @Override
        protected Class<BaseEntityUpdateTaskConfiguration> getConfigurationClass() {
            return BaseEntityUpdateTaskConfiguration.class;
        }

        @Override
        public L10nMessage getDescription() {
            return null;
        }
    }
}

