/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.statistics.BookingRefWithTimeStamp;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.model.statistics.CollectStatisticsFlagPublisher;
import com.gridnine.xtrip.server.model.statistics.SendProductStatisticsInterceptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xml.sax.InputSource;

public class ResendProductStatisticsTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        String licenseKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
        if (TextUtil.isBlank((String)licenseKey)) {
            CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
            this.log.debug("license key is null, resend task cancelled");
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)"unsent-product-statistics"));
        query.getCriteria().getOrders().put(BaseAsset.Property.modified.name(), SortOrder.ASC);
        for (TemporalObject to : AssetsStorage.get().search(TemporalObject.class, query).getData()) {
            try {
                this.log.debug("temporal object with uid " + to.getUid());
                BookingRefWithTimeStamp data = new BookingRefWithTimeStamp();
                data.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(to.getData()))).getDocumentElement());
                if (data.isDeleted()) {
                    if (!EntityStorage.get().isAvailable(BookingFile.class, data.getBooking().getUid()) && !SendProductStatisticsInterceptor.sendBookingDeleteRequest((EntityReference<BookingFile>)data.getBooking(), data.getTimestamp(), licenseKey, false)) continue;
                    AssetsStorage.get().delete((BaseAsset)to);
                    this.log.debug(String.format("temporal object %s for booking %s deleted", to.getUid(), data.getBooking()));
                    continue;
                }
                EntityContainer bookingCtr = EntityStorage.get().resolve(data.getBooking());
                if (bookingCtr != null && !SendProductStatisticsInterceptor.sendBookingSavedRequest((EntityContainer<BookingFile>)bookingCtr, null, data.getTimestamp(), licenseKey, false, null)) continue;
                AssetsStorage.get().delete((BaseAsset)to);
                this.log.debug(String.format("temporal object %s for booking %s deleted", to.getUid(), data.getBooking()));
            }
            catch (Exception e) {
                this.log.debug("unable to resend statistics for temporal object " + to.getUid());
            }
        }
    }
}

