/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ResendStatisticsTaskConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.statistics.CollectStatisticsFlagPublisher;
import com.gridnine.xtrip.server.model.statistics.SendProductStatisticsInterceptor;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ResendStatisticsTask
extends BaseEntityUpdateTask<ResendStatisticsTaskConfiguration> {
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        try {
            CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
            if (!CollectStatisticsFlagPublisher.isCollectStatistics()) {
                TemporalObject temporalObject = this.getTemporalObject();
                temporalObject.setData("OFF".getBytes("utf-8"));
                AssetsStorage.get().save((BaseAsset)temporalObject);
                callback.taskFinished();
                return;
            }
        }
        catch (Exception e) {
            TemporalObject temporalObject = this.getTemporalObject();
            temporalObject.setData(String.format("ERROR: unable to check flag, details = %s", TextUtil.getExceptionStackTrace((Throwable)e)).getBytes("utf-8"));
            AssetsStorage.get().save((BaseAsset)temporalObject);
            callback.taskFinished();
            return;
        }
        final ValueHolder holder = new ValueHolder();
        super.doJob(new LongRunningTask.EventsCallback(){

            @Override
            public void addEvent(String eventId, Message description) {
                if (description.getType() == MessageType.ERROR) {
                    holder.setValue((Object)description);
                }
                callback.addEvent(eventId, description);
            }

            @Override
            public void updateProgress(byte progress) {
                callback.updateProgress(progress);
            }

            @Override
            public void taskFinished() {
                callback.taskFinished();
            }
        });
        TemporalObject temporalObject = this.getTemporalObject();
        if (this.errorCount.get() == 0) {
            temporalObject.setData("DONE".getBytes("utf-8"));
            AssetsStorage.get().save((BaseAsset)temporalObject);
            callback.taskFinished();
            return;
        }
        if (holder.getValue() != null) {
            temporalObject.setData(String.format("ERROR: %s: %s", ((Message)holder.getValue()).getMessage(), ((Message)holder.getValue()).getDetails()).getBytes("utf-8"));
            AssetsStorage.get().save((BaseAsset)temporalObject);
            callback.taskFinished();
            return;
        }
        temporalObject.setData("ERROR".getBytes("utf-8"));
        AssetsStorage.get().save((BaseAsset)temporalObject);
        callback.taskFinished();
    }

    private TemporalObject getTemporalObject() {
        TemporalObject temporalObject = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, "resend-statistics-task-data");
        if (temporalObject == null) {
            temporalObject = new TemporalObject();
            temporalObject.setUid("resend-statistics-task-data");
            temporalObject.setTag(temporalObject.getUid());
            temporalObject.setExpired(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(60L)));
        }
        return temporalObject;
    }

    @Override
    protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object data) throws Exception {
        if (!CollectStatisticsFlagPublisher.isCollectStatistics()) {
            return;
        }
        if (BookingFile.class.equals((Object)ctr.getEntityType())) {
            SendProductStatisticsInterceptor.sendBookingSavedRequest(ctr, null, new Date(), ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey"), false, null);
        }
    }

    @Override
    protected Class<ResendStatisticsTaskConfiguration> getConfigurationClass() {
        return ResendStatisticsTaskConfiguration.class;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435: \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u0430\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", (Object[])new Object[0]);
    }
}

