/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.CouponStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.statistics.BookingRefWithTimeStamp;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeEntry;
import com.gridnine.xtrip.common.model.booking.statistics.SendProductStatisticsEntry;
import com.gridnine.xtrip.common.model.booking.statistics.SendProductStatisticsRequest;
import com.gridnine.xtrip.common.model.booking.statistics.SendProductStatisticsResponse;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.interceptors.ProductBillingDataChangeInterceptor;
import com.gridnine.xtrip.server.model.statistics.CollectStatisticsFlagPublisher;
import com.gridnine.xtrip.server.model.statistics.ResendProductStatisticsTask;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProductStatisticsInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SendProductStatisticsInterceptor.class);
    public static final double priority = 999.0;

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ScheduledTaskSettings stt = this.getSettings(data);
        if (stt != null && LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getOldCtr() != null) {
            throw Xeption.forEndUser((String)"\u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0439 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", (Object[])new Object[0]);
        }
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        BookingFile bf = (BookingFile)data.getEntity();
        if (bf.isDraftState()) {
            log.debug(String.format("booking %s: is in draft state", bf.getNumber()));
            return;
        }
        if (bf.getWorkflowStatus() != null && "ERROR".equals(bf.getWorkflowStatus().name())) {
            log.debug(String.format("booking %s: workflow status is error", bf.getNumber()));
            return;
        }
        if (!CollectStatisticsFlagPublisher.isCollectStatistics()) {
            log.debug(String.format("booking %s: collectstatistics flag is false", bf.getNumber()));
            return;
        }
        String licenseKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
        if (TextUtil.isBlank((String)licenseKey)) {
            CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
            log.debug(String.format("booking %s: license key is null", bf.getNumber()));
            return;
        }
        log.debug("analyzing save booking " + bf.getNumber());
        SendProductStatisticsInterceptor.sendBookingSavedRequest(data, (EntityContainer<BookingFile>)LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr(), new Date(), licenseKey, true, ss);
    }

    public static boolean sendBookingSavedRequest(EntityContainer<BookingFile> data, EntityContainer<BookingFile> oldCtr, Date modifiedData, String licenseKey, boolean async, SessionCallback ss) throws Exception {
        SendProductStatisticsRequest request = SendProductStatisticsInterceptor.createBookingSavedRequest(data);
        if (oldCtr != null) {
            SendProductStatisticsRequest oldRequest = SendProductStatisticsInterceptor.createBookingSavedRequest(oldCtr);
            oldRequest.setUid(request.getUid());
            if (Arrays.equals(XSUtil.toByteArray((XSSerializable)request), XSUtil.toByteArray((XSSerializable)oldRequest))) {
                log.debug("content does not change for  booking " + ((BookingFile)data.getEntity()).getNumber());
                return true;
            }
        }
        request.setModifiedDate(modifiedData);
        request.setLicenseKey(licenseKey);
        EntityReference ref = data.toReference();
        if (async) {
            ss.addCallback((Callback & Serializable)callback -> AsyncExecutor.get().execute(SendProductStatisticsInterceptor.class.getName(), (AsyncCommand & Serializable)() -> SendProductStatisticsInterceptor.sendRequest(request, (EntityReference<BookingFile>)ref, true), new AsyncCommandOption[]{AsyncCommandOption.LOCAL}));
            return true;
        }
        return SendProductStatisticsInterceptor.sendRequest(request, (EntityReference<BookingFile>)ref, false);
    }

    public static SendProductStatisticsRequest createBookingSavedRequest(EntityContainer<BookingFile> data) {
        EntityActualizer actualizer = EntityActualizer.newInstance();
        SendProductStatisticsRequest request = new SendProductStatisticsRequest();
        request.setBookingUid(data.getUid());
        BookingFile bookingFile = (BookingFile)data.getEntity();
        if (bookingFile.isDraftState() || bookingFile.getWorkflowStatus() != null && "ERROR".equals(bookingFile.getWorkflowStatus().name())) {
            return request;
        }
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)bp);
                if (handler.getStatus(bp) == ProductStatus.EXCHANGE || handler.getTicketType(bp) == TicketType.FAKE) continue;
                GdsName gdsName = CommonReservationGdsNameInfoHelper.getStatisticsGdsName((Reservation)res);
                List<ProductBillingDataChangeEntry> changeDataEntries = SendProductStatisticsInterceptor.getChangeDataEntries(bp, data.getCreated());
                for (ProductBillingDataChangeEntry changeEntry : changeDataEntries) {
                    SendProductStatisticsEntry entry = new SendProductStatisticsEntry();
                    entry.setUid(changeEntry.getUid());
                    entry.setProductUid(bp.getUid());
                    if (changeEntry.getSource() != null) {
                        entry.setActionSource(changeEntry.getSource().name());
                    }
                    entry.setVersion(Integer.valueOf(changeEntry.getVersion()));
                    if (bp instanceof Product && Boolean.TRUE.equals(((Product)bp).getCreatedInSmartTicketing())) {
                        entry.setGdsName("SMART_TICKETING");
                    } else if (bp instanceof HotelProduct) {
                        HotelProduct hotelProduct = (HotelProduct)bp;
                        if (hotelProduct.getProvider() != null) {
                            entry.setGdsName(hotelProduct.getProvider().name());
                        } else if (gdsName != null) {
                            entry.setGdsName(gdsName.name());
                        }
                    } else if (gdsName != null) {
                        entry.setGdsName(gdsName.name());
                    }
                    if (changeEntry.getStatus() != null) {
                        entry.setStatus(changeEntry.getStatus().name());
                    }
                    Date issueDate = changeEntry.getDate();
                    entry.setIssueDate(MiscUtil.clearTime((Date)issueDate));
                    if (handler.getProductType(bp) != null) {
                        entry.setProductType(handler.getProductType(bp).name());
                    }
                    entry.setPnr(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res));
                    List productNumbers = handler.getProductNumbers(bp);
                    if (!productNumbers.isEmpty()) {
                        entry.setTicketNumber((String)productNumbers.get(0));
                    }
                    EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)bp);
                    actualizer.actualize((Object)agency);
                    entry.setAgency(agency);
                    EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)bp);
                    actualizer.actualize((Object)subagency);
                    entry.setSubagency(subagency);
                    DictionaryReference carrier = handler.getCarrier(bp);
                    if (carrier != null) {
                        Airline airline = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(carrier);
                        String iataOrCrtCode = DictHelper.getCodeVariant((BaseDictionary)airline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT));
                        entry.setCarrierCode(TextUtil.firstNonBlank((String[])new String[]{iataOrCrtCode, carrier.getCode(), "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e"}));
                    }
                    if (bp instanceof Product) {
                        entry.setHasUsedCoupons(AirProductHelper.getProductSegmentsStream((Product)((Product)bp)).anyMatch(segment -> segment.getCouponStatus() == CouponStatus.USED));
                        if (handler.getStatus(bp) == ProductStatus.SELL && bp.getSalesOriginContent() == SalesOriginContent.DIRECT_CHANNEL) {
                            entry.setSegments400(Integer.valueOf(AirProductHelper.getProductSegmentsList((Product)((Product)bp)).size()));
                            entry.setSalesOriginProvider(bp.getSalesOriginProvider().toString());
                        }
                    } else if (bp instanceof AdditionalServiceProduct && ((AdditionalServiceProduct)bp).getCategory() == AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT && !handler.getRelatedProducts(bp).isEmpty()) {
                        Product relatedProduct = (Product)handler.getRelatedProducts(bp).get(0);
                        entry.setHasUsedCoupons(AirProductHelper.getProductSegmentsStream((Product)relatedProduct).anyMatch(segment -> segment.getCouponStatus() == CouponStatus.USED));
                    }
                    request.getEntries().add(entry);
                    log.debug(String.format("added product %s with uid %s", entry.getTicketNumber(), bp.getUid()));
                }
            }
        }
        return request;
    }

    private static List<ProductBillingDataChangeEntry> getChangeDataEntries(BaseProduct bp, Date ctrCreateDate) {
        Date issueDate;
        if (!bp.getBillingDataChangeEntries().isEmpty()) {
            ArrayList<ProductBillingDataChangeEntry> entries = new ArrayList<ProductBillingDataChangeEntry>(bp.getBillingDataChangeEntries());
            ProductBillingDataChangeInterceptor.removeDuplicatedEntries(entries);
            return entries;
        }
        ProductBillingDataChangeEntry entry = new ProductBillingDataChangeEntry();
        entry.setUid(bp.getUid());
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)bp);
        entry.setVersion(0);
        if (handler.getStatus(bp) != null) {
            entry.setStatus(handler.getStatus(bp));
            if (handler.getStatus(bp) == ProductStatus.SELL && handler.getPreviousProduct(bp) != null && handler.getStatus(handler.getPreviousProduct(bp)) == ProductStatus.EXCHANGE) {
                entry.setStatus(ProductStatus.EXCHANGE);
            }
        }
        if ((issueDate = handler.findIssueDate(bp)) == null && (issueDate = ctrCreateDate) == null) {
            issueDate = new Date();
        }
        entry.setDate(MiscUtil.clearTime((Date)issueDate));
        return Collections.singletonList(entry);
    }

    private static boolean sendRequest(SendProductStatisticsRequest request, EntityReference<BookingFile> bfRef, boolean createTemporalObject) throws Exception {
        boolean successfull = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug("sending data for booking " + bfRef + " products " + request.getEntries().stream().map(BaseIdentity::getUid).collect(Collectors.toList()) + " deleted " + request.isBookingDeleted());
            }
            SynchronizationRequest<SendProductStatisticsRequest> r = new SynchronizationRequest<SendProductStatisticsRequest>();
            r.setUser(CollectStatisticsFlagPublisher.STATISTICS_USER);
            r.setOperationId(SendProductStatisticsRequest.class.getSimpleName());
            r.setClientId(Environment.getApplicationId());
            r.setData(request);
            SynchronizationResponse response = SynchronizationHelper.execute(r, Address.getSync(), null);
            Message errorMessage = response.getMessages().stream().filter(m -> m.getType() == MessageType.ERROR).findFirst().orElse(null);
            if (errorMessage != null) {
                log.error("error occured getting response: " + errorMessage.getMessage().toString());
                successfull = false;
            }
            if (response.getData() != null && ((SendProductStatisticsResponse)response.getData()).isCollectStatisticsIsDisabled()) {
                log.debug("collection of statistics is disabled");
                CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
                return true;
            }
            log.debug("data was successfully sent");
        }
        catch (Exception e) {
            log.error("unable to sent statistics for booking " + bfRef, (Throwable)e);
            successfull = false;
        }
        if (!successfull && createTemporalObject) {
            TemporalObject obj = new TemporalObject();
            BookingRefWithTimeStamp data = new BookingRefWithTimeStamp();
            data.setBooking(bfRef);
            data.setTimestamp(new Date());
            data.setDeleted(request.isBookingDeleted());
            obj.setData(XSUtil.toByteArray((XSSerializable)data));
            obj.setExpired(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L)));
            obj.setTag("unsent-product-statistics");
            AssetsStorage.get().save((BaseAsset)obj);
            log.debug("temporal object created with uid " + obj.getUid());
        }
        return successfull;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ScheduledTaskSettings stt = this.getSettings(data);
        if (stt != null) {
            throw Xeption.forEndUser((String)"\u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0439 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", (Object[])new Object[0]);
        }
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        BookingFile bf = (BookingFile)data.getEntity();
        if (!CollectStatisticsFlagPublisher.isCollectStatistics()) {
            log.debug(String.format("booking %s: collectstatistics flag is false", bf.getNumber()));
            return;
        }
        String licenseKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
        if (TextUtil.isBlank((String)licenseKey)) {
            CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
            log.debug(String.format("booking %s: license key is null", bf.getNumber()));
            return;
        }
        SendProductStatisticsInterceptor.sendBookingDeleteRequest((EntityReference<BookingFile>)data.toReference(), new Date(), licenseKey, true);
    }

    public static boolean sendBookingDeleteRequest(EntityReference<BookingFile> ref, Date date, String licenseKey, boolean async) throws Exception {
        SendProductStatisticsRequest request = new SendProductStatisticsRequest();
        request.setBookingUid(ref.getUid());
        request.setModifiedDate(date);
        request.setBookingDeleted(true);
        request.setLicenseKey(licenseKey);
        log.debug("analyzing delete of booking " + ref);
        if (async) {
            AsyncExecutor.get().execute(SendProductStatisticsInterceptor.class.getName(), (AsyncCommand & Serializable)() -> SendProductStatisticsInterceptor.sendRequest(request, ref, true), new AsyncCommandOption[0]);
            return true;
        }
        return SendProductStatisticsInterceptor.sendRequest(request, ref, false);
    }

    public double getPriority() {
        return 999.0;
    }

    private ScheduledTaskSettings getSettings(EntityContainer<?> data) {
        if (ScheduledTaskSettings.class.equals((Object)data.getEntityType())) {
            ScheduledTaskSettings stt = (ScheduledTaskSettings)data.getEntity();
            if (ResendProductStatisticsTask.class.getName().equals(stt.getJobClass())) {
                return stt;
            }
        }
        return null;
    }
}

