/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeDataSource;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeEntry;
import com.gridnine.xtrip.common.model.booking.statistics.UpdateProductSalesStatisticsTaskConfiguration;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.tasks.BaseEntityUpdateTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class UpdateProductSalesStatisticsTask
extends BaseLongRunningTask<UpdateProductSalesStatisticsTaskConfiguration> {
    private UpdateProductSalesStatisticsTaskDelegate delegate = new UpdateProductSalesStatisticsTaskDelegate();

    @Override
    public void configure(UpdateProductSalesStatisticsTaskConfiguration configuration) throws Exception {
        UpdateProductSalesStatisticsDelegateTaskConfiguration delegateConfig = new UpdateProductSalesStatisticsDelegateTaskConfiguration();
        delegateConfig.setDate(MiscUtil.clearTime((Date)configuration.getStartDate()));
        delegateConfig.setDescOrder(false);
        delegateConfig.setStopOnError(false);
        delegateConfig.setHours(24);
        delegateConfig.setThreadCount(configuration.getThreadsCount());
        delegateConfig.setUsedCreateDate(false);
        delegateConfig.getTypeList().add(BookingFile.class.getName());
        delegateConfig.setForce(configuration.isForce());
        this.delegate.configure(delegateConfig);
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(UpdateProductSalesStatisticsTaskConfiguration.class), (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.delegate.doJob(callback);
    }

    public void toXML(Element elm) throws Exception {
        this.delegate.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.delegate.fromXML(elm);
    }

    static class UpdateProductSalesStatisticsTaskDelegate
    extends BaseEntityUpdateTask<UpdateProductSalesStatisticsDelegateTaskConfiguration> {
        UpdateProductSalesStatisticsTaskDelegate() {
        }

        @Override
        protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object data) throws Exception {
            Map<Integer, EntityContainer<BookingFile>> containersCache = null;
            BookingFile bookingFile = (BookingFile)ctr.getEntity();
            boolean changed = false;
            for (Reservation res : bookingFile.getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    int n;
                    if (prod.isBillingDataChangeEntriesInitialized() && !((UpdateProductSalesStatisticsDelegateTaskConfiguration)this.config).isForce()) continue;
                    if (containersCache == null) {
                        containersCache = this.createContainersCache(ctr);
                    }
                    ArrayList currentData = new ArrayList(prod.getBillingDataChangeEntries());
                    prod.getBillingDataChangeEntries().clear();
                    Date historyStartDate = currentData.isEmpty() ? null : ((ProductBillingDataChangeEntry)currentData.get(0)).getDate();
                    ProductStatus historyStatus = currentData.isEmpty() ? null : ((ProductBillingDataChangeEntry)currentData.get(0)).getStatus();
                    ProductStatus lastStatus = null;
                    int idx = 0;
                    for (n = 0; n < containersCache.size(); ++n) {
                        ProductHandler handler;
                        ProductStatus status;
                        EntityContainer<BookingFile> oldCtr = containersCache.get(n);
                        if (historyStartDate != null && oldCtr.getVersionInfo().getModified().after(historyStartDate)) break;
                        BaseProduct oldProduct = BookingHelper.findProduct((BookingFile)((BookingFile)oldCtr.getEntity()), (String)prod.getUid());
                        if (oldProduct == null || (status = (handler = GeneralProductHelper.getHandler((BaseProduct)oldProduct)).getStatus(oldProduct)) == ProductStatus.EXCHANGE || status == null || status == lastStatus) continue;
                        ProductBillingDataChangeEntry entry = new ProductBillingDataChangeEntry();
                        entry.setDate(oldCtr.getVersionInfo().getModified());
                        entry.setSource(this.getDataSource(oldCtr));
                        entry.setStatus(status);
                        if (handler.getStatus(oldProduct) == ProductStatus.SELL && handler.getPreviousProduct(oldProduct) != null && handler.getStatus(handler.getPreviousProduct(oldProduct)) == ProductStatus.EXCHANGE) {
                            entry.setStatus(ProductStatus.EXCHANGE);
                        }
                        entry.setVersion(idx);
                        ++idx;
                        prod.getBillingDataChangeEntries().add(entry);
                        lastStatus = status;
                    }
                    if (!prod.getBillingDataChangeEntries().isEmpty()) {
                        ProductBillingDataChangeEntry lastEntry = (ProductBillingDataChangeEntry)prod.getBillingDataChangeEntries().get(prod.getBillingDataChangeEntries().size() - 1);
                        if (historyStatus != null && lastEntry.getStatus() == historyStatus) {
                            prod.getBillingDataChangeEntries().remove(lastEntry);
                        }
                    }
                    prod.getBillingDataChangeEntries().addAll(currentData);
                    for (n = 0; n < prod.getBillingDataChangeEntries().size(); ++n) {
                        ((ProductBillingDataChangeEntry)prod.getBillingDataChangeEntries().get(n)).setVersion(n);
                    }
                    prod.setBillingDataChangeEntriesInitialized(true);
                    changed = true;
                }
            }
            if (changed) {
                ctr.getVersionInfo().setDataSource("update sales statistics task");
                EntityStorage.get().save(ctr, true, ((EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors()).dontTouchTheIndexes(true));
            }
        }

        private <E extends BaseEntity> ProductBillingDataChangeDataSource getDataSource(EntityContainer<E> ctr) {
            if (ctr.getVersionInfo().getDataSource() != null && ctr.getVersionInfo().getDataSource().startsWith("fx-")) {
                return ProductBillingDataChangeDataSource.CLIENT;
            }
            if (ctr.getVersionInfo().getVersionNotes() != null && ctr.getVersionInfo().getVersionNotes().contains("created by parser")) {
                return ProductBillingDataChangeDataSource.EXCHANGE_FILE;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Integer, EntityContainer<BookingFile>> createContainersCache(EntityContainer<BookingFile> ctr) {
            HashMap<Integer, EntityContainer<BookingFile>> result = new HashMap<Integer, EntityContainer<BookingFile>>();
            LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
            try {
                for (int n = ctr.getVersionsCount() - 2; n >= 0; --n) {
                    result.put(n, LogicalStorage.get().getEntityStorage().load(BookingFile.class, ctr.getUid(), Integer.valueOf(n), new EntityStorageLoadParameters()));
                }
            }
            finally {
                LogicalStorage.get().cancelUnitOfWork(ls);
            }
            result.put(ctr.getVersionsCount() - 1, ctr);
            return result;
        }

        @Override
        protected Class<UpdateProductSalesStatisticsDelegateTaskConfiguration> getConfigurationClass() {
            return UpdateProductSalesStatisticsDelegateTaskConfiguration.class;
        }

        @Override
        public L10nMessage getDescription() {
            return null;
        }

        @Override
        protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
            super.doJob(callback);
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeBoolean((Element)elm, (String)"force", (boolean)((UpdateProductSalesStatisticsDelegateTaskConfiguration)this.config).isForce());
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            super.fromXML(elm);
            ((UpdateProductSalesStatisticsDelegateTaskConfiguration)this.config).setForce(XHelper.readBoolean((Element)elm, (String)"force", (boolean)false));
        }
    }

    public static class UpdateProductSalesStatisticsDelegateTaskConfiguration
    extends BaseEntityUpdateTaskConfiguration {
        private boolean force;

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }
    }
}

