/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.stockcontrol;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.BlankProductLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.OrderItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderStatus;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderType;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterStockOrderHelper {
    private static final Logger log = LoggerFactory.getLogger(RegisterStockOrderHelper.class);

    public static Set<Message> registerBlanks(EntityContainer<StockOrder> orderContainer) throws Exception {
        LinkedHashSet<Message> result = new LinkedHashSet<Message>();
        RestrictionResourceProxy proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies(orderContainer, (String)ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId()).get(((StockOrder)orderContainer.getEntity()).getUid());
        boolean granted = AclHelper.isGranted((RestrictionResourceProxy)proxy, (String)ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
        if (!granted) {
            RegisterStockOrderHelper.addMessage(result, MessageType.ERROR, Messages.RegisterStockOrderHelper_noRightChange, null, orderContainer.toReference());
            return result;
        }
        granted = AclHelper.isGranted(null, (String)ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.CREATE.getId(), Collections.emptyList());
        if (!granted) {
            RegisterStockOrderHelper.addMessage(result, MessageType.ERROR, Messages.RegisterStockOrderHelper_noRightChange, null, StockBlank.class.getName());
            return result;
        }
        if (!RegisterStockOrderHelper.canRegisterBlanks(orderContainer, result)) {
            return result;
        }
        StockOrder order = (StockOrder)orderContainer.getEntity();
        if (order.getRegistrationDate() == null) {
            order.setRegistrationDate(new Date());
        }
        try {
            int count = 0;
            switch (order.getType()) {
                case VENDOR: {
                    for (OrderItem item : order.getItems()) {
                        count += RegisterStockOrderHelper.registerVendorBlanks(item, orderContainer, result);
                    }
                    break;
                }
                case TRANSFER: {
                    for (OrderItem item : order.getItems()) {
                        count += RegisterStockOrderHelper.registerTransferBlanks(item, orderContainer, result);
                    }
                    break;
                }
            }
            if (count > 0) {
                order.setStatus(StockOrderStatus.REGISTERED);
            }
            EntityStorage.get().save(orderContainer, true);
            RegisterStockOrderHelper.addMessage(result, MessageType.MESSAGE, "StockControlDao_BlanksRegistered", null, String.valueOf(count));
        }
        catch (Exception e) {
            RegisterStockOrderHelper.addMessage(result, MessageType.ERROR, "StockControlDao_OrderRegisterError", e, new Object[0]);
        }
        return result;
    }

    private static int registerTransferBlanks(OrderItem item, EntityContainer<StockOrder> orderContainer, Set<Message> messages) throws Exception {
        LinkedHashSet relatedOrders = new LinkedHashSet();
        StockOrder order = (StockOrder)orderContainer.getEntity();
        int result = 0;
        HashSet<EntityReference<BookingFile>> bookings = new HashSet<EntityReference<BookingFile>>();
        int i = 0;
        while ((long)i < item.getBlanksCount()) {
            String string = FormattedNumberUtil.add((String)item.getFirstBlankNumber(), (long)i);
            EntityReference<StockBlank> blankReference = RegisterStockOrderHelper.isBlankAcceptedToTransfer(string, item, orderContainer, messages);
            if (blankReference != null) {
                EntityContainer blankContainer = EntityStorage.get().resolve(blankReference);
                StockBlank blank = (StockBlank)blankContainer.getEntity();
                relatedOrders.addAll(blank.getOrders());
                if (RegisterStockOrderHelper.receiverIsSupplier((EntityReference<? extends BaseProfile>)blank.getSupplier(), (EntityReference<? extends BaseProfile>)((StockOrder)orderContainer.getEntity()).getReceiver(), messages)) {
                    blank.setCurrentLocation(null);
                    blank.setOperationDate(order.getRegistrationDate());
                    blank.setUsageStatus(UsageStatus.RETURN);
                } else {
                    blank.setCurrentLocation(order.getReceiver());
                }
                blank.getOrders().add(orderContainer.toReference());
                blank.setReserved(false);
                if (order.getReceiver() != null) {
                    EntityReference<BookingFile> booking;
                    String clsName = order.getReceiver().getType().getName();
                    if ((Person.class.getName().equals(clsName) || SalesPoint.class.getName().equals(clsName)) && (booking = RegisterStockOrderHelper.bindToProduct(blank, order, messages)) != null) {
                        bookings.add(booking);
                    }
                }
                RegisterStockOrderHelper.addOrderLogItem(blank, orderContainer);
                EntityStorage.get().save(blankContainer, false);
                ++result;
            }
            ++i;
        }
        for (EntityReference entityReference : bookings) {
            EntityContainer container = EntityStorage.get().resolve(entityReference);
            if (container == null) continue;
            EntityStorage.get().save(container, false);
        }
        LinkedHashSet oldOrders = new LinkedHashSet(order.getRelatedOrders());
        oldOrders.addAll(relatedOrders);
        order.getRelatedOrders().clear();
        order.getRelatedOrders().addAll(oldOrders);
        return result;
    }

    private static boolean receiverIsSupplier(EntityReference<? extends BaseProfile> supplier, EntityReference<? extends BaseProfile> receiver, Set<Message> messages) throws Exception {
        if (supplier == null || !Organization.class.equals((Object)supplier.getType()) || receiver == null || !Organization.class.equals((Object)receiver.getType())) {
            return false;
        }
        return receiver.getUid().equals(supplier.getUid());
    }

    private static EntityReference<BookingFile> bindToProduct(StockBlank result, StockOrder order, Set<Message> messages) throws Exception {
        String blankNumber = result.getNumber();
        ProductSearchResult searchResult = RegisterStockOrderHelper.findProductByScnAndDate(blankNumber, order.getRegistrationDate(), 31536000000L, ProductStatus.EXCHANGE);
        if (searchResult == null) {
            searchResult = RegisterStockOrderHelper.findProductByScnAndDate(blankNumber, order.getRegistrationDate(), 31536000000L, ProductStatus.REFUND);
        }
        if (searchResult == null) {
            searchResult = RegisterStockOrderHelper.findProductByScnAndDate(blankNumber, order.getRegistrationDate(), 31536000000L, ProductStatus.VOID);
        }
        if (searchResult == null) {
            searchResult = RegisterStockOrderHelper.findProductByScnAndDate(blankNumber, order.getRegistrationDate(), 31536000000L, ProductStatus.SELL);
        }
        if (searchResult != null) {
            if (!searchResult.isUnique()) {
                RegisterStockOrderHelper.addMessage(messages, MessageType.WARNING, "StockControlDao_FewProductsFound", null, blankNumber);
            }
            if (RegisterStockOrderHelper.updateFromProduct(searchResult.getContainer(), searchResult.getProduct(), result, messages)) {
                return searchResult.getContainer().toReference();
            }
        }
        return null;
    }

    private static ProductSearchResult findProductByScnAndDate(String blankNumber, Date registrationDate, long treshold, ProductStatus exchange) throws Exception {
        for (StockControlProductHandler<?, ?, ?> handler : ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllStockControlHandlers()) {
            ProductSearchResult res = handler.findProductByScnAndDate(blankNumber, registrationDate, treshold, exchange);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static void addOrderLogItem(StockBlank blank, EntityContainer<StockOrder> orderContainer) {
        BlankOrderLogItem logItem;
        BlankOrderLogItem blankOrderLogItem = logItem = !blank.getOrderLogItems().isEmpty() ? (BlankOrderLogItem)blank.getOrderLogItems().get(blank.getOrderLogItems().size() - 1) : null;
        if (logItem == null || !RegisterStockOrderHelper.isSame(logItem, orderContainer)) {
            logItem = new BlankOrderLogItem();
            blank.getOrderLogItems().add(logItem);
        }
        logItem.setOrder(orderContainer.toReference());
        logItem.setOrderType(((StockOrder)orderContainer.getEntity()).getType());
        logItem.setOperationDate(((StockOrder)orderContainer.getEntity()).getRegistrationDate());
        logItem.setBlankLocation(blank.getCurrentLocation());
    }

    private static boolean isSame(BlankOrderLogItem logItem, EntityContainer<StockOrder> orderContainer) {
        if (logItem.getOrder() != null && !logItem.getOrder().equals((Object)orderContainer.toReference())) {
            return false;
        }
        return MiscUtil.compare((Date)logItem.getOperationDate(), (Date)((StockOrder)orderContainer.getEntity()).getCreated()) == 0;
    }

    private static int registerVendorBlanks(OrderItem item, EntityContainer<StockOrder> orderContainer, Set<Message> messages) throws Exception {
        int result = 0;
        int i = 0;
        while ((long)i < item.getBlanksCount()) {
            block5: {
                String blankNumber;
                block4: {
                    blankNumber = FormattedNumberUtil.add((String)item.getFirstBlankNumber(), (long)i);
                    try {
                        if (RegisterStockOrderHelper.countBlanks((EntityReference<? extends BaseProfile>)item.getOwner(), blankNumber, item.getBlankType().getCode()) > 0) {
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_SearchBlankInStockError", e, blankNumber);
                    }
                    break block5;
                }
                RegisterStockOrderHelper.createBlank(blankNumber, item, orderContainer, messages);
                ++result;
            }
            ++i;
        }
        return result;
    }

    private static void createBlank(String blankNumber, OrderItem item, EntityContainer<StockOrder> orderContainer, Set<Message> messages) throws Exception {
        EntityContainer container = new EntityContainer(StockBlank.class);
        String user = LogicalStorage.get().getUser();
        Date createDate = new Date();
        container.setCreated(createDate);
        container.setCreatedBy(user);
        container.setModified(createDate);
        container.setModifiedBy(user);
        container.getVersionInfo().setDataSource("create-stock-blank");
        StockOrder order = (StockOrder)orderContainer.getEntity();
        StockBlank result = (StockBlank)container.getEntity();
        result.setNumber(blankNumber);
        result.setCurrentLocation(order.getReceiver());
        result.setOwner(item.getOwner());
        result.setStockHolder(order.getStockHolder());
        result.setDestination(item.getDestination());
        result.setSupplier(order.getSupplier());
        result.setType(item.getBlankType());
        result.setTariffType(item.getTariffType());
        result.setRegistrationDate(order.getRegistrationDate());
        result.setReservationOrder(orderContainer.toReference());
        result.getOrders().add(orderContainer.toReference());
        result.setUsageStatus(UsageStatus.NEW);
        RegisterStockOrderHelper.addOrderLogItem(result, orderContainer);
        EntityStorage.get().save(container, true);
    }

    private static <P extends BaseProduct> boolean updateFromProduct(EntityContainer<BookingFile> bookingContainer, P product, StockBlank blank, Set<Message> messages) {
        if (product == null) {
            return false;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if (blank == null || handler.getSCNs(product).isEmpty() || TextUtil.isBlank((String)blank.getNumber()) || blank.getUsageStatus() != UsageStatus.NEW && blank.getUsageStatus() != UsageStatus.SELL || handler.getTicketType(product) == TicketType.EXTERNAL || handler.getTicketType(product) == TicketType.FAKE || handler.getTicketType(product) == TicketType.CORRECTION || handler.getTicketType(product) == TicketType.NOT_OWN) {
            return false;
        }
        boolean inRange = false;
        for (String scn : handler.getSCNs(product)) {
            if (!blank.getNumber().equals(scn)) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            return false;
        }
        blank.setValidatorCode(handler.getValidator(product));
        blank.setProductUid(product.getUid());
        blank.setProductNumber(RegisterStockOrderHelper.buildProductNumber(product, blank.getNumber()));
        blank.setBookingFile(bookingContainer.toReference());
        RegisterStockOrderHelper.changeBlankUsageStatus(blank, product);
        if (handler.getPreviousProduct(product) != null && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.SELL) {
            RegisterStockOrderHelper.registerProductLogItem(bookingContainer, handler.getPreviousProduct(product), blank, messages);
        }
        RegisterStockOrderHelper.registerProductLogItem(bookingContainer, product, blank, messages);
        return true;
    }

    public static <P extends BaseProduct> String buildProductNumber(P product, String number) {
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if (handler.getConjCount(product) == 0) {
            return handler.getSystemNumber(product);
        }
        ArrayList<String> lst = new ArrayList<String>(handler.getSCNs(product));
        Collections.sort(lst);
        int index = lst.indexOf(number);
        return handler.getSystemNumber(product) + "/" + (index >= 0 ? index : 0);
    }

    public static <P extends BaseProduct> void changeBlankUsageStatus(StockBlank blank, P product) {
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        switch (handler.getStatus(product)) {
            case SELL: 
            case REFUND: 
            case EXCHANGE: {
                blank.setUsageStatus(UsageStatus.SELL);
                blank.setOperationDate(RegisterStockOrderHelper.getOperationDate(product));
                break;
            }
            case VOID: {
                blank.setUsageStatus(UsageStatus.VOID);
                if (blank.getOperationDate() != null) break;
                blank.setOperationDate(RegisterStockOrderHelper.getOperationDate(product));
            }
        }
    }

    public static <P extends BaseProduct> void registerProductLogItem(EntityContainer<BookingFile> bookingContainer, P product, StockBlank blank, Set<Message> messages) {
        if (product == null) {
            return;
        }
        BlankProductLogItem item = null;
        List productLogItems = blank.getProductLogItems();
        if (!productLogItems.isEmpty()) {
            item = (BlankProductLogItem)productLogItems.get(productLogItems.size() - 1);
        }
        if (item == null || !RegisterStockOrderHelper.isSame(item, product)) {
            item = new BlankProductLogItem();
            productLogItems.add(item);
        }
        item.setBookingFile(bookingContainer.toReference());
        RegisterStockOrderHelper.update(item, blank, product, messages);
    }

    private static <P extends BaseProduct> void update(BlankProductLogItem item, StockBlank blank, P product, Set<Message> messages) {
        String scns;
        if (item == null) {
            return;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        item.setProductUid(product.getUid());
        item.setProductStatus(handler.getStatus(product));
        item.setOperationDate(handler.getIssueDate(product));
        item.setProductTitle(BookingHelper.generateProductName(product));
        String ticketNumber = handler.getSystemNumber(product);
        if (handler.getConjCount(product) > 0) {
            ticketNumber = ticketNumber + " / " + handler.getConjCount(product);
        }
        item.setTicketNumber(ticketNumber);
        item.setBlankLocation(handler.getSubagency(product));
        item.setTraveller(handler.getTraveller(product) != null ? handler.getTraveller(product).getName() : null);
        String string = scns = !handler.getSCNs(product).isEmpty() ? handler.getSCNs(product).get(0) : null;
        if (handler.getSCNs(product).size() > 1) {
            scns = scns + " / " + (handler.getSCNs(product).size() - 1);
        }
        item.setBlankNumber(scns);
    }

    private static <P extends BaseProduct> boolean isSame(BlankProductLogItem item, P product) {
        if (!item.getProductUid().equals(product.getUid())) {
            return false;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if (item.getProductStatus() == ProductStatus.SELL && handler.getStatus(product) == ProductStatus.VOID) {
            return true;
        }
        if (item.getProductStatus() == ProductStatus.VOID && handler.getStatus(product) == ProductStatus.SELL) {
            return true;
        }
        return item.getProductStatus() == handler.getStatus(product);
    }

    private static boolean canRegisterBlanks(EntityContainer<StockOrder> orderContainer, Set<Message> messages) throws Exception {
        if (orderContainer == null) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_OrderContainerIsNull", null, new Object[0]);
            return false;
        }
        StockOrder order = (StockOrder)orderContainer.getEntity();
        List allItems = order.getItems();
        if (order.getStatus() != StockOrderStatus.NEW) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NotNewStatus", null, new Object[0]);
            return false;
        }
        if (allItems.isEmpty()) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_ItemsEmpty", null, new Object[0]);
            return false;
        }
        if (TextUtil.isBlank((String)order.getNumber())) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoNumber", null, new Object[0]);
            return false;
        }
        if (order.getCreated() == null) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoCreateDate", null, new Object[0]);
            return false;
        }
        if (order.getReceiver() == null) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoReciever", null, new Object[0]);
            return false;
        }
        switch (order.getType()) {
            case VENDOR: {
                if (order.getSupplier() == null) {
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoSupplier", null, new Object[0]);
                    return false;
                }
                if (order.getStockHolder() == null) {
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoStockHolder", null, new Object[0]);
                    return false;
                }
                TariffType transpType = null;
                for (OrderItem item : allItems) {
                    if (transpType == null) {
                        transpType = item.getTariffType();
                    } else if (!transpType.equals((Object)item.getTariffType())) {
                        if (order.getSupplier() == null) {
                            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_DifferentTariffTypes", null, new Object[0]);
                            return false;
                        }
                        return false;
                    }
                    if (item.getOwner() == null) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoOwner", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                        return false;
                    }
                    if (item.getBlanksCount() <= 0L) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoBlanks", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                        return false;
                    }
                    if (TextUtil.isBlank((String)item.getFirstBlankNumber())) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoFirstBlank", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                        return false;
                    }
                    if (item.getBlankType() != null) continue;
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoBlankType", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                    return false;
                }
                break;
            }
            case TRANSFER: {
                if (order.getSender() == null) {
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoSender", null, new Object[0]);
                    return false;
                }
                for (OrderItem item : allItems) {
                    if (item.getOwner() == null) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoOwner", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                        return false;
                    }
                    if (item.getBlanksCount() <= 0L) {
                        RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoBlanks", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                        return false;
                    }
                    if (!TextUtil.isBlank((String)item.getFirstBlankNumber())) continue;
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_NoFirstBlank", null, item.getFirstBlankNumber(), item.getLastBlankNumber());
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static EntityReference<StockBlank> isBlankAcceptedToTransfer(String blankNumber, OrderItem item, EntityContainer<StockOrder> orderContainer, Set<Message> messages) {
        try {
            EntityStorage es = EntityStorage.get();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)item.getOwner().getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.number.name(), (Object)blankNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW), SearchCriterion.ne((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.RETURN)})}));
            List data = es.search(StockBlankIndex.class, query).getData();
            if (data.size() == 0) {
                RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_BlankNotFound", null, blankNumber);
                return null;
            }
            if (data.size() > 1) {
                RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_FewBlanksFound", null, blankNumber);
                return null;
            }
            StockBlankIndex blankIndex = (StockBlankIndex)data.get(0);
            EntityReference currentLocation = blankIndex.getCurrentLocation();
            if (currentLocation == null || !currentLocation.equals((Object)((StockOrder)orderContainer.getEntity()).getSender())) {
                RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_WrongCurrentLocation", null, blankNumber, currentLocation != null ? currentLocation.toString() : null);
                return null;
            }
            if (RegisterStockOrderHelper.receiverIsSupplier((EntityReference<? extends BaseProfile>)blankIndex.getSupplier(), (EntityReference<? extends BaseProfile>)((StockOrder)orderContainer.getEntity()).getReceiver(), messages)) {
                if (!blankIndex.getStockHolder().getUid().equals(blankIndex.getCurrentLocation().getUid())) {
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, String.format("\u0411\u043b\u0430\u043d\u043a \u2116%s. \u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0431\u043b\u0430\u043d\u043a\u0430 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0434\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u043e\u043a\u0430 \u0431\u043b\u0430\u043d\u043a\u0430. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430", blankIndex.getNumber()), null, blankNumber);
                    return null;
                }
                if (blankIndex.getUsageStatus() != UsageStatus.NEW) {
                    RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "\u0421\u0442\u0430\u0442\u0443\u0441 \u0431\u043b\u0430\u043d\u043a\u0430 \u043d\u0435 \"\u041d\u043e\u0432\u044b\u0439\". \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430", null, blankNumber);
                    return null;
                }
            }
            return blankIndex.getSource();
        }
        catch (Exception e) {
            RegisterStockOrderHelper.addMessage(messages, MessageType.ERROR, "StockControlDao_SearchBlankInStockError", e, item.getFirstBlankNumber());
            return null;
        }
    }

    private static int countBlanks(EntityReference<? extends BaseProfile> owner, String blankNumber, String blankTypeCode) throws Exception {
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)owner.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.number.name(), (Object)blankNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.type.name(), (Object)blankTypeCode));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW), SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.SELL), SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.VOID)}));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return es.search(StockBlankIndex.class, query).getTotalCount();
    }

    private static void addMessage(Set<Message> messages, MessageType messageType, String key, Exception e, Object ... parameters) {
        messages.add(RegisterStockOrderHelper.createMessage(messageType, key, e, parameters));
    }

    public static Message createMessage(MessageType messageType, String key, Exception e, Object ... parameters) {
        Message result = new Message();
        result.setType(messageType);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        if (e != null) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            result.setDetails(writer.toString());
        }
        return result;
    }

    public static Message unregisterBlanks(EntityContainer<StockOrder> orderContainer) throws Exception {
        if (orderContainer == null) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_OrderContainerIsNull", null, new Object[0]);
        }
        RestrictionResourceProxy proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies(orderContainer, (String)ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId()).get(((StockOrder)orderContainer.getEntity()).getUid());
        boolean granted = AclHelper.isGranted((RestrictionResourceProxy)proxy, (String)ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
        if (!granted) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, Messages.RegisterStockOrderHelper_noRightChange, null, orderContainer.toReference());
        }
        StockOrder order = (StockOrder)orderContainer.getEntity();
        if (order.getStatus() == StockOrderStatus.NEW) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_NewStatus", null, new Object[0]);
        }
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)StockOrderIndex.Property.relatedOrders.name(), (Object)orderContainer.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockOrderIndex.Property.status.name(), (Object)StockOrderStatus.REGISTERED));
        int totalCount = EntityStorage.get().search(StockOrderIndex.class, query).getTotalCount();
        if (totalCount > 0) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_hasRelatedOrders", null, String.valueOf(totalCount));
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query2 = new SearchQuery();
        query2.getCriteria().getCriterions().add(SearchCriterion.contains((String)StockBlankIndex.Property.orders.name(), (Object)orderContainer.getUid()));
        for (StockBlankIndex index : es.search(StockBlankIndex.class, query2).getData()) {
            EntityContainer container = es.resolve(index.getSource());
            StockBlank stockBlank = (StockBlank)container.getEntity();
            proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies((EntityContainer)container, (String)ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId()).get(stockBlank.getUid());
            granted = AclHelper.isGranted((RestrictionResourceProxy)proxy, (String)ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.DELETE.getId(), Collections.emptyList());
            if (!granted) {
                return RegisterStockOrderHelper.createMessage(MessageType.ERROR, Messages.RegisterStockOrderHelper_noRightDelete, null, StockBlank.class.getName());
            }
            stockBlank.getOrders().remove(orderContainer.toReference());
            if (order.getType() == StockOrderType.VENDOR) {
                es.delete(container);
                continue;
            }
            BlankOrderLogItem item = null;
            for (BlankOrderLogItem li : stockBlank.getOrderLogItems()) {
                if (li.getOrder() == null || !li.getOrder().equals((Object)orderContainer.toReference())) continue;
                item = li;
                break;
            }
            if (item != null) {
                stockBlank.getOrderLogItems().remove(item);
            }
            stockBlank.setCurrentLocation(order.getSender());
            if (stockBlank.getUsageStatus() == UsageStatus.RETURN) {
                stockBlank.setOperationDate(null);
                stockBlank.setUsageStatus(UsageStatus.NEW);
            }
            es.save(container, false);
        }
        order.setStatus(StockOrderStatus.NEW);
        es.save(orderContainer, false);
        return null;
    }

    public static Message changeBlankProperties(EntityContainer<StockBlank> data, Date date, UsageStatus usageStatus, String validator) throws Exception {
        EntityContainer container;
        if (usageStatus == null && TextUtil.isBlank((String)validator)) {
            return null;
        }
        if (data == null) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_BlankContainerIsNull", null, new Object[0]);
        }
        RestrictionResourceProxy proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies(data, (String)ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId()).get(((StockBlank)data.getEntity()).getUid());
        boolean granted = AclHelper.isGranted((RestrictionResourceProxy)proxy, (String)ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
        if (!granted) {
            return RegisterStockOrderHelper.createMessage(MessageType.ERROR, Messages.RegisterStockOrderHelper_noRightChange, null, data.toReference());
        }
        EntityStorage es = EntityStorage.get();
        EntityReference booking = null;
        StockBlank stockBlank = (StockBlank)data.getEntity();
        EntityReference bookingFile = stockBlank.getBookingFile();
        UsageStatus oldStatus = stockBlank.getUsageStatus();
        String oldValidator = stockBlank.getValidatorCode();
        if (bookingFile != null) {
            if (usageStatus != null && usageStatus != oldStatus) {
                if (!(oldStatus != UsageStatus.SELL && oldStatus != UsageStatus.VOID || usageStatus != UsageStatus.LOCKED && usageStatus != UsageStatus.WRITTENOFF && usageStatus != UsageStatus.LOST && usageStatus != UsageStatus.RETURN)) {
                    booking = bookingFile;
                    stockBlank.setOperationDate(null);
                } else {
                    return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_UnableToChangeBindedBlank", null, stockBlank.toString(), bookingFile.toString());
                }
            }
            if (!TextUtil.isBlank((String)oldValidator) && !TextUtil.isSame((String)validator, (String)oldValidator)) {
                return RegisterStockOrderHelper.createMessage(MessageType.ERROR, "StockControlDao_UnableToChangeBindedBlank", null, stockBlank.toString(), bookingFile.toString());
            }
        }
        if (usageStatus != null) {
            stockBlank.setUsageStatus(usageStatus);
        }
        if (!TextUtil.isBlank((String)validator)) {
            stockBlank.setValidatorCode(validator);
        }
        if (usageStatus == UsageStatus.NEW) {
            stockBlank.setOperationDate(null);
        } else if (date != null) {
            stockBlank.setOperationDate(date);
        }
        es.save(data, false);
        if (booking != null && (container = es.resolve(booking)) != null) {
            es.save(container, false);
        }
        return null;
    }

    public static <P extends BaseProduct> Date getOperationDate(P product) {
        if (product == null) {
            return null;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if (!(handler.getStatus(product) != ProductStatus.REFUND && handler.getStatus(product) != ProductStatus.EXCHANGE || handler.getPreviousProduct(product) == null || handler.getTicketType(handler.getPreviousProduct(product)) != null && handler.getTicketType(handler.getPreviousProduct(product)) != TicketType.OWN)) {
            return handler.getIssueDate(handler.getPreviousProduct(product));
        }
        return handler.getIssueDate(product);
    }

    public static <P extends BaseProduct> Date getVendorPaymentDate(P product) {
        if (product == null) {
            return null;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if (!(handler.getStatus(product) != ProductStatus.REFUND && handler.getStatus(product) != ProductStatus.EXCHANGE || handler.getPreviousProduct(product) == null || handler.getTicketType(handler.getPreviousProduct(product)) != null && handler.getTicketType(handler.getPreviousProduct(product)) != TicketType.OWN)) {
            return RegisterStockOrderHelper.getVendorPaymentDate(handler.getPreviousProduct(product));
        }
        if (handler.getVendorFops(product).isEmpty()) {
            return null;
        }
        return handler.getOperationDate((Fop)handler.getVendorFops(product).get(0));
    }
}

