/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.storage;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.db.storage.model.DictionaryDataProvider;
import com.gridnine.xtrip.server.storage.StandardDictionaryDataProvider;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class BaseDictionaryWithPredefinedValuesDataProvider<T extends BaseDictionary>
implements DictionaryDataProvider {
    private final StandardDictionaryDataProvider delegate;
    private final Map<String, T> predefinedValues = new HashMap<String, T>();
    private final Class<T> dictCls = this.getDictClass();

    public BaseDictionaryWithPredefinedValuesDataProvider() {
        this.delegate = new StandardDictionaryDataProvider();
        String pointId = this.getExtensionPointId();
        if (!TextUtil.isBlank((String)pointId)) {
            PluginManager pluginManager = PluginManager.lookup((Object)this);
            if (pluginManager == null) {
                return;
            }
            int index = pointId.lastIndexOf(46);
            try {
                for (Extension ext : JpfUtil.getConnectedExtensions((String)pointId.substring(0, index), (String)pointId.substring(index + 1))) {
                    URL resource = pluginManager.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(ext.getParameter("url").valueAsString());
                    this.registerMetadataFile(resource);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to load predefined person positions", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetadataFile(URL resource) throws Exception {
        LoggerFactory.getLogger(this.getClass()).info("registering person positions from " + resource);
        try (InputStream in = resource.openStream();){
            for (Element elm : XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputSource)new InputSource(in)).getDocumentElement(), (String)"object")) {
                BaseDictionary dict = (BaseDictionary)this.dictCls.newInstance();
                dict.fromXML(elm);
                this.predefinedValues.put(dict.getCode(), dict);
            }
        }
    }

    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Class<? extends BaseDictionary> cls, Set<String> ignoredTypes) throws Exception {
        return !(modifiedSince != null || cls != null && ignoredTypes.contains(cls.getName()) || cls != null && !this.dictCls.equals(cls)) ? this.predefinedValues.values() : Collections.emptyList();
    }

    public <D extends BaseDictionary> D load(Class<D> cls, String code) throws Exception {
        if (!this.dictCls.equals(cls)) {
            throw new IllegalAccessException("bad class in load method: " + cls);
        }
        BaseDictionary res = (BaseDictionary)this.predefinedValues.get(code);
        if (res != null) {
            return (D)res;
        }
        return (D)this.delegate.load(cls, code);
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> save(D dict, boolean ignoreInterceptors) throws Exception {
        if (!this.dictCls.equals(dict.getClass())) {
            throw new IllegalAccessException("bad class in save method: " + dict.getClass());
        }
        if (this.predefinedValues.containsKey(dict.getCode())) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.BaseDictionaryWithPredefinedValuesDataProvider_cantChangePresetValue, (Object[])new Object[0]));
        }
        return this.delegate.save(dict, ignoreInterceptors);
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> delete(D dict, boolean ignoreInterceptors) throws Exception {
        if (!this.dictCls.equals(dict.getClass())) {
            throw new IllegalAccessException("bad class in delete method: " + dict.getClass());
        }
        if (this.predefinedValues.containsKey(dict.getCode())) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.BaseDictionaryWithPredefinedValuesDataProvider_cantDeletePresetValue, (Object[])new Object[0]));
        }
        return this.delegate.delete(dict, ignoreInterceptors);
    }

    public Collection<? extends DictionaryReference<?>> getDeleted(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        return Collections.emptyList();
    }

    protected abstract Class<T> getDictClass();

    protected abstract String getExtensionPointId();

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> update(Collection<D> dictionaries, Class<D> cls, boolean ignoreInterceptors) throws Exception {
        throw new UnsupportedOperationException("bulk update is not supported");
    }

    public Collection<String> getResetTypes(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        return Collections.emptySet();
    }
}

