/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.storage;

import com.gridnine.xtrip.common.db.storage.entity.RevisionConflictException;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.test.LogicalStorageTestBase;
import org.junit.Assert;
import org.junit.Test;

public class UpdateVersionTest
extends LogicalStorageTestBase {
    public void setUp() throws Exception {
        super.setUp();
        UpdateVersionTest.setSysProp((String)"org.apache.commons.logging.simplelog.log.com.gridnine.xtrip.server.db.storage.hibernate.HibernateEntityStorage.UPDATE", (String)"debug");
    }

    @Test
    public void test() throws Exception {
        EntityContainer bf1 = new EntityContainer(BookingFile.class);
        ((BookingFile)bf1.getEntity()).setNotes("some ip 0");
        EntityStorage.get().save(bf1, true);
        ((BookingFile)bf1.getEntity()).setNotes("some ip 1");
        EntityStorage.get().save(bf1, true);
        ((BookingFile)bf1.getEntity()).setNotes("some ip 2 (aaa)");
        EntityStorage.get().save(bf1, true);
        ((BookingFile)bf1.getEntity()).setNotes("some ip 3");
        EntityStorage.get().save(bf1, true);
        EntityContainer bf2 = (EntityContainer)XCloneHelper.clone((XCloneable)bf1);
        ((BookingFile)bf1.getEntity()).setNotes("some ip 4");
        Customer customer4 = ((BookingFile)bf1.getEntity()).getCustomer();
        EntityStorage.get().save(bf1, true);
        ((BookingFile)bf2.getEntity()).setNotes("new 3!!!");
        try {
            EntityStorage.get().save(bf2, false);
            Assert.fail((String)"old revision saved");
        }
        catch (RevisionConflictException revisionConflictException) {
            // empty catch block
        }
        EntityContainer last = EntityStorage.get().load(BookingFile.class, bf1.getUid());
        Assert.assertNotNull((Object)last);
        Assert.assertEquals((Object)"some ip 4", (Object)((BookingFile)last.getEntity()).getNotes());
        Assert.assertEquals((Object)customer4, (Object)((BookingFile)last.getEntity()).getCustomer());
        EntityContainer bf3 = EntityStorage.get().load(BookingFile.class, bf2.getUid(), (EntityStorageLoadParameters)new EntityStorageLoadParameters().noCache(true));
        Assert.assertNotNull((Object)bf3);
        Assert.assertEquals((Object)"some ip 4", (Object)((BookingFile)bf3.getEntity()).getNotes());
        Assert.assertEquals((Object)customer4, (Object)((BookingFile)bf3.getEntity()).getCustomer());
        EntityContainer bf44 = EntityStorage.get().load(BookingFile.class, bf1.getUid(), Integer.valueOf(4));
        Assert.assertNotNull((Object)bf44);
        Assert.assertEquals((Object)"some ip 4", (Object)((BookingFile)bf44.getEntity()).getNotes());
        Assert.assertEquals((Object)customer4, (Object)((BookingFile)bf44.getEntity()).getCustomer());
        EntityContainer bf43 = EntityStorage.get().load(BookingFile.class, bf1.getUid(), Integer.valueOf(3));
        Assert.assertNotNull((Object)bf43);
        Assert.assertEquals((Object)"some ip 3", (Object)((BookingFile)bf43.getEntity()).getNotes());
        EntityContainer bf42 = EntityStorage.get().load(BookingFile.class, bf1.getUid(), Integer.valueOf(2));
        Assert.assertNotNull((Object)bf42);
        Assert.assertEquals((Object)"some ip 2 (aaa)", (Object)((BookingFile)bf42.getEntity()).getNotes());
        EntityContainer bf41 = EntityStorage.get().load(BookingFile.class, bf1.getUid(), Integer.valueOf(1));
        Assert.assertNotNull((Object)bf41);
        Assert.assertEquals((Object)"some ip 1", (Object)((BookingFile)bf41.getEntity()).getNotes());
        EntityContainer bf40 = EntityStorage.get().load(BookingFile.class, bf1.getUid(), Integer.valueOf(0));
        Assert.assertNotNull((Object)bf40);
        Assert.assertEquals((Object)"some ip 0", (Object)((BookingFile)bf40.getEntity()).getNotes());
    }
}

