/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandlersRegistry;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationHandlersRegistryPublisher
implements Publisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void publish() throws Exception {
        if (!Environment.isPublished(SynchronizationHandlersRegistry.class)) {
            SynchronizationHandlersRegistry registry = new SynchronizationHandlersRegistry();
            for (Extension extension : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.model", (String)"SynchronizationHandler")) {
                this.log.debug("processing Synchronization from " + extension);
                for (Extension.Parameter param : extension.getParameters()) {
                    try {
                        SynchronizationHandler handler = (SynchronizationHandler)JpfUtil.getClass((Extension.Parameter)param).newInstance();
                        registry.register(handler);
                    }
                    catch (Exception e) {
                        this.log.error("failed handling SynchronizationHandler from " + extension, (Throwable)e);
                    }
                }
            }
            Environment.publish((Object)registry);
        }
    }
}

