/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.export.UrlConnectionInfoSettings;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class SynchronizationHelper {
    private static transient Logger log = LoggerFactory.getLogger(SynchronizationHelper.class);
    public static final String DEFAULT_SYNCH_URL = "http://ibe.gridnine.com:9090/sync/";
    private static File configFile = new File(Environment.getDataFolder(), "synchronization.properties");
    private static Properties props;
    private static final DateFormat configDF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setLastSynchronizationDate(Date date, String id) throws Exception {
        Properties config = SynchronizationHelper.getProperties();
        config.put(id + ".last-synchronization-date", date == null ? "" : configDF.format(date));
        try (FileOutputStream strm = new FileOutputStream(configFile);){
            config.store(strm, "This file contains last values of sequence numbers. Don't modify this file manually when server is running.");
        }
    }

    public static synchronized Date getLastSynchronizationDate(String id) throws Exception {
        Properties config = SynchronizationHelper.getProperties();
        String date = config.getProperty(id + ".last-synchronization-date");
        if (TextUtil.isBlank((String)date)) {
            return null;
        }
        return configDF.parse(date);
    }

    public static synchronized Properties getProperties() throws Exception {
        if (props == null) {
            File folder = configFile.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new Exception("unable to create directory " + folder.getName());
            }
            props = new Properties();
            if (configFile.isFile()) {
                try (FileInputStream strm = new FileInputStream(configFile);){
                    props.load(strm);
                }
            }
        }
        return props;
    }

    public static <I extends XSerializable, O extends XSerializable> SynchronizationResponse<O> execute(SynchronizationRequest<I> request, String url, ValueHolder<String> traceHolder) {
        return SynchronizationHelper.execute(request, url, null, traceHolder);
    }

    public static <I extends XSerializable, O extends XSerializable> SynchronizationResponse<O> execute(SynchronizationRequest<I> request, String url, UrlConnectionInfoSettings cnnSettings, ValueHolder<String> traceHolder) {
        return SynchronizationHelper.execute(request, url, 0, cnnSettings, traceHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends XSerializable, O extends XSerializable> SynchronizationResponse<O> execute(SynchronizationRequest<I> request, String url, int timeoutInMillis, UrlConnectionInfoSettings cnnSettings, ValueHolder<String> traceHolder) {
        SynchronizationResponse response = new SynchronizationResponse();
        long start = System.currentTimeMillis();
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            XUtil.serialize(request, (OutputStream)strm);
            URLConnection connection = cnnSettings == null ? URLConnectionHelper.prepareURLConnection((URL)new URL(url), null) : URLConnectionHelper.prepareURLConnection((URL)new URL(url), (UrlConnectionInfoSettings)cnnSettings, null);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            if (timeoutInMillis != 0) {
                connection.setReadTimeout(timeoutInMillis);
                connection.setConnectTimeout(timeoutInMillis);
            }
            ((HttpURLConnection)connection).setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "text/html; charset=utf-8");
            try (OutputStream os = connection.getOutputStream();){
                IoUtil.copyStream((InputStream)new ByteArrayInputStream(strm.toByteArray()), (OutputStream)os, (int)256);
                os.flush();
            }
            strm = new ByteArrayOutputStream();
            try (InputStream is = connection.getInputStream();){
                IoUtil.copyStream((InputStream)is, (OutputStream)strm, (int)256);
            }
            response.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(strm.toByteArray()))).getDocumentElement());
        }
        catch (ConnectException e) {
            log.error("unable to synchronize - connection refused", (Throwable)e);
            response = new SynchronizationResponse();
            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.SynchronizationHelper_connectionRefused, (Object[])new Object[0]), (Throwable)e, (Object[])new Object[0]));
        }
        catch (MalformedURLException e) {
            log.error("unable to synchronize - malformed url", (Throwable)e);
            response = new SynchronizationResponse();
            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.SynchronizationHelper_malformedURL, (Object[])new Object[]{url}), (Throwable)e, (Object[])new Object[0]));
        }
        catch (FileNotFoundException e) {
            log.error("unable to synchronize - resource not found by url", (Throwable)e);
            response = new SynchronizationResponse();
            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.SynchronizationHelper_resourceNotFound, (Object[])new Object[]{url}), (Throwable)e, (Object[])new Object[0]));
        }
        catch (UnknownHostException e) {
            log.error("unable to synchronize - unknown host", (Throwable)e);
            response = new SynchronizationResponse();
            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.SynchronizationHelper_unknownHost, (Object[])new Object[]{url}), (Throwable)e, (Object[])new Object[0]));
        }
        catch (Throwable e) {
            log.error("unable to synchronize", e);
            response = new SynchronizationResponse();
            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.SynchronizationHelper_synchronizationError, (Object[])new Object[0]), (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            if (traceHolder != null) {
                try {
                    String trace = SynchronizationHelper.getTrace(request.getOperationId(), request, response, System.currentTimeMillis() - start);
                    traceHolder.setValue((Object)trace);
                }
                catch (Throwable e) {
                    log.error("unable to log", e);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String trace, String operationId) {
        SimpleDateFormat df = new SimpleDateFormat("HH-mm-ss-SSS");
        if (TextUtil.isBlank((String)trace) || !log.isTraceEnabled()) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        File file = new File(Environment.getRootFolder(), String.format("/logs/synchronization/%s/%s/%s/%s-%s.log", Integer.toString(cal.get(1)), Integer.toString(cal.get(2) + 1), Integer.toString(cal.get(5)), operationId, df.format(cal.getTime())));
        file.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8");){
            writer.write(trace);
        }
        catch (Exception e) {
            log.error("unable to trace", (Throwable)e);
        }
    }

    public static <I extends XSerializable, O extends XSerializable> String getTrace(String operationId, SynchronizationRequest<I> request, SynchronizationResponse<O> response, long duration) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        doc.appendChild(doc.createElement("synchronization"));
        Element root = doc.getDocumentElement();
        XHelper.writeDate((Element)root, (String)"date", (Date)new Date());
        XHelper.writeLong((Element)root, (String)"duration", (Long)duration);
        XHelper.writeString((Element)root, (String)"operationId", (String)operationId);
        if (request != null) {
            XHelper.writeObject((Element)root, (String)"request", request);
        }
        XHelper.writeObject((Element)root, (String)"response", response);
        StringWriter writer = new StringWriter();
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    private SynchronizationHelper() {
    }

    static {
        configDF = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    }
}

