/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.auth.AuthHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandlersRegistry;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SynchronizationServlet
extends HttpServlet {
    private static final long serialVersionUID = 5642719011228204465L;
    private final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block42: {
            DebugUtil.setThreadName((String)"SynchronizationServlet-doPost");
            try {
                String operationId;
                long start;
                SynchronizationRequest request;
                SynchronizationResponse<Object> response;
                block41: {
                    SynchronizationHandler handler;
                    block40: {
                        response = new SynchronizationResponse();
                        request = null;
                        start = System.currentTimeMillis();
                        operationId = null;
                        request = new SynchronizationRequest();
                        try (ServletInputStream in = req.getInputStream();){
                            request.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)in)).getDocumentElement());
                        }
                        request.setRemoteAddress(req.getRemoteAddr());
                        if (!TextUtil.isBlank((String)request.getAuthToken())) {
                            AuthHelper.validateAuthToken((Serializable)((Object)request.getAuthToken()));
                        }
                        operationId = request.getOperationId();
                        handler = ((SynchronizationHandlersRegistry)Environment.getPublished(SynchronizationHandlersRegistry.class)).find(operationId);
                        if (handler != null) break block40;
                        this.log.error("no handler found for operation " + operationId + " ip = " + req.getRemoteAddr());
                        response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SynchronizationServlet_notFoundHandlerForCmd, (Object[])new Object[]{operationId}));
                        try {
                            String trace = SynchronizationHelper.getTrace(operationId, request, response, System.currentTimeMillis() - start);
                            SynchronizationHelper.log(trace, operationId);
                        }
                        catch (Throwable e) {
                            this.log.error("unable to log", e);
                        }
                        try {
                            XUtil.serialize(response, (OutputStream)resp.getOutputStream());
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        return;
                    }
                    LogicalStorage.get().setUser(request.getUser());
                    response = handler.process(request);
                    if (response.getDate() != null) break block41;
                    response.setDate(new Date());
                }
                try {
                    String trace = SynchronizationHelper.getTrace(operationId, request, response, System.currentTimeMillis() - start);
                    SynchronizationHelper.log(trace, operationId);
                }
                catch (Throwable e) {
                    this.log.error("unable to log", e);
                }
                try {
                    XUtil.serialize(response, (OutputStream)resp.getOutputStream());
                    break block42;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                catch (Throwable e) {
                    block43: {
                        try {
                            this.log.error("unable to process request", e);
                            if (e instanceof Xeption) {
                                response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)((Xeption)e).getEndUserMessage().toString(), (Object[])new Object[0]));
                                break block43;
                            }
                            response.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SynchronizationServlet_cantHandleQuery, (Throwable)e, (Object[])new Object[0]));
                        }
                        catch (Throwable throwable) {
                            try {
                                String trace = SynchronizationHelper.getTrace(operationId, request, response, System.currentTimeMillis() - start);
                                SynchronizationHelper.log(trace, operationId);
                            }
                            catch (Throwable e2) {
                                this.log.error("unable to log", e2);
                            }
                            try {
                                XUtil.serialize(response, (OutputStream)resp.getOutputStream());
                            }
                            catch (Exception e3) {
                                throw new IOException(e3);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        String trace = SynchronizationHelper.getTrace(operationId, request, response, System.currentTimeMillis() - start);
                        SynchronizationHelper.log(trace, operationId);
                    }
                    catch (Throwable e4) {
                        this.log.error("unable to log", e4);
                    }
                    try {
                        XUtil.serialize(response, (OutputStream)resp.getOutputStream());
                    }
                    catch (Exception e5) {
                        throw new IOException(e5);
                    }
                }
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(405);
    }
}

