/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.cir;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CirCardsUploadCallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = -6149973733239774477L;
    public static final String REQUEST_BODY_ENCODING = "utf8";
    public static final String RESPONSE_SUCCEFULL_CODE = "OK";
    public static final String STORE_ENCODING = "utf8";
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.debug("cir callback -> start");
        SimpleDateFormat format = new SimpleDateFormat("MMyy");
        try {
            try {
                LogicalStorage.get().authorizeAsSystem();
                this.log.debug("cir callback -> authorize success");
            }
            catch (Exception e) {
                this.log.debug("cir callback -> authorize failed");
                throw new Exception("Unable to authorize", e);
            }
            String data = IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8");
            this.log.debug("cir callback -> data retrieve success");
            JSONObject jsonObject = new JSONObject(data);
            this.log.debug("cir callback -> json retrieve success");
            JSONArray jsonCards = jsonObject.getJSONArray("cards");
            this.log.debug(String.format("cir callback -> found cards -> %s", String.valueOf(jsonCards.length())));
            for (int i = 0; i < jsonCards.length(); ++i) {
                JSONObject jsonCard = jsonCards.getJSONObject(i);
                String uid = jsonCard.getString("uid");
                String cirUid = jsonCard.getString("cirUid");
                String cardholderName = jsonCard.getString("cardholderName");
                String expirationDate = jsonCard.getString("expirationDate");
                String type = jsonCard.getString("type");
                String pan = jsonCard.getString("pan");
                String sof = jsonCard.getString("sof");
                String bta = jsonCard.getString("bta");
                String remarks = jsonCard.getString("remarks");
                String profileType = jsonCard.getString("profileType");
                String profileUid = jsonCard.getString("profileUid");
                Card card = new Card();
                card.setUid(uid);
                card.setCirUid(cirUid);
                card.setNameOnCard(cardholderName);
                try {
                    card.setExpiration(format.parse(expirationDate));
                }
                catch (Exception e) {
                    throw new Exception("Expiration date has wrong format", e);
                }
                try {
                    card.setVendor(CardVendor.valueOf((String)type));
                }
                catch (Exception e) {
                    throw new Exception(String.format("Unsupported card type %s", type), e);
                }
                card.setNumber(pan);
                card.setSof(Boolean.parseBoolean(sof));
                card.setBta(Boolean.parseBoolean(bta));
                card.setRemarks(remarks);
                if (TextUtil.isSame((String)profileType, (String)Organization.class.getName())) {
                    EntityContainer organizationContainer = EntityStorage.get().load(Organization.class, profileUid);
                    if (organizationContainer == null) throw new Exception("Unable to load organization profile");
                    Organization organization = (Organization)organizationContainer.getEntity();
                    organization.getCards().add(card);
                    organizationContainer.getVersionInfo().setDataSource("cir-cards-upload-callback");
                    EntityStorage.get().save(organizationContainer, true);
                } else {
                    if (!TextUtil.isSame((String)profileType, (String)Person.class.getName())) throw new Exception(String.format("Unsupported profile type %s", profileType));
                    EntityContainer personContainer = EntityStorage.get().load(Person.class, profileUid);
                    if (personContainer == null) throw new Exception("Unable to load person profile");
                    Person person = (Person)personContainer.getEntity();
                    person.getCards().add(card);
                    personContainer.getVersionInfo().setDataSource("cir-cards-upload-callback");
                    EntityStorage.get().save(personContainer, true);
                }
                this.log.debug(String.format("cir callback -> process card success -> %s of %s", String.valueOf(i), String.valueOf(jsonCards.length())));
            }
            this.log.debug("cir callback -> cards handle success");
            response.setStatus(204);
            this.log.debug("cir callback -> respond success");
            return;
        }
        catch (Exception e) {
            this.log.error("cir callback -> unable to handle cards", (Throwable)e);
            response.setStatus(500);
            response.setCharacterEncoding("utf-8");
            try (PrintWriter writer = response.getWriter();){
                writer.write(e.getMessage());
                return;
            }
        }
        finally {
            this.log.debug("cir callback -> finish");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dump(request, response);
    }

    private void dump(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        try {
            String dump = this.createDump(request);
            this.log.debug(String.format("request ok:\n%s", dump.toString()));
            writer.write("<h1>OK</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", dump.toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        catch (IOException e) {
            this.log.debug(String.format("request error:\n%s", e.getMessage()));
            writer.write("<h1>ERROR</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", URLDecoder.decode(e.getMessage(), "utf-8").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        writer.flush();
    }

    private String createDump(HttpServletRequest request) throws IOException {
        StringBuilder dump = new StringBuilder();
        dump.append("HEADER");
        dump.append("\n\n");
        Enumeration headerNamesEnumerator = request.getHeaderNames();
        dump.append("method -> " + request.getMethod());
        dump.append("\n");
        while (headerNamesEnumerator.hasMoreElements()) {
            String headerName = (String)headerNamesEnumerator.nextElement();
            Enumeration headersEnumerator = request.getHeaders(headerName);
            while (headersEnumerator.hasMoreElements()) {
                String header = (String)headersEnumerator.nextElement();
                dump.append(headerName + " -> " + header);
                dump.append("\n");
            }
        }
        dump.append("\n");
        dump.append("BODY");
        dump.append("\n\n");
        StringBuilder body = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            body.append(line);
            body.append("\n");
        }
        String[] parameters = body.toString().split("&");
        body = new StringBuilder();
        for (String parameter : parameters) {
            String[] tokens = parameter.split("=");
            if (tokens.length > 0) {
                body.append(tokens[0]);
            }
            if (tokens.length > 1) {
                body.append(" -> " + tokens[1]);
            }
            body.append("\n");
        }
        dump.append(body.toString());
        return URLDecoder.decode(dump.toString(), "utf8");
    }
}

