/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.cir;

import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.ibus.cir.IbusCirContextKeys;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CirSynchronizationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ServerApplication.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String request = this.readRequest((InputStream)req.getInputStream());
        JSONObject jsonRequest = this.parseJson(request);
        this.authorizeInStorage();
        this.processRequest(jsonRequest, resp);
    }

    private String readRequest(InputStream inputStream) throws IOException, UnsupportedCharsetException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((bytesRead = inputStream.read(buff)) != -1) {
            outputStream.write(buff, 0, bytesRead);
        }
        outputStream.flush();
        return outputStream.toString("UTF-8");
    }

    private JSONObject parseJson(String request) throws ServletException {
        try {
            return new JSONObject(request);
        }
        catch (JSONException e) {
            log.error("Unable to convert request to json: " + request, (Throwable)e);
            throw new ServletException("Unable to convert request to json");
        }
    }

    private void authorizeInStorage() throws ServletException {
        try {
            LogicalStorage.get().authorizeAsSystem();
        }
        catch (Exception e) {
            throw new ServletException("Unable to get to local storage", (Throwable)e);
        }
    }

    private void processRequest(JSONObject jsonRequest, HttpServletResponse httpResponse) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put(IbusCirContextKeys.JSON_REQUEST.name(), jsonRequest);
        contextData.put(IbusCirContextKeys.HTTP_RESPONSE.name(), httpResponse);
        IntegrationBusFacade.get().processRouteSync("cir:process-servlet-request", contextData);
    }
}

