/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.dictionaries;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dictremote.DictEditRequest;
import com.gridnine.xtrip.common.model.dictremote.DictEditResponse;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictSynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictSynchronizationTask;
import java.util.List;

public class DictRemoteHelper {
    private static final String SYNCHRONIZATION_ID = "dict-synchronization-processing";
    private static final String EDIT_ID = "dict-edit-processing";

    public static SynchronizationResponse<DictSynchronizationResponse> processRequest(DictSynchronizationRequest data, String url) {
        SynchronizationRequest<DictSynchronizationRequest> request = new SynchronizationRequest<DictSynchronizationRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId(SYNCHRONIZATION_ID);
        request.setUser("DictSynchronizationTaskUser");
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, TextUtil.nonBlank((String)url) ? url : DictRemoteHelper.getUrl(), (ValueHolder<String>)trace);
    }

    public static SynchronizationResponse<DictEditResponse> processRequest(DictEditRequest data) {
        SynchronizationRequest<DictEditRequest> request = new SynchronizationRequest<DictEditRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId(EDIT_ID);
        request.setUser("SendDictionaryToRemoteServerUser");
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, DictRemoteHelper.getUrl(), (ValueHolder<String>)trace);
    }

    public static String getUrl() {
        ScheduledTaskSettings taskSettings;
        EntityContainer setCont;
        List indexes = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, new SearchQuery()).getData();
        if (indexes == null) {
            return null;
        }
        for (ScheduledTaskSettingsIndex index : indexes) {
            setCont = EntityStorage.get().resolve(index.getSource());
            if (setCont == null || !"dictionaries-synchronization-task".equals(setCont.getUid())) continue;
            taskSettings = (ScheduledTaskSettings)setCont.getEntity();
            for (NamedValue nv : taskSettings.getDataMap()) {
                if (!TextUtil.isSame((String)"URL", (String)nv.getName(), (boolean)true)) continue;
                return nv.getValue();
            }
        }
        for (ScheduledTaskSettingsIndex index : indexes) {
            setCont = EntityStorage.get().resolve(index.getSource());
            if (setCont == null || setCont.getEntity() == null) continue;
            taskSettings = (ScheduledTaskSettings)setCont.getEntity();
            if (!TextUtil.isSame((String)DictSynchronizationTask.class.getName(), (String)taskSettings.getJobClass(), (boolean)true)) continue;
            for (NamedValue nv : taskSettings.getDataMap()) {
                if (!TextUtil.isSame((String)"URL", (String)nv.getName(), (boolean)true)) continue;
                return nv.getValue();
            }
        }
        return null;
    }
}

