/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.dictionaries;

import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.dbproperties.LogicalDBPropertiesStorage;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictRemoteHelper;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.dictionaries.DictSynchronizationResponse;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DictSynchronizationTask
extends BaseScheduledTask {
    private static final String dbPropertyName = "dicts-remote-update-date.";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");

    protected void doJob() throws Exception {
        this.log.info("dictionaries update started");
        Date startTime = new Date();
        LogicalDBPropertiesStorage dbPropertiesStorage = LogicalStorage.get().getDbPropertiesStorage();
        Map<Class<? extends BaseDictionary>, Date> classesAndDates = this.getClassesAndDates(dbPropertiesStorage);
        Map<Class<? extends BaseDictionary>, Collection<BaseDictionary>> classesAndDictionaries = this.getDictionaries(classesAndDates);
        this.sortDictionaries(classesAndDictionaries);
        int totalCount = classesAndDictionaries.values().stream().mapToInt(Collection::size).sum();
        if (totalCount == 0) {
            this.log.info("changed dictionaries not found");
        } else {
            this.log.info(totalCount + " dictionaries downloaded");
            int processed = this.updateDictionaries(classesAndDictionaries);
            this.log.info("all dictionaries updated, processed: " + processed);
        }
        this.logElements(classesAndDates.keySet());
        this.updateDates(classesAndDictionaries.keySet(), dbPropertiesStorage, startTime);
        this.log.info("dictionaries update finished");
    }

    private Map<Class<? extends BaseDictionary>, Date> getClassesAndDates(LogicalDBPropertiesStorage dbPropertiesStorage) {
        List classNames = MetaRegistry.get().getDictionaries().values().stream().filter(DictionaryType::isRemote).sorted(Comparator.comparing(DictionaryType::getRemotePriority).reversed()).map(BaseMetaElement::getId).collect(Collectors.toList());
        if (classNames.isEmpty()) {
            this.log.warn("dictionary classes for remote update not found");
            return Collections.emptyMap();
        }
        LinkedHashMap<Class<? extends BaseDictionary>, Date> result = new LinkedHashMap<Class<? extends BaseDictionary>, Date>();
        Map dbProperties = dbPropertiesStorage.getAllKeys();
        for (String className : classNames) {
            Class clazz;
            try {
                clazz = XSHelper.getClassForName((String)className);
            }
            catch (ClassNotFoundException e) {
                this.log.error(String.format("class %s not found", className), (Throwable)e);
                continue;
            }
            String remoteUpdateDate = (String)dbProperties.get(dbPropertyName + className);
            Date lastDateUpdate = null;
            if (remoteUpdateDate != null) {
                try {
                    lastDateUpdate = DATE_FORMAT.parse(remoteUpdateDate);
                }
                catch (ParseException e) {
                    this.log.error(String.format("last remote update date for class %s is incorrect: %s. All dictionary elements will be downloaded", className, remoteUpdateDate), (Throwable)e);
                }
            } else {
                this.log.info(String.format("last remote update date for class %s is null. All dictionary elements will be downloaded", className));
            }
            result.put(clazz, lastDateUpdate);
        }
        return result;
    }

    private Map<Class<? extends BaseDictionary>, Collection<BaseDictionary>> getDictionaries(Map<Class<? extends BaseDictionary>, Date> classesAndDates) {
        if (classesAndDates.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Class<? extends BaseDictionary>, Collection<BaseDictionary>> result = new LinkedHashMap<Class<? extends BaseDictionary>, Collection<BaseDictionary>>();
        for (Map.Entry<Class<? extends BaseDictionary>, Date> entry : classesAndDates.entrySet()) {
            Class<? extends BaseDictionary> clazz = entry.getKey();
            Date lastUpdateDate = entry.getValue();
            DictionaryHandler handler = HandlersRegistry.get().findDictionaryHandler(clazz);
            DictSynchronizationRequest request = new DictSynchronizationRequest();
            request.setLastUpdateDate(lastUpdateDate);
            request.getClassNames().add(clazz.getName());
            request.setCollectRelatedDictionaries(handler.getRelatedDictionaryClasses().stream().map(classesAndDates::get).anyMatch(Objects::nonNull));
            this.log.info(String.format("updating dictionaries, class %s, last update date: %s", clazz, lastUpdateDate));
            SynchronizationResponse<DictSynchronizationResponse> syncResponse = DictRemoteHelper.processRequest(request, this.getUrl());
            boolean hasErrors = false;
            for (Message msg : syncResponse.getMessages()) {
                if (msg.getType() == MessageType.ERROR) {
                    this.log.error("Request to dictionary server had error: " + msg.getMessage());
                    hasErrors = true;
                    continue;
                }
                this.log.info("Request to dictionary server had message: " + msg.getMessage());
            }
            if (hasErrors) continue;
            DictSynchronizationResponse response = syncResponse.getData();
            result.computeIfAbsent(clazz, k -> new HashSet()).addAll(response.getDictionariesToUpdate());
            for (BaseDictionary relatedDict : response.getRelatedDictionaries()) {
                if (relatedDict == null) continue;
                result.computeIfAbsent(relatedDict.getClass(), k -> new HashSet()).add(relatedDict);
            }
            this.log.info(String.format("dictionaries for class %s downloaded, count: %s", clazz, response.getDictionariesToUpdate().size()));
        }
        return result;
    }

    private void sortDictionaries(Map<Class<? extends BaseDictionary>, Collection<BaseDictionary>> dictionaries) {
        HashSet<Class<? extends BaseDictionary>> keys = new HashSet<Class<? extends BaseDictionary>>(dictionaries.keySet());
        for (Class clazz : keys) {
            List sortedResult = dictionaries.get(clazz).stream().sorted((d1, d2) -> MiscUtil.compare((Date)d1.getCreated(), (Date)d2.getCreated())).collect(Collectors.toList());
            dictionaries.put(clazz, sortedResult);
        }
    }

    private int updateDictionaries(Map<Class<? extends BaseDictionary>, Collection<BaseDictionary>> classesAndDictionaries) {
        int processed = 0;
        block2: for (Map.Entry<Class<? extends BaseDictionary>, Collection<BaseDictionary>> entry : classesAndDictionaries.entrySet()) {
            Class<? extends BaseDictionary> clazz = entry.getKey();
            Collection<BaseDictionary> dictionaries = entry.getValue();
            DictionaryHandler handler = HandlersRegistry.get().findDictionaryHandler(clazz);
            if (handler == null) {
                this.log.warn("handler for class " + clazz.getName() + " not found");
                continue;
            }
            Set relatedDictionaries = handler.getRelatedDictionaryClasses().stream().map(classesAndDictionaries::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            this.log.info("processing dictionaries for class " + clazz.getName());
            for (BaseDictionary remoteDictElement : dictionaries) {
                try {
                    if (remoteDictElement == null) {
                        this.log.warn("dictionary element is null");
                        continue;
                    }
                    Class<?> dictClass = remoteDictElement.getClass();
                    if (!handler.isForRemoteUpdate(remoteDictElement)) {
                        this.log.info(remoteDictElement + " element is not for remote update");
                        continue;
                    }
                    BaseDictionary foundDictElement = DictionaryCache.get().findByRemoteUid(dictClass, remoteDictElement.getUid());
                    if (foundDictElement == null) {
                        foundDictElement = handler.search(remoteDictElement);
                    }
                    if (foundDictElement == null) {
                        this.log.info("old element is not found, saving new element " + remoteDictElement);
                        if (remoteDictElement.getCode() != null) {
                            while (DictionaryCache.get().findByCode(dictClass, remoteDictElement.getCode()) != null) {
                                remoteDictElement.setCode(remoteDictElement.getCode() + 2);
                            }
                        }
                        remoteDictElement.setRemoteUid(remoteDictElement.getUid());
                        remoteDictElement.setDataSource("DictSynchronizationTask");
                        DictionaryStorage.get().save(remoteDictElement);
                    } else {
                        if (foundDictElement.isNotUpdatable()) {
                            if (foundDictElement.getRemoteUid() == null) {
                                foundDictElement.setRemoteUid(remoteDictElement.getUid());
                            }
                            this.log.info(String.format("element %s (found for element %s) is not for update", foundDictElement, remoteDictElement));
                        }
                        if (TextUtil.nonBlank((String)foundDictElement.getRemoteUid()) && !TextUtil.isSame((String)foundDictElement.getRemoteUid(), (String)remoteDictElement.getUid())) {
                            this.log.info(String.format("element %s (found for element %s) already has remoteUid for another dictionary element", foundDictElement, remoteDictElement));
                        } else {
                            ArrayList messages = new ArrayList();
                            handler.merge(foundDictElement, remoteDictElement, relatedDictionaries, messages);
                            messages.forEach(arg_0 -> ((Logger)this.log).info(arg_0));
                            foundDictElement.setRemoteUid(remoteDictElement.getUid());
                            foundDictElement.setDataSource("DictSynchronizationTask");
                            DictionaryStorage.get().save(foundDictElement);
                        }
                    }
                    ++processed;
                    if (!this.isToBeStopped()) continue;
                    this.log.info("task is interrupted");
                    break block2;
                }
                catch (Exception e) {
                    this.log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return processed;
    }

    private void logElements(Collection<Class<? extends BaseDictionary>> classes) {
        for (Class<? extends BaseDictionary> cls : classes) {
            try {
                DictionaryHandler dictHandler = HandlersRegistry.get().findDictionaryHandler(cls);
                if (dictHandler == null) {
                    this.log.error("handler for class " + cls.getName() + " not found");
                    continue;
                }
                List elementsWithoutRemoteUid = DictionaryCache.get().getAll(cls).values().stream().filter(Objects::nonNull).filter(dictElement -> dictElement.getRemoteUid() == null).filter(arg_0 -> ((DictionaryHandler)dictHandler).isForRemoteUpdate(arg_0)).map(BaseDictionary::toString).collect(Collectors.toList());
                if (elementsWithoutRemoteUid.isEmpty()) {
                    this.log.info(String.format("All elements of class %s have remoteUid", cls));
                    continue;
                }
                this.log.info(String.format("%s elements of class %s don't have remoteUid: %s", elementsWithoutRemoteUid.size(), cls, String.join((CharSequence)", ", elementsWithoutRemoteUid)));
            }
            catch (Exception e) {
                this.log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void updateDates(Collection<Class<? extends BaseDictionary>> classes, LogicalDBPropertiesStorage dbPropertiesStorage, Date date) {
        String dateString = DATE_FORMAT.format(date);
        for (Class<? extends BaseDictionary> cls : classes) {
            dbPropertiesStorage.putValue(dbPropertyName + cls.getName(), dateString);
        }
    }

    private String getUrl() {
        return this.getParameter("URL");
    }
}

