/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.getthere;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.GetThereHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileValidationUtil;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.BaseBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.GetThereSettings;
import com.gridnine.xtrip.common.model.profile.GetThereSubsiteSettings;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.RandomUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationRequestBase;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationRequestImport;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfile;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileAirPreferences;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCompanyInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCreditCard;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCustomField;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileDeliveryAddress;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileLoyalty;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfilePassport;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileSupervisorInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileUserInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileVisa;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class GetThereSynchronizationHelper {
    public static final String URL = "https://gtxch.itn.net/cgi/gtpc/gtpc";
    private static transient Logger log = LoggerFactory.getLogger(GetThereSynchronizationHelper.class);

    private static URL getURL(PCIDSSServerExchangeSettings cirSettings) throws Exception {
        if (cirSettings != null && cirSettings.isEnabled()) {
            return new URL(cirSettings.getServerAddress() + "/getThere");
        }
        return new URL(URL);
    }

    private static String getTrace(GetThereSynchronizationRequestBase request, GetThereSynchronizationResponse response, long duration) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        doc.appendChild(doc.createElement("synchronization"));
        Element root = doc.getDocumentElement();
        XHelper.writeDate((Element)root, (String)"date", (Date)new Date());
        XHelper.writeLong((Element)root, (String)"duration", (Long)duration);
        if (request != null) {
            XHelper.writeString((Element)root, (String)"type", (String)request.getType());
            XHelper.writeString((Element)root, (String)"operation", (String)request.getOperation());
            XHelper.writeObject((Element)root, (String)"request", (Object)request);
        }
        XHelper.writeObject((Element)root, (String)"response", (Object)response);
        StringWriter writer = new StringWriter();
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    private static String getResourceId(EntityContainer<Person> perCont) {
        String uid = perCont.getUid();
        uid = uid != null ? uid.replaceAll("\\-", "_") : RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM, (int)20, (int)25);
        return uid;
    }

    public static MiscUtil.Pair<String, String> sendPerson(EntityReference<Person> personRef) {
        if (personRef == null) {
            log.error("Null given as person reference for synchronization to GetThere");
            return null;
        }
        log.debug("Person sync to GetThere started for: " + personRef.getCaption());
        EntityContainer perCont = EntityStorage.get().resolve(personRef);
        return GetThereSynchronizationHelper.sendPerson((EntityContainer<Person>)perCont);
    }

    private static MiscUtil.Pair<String, String> sendPerson(EntityContainer<Person> perCont) {
        Person per = (Person)perCont.getEntity();
        Map details = GetThereHelper.getOrganizationDetailsForGetThereSync((EntityReference)perCont.toReference());
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        boolean useCir = cirSettings != null && cirSettings.isEnabled();
        Map<String, String> params = GetThereSynchronizationHelper.getSynchronizationParams(details);
        GetThereSynchronizationRequestImport request = GetThereSynchronizationHelper.prepareImportRequest(params, "update-user-profile");
        GetThereSynchronizationUserProfile userProfile = GetThereSynchronizationHelper.prepareGetThereUserProfile(per, details, params.get("siteName"), params.get("subsiteName"), useCir);
        userProfile.getUserInfo().setPwdChgDate("");
        request.setUserProfile(userProfile);
        GetThereSynchronizationResponse response = GetThereSynchronizationHelper.execute(request, (ValueHolder<String>)new ValueHolder(), cirSettings, params.get("agencyUid"));
        if (response != null && "3002".equals(response.getStatusCode())) {
            request.setOperation("add-user-profile");
            userProfile.getUserInfo().setPwdChgDate("-1");
            response = GetThereSynchronizationHelper.execute(request, (ValueHolder<String>)new ValueHolder(), cirSettings, params.get("agencyUid"));
        }
        if (response != null && !"1000".equals(response.getStatusCode())) {
            log.error("Error status code returned after import request to GetThere. Status code: " + response.getStatusCode() + ". Status text: " + response.getStatusText());
        }
        MiscUtil.Pair res = new MiscUtil.Pair((Object)"", (Object)"");
        if (response != null) {
            res = new MiscUtil.Pair((Object)response.getStatusCode(), (Object)response.getStatusText());
        }
        log.debug("Person sync to GetThere finished with status code: " + (String)res.getFirst() + " for:" + perCont.toReference().getCaption());
        return res;
    }

    private static Map<String, String> getSynchronizationParams(Map<String, Object> details) {
        GetThereSubsiteSettings settings;
        HashMap<String, String> params = new HashMap<String, String>();
        if (Boolean.TRUE.equals(details.get("ORGANIZATION_FOUND")) && (settings = (GetThereSubsiteSettings)details.get("ORGANIZATION_GET_THERE_SETTINGS")) != null) {
            settings = GetThereSynchronizationHelper.updateSettings(settings);
            params.put("password", settings.getSiteSettings().getPassword());
            params.put("siteName", settings.getSiteSettings().getSiteName());
            params.put("userName", settings.getSiteSettings().getUserName());
            params.put("subsiteName", settings.getSubsiteName());
            params.put("agencyUid", settings.getAgency().getUid());
        }
        return params;
    }

    public static GetThereSubsiteSettings updateSettings(GetThereSubsiteSettings subsiteSettingsFromOrg) {
        GetThereSettings settings = GetThereHelper.getGetThereSettings();
        for (GetThereSubsiteSettings subsiteSettings : settings.getSubSites()) {
            if (!TextUtil.isSame((String)subsiteSettings.getUid(), (String)subsiteSettingsFromOrg.getUid())) continue;
            return subsiteSettings;
        }
        return subsiteSettingsFromOrg;
    }

    private static GetThereSynchronizationRequestImport prepareImportRequest(Map<String, String> params, String requestOperationType) {
        String userName = params.get("userName");
        String siteName = params.get("siteName");
        String password = params.get("password");
        if (TextUtil.isBlank((String)userName)) {
            log.error("No userName set for synchronization to GetThere");
            return null;
        }
        if (TextUtil.isBlank((String)siteName)) {
            log.error("No siteName set for synchronization to GetThere");
            return null;
        }
        if (TextUtil.isBlank((String)password)) {
            log.error("No password set for synchronization to GetThere");
            return null;
        }
        return new GetThereSynchronizationRequestImport(siteName, null, userName, password, "import", requestOperationType);
    }

    private static GetThereSynchronizationUserProfile prepareGetThereUserProfile(Person per, Map<String, Object> details, String siteNameFromParams, String subsiteName, boolean useCir) {
        String code;
        String[] parts;
        GetThereSynchronizationUserProfileLoyalty loyalty;
        SabreProfileLine rem2;
        String orgName = null;
        String orgCode = null;
        String orgPosition = null;
        if (Boolean.TRUE.equals(details.get("ORGANIZATION_FOUND"))) {
            orgCode = (String)details.get("ORGANIZATION_CODE");
            orgName = (String)details.get("ORGANIZATION_SHORT_NAME");
            orgPosition = (String)details.get("PERSON_POSITION");
        }
        GetThereSynchronizationUserProfile userProfile = new GetThereSynchronizationUserProfile("upu_event", GetThereSynchronizationUtil.getCurrentTimeStamp(), siteNameFromParams, "corp", subsiteName, per.getResourceIdForGetThere(), "");
        GetThereSynchronizationUserProfileUserInfo userInfo = new GetThereSynchronizationUserProfileUserInfo();
        userInfo.setCrsProfile(orgCode);
        if (Gender.FEMALE.equals((Object)per.getGender())) {
            userInfo.setGender("f");
        } else if (Gender.MALE.equals((Object)per.getGender())) {
            userInfo.setGender("m");
        } else {
            userInfo.setGender(null);
        }
        if (per.getTitle() != null) {
            String title = GetThereSynchronizationUtil.title2String.get(per.getTitle());
            if (!TextUtil.isBlank((String)title)) {
                userInfo.setNtitle(title);
            } else {
                userInfo.setNtitle(Gender.FEMALE.equals((Object)per.getGender()) ? "Mrs" : "Mr");
            }
        } else if (per.getGender() != null) {
            userInfo.setNtitle(Gender.FEMALE.equals((Object)per.getGender()) ? "Mrs" : "Mr");
        }
        if (per.getFirstName() != null) {
            String firstName = GetThereSynchronizationUtil.getEnglishValue(per.getFirstName());
            if (firstName != null && firstName.trim().indexOf(" ") > 0) {
                userInfo.setFirstName(firstName.substring(0, firstName.indexOf(" ")));
                userInfo.setMiddleName(firstName.substring(firstName.indexOf(" ") + 1));
            } else {
                userInfo.setFirstName(firstName);
            }
        } else {
            userInfo.setFirstName(null);
        }
        if (per.getLastName() != null) {
            userInfo.setLastName(GetThereSynchronizationUtil.getEnglishValue(per.getLastName()));
        } else {
            userInfo.setLastName(null);
        }
        boolean hasWorkPhone = false;
        boolean hasHomePhone = false;
        boolean hasFax = false;
        String email = null;
        for (Object pc : per.getCommunications()) {
            if (!hasWorkPhone && CommunicationType.WORK_PHONE == pc.getType()) {
                userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone((PersonCommunication)pc, null));
                hasWorkPhone = true;
            }
            if (!hasHomePhone && CommunicationType.HOME_PHONE == pc.getType()) {
                userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone((PersonCommunication)pc, null));
                hasHomePhone = true;
            }
            if (!hasFax && CommunicationType.MOBILE == pc.getType()) {
                userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone((PersonCommunication)pc, null));
                hasFax = true;
            }
            if (CommunicationType.EMAIL != pc.getType() || TextUtil.isBlank((String)pc.getSense())) continue;
            email = pc.getSense();
        }
        if (!hasWorkPhone) {
            userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone(null, CommunicationType.WORK_PHONE));
        }
        if (!hasHomePhone) {
            userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone(null, CommunicationType.HOME_PHONE));
        }
        if (!hasFax) {
            userInfo.getPhones().add(GetThereSynchronizationUtil.createUserProfilePhone(null, CommunicationType.FAX));
        }
        userInfo.setEmail(email);
        userProfile.setUserInfo(userInfo);
        ArrayList<Passport> selectedPassports = new ArrayList<Passport>();
        for (Passport p : per.getPassports()) {
            if (PassportType.FOREIGN != p.getType() || TextUtil.isBlank((String)p.getNumber())) continue;
            selectedPassports.add(p);
        }
        Date birthDate = null;
        if (selectedPassports.size() > 0) {
            List<GetThereSynchronizationUserProfileCustomField> cfList;
            GetThereSynchronizationUserProfilePassport passport = GetThereSynchronizationUtil.createUserPassport((Passport)selectedPassports.get(0));
            userProfile.getPassports().add(passport);
            birthDate = ((Passport)selectedPassports.get(0)).getBirthday();
            if (selectedPassports.size() > 1) {
                cfList = GetThereSynchronizationUtil.createUserPassportInCustomField((Passport)selectedPassports.get(1));
                userProfile.getCustomFields().addAll(cfList);
            } else {
                cfList = GetThereSynchronizationUtil.createUserPassportInCustomField(null);
                userProfile.getCustomFields().addAll(cfList);
            }
        } else if (selectedPassports.size() == 0) {
            userProfile.getPassports().add(GetThereSynchronizationUtil.createUserPassport(null));
            List<GetThereSynchronizationUserProfileCustomField> cfList = GetThereSynchronizationUtil.createUserPassportInCustomField(null);
            userProfile.getCustomFields().addAll(cfList);
        }
        if (birthDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(birthDate);
            userInfo.setDateOfBirthYear(String.valueOf(cal.get(1)));
            userInfo.setDateOfBirthMonth(String.valueOf(cal.get(2) + 1));
            userInfo.setDateOfBirthDay(String.valueOf(cal.get(5)));
        }
        boolean hasBusinessAddress = false;
        for (Object addr : per.getAddresses()) {
            GetThereSynchronizationUserProfileDeliveryAddress address;
            if (AddressType.BUSINESS != addr.getAddressType() || (address = GetThereSynchronizationUtil.createUserProfileAddress((Address)addr)) == null) continue;
            userProfile.getAddresses().add(address);
            hasBusinessAddress = true;
        }
        if (!hasBusinessAddress) {
            userProfile.getAddresses().add(GetThereSynchronizationUtil.createUserProfileAddress(null));
        }
        int num = 0;
        for (Visa v : per.getVisas()) {
            GetThereSynchronizationUserProfileVisa visa = GetThereSynchronizationUtil.createUserVisa(v, ++num);
            if (visa == null) continue;
            userProfile.getVisas().add(visa);
        }
        while (num < 3) {
            userProfile.getVisas().add(GetThereSynchronizationUtil.createUserVisa(null, ++num));
        }
        num = 0;
        for (Object c : per.getCards()) {
            GetThereSynchronizationUserProfileCreditCard creditCard = GetThereSynchronizationUtil.createCreditCard((Card)c, ++num, useCir);
            if (creditCard == null) continue;
            userProfile.getCreditCards().add(creditCard);
        }
        while (num < 8) {
            userProfile.getCreditCards().add(GetThereSynchronizationUtil.createCreditCard(null, ++num, useCir));
        }
        HashMap<SabreProfileLineServiceType, ArrayList<SabreProfileLine>> remarksMap = new HashMap<SabreProfileLineServiceType, ArrayList<SabreProfileLine>>();
        for (SabreProfileLine rem2 : per.getSabreAdditionalProfileLines()) {
            if (rem2.getLineServiceType() == null) continue;
            SabreProfileLineServiceType key = rem2.getLineServiceType();
            ArrayList<SabreProfileLine> list = (ArrayList<SabreProfileLine>)remarksMap.get(key);
            if (list == null) {
                list = new ArrayList<SabreProfileLine>();
                remarksMap.put(key, list);
            }
            list.add(rem2);
        }
        userProfile.setGenPreferencesSpecial(String.join((CharSequence)"\n", per.getSabreFreeTextRemarks()));
        num = 0;
        for (AirlineBonusCard abc : per.getAirlineBonusCards()) {
            loyalty = GetThereSynchronizationUtil.createLoyaltyFromBonusCard(abc, ++num);
            if (loyalty == null) continue;
            userProfile.getLoyaltiesAirline().add(loyalty);
        }
        while (num < 12) {
            userProfile.getLoyaltiesAirline().add(GetThereSynchronizationUtil.createLoyaltyFromBonusCard(null, ++num));
        }
        num = 0;
        for (HotelBonusCard card : per.getHotelBonusCards()) {
            loyalty = GetThereSynchronizationUtil.createLoyaltyFromBaseBonusCard((BaseBonusCard)card, ++num);
            if (loyalty == null) continue;
            userProfile.getLoyaltiesHotel().add(loyalty);
        }
        while (num < 12) {
            userProfile.getLoyaltiesHotel().add(GetThereSynchronizationUtil.createLoyaltyFromRemark(null, ++num));
        }
        num = 0;
        for (HotelBonusCard card : per.getCarBonusCards()) {
            loyalty = GetThereSynchronizationUtil.createLoyaltyFromBaseBonusCard((BaseBonusCard)card, ++num);
            if (loyalty == null) continue;
            userProfile.getLoyaltiesCar().add(loyalty);
        }
        while (num < 12) {
            userProfile.getLoyaltiesCar().add(GetThereSynchronizationUtil.createLoyaltyFromRemark(null, ++num));
        }
        GetThereSynchronizationUserProfileAirPreferences airPref = new GetThereSynchronizationUserProfileAirPreferences();
        if (remarksMap.get(SabreProfileLineServiceType.M) != null && ((List)remarksMap.get(SabreProfileLineServiceType.M)).size() > 0) {
            rem2 = (SabreProfileLine)((List)remarksMap.get(SabreProfileLineServiceType.M)).get(0);
            if (!TextUtil.isBlank((String)rem2.getLineSubsection())) {
                parts = rem2.getLineSubsection().split("\\s+");
                String string = code = parts.length > 0 ? parts[0] : "";
                if (code != null && GetThereSynchronizationUtil.MEAL_CODES.containsKey(code)) {
                    airPref.setAirMeal(GetThereSynchronizationUtil.MEAL_CODES.get(code));
                } else {
                    airPref.setAirMeal(null);
                }
            } else {
                airPref.setAirMeal(rem2.getLineBody());
            }
        }
        if (remarksMap.get(SabreProfileLineServiceType.S) != null && ((List)remarksMap.get(SabreProfileLineServiceType.S)).size() > 0) {
            rem2 = (SabreProfileLine)((List)remarksMap.get(SabreProfileLineServiceType.S)).get(0);
            if (!TextUtil.isBlank((String)rem2.getLineSubsection())) {
                parts = rem2.getLineSubsection().split("\\s+");
                String string = code = parts.length > 0 ? parts[0] : "";
                if (code != null && GetThereSynchronizationUtil.SEAT_CODES.containsKey(code)) {
                    airPref.setAirSeat(GetThereSynchronizationUtil.SEAT_CODES.get(code));
                } else {
                    airPref.setAirSeat(null);
                }
            } else {
                airPref.setAirSeat(rem2.getLineBody());
            }
        }
        if (per.getPreferredDepartureAirport() != null) {
            GeoLocation airport = (GeoLocation)DictionaryCache.get().resolveReference(per.getPreferredDepartureAirport());
            if (airport != null) {
                airPref.setAirHomeApt((String)airport.getCodeVariants().get(CodeSystem.IATA.name()));
            } else {
                airPref.setAirHomeApt(null);
            }
        } else {
            airPref.setAirHomeApt(null);
        }
        userProfile.setAirPreferences(airPref);
        num = 0;
        for (SabreContactEmail e : per.getSabreEmailContacts()) {
            GetThereSynchronizationUserProfileSupervisorInfo sup = GetThereSynchronizationUtil.createSupervisorInfo(e, ++num);
            if (sup == null) continue;
            userProfile.getSupervisors().add(sup);
        }
        while (num < 3) {
            userProfile.getSupervisors().add(GetThereSynchronizationUtil.createSupervisorInfo(null, ++num));
        }
        GetThereSynchronizationUserProfileCompanyInfo companyInfo = GetThereSynchronizationUtil.createCompanyInfo(per.getCostCodes(), ProfileSynchronizationUtil.getPersonGetThereAcquisitionCode((Person)per), orgName, orgPosition, userInfo);
        userProfile.setCompanyInfo(companyInfo);
        List<GetThereSynchronizationUserProfileCustomField> customFieldsForUdids = GetThereSynchronizationUtil.createUdidsInCustomField(per.getCostCodes());
        userProfile.getCustomFields().addAll(customFieldsForUdids);
        GetThereSynchronizationUtil.inspectNonLatinSymbols(userProfile);
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetThereSynchronizationResponse execute(GetThereSynchronizationRequestBase request, ValueHolder<String> traceHolder, PCIDSSServerExchangeSettings cirSettings, String orgMainAgencyUid) {
        GetThereSynchronizationResponse response = new GetThereSynchronizationResponse();
        long start = System.currentTimeMillis();
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            XUtil.serializeWithoutRoot((XSerializable)request, (OutputStream)strm, (boolean)false);
            log.debug("GETTHERE REQUEST:");
            log.debug(strm.toString());
            URL url = GetThereSynchronizationHelper.getURL(cirSettings);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return true;
                }
            });
            HttpsURLConnection.setDefaultSSLSocketFactory(GetThereSynchronizationHelper.getFactory());
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/xml; charset=utf8");
            connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            CirHelper.setCookie((HttpURLConnection)connection, (PCIDSSServerExchangeSettings)cirSettings, (String)orgMainAgencyUid);
            try (OutputStream os = connection.getOutputStream();){
                IoUtil.copyStream((InputStream)new ByteArrayInputStream(strm.toByteArray()), (OutputStream)os, (int)256);
                os.flush();
            }
            strm = new ByteArrayOutputStream();
            InputStream is = connection.getInputStream();
            if ("gzip".equals(connection.getContentEncoding())) {
                is = new GZIPInputStream(is);
            }
            try {
                IoUtil.copyStream((InputStream)is, (OutputStream)strm, (int)256);
            }
            finally {
                is.close();
            }
            byte[] data = strm.toByteArray();
            if (data.length > 0 && data[0] == 10) {
                data = Arrays.copyOfRange(data, 1, data.length);
            }
            Document doc = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(data), (boolean)true));
            response.fromXML(doc.getDocumentElement());
            response.setStatus(GetThereSynchronizationResponse.GetThereSynchronizationResponseStatus.OK);
            log.debug("GETTHERE RESPONSE:");
            log.debug(strm.toString());
        }
        catch (Throwable e) {
            log.error("Error while sending request to GetThere", e);
            response = new GetThereSynchronizationResponse();
            response.setStatus(GetThereSynchronizationResponse.GetThereSynchronizationResponseStatus.ERROR);
        }
        finally {
            if (traceHolder != null) {
                try {
                    String trace = GetThereSynchronizationHelper.getTrace(request, response, System.currentTimeMillis() - start);
                    traceHolder.setValue((Object)trace);
                }
                catch (Throwable e) {
                    log.error("unable to log", e);
                }
            }
        }
        return response;
    }

    private static SSLSocketFactory getFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        }};
        KeyManager[] managers = new KeyManager[]{new X509KeyManager(){

            @Override
            public String[] getServerAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String arg0) {
                return null;
            }

            @Override
            public String[] getClientAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String arg0) {
                return null;
            }

            @Override
            public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
                return null;
            }

            @Override
            public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
                return null;
            }
        }};
        sc.init(managers, trustAllCerts, new SecureRandom());
        return sc.getSocketFactory();
    }

    private static List<EntityContainer<Person>> validatePersons(List<EntityReference<Person>> perRefs) {
        ArrayList<EntityContainer<Person>> res = new ArrayList<EntityContainer<Person>>();
        perRefs.forEach(perRef -> {
            boolean isValid;
            ArrayList validationItemErrors = new ArrayList();
            EntityContainer perCont = EntityStorage.get().resolve(perRef);
            if (perCont != null && perCont.getEntity() != null && (isValid = ProfileValidationUtil.validatePersonForGetThere((EntityContainer)perCont, validationItemErrors))) {
                res.add(perCont);
            }
        });
        return res;
    }

    public static List<Integer> validateAndSendPersons(List<EntityReference<Person>> perRefs) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        log.debug("validating Persons list before sending to GetThere. Amount of profiles: " + perRefs.size());
        List<EntityContainer<Person>> perContsAndDetails = GetThereSynchronizationHelper.validatePersons(perRefs);
        log.debug("synchronizing Persons list to GetThere. Amount of profiles: " + perContsAndDetails.size());
        int numSuccess = GetThereSynchronizationHelper.sendPersons(perContsAndDetails);
        res.add(perRefs.size());
        res.add(numSuccess);
        res.add(perRefs.size() - perContsAndDetails.size());
        res.add(perContsAndDetails.size() - numSuccess);
        return res;
    }

    private static int sendPersons(List<EntityContainer<Person>> personsList) {
        int numSuccess = 0;
        for (EntityContainer<Person> person : personsList) {
            try {
                MiscUtil.Pair<String, String> syncResult = GetThereSynchronizationHelper.sendPerson(person);
                if (!"1000".equals(syncResult.getFirst())) continue;
                ++numSuccess;
            }
            catch (Exception e) {
                log.error("SabreProfiles persons list synchronization error", (Throwable)e);
            }
        }
        return numSuccess;
    }
}

