/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.getthere;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.gds.sabre.GetThereHelper;
import com.gridnine.xtrip.common.model.profile.GetThereSettings;
import com.gridnine.xtrip.common.model.profile.GetThereSiteSettings;
import com.gridnine.xtrip.common.model.profile.GetThereSubsiteSettings;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.dbproperties.LogicalDBPropertiesStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationRequestQuery;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfile;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetThereSynchronizationProfileUpdater
extends BaseScheduledTask {
    private static final ValueHolder<String> TRACE = new ValueHolder();

    protected void doJob() throws Exception {
        ArrayList<GetThereSynchronizationUserProfile> profiles = new ArrayList();
        try {
            profiles = this.requestForProfileUpdates(CirHelper.getSettings());
        }
        catch (Exception e) {
            this.log.error("Exception while sending request to GetThere", (Throwable)e);
        }
        Map<String, List<GetThereSynchronizationUserProfile>> personsByOrganization = GetThereSynchronizationUtil.arrangePersonsByOrganizations(profiles);
        for (Map.Entry<String, List<GetThereSynchronizationUserProfile>> entry : personsByOrganization.entrySet()) {
            String orgDkNumber = entry.getKey();
            this.log.debug("Processing user profile  for organization: " + orgDkNumber);
            EntityContainer orgCont = ProfileDao.findProfileByCode(orgDkNumber, OrganizationIndex.class, true);
            if (orgCont == null || orgCont.getEntity() == null) {
                StringBuilder usersResourceId = new StringBuilder();
                for (GetThereSynchronizationUserProfile per : entry.getValue()) {
                    if (usersResourceId.length() > 0) {
                        usersResourceId.append(", ");
                    }
                    usersResourceId.append(per.getResourceId());
                }
                this.log.error("Failed to find organization by CRS_PROFILE code = " + orgDkNumber + " for users: " + usersResourceId);
                continue;
            }
            List<GetThereSynchronizationUserProfile> persons = entry.getValue();
            for (GetThereSynchronizationUserProfile person : persons) {
                GetThereSynchronizationUtil.updatePersonInOrganization(orgCont, person);
            }
        }
    }

    private List<GetThereSynchronizationUserProfile> requestForProfileUpdates(PCIDSSServerExchangeSettings cirSettings) {
        ArrayList<GetThereSynchronizationUserProfile> profiles = new ArrayList<GetThereSynchronizationUserProfile>();
        LogicalDBPropertiesStorage dbProps = LogicalStorage.get().getDbPropertiesStorage();
        GetThereSettings settings = GetThereHelper.getGetThereSettings();
        for (GetThereSiteSettings siteSettings : settings.getSites()) {
            String siteName = siteSettings.getSiteName();
            String userName = siteSettings.getUserName();
            String password = siteSettings.getPassword();
            for (GetThereSubsiteSettings subsiteSettings : siteSettings.getSubSites()) {
                String subsiteName = subsiteSettings.getSubsiteName();
                String orgMainAgencyUid = subsiteSettings.getAgency() != null ? subsiteSettings.getAgency().getUid() : "";
                String queryStartId = dbProps.getValue("get_there_sync.query-start-id" + siteName + subsiteName);
                GetThereSynchronizationRequestQuery request = new GetThereSynchronizationRequestQuery(siteName, subsiteName, userName, password, "query", "query-user-profiles", queryStartId, "50");
                this.log.debug("Request prepared with transactionId = " + request.getTransactionId());
                GetThereSynchronizationResponse response = GetThereSynchronizationHelper.execute(request, TRACE, cirSettings, orgMainAgencyUid);
                if ("1000".equals(response.getStatusCode())) {
                    profiles.addAll(response.getUserProfiles());
                } else {
                    this.log.error("Responce received with status code = " + response.getStatusCode() + ", status text = " + response.getStatusText());
                }
                while (response.getRecordsReturned() != null && !"0".equals(response.getRecordsReturned()) && TextUtil.isSame((String)request.getQueryMaxRecords(), (String)response.getRecordsReturned())) {
                    if (!TextUtil.isBlank((String)response.getNextQueryStartId())) {
                        request.setQueryStartId(response.getNextQueryStartId());
                    }
                    request.updateTransactionId();
                    response = GetThereSynchronizationHelper.execute(request, TRACE, cirSettings, orgMainAgencyUid);
                    if ("1000".equals(response.getStatusCode())) {
                        profiles.addAll(response.getUserProfiles());
                        continue;
                    }
                    this.log.error("Responce received with status code = " + response.getStatusCode() + ", status text = " + response.getStatusText());
                }
                this.updateQueryStartId(siteName + subsiteName, dbProps, response.getNextQueryStartId());
            }
        }
        this.log.debug("Records returned: " + profiles.size());
        return profiles;
    }

    private synchronized void updateQueryStartId(String postfix, LogicalDBPropertiesStorage dbProps, String value) {
        if (!TextUtil.isBlank((String)value)) {
            dbProps.putValue("get_there_sync.query-start-id" + postfix, value);
        }
    }
}

