/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.getthere;

import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfile;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetThereSynchronizationResponse
implements XSerializable {
    public static final String GTXML_HEADER_SENDER = "HEADER/SENDER/";
    public static final String GTXML_HEADER_RECEIVER = "HEADER/RECEIVER/";
    public static final String GTXML_BODY_RESPONSE = "BODY/RESPONSE/";
    public static final String GTXML_BODY_RESPONSE_QUERY_RESPONSE = "BODY/RESPONSE/QUERY_RESPONSE/";
    public static final String GTXML_BODY_RESPONSE_QUERY_RESULTS = "BODY/RESPONSE/QUERY_RESPONSE/QUERY_RESULTS";
    private GetThereSynchronizationResponseStatus status;
    private String version;
    private String timeStamp;
    private String senderName;
    private String receiverName;
    private String type;
    private String statusCode;
    private String statusText;
    private String recordsReturned;
    private String nextQueryStartId;
    private String transactionId;
    List<GetThereSynchronizationUserProfile> userProfiles = new ArrayList<GetThereSynchronizationUserProfile>();

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
        this.version = XHelper.readString((Element)elm, (String)"@VERSION");
        this.timeStamp = XHelper.readString((Element)elm, (String)"@TIME_STAMP");
        this.transactionId = XHelper.readString((Element)elm, (String)"@TRANSACTION_ID");
        this.senderName = XHelper.readString((Element)elm, (String)"HEADER/SENDER/SENDER_NAME");
        this.receiverName = XHelper.readString((Element)elm, (String)"HEADER/SENDER/RECEIVER_NAME");
        this.statusCode = XHelper.readString((Element)elm, (String)"BODY/RESPONSE/STATUS_CODE");
        this.statusText = XHelper.readString((Element)elm, (String)"BODY/RESPONSE/STATUS_TEXT");
        this.recordsReturned = XHelper.readString((Element)elm, (String)"BODY/RESPONSE/QUERY_RESPONSE/RECORDS_RETURNED");
        this.nextQueryStartId = XHelper.readString((Element)elm, (String)"BODY/RESPONSE/QUERY_RESPONSE/NEXT_QUERY_START_ID");
        int recNum = 0;
        try {
            Integer val = Integer.parseInt(this.recordsReturned);
            if (val != null) {
                recNum = val;
            }
        }
        catch (NumberFormatException e) {
            recNum = 0;
        }
        NodeList userProfilesNodes = elm.getElementsByTagName("USER_PROFILE");
        for (int i = 0; i < recNum; ++i) {
            GetThereSynchronizationUserProfile profile = new GetThereSynchronizationUserProfile();
            Node node = userProfilesNodes.item(i);
            if (node instanceof Element) {
                profile.fromXML((Element)node);
            }
            this.userProfiles.add(profile);
        }
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public GetThereSynchronizationResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(GetThereSynchronizationResponseStatus status) {
        this.status = status;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getRecordsReturned() {
        return this.recordsReturned;
    }

    public void setRecordsReturned(String recordsReturned) {
        this.recordsReturned = recordsReturned;
    }

    public String getNextQueryStartId() {
        return this.nextQueryStartId;
    }

    public void setNextQueryStartId(String nextQueryStartId) {
        this.nextQueryStartId = nextQueryStartId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public List<GetThereSynchronizationUserProfile> getUserProfiles() {
        return this.userProfiles;
    }

    public static enum GetThereSynchronizationResponseStatus {
        OK,
        ERROR;

    }
}

