/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.getthere;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CarsSupplier;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeExternalType;
import com.gridnine.xtrip.common.model.dict.CostCodeExternalTypeReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.PersonTitle;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.BaseBonusCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.GetThereSettings;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfile;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileAirPreferences;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCompanyInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCreditCard;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileCustomField;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileDeliveryAddress;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileLoyalty;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfilePassport;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfilePhone;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileSupervisorInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileUserInfo;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUserProfileVisa;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.text.MaskFormatter;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetThereSynchronizationUtil {
    private static final String DD_MM_MYYYY_FORMAT_PATTERN = "ddMMMyyyy";
    private static final String SDF_WITH_SLASHES_REVERSED_FORMAT_PATTERN = "MM/dd/yyyy";
    private static final String SDF_FOR_CREDIT_CARD_FORMAT_PATTERN = "MM/yy";
    public static final String PARAM_SITE_NAME = "siteName";
    public static final String PARAM_USER_NAME = "userName";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_SUBSITE_NAME = "subsiteName";
    public static final String PARAM_AGENCY_UID = "agencyUid";
    public static final String QUERY_MAX_RECORDS = "50";
    public static final String REQUEST_TYPE_QUERY = "query";
    public static final String REQUEST_TYPE_IMPORT = "import";
    public static final String REQUEST_OPERATION_QUERY = "query-user-profiles";
    public static final String REQUEST_OPERATION_ADD = "add-user-profile";
    public static final String REQUEST_OPERATION_UPDATE = "update-user-profile";
    public static final String REQUEST_OPERATION_FORCE = "force-user-profile";
    public static final String REQUEST_OPERATION_DELETE = "delete-user-profile";
    public static final String REQUEST_EVENT_TYPE_UPU = "upu_event";
    public static final String REQUEST_SITE_TYPE_CORP = "corp";
    private static final String COST_CENTER = "cost_center";
    private static final String DEPARTMENT = "department";
    private static final String DIVISION = "division";
    private static final String CORPORATE_ID = "corporate_id";
    private static final String PROJECT_CODE = "project_code";
    public static final String STATUS_CODE_OK = "1000";
    public static final String STATUS_CODE_IMPORT_INVALID_DML = "3002";
    public static final String DB_PROPS_QUERY_START_ID = "get_there_sync.query-start-id";
    protected static final transient Logger log = LoggerFactory.getLogger(GetThereSynchronizationUtil.class);
    public static final Map<String, CommunicationType> COMMUNICATION_TYPES = new HashMap<String, CommunicationType>(){
        private static final long serialVersionUID = -5683877524256737346L;
        {
            this.put("HOME", CommunicationType.HOME_PHONE);
            this.put("WORK", CommunicationType.WORK_PHONE);
            this.put("FAX", CommunicationType.MOBILE);
        }
    };
    public static final Map<String, CardVendor> CARD_VENDORS = new HashMap<String, CardVendor>(){
        private static final long serialVersionUID = 6151517223020013572L;
        {
            this.put("Visa", CardVendor.VISA);
            this.put("MasterCard", CardVendor.MASTERCARD);
            this.put("American Express", CardVendor.AMEX);
            this.put("Diners Club", CardVendor.DINERS_CLUB);
            this.put("Discover Card", null);
            this.put("Eurocard", null);
            this.put("jcb card", CardVendor.JCB);
            this.put("Universal Air Travel Card", CardVendor.AIR_TRAVEL_CARD);
        }
    };
    public static final Map<String, String> SEAT_CODES = new HashMap<String, String>(){
        private static final long serialVersionUID = 3448921708889290244L;
        {
            this.put("NSSA", "aisle");
            this.put("NSSW", "window");
        }
    };
    public static final Map<String, String> MEAL_CODES = new HashMap<String, String>(){
        private static final long serialVersionUID = -1320535898233060346L;
        {
            this.put("AVML", "asian vegetarian");
            this.put("BBML", "child");
            this.put("BLML", "bland");
            this.put("CHML", "child");
            this.put("DBML", "diabetic");
            this.put("FPML", "fruit plate");
            this.put("GFML", "gluten free");
            this.put("HNML", "hindu");
            this.put("KSML", "kosher");
            this.put("LFML", "low calorie");
            this.put("LSML", "low sodium");
            this.put("MOML", "muslim");
            this.put("NLML", "non-lacrose");
            this.put("RVML", "raw vegetarian");
            this.put("SFML", "seafood");
            this.put("VJML", "vegetarian");
            this.put("VLML", "vegetarian lacto-ovo");
            this.put("VOML", "vegetarian");
            this.put("VGML", "vegetarian");
        }
    };
    private static final List<SimpleDateFormat> DATE_FORMATS = new ArrayList<SimpleDateFormat>(){
        private static final long serialVersionUID = 3448921708889290244L;
        {
            this.add(new SimpleDateFormat(GetThereSynchronizationUtil.SDF_FOR_CREDIT_CARD_FORMAT_PATTERN));
            this.add(new SimpleDateFormat("dd/MM/yyyy"));
            this.add(new SimpleDateFormat("dd-MM-yyyy"));
            this.add(new SimpleDateFormat(GetThereSynchronizationUtil.DD_MM_MYYYY_FORMAT_PATTERN, LocaleUtil.LOCALE_EN));
            this.add(new SimpleDateFormat("dd.MM.yyyy"));
            this.add(new SimpleDateFormat("MM/yyyy"));
        }
    };
    public static final int MAX_VISAS = 3;
    public static final int MAX_CREDIT_CARDS = 8;
    public static final int MAX_LOYALTIES_AIRLINE = 12;
    public static final int MAX_LOYALTIES_HOTEL = 12;
    public static final int MAX_LOYALTIES_CAR = 12;
    public static final int MAX_LOYALTIES_RAIL = 30;
    public static final int MAX_SUPERVISORS = 3;
    public static final String ADDITIONAL_PASSPORT_EXPIRATION = "addl_passport_exp";
    public static final String ADDITIONAL_PASSPORT_NUMBER = "addl_passport_no";
    public static final String ADDITIONAL_PASSPORT_COUNTRY = "addl_passport_co";
    public static final Map<String, PersonTitle> string2Title = new HashMap<String, PersonTitle>(){
        private static final long serialVersionUID = 4522597487164636928L;
        {
            this.put("DR", PersonTitle.DR);
            this.put("JR", PersonTitle.JR);
            this.put("MISS", PersonTitle.MISS);
            this.put("MR", PersonTitle.MR);
            this.put("MRS", PersonTitle.MRS);
            this.put("MS", PersonTitle.MS);
            this.put("MSTR", PersonTitle.MSTR);
            this.put("SR", PersonTitle.SR);
        }
    };
    public static final Map<PersonTitle, String> title2String = new HashMap<PersonTitle, String>(){
        private static final long serialVersionUID = -759483184270337506L;
        {
            this.put(PersonTitle.DR, "Dr");
            this.put(PersonTitle.MISS, "Miss");
            this.put(PersonTitle.MR, "Mr");
            this.put(PersonTitle.MRS, "Mrs");
            this.put(PersonTitle.MS, "Ms");
        }
    };
    private static final Pattern cyrillicSymbols = Pattern.compile("[\u0410-\u042f\u0430-\u044f]+");

    private static DateFormat createSdfFull() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss' GMT'");
    }

    private static DateFormat createSdfWithSlashesReversedFormat() {
        return new SimpleDateFormat(SDF_WITH_SLASHES_REVERSED_FORMAT_PATTERN);
    }

    private static DateFormat createSdfForCreditCardFormat() {
        return new SimpleDateFormat(SDF_FOR_CREDIT_CARD_FORMAT_PATTERN);
    }

    private static DateFormat createSdf_ddMMMyyyyFormat() {
        return new SimpleDateFormat(DD_MM_MYYYY_FORMAT_PATTERN, LocaleUtil.LOCALE_EN);
    }

    static Map<String, List<GetThereSynchronizationUserProfile>> arrangePersonsByOrganizations(List<GetThereSynchronizationUserProfile> profiles) {
        HashMap<String, List<GetThereSynchronizationUserProfile>> res = new HashMap<String, List<GetThereSynchronizationUserProfile>>();
        for (GetThereSynchronizationUserProfile profile : profiles) {
            List<GetThereSynchronizationUserProfile> list;
            String profileName;
            String string = profileName = profile.getUserInfo() != null ? profile.getUserInfo().getCrsProfile() : null;
            if (TextUtil.isBlank((String)profileName)) {
                log.error("User profile has empty CRS_PROFILE tag - unable to determine it's organization - " + profile.getResourceId());
                continue;
            }
            if (!res.containsKey(profileName)) {
                list = new ArrayList();
                res.put(profileName, list);
            }
            list = (List)res.get(profileName);
            list.add(profile);
        }
        return res;
    }

    static void updatePersonInOrganization(EntityContainer<Organization> orgCont, GetThereSynchronizationUserProfile gtPerson) {
        String resourceId = gtPerson.getResourceId();
        EntityContainer<Person> perCont = GetThereSynchronizationUtil.findOrCreatePersonContainer((EntityReference<Organization>)orgCont.toReference(), resourceId);
        Person per = (Person)perCont.getEntity();
        GetThereSynchronizationUserProfileUserInfo userInfo = gtPerson.getUserInfo();
        GetThereSynchronizationUtil.updateName(per, userInfo);
        Date birthDate = GetThereSynchronizationUtil.getBirthDate(userInfo);
        if ("f".equalsIgnoreCase(userInfo.getGender())) {
            per.setGender(Gender.FEMALE);
        } else if ("m".equalsIgnoreCase(userInfo.getGender())) {
            per.setGender(Gender.MALE);
        } else {
            per.setGender(null);
        }
        GetThereSynchronizationUtil.updateCommunications(userInfo, per, (EntityReference<Organization>)orgCont.toReference());
        GetThereSynchronizationUtil.updatePassports(gtPerson.getPassports(), gtPerson.getCustomFields(), per, birthDate, gtPerson.getResourceId());
        GetThereSynchronizationUtil.updateAddresses(gtPerson.getAddresses(), per, (EntityReference<Organization>)orgCont.toReference(), gtPerson.getResourceId());
        GetThereSynchronizationUtil.updateVisas(gtPerson.getVisas(), per, gtPerson.getResourceId());
        GetThereSynchronizationUtil.updateCreditCards(gtPerson.getCreditCards(), per, gtPerson.getResourceId(), (EntityReference<Organization>)orgCont.toReference());
        GetThereSynchronizationUtil.updateBonusCards(gtPerson.getLoyaltiesAirline(), per, gtPerson.getResourceId());
        GetThereSynchronizationUtil.updateHotelBonusCards(gtPerson.getLoyaltiesHotel(), per, gtPerson.getResourceId());
        GetThereSynchronizationUtil.updateCarBonusCards(gtPerson.getLoyaltiesCar(), per, gtPerson.getResourceId());
        per.getSabreFreeTextRemarks().clear();
        per.getSabreFreeTextRemarks().add(gtPerson.getGenPreferencesSpecial());
        GetThereSynchronizationUtil.updatePreferencesRemarks(gtPerson.getAirPreferences(), per);
        GetThereSynchronizationUtil.updateEmergencyContact(per, (EntityReference<Organization>)orgCont.toReference(), gtPerson.getEcInfoPhone(), gtPerson.getEcInfoCountry(), gtPerson.getEcInfoFirstName(), gtPerson.getEcInfoLastName());
        GetThereSynchronizationUtil.updateSabreEmails(gtPerson.getSupervisors(), per);
        GetThereSynchronizationUtil.updateUdids(gtPerson.getCompanyInfo(), gtPerson.getCustomFields(), per, orgCont, gtPerson.getResourceId());
        perCont.getVersionInfo().setDataSource("GetThere");
        EntityStorage.get().save(perCont, true);
    }

    static EntityContainer<Person> findPersonInOrganization(String orgRefUid, String resourceId) {
        EntityReference perRef;
        EntityContainer res = null;
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)orgRefUid)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)orgRefUid));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.resourceIdForGetThere.name(), (Object)resourceId));
        List indices = EntityStorage.get().search(PersonIndex.class, query).getData();
        if (indices.size() > 1) {
            log.warn("More than one (" + indices.size() + ") persons are found by resourceId = " + resourceId);
        }
        if (indices.size() > 0 && (perRef = ((PersonIndex)indices.get(0)).getSource()) != null) {
            res = EntityStorage.get().resolve(perRef);
        }
        return res;
    }

    private static void updateBonusCards(List<GetThereSynchronizationUserProfileLoyalty> loyaltiesAirline, Person per, String resourceId) {
        per.getAirlineBonusCards().clear();
        for (GetThereSynchronizationUserProfileLoyalty card : loyaltiesAirline) {
            if (TextUtil.isBlank((String)card.getAcctNum())) continue;
            AirlineBonusCard abc = new AirlineBonusCard();
            abc.setNumber(card.getAcctNum());
            if (card.getAcctName() != null) {
                Airline airline = DictHelper.findAirlineByAnyCode((String)card.getAcctName());
                Object airlineRef = null;
                airlineRef = airline == null ? DictHelper.getAirlineByNameAndAnyVariants((String)card.getAcctName()) : airline.toReference();
                if (airlineRef == null) {
                    log.error("Failed to determine airline by name/code: " + card.getAcctName() + " while updating bonus cards - " + resourceId);
                }
                abc.setAirline((DictionaryReference)airlineRef);
                abc.setAirlineApplied((DictionaryReference)airlineRef);
            }
            String nameOnCard = "";
            if (L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true) != null) {
                nameOnCard = nameOnCard + L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true) + " ";
            }
            if (L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true) != null) {
                nameOnCard = nameOnCard + L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
            }
            abc.setNameOnCard(nameOnCard.trim());
            per.getAirlineBonusCards().add(abc);
        }
    }

    private static void updateHotelBonusCards(List<GetThereSynchronizationUserProfileLoyalty> loyaltiesHotel, Person per, String resourceId) {
        per.getHotelBonusCards().clear();
        for (GetThereSynchronizationUserProfileLoyalty card : loyaltiesHotel) {
            if (TextUtil.isBlank((String)card.getAcctNum())) continue;
            HotelBonusCard hbc = new HotelBonusCard();
            hbc.setNumber(card.getAcctNum());
            if (card.getAcctName() != null) {
                HotelsBrand hotelBrand;
                Set hotelBrands = DictHelper.findHotelBrandByName((String)card.getAcctName());
                HotelsBrand hotelsBrand = hotelBrand = hotelBrands.size() > 0 ? (HotelsBrand)hotelBrands.iterator().next() : null;
                if (hotelBrand == null) {
                    hotelBrands = DictHelper.findHotelBrandByCode((String)card.getAcctName());
                    HotelsBrand hotelsBrand2 = hotelBrand = hotelBrands.size() > 0 ? (HotelsBrand)hotelBrands.iterator().next() : null;
                }
                if (hotelBrand == null) {
                    log.error("Failed to determine hotels brand by name/code: " + card.getAcctName() + " while updating hotel bonus cards - " + resourceId);
                } else {
                    hbc.setHotelBrand((DictionaryReference)hotelBrand.toReference());
                }
            }
            per.getHotelBonusCards().add(hbc);
        }
    }

    private static void updateCarBonusCards(List<GetThereSynchronizationUserProfileLoyalty> loyaltiesCar, Person per, String resourceId) {
        per.getCarBonusCards().clear();
        for (GetThereSynchronizationUserProfileLoyalty card : loyaltiesCar) {
            if (TextUtil.isBlank((String)card.getAcctNum())) continue;
            CarBonusCard cbc = new CarBonusCard();
            cbc.setNumber(card.getAcctNum());
            if (card.getAcctName() != null) {
                CarsSupplier carsSupplier;
                Set carsSuppliers = DictHelper.findCarsSupplierByName((String)card.getAcctName());
                CarsSupplier carsSupplier2 = carsSupplier = carsSuppliers.size() > 0 ? (CarsSupplier)carsSuppliers.iterator().next() : null;
                if (carsSupplier == null) {
                    carsSuppliers = DictHelper.findCarsSupplierByCode((String)card.getAcctName());
                    CarsSupplier carsSupplier3 = carsSupplier = carsSuppliers.size() > 0 ? (CarsSupplier)carsSuppliers.iterator().next() : null;
                }
                if (carsSupplier == null) {
                    log.error("Failed to determine car supplier by name/code: " + card.getAcctName() + " while updating car bonus cards - " + resourceId);
                } else {
                    cbc.setCarSupplier((DictionaryReference)carsSupplier.toReference());
                }
            }
            per.getCarBonusCards().add(cbc);
        }
    }

    private static void updateRailwayBonusCards(List<GetThereSynchronizationUserProfileLoyalty> loyaltiesRail, Person per, String resourceId) {
        per.getRailwayBonusCards().clear();
        for (GetThereSynchronizationUserProfileLoyalty card : loyaltiesRail) {
            if (TextUtil.isBlank((String)card.getAcctNum())) continue;
            boolean hasRailway = false;
            for (PluginDescriptor descr : PluginManager.lookup(DictHelper.class).getRegistry().getPluginDescriptors()) {
                if (descr.getId() == null || !descr.getId().endsWith(".railway")) continue;
                hasRailway = true;
                break;
            }
            if (!hasRailway) continue;
            RailwayBonusCard rbc = new RailwayBonusCard();
            rbc.setNumber(card.getAcctNum());
            if (card.getAcctName() != null) {
                String railwayCarrierCode = GetThereSynchronizationUtil.findRailwayCarrierByCode(card.getAcctName());
                if (TextUtil.isBlank((String)railwayCarrierCode)) {
                    log.error("Failed to determine railway brand by name/code: " + card.getAcctName() + " while updating railway bonus cards - " + resourceId);
                } else {
                    rbc.setRailwayCarrierCode(railwayCarrierCode);
                }
            }
            per.getRailwayBonusCards().add(rbc);
        }
    }

    private static void updateCreditCards(List<GetThereSynchronizationUserProfileCreditCard> creditCards, Person per, String resourceId, EntityReference<Organization> orgRef) {
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        boolean cirEnabled = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)cirSettings);
        if (cirEnabled) {
            per.getCards().forEach(card -> card.setToRemove(true));
        } else {
            per.getCards().clear();
        }
        for (GetThereSynchronizationUserProfileCreditCard card2 : creditCards) {
            Card c;
            if (TextUtil.isBlank((String)card2.getCcNum())) continue;
            if (cirEnabled) {
                String[] splitResult = card2.getCcNum().split("\\|");
                String cirUid = splitResult[0];
                String truncatedPan = splitResult[1];
                c = per.getCards().stream().filter(perCard -> Objects.equals(perCard.getCirUid(), cirUid)).findAny().orElse(new Card());
                c.setToRemove(false);
                c.setNumber(truncatedPan);
                c.setCirUid(cirUid);
            } else {
                c = new Card();
                c.setNumber(card2.getCcNum());
            }
            c.setNameOnCard(card2.getCcName());
            c.setRemarks(card2.getCcUniqueName());
            CardVendor cv = CARD_VENDORS.get(card2.getCcType());
            if (cv == null && (cv = (CardVendor)ProfileSynchronizationConstants.Abbr2Card.get(card2.getCcType())) == null) {
                log.warn("Failed to determine card vendor for code: " + card2.getCcType() + " - " + resourceId);
            }
            c.setVendor(cv);
            if (card2.getCcExp() != null) {
                Date d = null;
                try {
                    d = GetThereSynchronizationUtil.createSdfForCreditCardFormat().parse(card2.getCcExp());
                    if (d != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(d);
                        cal.set(5, cal.getActualMaximum(5));
                        cal.set(10, 23);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        d = cal.getTime();
                    }
                }
                catch (ParseException exc) {
                    d = GetThereSynchronizationUtil.parseDate(card2.getCcExp());
                }
                if (d == null) {
                    log.warn("Failed to parse date: " + card2.getCcExp() + " while updating credit card - " + resourceId);
                } else {
                    c.setExpiration(d);
                }
            }
            if (per.getCards().contains(c)) continue;
            per.getCards().add(c);
        }
        MiscUtil.Pair cirToken = CirHelper.cirToken((PCIDSSServerExchangeSettings)cirSettings, orgRef);
        String agencyToken = Optional.ofNullable(cirToken).map(MiscUtil.Pair::getSecond).orElse(null);
        Iterator iterator = per.getCards().iterator();
        while (iterator.hasNext()) {
            Card card3 = (Card)iterator.next();
            if (!card3.isToRemove()) continue;
            if (!TextUtil.isBlank((String)card3.getCirUid())) {
                try {
                    CirHelper.deleteCard((Card)card3, (PCIDSSServerExchangeSettings)cirSettings, (String)agencyToken);
                    iterator.remove();
                }
                catch (Exception e) {
                    log.error("Unable to delete card", (Throwable)e);
                }
                continue;
            }
            iterator.remove();
        }
    }

    private static void updateVisas(List<GetThereSynchronizationUserProfileVisa> visas, Person per, String resourceId) {
        per.getVisas().clear();
        for (GetThereSynchronizationUserProfileVisa visa : visas) {
            if (TextUtil.isBlank((String)visa.getVisaNo())) continue;
            Visa v = new Visa();
            v.setNumber(visa.getVisaNo());
            if (!TextUtil.isBlank((String)visa.getVisaCo())) {
                DictionaryReference countryByName = DictHelper.findCountryByName((String)visa.getVisaCo());
                if (countryByName == null) {
                    Set countries = DictHelper.findCountryByCode((String)visa.getVisaCo());
                    if (countries.size() == 0) {
                        log.warn("No country found for code: " + visa.getVisaCo() + " while updating visa - " + resourceId);
                    } else {
                        Country c = (Country)countries.iterator().next();
                        if (c != null) {
                            countryByName = c.toReference();
                        } else {
                            log.warn("No country found for code: " + visa.getVisaCo() + " while updating visa - " + resourceId);
                        }
                    }
                }
                v.setCountry(countryByName);
            }
            if (!TextUtil.isBlank((String)visa.getVisaExp())) {
                Date expDate = null;
                try {
                    expDate = GetThereSynchronizationUtil.createSdfWithSlashesReversedFormat().parse(visa.getVisaExp());
                }
                catch (ParseException e) {
                    expDate = GetThereSynchronizationUtil.parseDate(visa.getVisaExp());
                }
                if (expDate == null) {
                    log.warn("Failed to parse expiration date " + visa.getVisaExp() + " while updating visa - " + resourceId);
                } else {
                    v.setEndDate(expDate);
                }
            }
            per.getVisas().add(v);
        }
    }

    public static Date parseDate(String date) {
        Date res = null;
        for (SimpleDateFormat sdf : DATE_FORMATS) {
            try {
                res = sdf.parse(date);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        return res;
    }

    private static void updateLoyaltiesRemarks(List<GetThereSynchronizationUserProfileLoyalty> loyaltiesList, Person per, SabreProfileLineServiceType serviceType, String subsection) {
        Iterator iter = per.getSabreAdditionalProfileLines().iterator();
        while (iter.hasNext()) {
            SabreProfileLine line = (SabreProfileLine)iter.next();
            if (serviceType == null || !serviceType.equals((Object)line.getLineServiceType()) || !TextUtil.isSame((String)subsection, (String)line.getLineSubsection())) continue;
            iter.remove();
        }
        for (GetThereSynchronizationUserProfileLoyalty card : loyaltiesList) {
            if (TextUtil.isBlank((String)card.getAcctNum())) continue;
            SabreProfileLine remark = new SabreProfileLine();
            remark.setLineType(SabreProfileLineType.A);
            remark.setLineServiceType(serviceType);
            remark.setLineSubsection(subsection);
            remark.setLineBody(card.getAcctName() + " " + card.getAcctNum());
            per.getSabreAdditionalProfileLines().add(remark);
        }
    }

    private static void updatePreferencesRemarks(GetThereSynchronizationUserProfileAirPreferences airPreferences, Person per) {
        boolean found;
        SabreProfileLine remark;
        Iterator iter = per.getSabreAdditionalProfileLines().iterator();
        while (iter.hasNext()) {
            SabreProfileLine line = (SabreProfileLine)iter.next();
            if (SabreProfileLineServiceType.S != line.getLineServiceType() && SabreProfileLineServiceType.M != line.getLineServiceType()) continue;
            iter.remove();
        }
        if (!TextUtil.isBlank((String)airPreferences.getAirMeal())) {
            remark = new SabreProfileLine();
            remark.setLineType(SabreProfileLineType.A);
            remark.setLineServiceType(SabreProfileLineServiceType.M);
            found = false;
            Map dictMap = DictionaryCache.get().getAll(SpecialServiceRequestDict.class);
            HashMap abbrToDescr = new HashMap();
            for (SpecialServiceRequestDict specialServiceRequestDict : dictMap.values()) {
                if (specialServiceRequestDict.getCategory() != SpecialServiceRequestCategory.MEALS) continue;
                abbrToDescr.put(specialServiceRequestDict.getCodeVariants().get(CodeSystem.IATA.name()), specialServiceRequestDict.getTranslations().get(LocaleUtil.LOCALE_EN));
            }
            for (Map.Entry entry : MEAL_CODES.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!TextUtil.isSame((String)value, (String)airPreferences.getAirMeal())) continue;
                found = true;
                String descr = (String)abbrToDescr.get(key);
                if (descr != null) {
                    remark.setLineSubsection(key + " - " + descr);
                    break;
                }
                remark.setLineSubsection(key);
                break;
            }
            if (!found) {
                remark.setLineBody(airPreferences.getAirMeal());
            }
            per.getSabreAdditionalProfileLines().add(remark);
        }
        if (!TextUtil.isBlank((String)airPreferences.getAirSeat())) {
            remark = new SabreProfileLine();
            remark.setLineType(SabreProfileLineType.A);
            remark.setLineServiceType(SabreProfileLineServiceType.S);
            found = false;
            for (Map.Entry<String, String> entry : SEAT_CODES.entrySet()) {
                String key = entry.getKey();
                String string = entry.getValue();
                if (!TextUtil.isSame((String)string, (String)airPreferences.getAirSeat())) continue;
                found = true;
                if ("NSSA".equals(key)) {
                    remark.setLineSubsection("NSSA - AISLE");
                    break;
                }
                if ("NSSW".equals(key)) {
                    remark.setLineSubsection("NSSW - WINDOW");
                    break;
                }
                remark.setLineSubsection(key);
                break;
            }
            if (!found) {
                remark.setLineBody(airPreferences.getAirSeat());
            }
            per.getSabreAdditionalProfileLines().add(remark);
        }
        if (!TextUtil.isBlank((String)airPreferences.getAirHomeApt())) {
            GeoLocation airport = DictHelper.findAirport((String)airPreferences.getAirHomeApt());
            if (airport != null) {
                per.setPreferredDepartureAirport((DictionaryReference)airport.toReference());
            } else {
                per.setPreferredDepartureAirport(null);
            }
        } else {
            per.setPreferredDepartureAirport(null);
        }
    }

    private static void updateEmergencyContact(Person per, EntityReference<Organization> orgRef, String ecInfoPhone, String ecInfoCountry, String ecInfoFirstName, String ecInfoLastName) {
        PersonCommunication pc;
        Iterator iter = per.getCommunications().iterator();
        while (iter.hasNext()) {
            pc = (PersonCommunication)iter.next();
            if (CommunicationType.EMERGENCY != pc.getType()) continue;
            iter.remove();
        }
        if (TextUtil.nonBlank((String)ecInfoPhone)) {
            pc = new PersonCommunication();
            pc.setOrganization(orgRef);
            pc.setSense(ecInfoPhone);
            pc.setCountryCode("");
            if (ecInfoFirstName == null) {
                ecInfoFirstName = "";
            }
            if (ecInfoLastName == null) {
                ecInfoLastName = "";
            }
            pc.setRemarks(ecInfoFirstName + " " + ecInfoLastName);
            pc.setType(CommunicationType.EMERGENCY);
            per.getCommunications().add(pc);
        }
    }

    private static void updateAddresses(List<GetThereSynchronizationUserProfileDeliveryAddress> addresses, Person per, EntityReference<Organization> orgRef, String resourceId) {
        Iterator iter = per.getAddresses().iterator();
        while (iter.hasNext()) {
            PersonAddress a = (PersonAddress)iter.next();
            if (AddressType.BUSINESS != a.getAddressType()) continue;
            iter.remove();
        }
        for (GetThereSynchronizationUserProfileDeliveryAddress addr : addresses) {
            if (TextUtil.isBlank((String)addr.getStreet())) continue;
            PersonAddress a = new PersonAddress();
            String addressLine = addr.getStreet();
            a.getAddress().getValues().put(LocaleUtil.LOCALE_EN, addressLine);
            DictionaryReference city = DictHelper.findCityByNameAndAnyVariants((String)addr.getCity());
            if (city == null) {
                log.warn("No city found for name: " + addr.getCity() + " while updating address - " + resourceId);
            }
            a.setCity(city);
            DictionaryReference country = null;
            Set countries = DictHelper.findCountryByCode((String)addr.getCountry());
            if (countries.size() == 0) {
                country = DictHelper.findCountryByName((String)addr.getCountry());
            } else {
                Country c = (Country)countries.iterator().next();
                if (c != null) {
                    country = c.toReference();
                }
            }
            if (country == null) {
                log.warn("No country found for name: " + addr.getCountry() + " while updating asddress - " + resourceId);
            } else {
                a.setCountry(country);
            }
            a.setZip(addr.getPostalCode());
            DictionaryReference region = DictHelper.findGeoRegionByName((String)addr.getState());
            if (region == null) {
                log.warn("No region found for name: " + addr.getState() + " while updating address - " + resourceId);
            }
            a.setRegion(region);
            a.getHouse().getValues().put(LocaleUtil.LOCALE_EN, addr.getMailStop());
            a.setAddressType(AddressType.BUSINESS);
            a.setOrganization(orgRef);
            per.getAddresses().add(a);
        }
    }

    private static EntityContainer<Person> findOrCreatePersonContainer(EntityReference<Organization> orgRef, String resourceId) {
        EntityContainer res = GetThereSynchronizationUtil.findPersonInOrganization(orgRef != null ? orgRef.getUid() : null, resourceId);
        PersonEmployment pe = null;
        if (res == null) {
            log.warn("No person found for ResourceId = " + resourceId + ". Creating new profile");
            res = new EntityContainer(Person.class, UUIDGenerator.generate().toString());
            res.setCreatedBy("system");
            res.setModifiedBy("system");
            VersionInfo versionInfo = res.getVersionInfo();
            String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
            versionInfo.setUid(versionInfoUid);
            versionInfo.setCreatedBy("system");
            versionInfo.setModifiedBy("system");
            pe = new PersonEmployment();
            pe.setOrganization(orgRef);
            Person per = (Person)res.getEntity();
            per.getEmployments().add(pe);
            per.setResourceIdForGetThere(resourceId);
            per.getTypes().add(PersonType.PASSENGER);
        }
        return res;
    }

    private static void updateName(Person per, GetThereSynchronizationUserProfileUserInfo userInfo) {
        per.getLastName().getValues().put(LocaleUtil.LOCALE_EN, userInfo.getLastName());
        StringBuilder name = new StringBuilder(userInfo.getFirstName());
        if (!TextUtil.isBlank((String)userInfo.getMiddleName())) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append(userInfo.getMiddleName());
        }
        per.getFirstName().getValues().put(LocaleUtil.LOCALE_EN, name.toString());
        if (!TextUtil.isBlank((String)userInfo.getNtitle())) {
            per.setTitle(string2Title.get(userInfo.getNtitle().toUpperCase()));
        }
    }

    private static void updatePassports(List<GetThereSynchronizationUserProfilePassport> passports, List<GetThereSynchronizationUserProfileCustomField> customFields, Person per, Date birthDate, String resourceId) {
        Iterator iter = per.getPassports().iterator();
        while (iter.hasNext()) {
            Passport p = (Passport)iter.next();
            if (PassportType.FOREIGN != p.getType()) continue;
            iter.remove();
        }
        for (GetThereSynchronizationUserProfilePassport passport : passports) {
            if (TextUtil.isBlank((String)passport.getPassportNo())) continue;
            Passport p = GetThereSynchronizationUtil.createPassport(passport.getPassportNo(), passport.getPassportCo(), passport.getPassportExp(), per.getLastName(), per.getFirstName(), birthDate, per.getGender(), resourceId);
            per.getPassports().add(p);
        }
        String addCountry = null;
        String addNumber = null;
        String addExp = null;
        for (GetThereSynchronizationUserProfileCustomField cf : customFields) {
            if (ADDITIONAL_PASSPORT_COUNTRY.equals(cf.getName())) {
                addCountry = cf.getValue();
            }
            if (ADDITIONAL_PASSPORT_NUMBER.equals(cf.getName())) {
                addNumber = cf.getValue();
            }
            if (ADDITIONAL_PASSPORT_EXPIRATION.equals(cf.getName())) {
                addExp = cf.getValue();
            }
            if (TextUtil.isBlank((String)addCountry) || TextUtil.isBlank((String)addNumber) || TextUtil.isBlank((String)addExp)) continue;
            break;
        }
        if (!TextUtil.isBlank(addNumber)) {
            Passport p = GetThereSynchronizationUtil.createPassport(addNumber, addCountry, addExp, per.getLastName(), per.getFirstName(), birthDate, per.getGender(), resourceId);
            per.getPassports().add(p);
        }
    }

    private static Passport createPassport(String passportNo, String passportCo, String passportExp, L10nString lastName, L10nString firstName, Date birthDate, Gender gender, String resourceId) {
        Passport p = new Passport();
        p.setType(PassportType.FOREIGN);
        p.setBirthday(birthDate);
        p.setNumber(passportNo);
        if (lastName != null) {
            p.setLastName((String)lastName.getValues().get(LocaleUtil.LOCALE_EN));
        }
        if (firstName != null) {
            p.setFirstName((String)firstName.getValues().get(LocaleUtil.LOCALE_EN));
        }
        if (!TextUtil.isBlank((String)passportCo)) {
            DictionaryReference countryByName = DictHelper.findCountryByName((String)passportCo);
            if (countryByName == null) {
                Set countries = DictHelper.findCountryByCode((String)passportCo);
                if (countries.size() == 0) {
                    log.warn("No country found for code: " + passportCo + " while updating passport - " + resourceId);
                } else {
                    Country c = (Country)countries.iterator().next();
                    if (c != null) {
                        countryByName = c.toReference();
                    } else {
                        log.warn("No country found for code: " + passportCo + " while updating passport - " + resourceId);
                    }
                }
            }
            p.setOriginCountry(countryByName);
            p.setCitizenship(countryByName);
        }
        if (!TextUtil.isBlank((String)passportExp)) {
            Date expDate = null;
            try {
                expDate = GetThereSynchronizationUtil.createSdfWithSlashesReversedFormat().parse(passportExp);
            }
            catch (ParseException e) {
                expDate = GetThereSynchronizationUtil.parseDate(passportExp);
            }
            if (expDate == null) {
                log.warn("Failed to parse date " + passportExp + " while updating passport - " + resourceId);
            } else {
                p.setExpired(expDate);
            }
        }
        p.setGender(gender);
        return p;
    }

    private static Date getBirthDate(GetThereSynchronizationUserProfileUserInfo userInfo) {
        if (!(TextUtil.isBlank((String)userInfo.getDateOfBirthYear()) || TextUtil.isBlank((String)userInfo.getDateOfBirthMonth()) || TextUtil.isBlank((String)userInfo.getDateOfBirthDay()))) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, GetThereSynchronizationUtil.stringToInt(userInfo.getDateOfBirthYear()));
            cal.set(2, GetThereSynchronizationUtil.stringToInt(userInfo.getDateOfBirthMonth()) - 1);
            cal.set(5, GetThereSynchronizationUtil.stringToInt(userInfo.getDateOfBirthDay()));
            return cal.getTime();
        }
        return null;
    }

    private static void updateCommunications(GetThereSynchronizationUserProfileUserInfo userInfo, Person per, EntityReference<Organization> orgRef) {
        Object pc;
        Iterator iter = per.getCommunications().iterator();
        while (iter.hasNext()) {
            pc = (PersonCommunication)iter.next();
            if (!COMMUNICATION_TYPES.values().contains(pc.getType()) && CommunicationType.EMAIL != pc.getType()) continue;
            iter.remove();
        }
        for (GetThereSynchronizationUserProfilePhone phone : userInfo.getPhones()) {
            if (TextUtil.isBlank((String)phone.getValue())) continue;
            PersonCommunication pc2 = new PersonCommunication();
            pc2.setOrganization(orgRef);
            if (phone.getValue().toLowerCase().contains("x")) {
                int pos = phone.getValue().toLowerCase().indexOf("x");
                pc2.setSense(phone.getValue().substring(0, pos));
                if (pos < phone.getValue().length() - 1) {
                    pc2.setInternalNumber(phone.getValue().substring(pos + 1));
                }
            } else {
                pc2.setSense(phone.getValue());
            }
            pc2.setType(COMMUNICATION_TYPES.get(phone.getType()));
            per.getCommunications().add(pc2);
        }
        if (!TextUtil.isBlank((String)userInfo.getContactPhoneNumber())) {
            pc = new PersonCommunication();
            pc.setOrganization(orgRef);
            pc.setSense(userInfo.getContactPhoneNumber());
            if (userInfo.getContactPhoneNumber().toLowerCase().contains("x")) {
                int pos = userInfo.getContactPhoneNumber().toLowerCase().indexOf("x");
                pc.setSense(userInfo.getContactPhoneNumber().substring(0, pos));
                if (pos < userInfo.getContactPhoneNumber().length() - 1) {
                    pc.setInternalNumber(userInfo.getContactPhoneNumber().substring(pos + 1));
                }
            } else {
                pc.setSense(userInfo.getContactPhoneNumber());
            }
            pc.setCityCode(userInfo.getContactPhoneAreaCode());
            pc.setCountryCode(userInfo.getContactPhoneCountryCode());
            if (!TextUtil.isBlank((String)userInfo.getContactPhoneExtension())) {
                pc.setInternalNumber(userInfo.getContactPhoneExtension());
            }
            pc.setType(CommunicationType.WORK_PHONE);
            per.getCommunications().add(pc);
        }
        if (!TextUtil.isBlank((String)userInfo.getEmail())) {
            pc = new PersonCommunication();
            pc.setOrganization(orgRef);
            pc.setSense(userInfo.getEmail());
            pc.setType(CommunicationType.EMAIL);
            per.getCommunications().add(pc);
        }
    }

    private static void compareAndAddAddress(Person per, PersonAddress a) {
        boolean found = false;
        for (PersonAddress address : per.getAddresses()) {
            if (address == null) continue;
            boolean eqOrg = address.getOrganization() == null && a.getOrganization() == null || address.getOrganization() != null && address.getOrganization().equals((Object)a.getOrganization());
            boolean eqCountry = address.getCountry() == null && a.getCountry() == null || address.getCountry() != null && address.getCountry().equals((Object)a.getCountry());
            boolean eqCity = address.getCity() == null && a.getCity() == null || address.getCity() != null && address.getCity().equals((Object)a.getCity());
            boolean eqRegion = address.getRegion() == null && a.getRegion() == null || address.getRegion() != null && address.getRegion().equals((Object)a.getRegion());
            boolean eqType = address.getAddressType() == a.getAddressType();
            String addr1 = address.getAddress() != null ? (String)address.getAddress().getValues().get(LocaleUtil.LOCALE_EN) : null;
            String addr2 = a.getAddress() != null ? (String)a.getAddress().getValues().get(LocaleUtil.LOCALE_EN) : null;
            found = eqOrg && eqCountry && eqCity && eqRegion && eqType && TextUtil.isSame((String)addr1, (String)addr2) && TextUtil.isSame((String)address.getZip(), (String)a.getZip());
            if (!found) continue;
            break;
        }
        if (!found) {
            per.getAddresses().add(a);
        }
    }

    private static void compareAndAddPassport(Person per, Passport p) {
        boolean found = false;
        for (Passport passport : per.getPassports()) {
            if (passport == null) continue;
            boolean eqCountry = passport.getOriginCountry() == null && p.getOriginCountry() == null || passport.getOriginCountry() != null && passport.getOriginCountry().equals((Object)p.getOriginCountry());
            boolean eqExp = passport.getExpired() == null && p.getExpired() == null || passport.getExpired() != null && passport.getExpired().equals(p.getExpired());
            boolean eqBirth = passport.getBirthday() == null && p.getBirthday() == null || passport.getBirthday() != null && passport.getBirthday().equals(p.getBirthday());
            found = eqCountry && eqExp && eqBirth && TextUtil.isSame((String)passport.getNumber(), (String)p.getNumber());
            if (!found) continue;
            break;
        }
        if (!found) {
            per.getPassports().add(p);
        }
    }

    private static void compareAndAddCommunication(Person per, PersonCommunication pc) {
        boolean eqOrg;
        PersonCommunication comm;
        boolean found = false;
        Iterator iterator = per.getCommunications().iterator();
        while (iterator.hasNext() && ((comm = (PersonCommunication)iterator.next()) == null || !(found = (eqOrg = comm.getOrganization() == null && pc.getOrganization() == null || comm.getOrganization() != null && comm.getOrganization().equals((Object)pc.getOrganization())) && TextUtil.isSame((String)comm.getSense(), (String)pc.getSense()) && comm.getType() == pc.getType()))) {
        }
        if (!found) {
            per.getCommunications().add(pc);
        }
    }

    private static int stringToInt(String value) {
        int res;
        block3: {
            res = 0;
            try {
                Integer intVal = Integer.valueOf(value);
                if (intVal != null) {
                    res = intVal;
                }
            }
            catch (NumberFormatException e) {
                if (TextUtil.isBlank((String)value)) break block3;
                log.error("Failed to parse string to integer for value: " + value);
            }
        }
        return res;
    }

    private static void updateSabreEmails(List<GetThereSynchronizationUserProfileSupervisorInfo> supervisors, Person per) {
        per.getSabreEmailContacts().clear();
        for (GetThereSynchronizationUserProfileSupervisorInfo sup : supervisors) {
            if (TextUtil.isBlank((String)sup.getEmail())) continue;
            SabreContactEmail sce = new SabreContactEmail();
            sce.setSense(sup.getEmail());
            sce.setType("CC:");
            boolean found = false;
            for (SabreContactEmail e : per.getSabreEmailContacts()) {
                if (e == null || !TextUtil.isSame((String)e.getSense(), (String)sce.getSense())) continue;
                found = true;
                break;
            }
            if (found) continue;
            per.getSabreEmailContacts().add(sce);
        }
    }

    private static void updateUdids(GetThereSynchronizationUserProfileCompanyInfo companyInfo, List<GetThereSynchronizationUserProfileCustomField> customFields, Person per, EntityContainer<Organization> orgCont, String resourceId) {
        Iterator iter = per.getCostCodes().iterator();
        while (iter.hasNext()) {
            CostCodeCategory cat;
            DictionaryReference catRef;
            PersonCostCode pcc = (PersonCostCode)iter.next();
            if (pcc == null || pcc.getCostCodeProperties() == null || pcc.getCostCodeProperties().getCategory() == null || (catRef = pcc.getCostCodeProperties().getCategory()) == null || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(catRef)) == null || cat.getExternalCategoryType() == null) continue;
            iter.remove();
        }
        Organization org = (Organization)orgCont.getEntity();
        HashMap mapUdidsReceivedFromGT = new HashMap();
        HashMap<CostCodeExternalTypeReference, Boolean> mapUdidsExistInProfile = new HashMap<CostCodeExternalTypeReference, Boolean>();
        HashMap<CostCodeExternalTypeReference, Boolean> mapUdidsMaskAccepted = new HashMap<CostCodeExternalTypeReference, Boolean>();
        Map allCodes = DictionaryCache.get().getAll(CostCodeExternalType.class).values().stream().map(CostCodeExternalType::toReference).collect(Collectors.toMap(DictionaryReference::getCode, Function.identity()));
        ArrayList<String> excludeValue = new ArrayList<String>();
        excludeValue.add(PROJECT_CODE);
        excludeValue.add(CORPORATE_ID);
        excludeValue.add(DIVISION);
        excludeValue.add(DEPARTMENT);
        excludeValue.add(COST_CENTER);
        for (GetThereSynchronizationUserProfileCustomField cf : customFields) {
            if (!allCodes.containsKey(cf.getName()) || excludeValue.contains(cf.getName()) || !TextUtil.nonBlank((String)cf.getValue())) continue;
            mapUdidsReceivedFromGT.put(allCodes.get(cf.getName()), GetThereSynchronizationUtil.valueOrNull(cf.getValue()));
        }
        if (TextUtil.nonBlank((String)companyInfo.getCostCtr())) {
            mapUdidsReceivedFromGT.put(allCodes.get(COST_CENTER), GetThereSynchronizationUtil.valueOrNull(companyInfo.getCostCtr()));
        }
        if (TextUtil.nonBlank((String)companyInfo.getDeptNum())) {
            mapUdidsReceivedFromGT.put(allCodes.get(DEPARTMENT), GetThereSynchronizationUtil.valueOrNull(companyInfo.getDeptNum()));
        }
        if (TextUtil.nonBlank((String)companyInfo.getDivision())) {
            mapUdidsReceivedFromGT.put(allCodes.get(DIVISION), GetThereSynchronizationUtil.valueOrNull(companyInfo.getDivision()));
        }
        if (TextUtil.nonBlank((String)companyInfo.getCrsLoc())) {
            mapUdidsReceivedFromGT.put(allCodes.get(CORPORATE_ID), GetThereSynchronizationUtil.valueOrNull(companyInfo.getCrsLoc()));
        }
        if (TextUtil.nonBlank((String)companyInfo.getProjectCode())) {
            mapUdidsReceivedFromGT.put(allCodes.get(PROJECT_CODE), GetThereSynchronizationUtil.valueOrNull(companyInfo.getProjectCode()));
        }
        for (CostCodeExternalTypeReference type : allCodes.values()) {
            mapUdidsExistInProfile.put(type, Boolean.FALSE);
        }
        for (CostCodeExternalTypeReference type : allCodes.values()) {
            mapUdidsMaskAccepted.put(type, Boolean.FALSE);
        }
        for (CostCodeProperties ccp : org.getCostCodeProperties()) {
            CostCodeExternalTypeReference udidType;
            DictionaryReference dictRefUdidType;
            CostCodeCategory cat;
            if (ccp.getCategory() == null || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory())) == null || (dictRefUdidType = cat.getExternalCategoryType()) == null || (udidType = ((CostCodeExternalType)DictionaryCache.get().resolveReference(dictRefUdidType)).toReference()) == null || !mapUdidsReceivedFromGT.containsKey(udidType)) continue;
            mapUdidsExistInProfile.put(udidType, Boolean.TRUE);
            if (!GetThereSynchronizationUtil.checkMask((String)mapUdidsReceivedFromGT.get(udidType), ccp.getMask())) continue;
            mapUdidsMaskAccepted.put(udidType, Boolean.TRUE);
            per.getCostCodes().add(GetThereSynchronizationUtil.createCostCode((String)mapUdidsReceivedFromGT.get(udidType), ccp, (EntityReference<Organization>)orgCont.toReference()));
        }
        for (CostCodeExternalTypeReference type : allCodes.values()) {
            if (mapUdidsReceivedFromGT.containsKey(type) && mapUdidsExistInProfile.get(type) == Boolean.FALSE) {
                log.warn("Udid " + type.toString() + " received with value - " + (String)mapUdidsReceivedFromGT.get(type) + " but no udid type found - " + resourceId);
                continue;
            }
            if (mapUdidsReceivedFromGT.get(type) == null || mapUdidsMaskAccepted.get(type) != Boolean.FALSE) continue;
            log.warn("Udid " + type.toString() + " received with value - " + (String)mapUdidsReceivedFromGT.get(type) + ", udid type foung, but mask not accepted - " + resourceId);
        }
        if (TextUtil.nonBlank((String)companyInfo.getPosition())) {
            DictionaryReference<PersonPosition> pos = GetThereSynchronizationUtil.getOrCreatePersonPosition(companyInfo.getPosition(), resourceId);
            for (PersonEmployment pe : per.getEmployments()) {
                if (pe == null || pe.getOrganization() == null || !TextUtil.isSame((String)pe.getOrganization().getUid(), (String)orgCont.toReference().getUid())) continue;
                pe.setPosition(pos);
            }
        }
    }

    public static DictionaryReference<PersonPosition> getOrCreatePersonPosition(String positionName, String resourceId) {
        PersonPosition newPosition = null;
        Map positionsMap = DictionaryCache.get().getAll(PersonPosition.class);
        for (Map.Entry entry : positionsMap.entrySet()) {
            PersonPosition pos = (PersonPosition)entry.getValue();
            if (pos == null || TextUtil.isBlank((String)((String)pos.getTranslations().get(LocaleUtil.LOCALE_EN))) || !((String)pos.getTranslations().get(LocaleUtil.LOCALE_EN)).equals(positionName)) continue;
            newPosition = pos;
            break;
        }
        if (newPosition == null) {
            try {
                newPosition = (PersonPosition)PersonPosition.class.newInstance();
                newPosition.setUid(UUIDGenerator.generate().toString());
                newPosition.setCode(UUIDGenerator.generate().toString());
                newPosition.setCreatedBy("system");
                newPosition.setModifiedBy("system");
                newPosition.getTranslations().put(LocaleUtil.LOCALE_EN, positionName);
                newPosition.getTranslations().put(LocaleUtil.LOCALE_RU, positionName);
                newPosition.setDataSource("get-there-util");
                DictionaryStorage.get().save((BaseDictionary)newPosition);
            }
            catch (Exception e) {
                log.error("Error while creating new dictionary element for PersonPosition: " + positionName + " - " + resourceId);
                newPosition = null;
            }
        }
        return newPosition != null ? newPosition.toReference() : null;
    }

    private static String valueOrNull(String value) {
        return !TextUtil.isBlank((String)value) ? value : null;
    }

    private static PersonCostCode createCostCode(String value, CostCodeProperties ccp, EntityReference<Organization> orgRef) {
        PersonCostCode costCode = new PersonCostCode();
        costCode.setOrganization(orgRef);
        costCode.setValue(value);
        costCode.setCostCodeProperties(ccp);
        return costCode;
    }

    private static boolean checkMask(String value, String mask) {
        if (!TextUtil.isBlank((String)mask) && !TextUtil.isBlank((String)value)) {
            try {
                MaskFormatter formatter = new MaskFormatter(mask);
                formatter.stringToValue(value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    private static void compareAndAddVisa(Person per, Visa v, String validTill) {
        boolean found = false;
        for (Visa visa : per.getVisas()) {
            if (visa == null) continue;
            boolean eqIssueCountry = visa.getIssueCountry() == null && v.getIssueCountry() == null || visa.getIssueCountry() != null && visa.getIssueCountry().equals((Object)v.getIssueCountry());
            boolean eqTargetCountry = visa.getCountry() == null && v.getCountry() == null || visa.getCountry() != null && visa.getCountry().equals((Object)v.getCountry());
            found = TextUtil.isSame((String)v.getNumber(), (String)visa.getNumber()) && eqIssueCountry && eqTargetCountry;
            if (!found) continue;
            break;
        }
        if (!found) {
            per.getVisas().add(v);
            SabreProfileLine remark = new SabreProfileLine();
            remark.setLineType(SabreProfileLineType.A);
            remark.setLineServiceType(SabreProfileLineServiceType.V);
            remark.setLineSubsection(v.getCountry().getCaption());
            remark.setLineBody("Visa " + v.getNumber() + " valid till " + validTill);
            per.getSabreAdditionalProfileLines().add(remark);
        }
    }

    private static void compareAndAddCreditCard(Person per, Card c) {
        boolean eqType;
        Card card;
        boolean found = false;
        Iterator iterator = per.getCards().iterator();
        while (iterator.hasNext() && ((card = (Card)iterator.next()) == null || !(found = (eqType = card.getVendor() == c.getVendor()) && TextUtil.isSame((String)card.getNumber(), (String)c.getNumber())))) {
        }
        if (!found) {
            per.getCards().add(c);
        }
    }

    private static void compareAndAddBonusCard(Person per, AirlineBonusCard abc) {
        boolean found = false;
        for (AirlineBonusCard card : per.getAirlineBonusCards()) {
            if (card == null) continue;
            boolean eqAirline = card.getAirline() == null && abc.getAirline() == null || card.getAirline() != null && card.getAirline().equals((Object)abc.getAirline());
            boolean eqAirlineApplied = card.getAirlineApplied() == null && abc.getAirlineApplied() == null || card.getAirlineApplied() != null && card.getAirlineApplied().equals((Object)abc.getAirlineApplied());
            found = eqAirline && eqAirlineApplied && TextUtil.isSame((String)card.getNumber(), (String)abc.getNumber());
            if (!found) continue;
            break;
        }
        if (!found) {
            per.getAirlineBonusCards().add(abc);
        }
    }

    private static void compareAndAddRemark(Person per, SabreProfileLine remark) {
        boolean found = false;
        for (SabreProfileLine line : per.getSabreAdditionalProfileLines()) {
            if (TextUtil.isBlank((String)line.getLineBody())) continue;
            found = line.getLineServiceType() == remark.getLineServiceType() && TextUtil.isSame((String)line.getLineSubsection(), (String)remark.getLineSubsection()) && TextUtil.isSame((String)line.getLineBody(), (String)remark.getLineBody());
        }
        if (!found) {
            per.getSabreAdditionalProfileLines().add(remark);
        }
    }

    public static ScheduledTaskSettings getScheduledTaskSetting() {
        ScheduledTaskSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.enabled.name(), (Object)Boolean.TRUE));
        List indices = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, query).getData();
        if (indices == null) {
            return res;
        }
        for (ScheduledTaskSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !"system-settings-getthere-synchronization-task".equals(setCont.getUid())) continue;
            res = (ScheduledTaskSettings)setCont.getEntity();
            break;
        }
        return res;
    }

    public static String getCurrentTimeStamp() {
        return GetThereSynchronizationUtil.createSdfFull().format(new Date());
    }

    public static GetThereSynchronizationUserProfilePhone createUserProfilePhone(PersonCommunication pc, CommunicationType type) {
        if (pc == null) {
            GetThereSynchronizationUserProfilePhone phone = new GetThereSynchronizationUserProfilePhone();
            phone.setType(GetThereSynchronizationUtil.getPhoneTypeByCommunicationType(type));
            return phone;
        }
        GetThereSynchronizationUserProfilePhone phone = new GetThereSynchronizationUserProfilePhone();
        phone.setType(GetThereSynchronizationUtil.getPhoneTypeByCommunicationType(pc.getType()));
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)pc.getCountryCode())) {
            sb.append(pc.getCountryCode());
        }
        if (!TextUtil.isBlank((String)pc.getCityCode())) {
            sb.append(pc.getCityCode());
        }
        if (!TextUtil.isBlank((String)pc.getSense())) {
            sb.append(pc.getSense());
        }
        if (!TextUtil.isBlank((String)pc.getInternalNumber())) {
            sb.append(pc.getInternalNumber());
        }
        phone.setValue(sb.toString());
        return phone;
    }

    public static String getPhoneTypeByCommunicationType(CommunicationType type) {
        String res = "WORK";
        for (Map.Entry<String, CommunicationType> entry : COMMUNICATION_TYPES.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals((Object)type)) continue;
            res = entry.getKey();
        }
        return res;
    }

    public static GetThereSynchronizationUserProfilePassport createUserPassport(Passport p) {
        if (p == null) {
            return new GetThereSynchronizationUserProfilePassport();
        }
        GetThereSynchronizationUserProfilePassport passport = new GetThereSynchronizationUserProfilePassport();
        if (p.getNumber() != null) {
            passport.setPassportNo(TextUtil.translit((String)p.getNumber(), (boolean)true).toUpperCase());
        }
        if (p.getOriginCountry() != null) {
            passport.setPassportCo(p.getOriginCountry().getCode());
        }
        if (p.getExpired() != null) {
            passport.setPassportExp(GetThereSynchronizationUtil.createSdfWithSlashesReversedFormat().format(p.getExpired()));
        }
        return passport;
    }

    public static GetThereSynchronizationUserProfileDeliveryAddress createUserProfileAddress(Address a) {
        DictionaryCache cache;
        if (a == null) {
            return new GetThereSynchronizationUserProfileDeliveryAddress();
        }
        GetThereSynchronizationUserProfileDeliveryAddress addr = new GetThereSynchronizationUserProfileDeliveryAddress();
        if (a.getCity() != null && (cache = DictionaryCache.get()) != null) {
            GeoLocation city = (GeoLocation)cache.resolveReference(a.getCity());
            addr.setCity((String)city.getTranslations().get(LocaleUtil.LOCALE_EN));
        }
        addr.setCountry(a.getCountry() != null ? a.getCountry().getCode() : null);
        addr.setPostalCode(a.getZip());
        if (a.getRegion() != null) {
            GeoRegion region = (GeoRegion)DictionaryCache.get().resolveReference(a.getRegion());
            if (region != null) {
                addr.setState(DictHelper.getTranslation((BaseDictionary)region, (Locale)LocaleUtil.LOCALE_EN, (boolean)true));
            } else {
                addr.setState(a.getRegion().toString());
            }
        }
        StringBuilder streetAndNumber = new StringBuilder();
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getHouse()))) {
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getHouse()));
        }
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getHousing()))) {
            if (streetAndNumber.length() > 0) {
                streetAndNumber.append(", ");
            }
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getHousing()));
        }
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getBuilding()))) {
            if (streetAndNumber.length() > 0) {
                streetAndNumber.append(", ");
            }
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getBuilding()));
        }
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getHousing()))) {
            if (streetAndNumber.length() > 0) {
                streetAndNumber.append(", ");
            }
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getHousing()));
        }
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getFlat()))) {
            if (streetAndNumber.length() > 0) {
                streetAndNumber.append(", ");
            }
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getFlat()));
        }
        if (!TextUtil.isBlank((String)GetThereSynchronizationUtil.getEnglishValue(a.getAddress()))) {
            if (streetAndNumber.length() > 0) {
                streetAndNumber.append(", ");
            }
            streetAndNumber.append(GetThereSynchronizationUtil.getEnglishValue(a.getAddress()));
        }
        addr.setStreet(streetAndNumber.toString());
        return addr;
    }

    public static GetThereSynchronizationUserProfileVisa createUserVisa(Visa v, int num) {
        if (v == null) {
            GetThereSynchronizationUserProfileVisa emptyVisa = new GetThereSynchronizationUserProfileVisa(num);
            return emptyVisa;
        }
        GetThereSynchronizationUserProfileVisa visa = new GetThereSynchronizationUserProfileVisa(num);
        visa.setVisaCo(v.getCountry() != null ? v.getCountry().getCode() : null);
        visa.setVisaExp(v.getEndDate() != null ? GetThereSynchronizationUtil.createSdfWithSlashesReversedFormat().format(v.getEndDate()) : null);
        visa.setVisaNo(v.getNumber());
        return visa;
    }

    public static String getEnglishValue(L10nString str) {
        if (str == null || str.getValues().size() == 0) {
            return null;
        }
        if (str.getValues().containsKey(LocaleUtil.LOCALE_EN)) {
            return (String)str.getValues().get(LocaleUtil.LOCALE_EN);
        }
        if (str.getValues().containsKey(null)) {
            return (String)str.getValues().get(null);
        }
        return (String)str.getValues().values().iterator().next();
    }

    public static GetThereSynchronizationUserProfileCreditCard createCreditCard(Card c, int num, boolean useCir) {
        if (c == null) {
            return new GetThereSynchronizationUserProfileCreditCard(num);
        }
        GetThereSynchronizationUserProfileCreditCard card = new GetThereSynchronizationUserProfileCreditCard(num);
        if (useCir) {
            card.setCcNum("{UID:" + c.getCirUid() + "}");
        } else {
            card.setCcNum(c.getNumber());
        }
        card.setCcName(c.getNameOnCard());
        card.setCcUniqueName(c.getRemarks());
        card.setCcType(c.getVendor() != null ? (String)ProfileSynchronizationConstants.Card2Abbr.get(c.getVendor()) : null);
        card.setCcExp(c.getExpiration() != null ? GetThereSynchronizationUtil.createSdfForCreditCardFormat().format(c.getExpiration()) : null);
        return card;
    }

    public static GetThereSynchronizationUserProfileLoyalty createLoyaltyFromBonusCard(AirlineBonusCard abc, int num) {
        if (abc == null) {
            return new GetThereSynchronizationUserProfileLoyalty(num);
        }
        GetThereSynchronizationUserProfileLoyalty loyalty = new GetThereSynchronizationUserProfileLoyalty(num);
        loyalty.setAcctNum(abc.getNumber());
        loyalty.setAcctName(abc.getAirline() != null ? abc.getAirline().getCode() : null);
        return loyalty;
    }

    public static GetThereSynchronizationUserProfileLoyalty createLoyaltyFromBaseBonusCard(BaseBonusCard card, int num) {
        String[] parts;
        String str;
        if (card == null) {
            return new GetThereSynchronizationUserProfileLoyalty(num);
        }
        GetThereSynchronizationUserProfileLoyalty loyalty = new GetThereSynchronizationUserProfileLoyalty(num);
        loyalty.setAcctNum(card.getNumber());
        if (card instanceof HotelBonusCard) {
            loyalty.setAcctName(((HotelBonusCard)card).getHotelBrand() != null ? ((HotelBonusCard)card).getHotelBrand().getCode() : null);
        } else if (card instanceof CarBonusCard) {
            loyalty.setAcctName(((CarBonusCard)card).getCarSupplier() != null ? ((CarBonusCard)card).getCarSupplier().getCode() : null);
        } else if (card instanceof RailwayBonusCard && !TextUtil.isBlank((String)(str = ((RailwayBonusCard)card).getRailwayCarrierCode())) && (parts = str.split("\\-")).length > 0 && parts[0] != null) {
            loyalty.setAcctName(parts[0].trim());
        }
        return loyalty;
    }

    public static GetThereSynchronizationUserProfileLoyalty createLoyaltyFromRemark(SabreProfileLine rem, int num) {
        if (rem == null) {
            return new GetThereSynchronizationUserProfileLoyalty(num);
        }
        GetThereSynchronizationUserProfileLoyalty loyalty = new GetThereSynchronizationUserProfileLoyalty(num);
        if (!TextUtil.isBlank((String)rem.getLineBody())) {
            if (rem.getLineBody().indexOf(32) > -1) {
                int pos = rem.getLineBody().lastIndexOf(32);
                loyalty.setAcctName(rem.getLineBody().substring(0, pos).trim());
                loyalty.setAcctNum(rem.getLineBody().substring(pos).trim());
            } else {
                loyalty.setAcctNum(rem.getLineBody());
            }
        } else {
            loyalty.setAcctName(null);
            loyalty.setAcctNum(null);
        }
        return loyalty;
    }

    public static GetThereSynchronizationUserProfileSupervisorInfo createSupervisorInfo(SabreContactEmail e, int num) {
        if (e == null) {
            return new GetThereSynchronizationUserProfileSupervisorInfo(num);
        }
        GetThereSynchronizationUserProfileSupervisorInfo sup = new GetThereSynchronizationUserProfileSupervisorInfo(num);
        sup.setEmail(e.getSense());
        return sup;
    }

    public static GetThereSynchronizationUserProfileCompanyInfo createCompanyInfo(List<PersonCostCode> costCodes, String resourceIdForGetThere, String companyName, String position, GetThereSynchronizationUserProfileUserInfo userInfo) {
        GetThereSynchronizationUserProfileCompanyInfo res = new GetThereSynchronizationUserProfileCompanyInfo();
        for (PersonCostCode pcc : costCodes) {
            CostCodeCategory cat;
            DictionaryReference catRef;
            String value = pcc.getValue();
            if (TextUtil.isBlank((String)value) || pcc.getCostCodeProperties() == null || (catRef = pcc.getCostCodeProperties().getCategory()) == null || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(catRef)) == null) continue;
            DictionaryReference type = cat.getExternalCategoryType();
            if (TextUtil.equals((String)COST_CENTER, (String)type.getCode(), (boolean)true)) {
                res.setCostCtr(value);
                continue;
            }
            if (TextUtil.equals((String)DEPARTMENT, (String)type.getCode(), (boolean)true)) {
                res.setDeptNum(value);
                continue;
            }
            if (TextUtil.equals((String)PROJECT_CODE, (String)type.getCode(), (boolean)true)) {
                res.setProjectCode(value);
                continue;
            }
            if (TextUtil.equals((String)DIVISION, (String)type.getCode(), (boolean)true)) {
                res.setDivision(value);
                continue;
            }
            if (!TextUtil.equals((String)CORPORATE_ID, (String)type.getCode(), (boolean)true)) continue;
            userInfo.setCorpId(value);
        }
        res.setEmpNo(resourceIdForGetThere.replaceAll("@", "at").replaceAll("_", ""));
        res.setCompanyName(companyName);
        res.setPosition(position);
        return res;
    }

    public static List<GetThereSynchronizationUserProfileCustomField> createUserPassportInCustomField(Passport p) {
        ArrayList<GetThereSynchronizationUserProfileCustomField> res = new ArrayList<GetThereSynchronizationUserProfileCustomField>();
        if (p == null) {
            GetThereSynchronizationUserProfileCustomField cf1 = new GetThereSynchronizationUserProfileCustomField(1);
            cf1.setName(ADDITIONAL_PASSPORT_NUMBER);
            cf1.setValue(null);
            res.add(cf1);
            GetThereSynchronizationUserProfileCustomField cf3 = new GetThereSynchronizationUserProfileCustomField(3);
            cf3.setName(ADDITIONAL_PASSPORT_EXPIRATION);
            cf3.setValue(null);
            res.add(cf3);
            return res;
        }
        GetThereSynchronizationUserProfileCustomField cf1 = new GetThereSynchronizationUserProfileCustomField(1);
        cf1.setName(ADDITIONAL_PASSPORT_NUMBER);
        if (p.getNumber() != null) {
            cf1.setValue(TextUtil.translit((String)p.getNumber(), (boolean)true).toUpperCase());
        }
        res.add(cf1);
        if (p.getOriginCountry() != null) {
            GetThereSynchronizationUserProfileCustomField cf2 = new GetThereSynchronizationUserProfileCustomField(2);
            cf2.setName(ADDITIONAL_PASSPORT_COUNTRY);
            Country country = (Country)DictionaryCache.get().resolveReference(p.getOriginCountry());
            if (country != null) {
                String code = (String)country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name());
                if (TextUtil.isBlank((String)code)) {
                    code = (String)country.getCodeVariants().get(CodeSystem.ISO.name());
                }
                cf2.setValue(code);
                res.add(cf2);
            }
        }
        if (p.getExpired() != null) {
            GetThereSynchronizationUserProfileCustomField cf3 = new GetThereSynchronizationUserProfileCustomField(3);
            cf3.setName(ADDITIONAL_PASSPORT_EXPIRATION);
            cf3.setValue(GetThereSynchronizationUtil.createSdf_ddMMMyyyyFormat().format(p.getExpired()));
            res.add(cf3);
        }
        return res;
    }

    public static void inspectNonLatinSymbols(Object obj) {
        if (obj == null) {
            return;
        }
        for (Method m : obj.getClass().getDeclaredMethods()) {
            if (m.getName() == null || !m.getName().startsWith("get") || m.getParameterTypes().length > 0) continue;
            try {
                m.setAccessible(true);
                if (m.getReturnType() != null && m.getReturnType().equals(String.class)) {
                    String value = (String)m.invoke(obj, new Object[0]);
                    if (TextUtil.isBlank((String)value)) continue;
                    Matcher matcher = cyrillicSymbols.matcher(value);
                    int first = -1;
                    int last = -1;
                    while (matcher.find()) {
                        if (first == -1) {
                            first = matcher.start();
                        }
                        last = matcher.end();
                    }
                    if (first == -1 || last == -1) continue;
                    String newValue = value.substring(0, first) + value.substring(last);
                    String setMethodName = "set" + m.getName().substring(3);
                    Method setMethod = obj.getClass().getMethod(setMethodName, String.class);
                    if (setMethod == null) continue;
                    setMethod.invoke(obj, newValue);
                    continue;
                }
                if (Collection.class.isAssignableFrom(m.getReturnType())) {
                    Collection col = (Collection)m.invoke(obj, new Object[0]);
                    for (Object o : col) {
                        GetThereSynchronizationUtil.inspectNonLatinSymbols(o);
                    }
                    continue;
                }
                if (m.getReturnType().isArray()) {
                    Object[] arr;
                    for (Object o : arr = (Object[])m.invoke(obj, new Object[0])) {
                        GetThereSynchronizationUtil.inspectNonLatinSymbols(o);
                    }
                    continue;
                }
                if (m.getReturnType().isPrimitive() || m.getReturnType().isSynthetic() || m.getReturnType().isEnum()) continue;
                Object o = m.invoke(obj, new Object[0]);
                GetThereSynchronizationUtil.inspectNonLatinSymbols(o);
            }
            catch (IllegalArgumentException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static List<GetThereSynchronizationUserProfileCustomField> createUdidsInCustomField(List<PersonCostCode> costCodes) {
        EntityReference organizationEntityReference;
        CostCodeCategory cat;
        ArrayList<GetThereSynchronizationUserProfileCustomField> res = new ArrayList<GetThereSynchronizationUserProfileCustomField>();
        int startNum = 4;
        ArrayList<String> excludeValue = new ArrayList<String>();
        excludeValue.add(PROJECT_CODE);
        excludeValue.add(CORPORATE_ID);
        excludeValue.add(DIVISION);
        excludeValue.add(DEPARTMENT);
        excludeValue.add(COST_CENTER);
        for (PersonCostCode pcc : costCodes) {
            String value = pcc.getValue();
            DictionaryReference catRef = pcc.getCostCodeProperties().getCategory();
            if (!TextUtil.nonBlank((String)value) || pcc.getCostCodeProperties() == null || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(catRef)) == null) continue;
            Map validCodes = DictionaryCache.get().getAll(CostCodeExternalType.class).values().stream().map(CostCodeExternalType::toReference).collect(Collectors.toMap(DictionaryReference::getCode, Function.identity()));
            for (String key : excludeValue) {
                validCodes.remove(key);
            }
            CostCodeExternalTypeReference reference = ((CostCodeExternalType)DictionaryCache.get().resolveReference(cat.getExternalCategoryType())).toReference();
            if (!validCodes.containsValue(reference)) continue;
            GetThereSynchronizationUserProfileCustomField cf = new GetThereSynchronizationUserProfileCustomField(startNum);
            cf.setName(cat.getExternalCategoryType().getCode());
            cf.setValue(value);
            res.add(cf);
            ++startNum;
        }
        Organization org = null;
        if (!costCodes.isEmpty() && (organizationEntityReference = costCodes.get(0).getOrganization()) != null) {
            EntityContainer ecOrg = EntityStorage.get().resolve(organizationEntityReference);
            org = (Organization)ecOrg.getEntity();
        }
        if (org != null) {
            res.forEach(gz -> excludeValue.add(gz.getName()));
            ArrayList<GetThereSynchronizationUserProfileCustomField> emptyRes = new ArrayList<GetThereSynchronizationUserProfileCustomField>();
            for (CostCodeProperties ccp : org.getCostCodeProperties()) {
                DictionaryReference dictRefUdidType;
                if (ccp.getCategory() == null || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory())) == null || (dictRefUdidType = cat.getExternalCategoryType()) == null || excludeValue.contains(dictRefUdidType.getCode())) continue;
                GetThereSynchronizationUserProfileCustomField cf = new GetThereSynchronizationUserProfileCustomField(startNum);
                cf.setName(dictRefUdidType.getCode());
                cf.setValue("");
                emptyRes.add(cf);
                ++startNum;
            }
            res.addAll(emptyRes);
        }
        return res;
    }

    public static String findRailwayCarrierByCode(String acctName) {
        String res = null;
        try {
            Class<?> RailwayCarrierClass = Class.forName("com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier");
            Collection values = DictionaryCache.get().getAll(RailwayCarrierClass).values();
            for (BaseDictionary value : values) {
                if (value == null || !TextUtil.isSame((String)value.getCode(), (String)acctName)) continue;
                res = value.getCode();
                if (!value.getTranslations().containsKey(LocaleUtil.LOCALE_EN)) continue;
                res = res + " - " + (String)value.getTranslations().get(LocaleUtil.LOCALE_EN);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return res;
    }

    public static boolean isGetThereEnabled() {
        EntityContainer getThereSettings = EntityStorage.get().load(GetThereSettings.class, "get-there-exchange-setting-uid");
        if (EntityStorageHelper.isEmpty((EntityContainer)getThereSettings)) {
            List getThereSettings1 = SystemHelper.searchSystemSettings(GetThereSettings.class);
            if (getThereSettings1.isEmpty()) {
                return false;
            }
            return ((GetThereSettings)getThereSettings1.get(0)).isEnabled();
        }
        return ((GetThereSettings)getThereSettings.getEntity()).isEnabled();
    }
}

