/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.migration;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.migration.DataMigrationRequest;
import com.gridnine.xtrip.server.model.synchronization.migration.DataMigrationResponse;

public class DataMigrationSynchronizationHandler
implements SynchronizationHandler<DataMigrationRequest, DataMigrationResponse> {
    public static String OPERATION_ID = "DATA_MIGRATION";

    @Override
    public String getOperationId() {
        return OPERATION_ID;
    }

    @Override
    public SynchronizationResponse<DataMigrationResponse> process(SynchronizationRequest<DataMigrationRequest> request) throws Exception {
        SynchronizationResponse<DataMigrationResponse> result = new SynchronizationResponse<DataMigrationResponse>();
        try {
            if (request.getData().isCheckOnly()) {
                result.getMessages().add(MessageHelper.createMessage((String)"\u0437\u0430\u043f\u0440\u043e\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d", (Object[])new Object[0]));
                return result;
            }
            LogicalStorage.get().setUser("sync-user");
            DataMigrationResponse data = new DataMigrationResponse();
            EntityContainer ctr = (EntityContainer)request.getData().getObject();
            ctr.getVersionInfo().setDataSource("data-migration-task");
            LogicalEntityStorage.clearRevision((EntityContainer)ctr);
            EntityStorage.get().save(ctr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
            result.getMessages().add(MessageHelper.createMessage((String)"\u0437\u0430\u043f\u0440\u043e\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.getMessages().add(MessageHelper.createExceptonMessage((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441", (Throwable)e, (Object[])new Object[0]));
            return result;
        }
    }
}

