/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabrepassive;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.passive.PassiveSegmentsTransferStatus;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsClientMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSettings;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSubagencyMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsXIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.SabrePassiveSegmentsConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequestType;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsResponse;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsResponseType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabrePassiveSegmentsHelper {
    static final transient Logger log = LoggerFactory.getLogger(SabrePassiveSegmentsHelper.class);
    public static final String SERVER = "server";
    public static final String PCC = "pcc";
    public static final String PNR = "pnr";
    public static final String PASSWORD = "password";
    public static final String OPERATION = "sabre-passive-segments";

    public static SabrePassiveSegmentsResult createPassiveSegments(EntityReference<BookingFile> bfRef, SabrePassiveSegmentsSettings settings, List<Message> msgs) throws ServiceException {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        if (bfRef == null) {
            log.error("Organization reference passed to sendOrganization method is null");
            throw new ServiceException(l10nResourcesManager.getMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.PassiveSegments_failedToResolveBookingFile, (Object[])new Object[0]), (Object[])new Object[]{bfRef}).getMessage()));
        }
        return SabrePassiveSegmentsHelper.createPassiveSegments((EntityContainer<BookingFile>)EntityStorage.get().resolve(bfRef), settings, msgs, true);
    }

    public static SabrePassiveSegmentsResult createPassiveSegments(EntityContainer<BookingFile> bfCont, SabrePassiveSegmentsSettings settings, List<Message> msgs, boolean saveResult) throws ServiceException {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        if (bfCont == null || bfCont.getEntity() == null) {
            log.error("Organization reference passed to sendOrganization method failed to resolve");
            throw new ServiceException(l10nResourcesManager.getMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.PassiveSegments_failedToResolveBookingFile, (Object[])new Object[0]), (Object[])new Object[]{bfCont.toReference()}).getMessage()));
        }
        SabrePassiveSegmentsSubagencyMode subagencyMode = settings.getSubagencyMode();
        if (subagencyMode == null) {
            settings.setSubagencyMode(SabrePassiveSegmentsSubagencyMode.REGULAR);
        }
        SabrePassiveSegmentsResult result = SabrePassiveSegmentsHelper.prepareAndSendRequest(bfCont, settings, msgs);
        if (saveResult && !TextUtil.isSame((String)SabrePassiveSegmentsResponseType.ERROR.name(), (String)result.getResponseType()) && !TextUtil.isBlank((String)result.getPnr())) {
            for (Reservation res : ((BookingFile)bfCont.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    if (!settings.getProductUids().contains(bp.getUid())) continue;
                    if (bp.getPassiveSegmentsCreationResult() == null) {
                        bp.setPassiveSegmentsCreationResult(new SabrePassiveSegmentsResult());
                    }
                    if (bp.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData() == null) {
                        bp.getPassiveSegmentsCreationResult().setPassiveSegmentsXIData(new SabrePassiveSegmentsXIData());
                    }
                    bp.getPassiveSegmentsCreationResult().setTransferStatus(PassiveSegmentsTransferStatus.TRANSFERRED);
                    bp.getPassiveSegmentsCreationResult().setPcc(result.getPcc());
                    bp.getPassiveSegmentsCreationResult().setPnr(result.getPnr());
                    bp.getPassiveSegmentsCreationResult().setResponseDate(result.getResponseDate());
                    bp.getPassiveSegmentsCreationResult().setResponseType(result.getResponseType());
                    bp.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().setPnr(result.getPnr());
                    bp.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().setResponseDate(result.getResponseDate());
                }
            }
            EntityStorage.get().save(bfCont, false);
        }
        return result;
    }

    public static SabrePassiveSegmentsRequest prepareRequest(EntityContainer<BookingFile> bfCont, SabrePassiveSegmentsSettings passiveSegmentsSettings, List<Message> msgs) throws ServiceException {
        return SabrePassiveSegmentsHelper.prepareRequest(passiveSegmentsSettings, bfCont, msgs);
    }

    private static SabrePassiveSegmentsResult prepareAndSendRequest(EntityContainer<BookingFile> bfCont, SabrePassiveSegmentsSettings passiveSegmentsSettings, List<Message> messages) throws ServiceException {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        ArrayList<Message> msgs = new ArrayList<Message>();
        SabrePassiveSegmentsConnectionSettings connectionSettings = SabrePassiveSegmentsUtil.getSabrePassiveSegmentsSettings();
        boolean checked = SabrePassiveSegmentsHelper.checkAndAdjustParams(passiveSegmentsSettings, connectionSettings, msgs);
        if (!checked) {
            throw new ServiceException(msgs.size() > 0 ? l10nResourcesManager.getMessage(((Message)msgs.get(0)).getMessage()) : null);
        }
        SabrePassiveSegmentsRequest request = SabrePassiveSegmentsHelper.prepareRequest(passiveSegmentsSettings, bfCont, messages);
        String url = connectionSettings.getServerURL();
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabrePassiveSegmentsResponse> response = SabrePassiveSegmentsHelper.sendRequest(request, url, (ValueHolder<String>)traceHolder);
        return SabrePassiveSegmentsHelper.parseResponse(response);
    }

    public static SabrePassiveSegmentsResult parseResponse(SynchronizationResponse<SabrePassiveSegmentsResponse> response) throws ServiceException {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        SabrePassiveSegmentsResponse synchResponse = response.getData();
        StringBuilder errors = new StringBuilder();
        List<Message> messagesFromResponse = synchResponse != null ? synchResponse.getMessages() : response.getMessages();
        for (Message msg : messagesFromResponse) {
            if (msg.getType() != MessageType.ERROR) continue;
            log.warn("Request Sabre passive segments returned with error: " + msg.getMessage());
            if (errors.length() > 0) {
                errors.append("||");
            }
            errors.append(l10nResourcesManager.getMessage(msg.getMessage()) + " ");
            if (msg.getDetails() == null) continue;
            errors.append("\nDetails:\n" + msg.getDetails());
        }
        if (errors.length() > 0) {
            throw new ServiceException(errors.toString());
        }
        SabrePassiveSegmentsResult result = new SabrePassiveSegmentsResult();
        result.setPnr(synchResponse.getResponsePNR());
        result.setPcc(synchResponse.getResponsePCC());
        result.setResponseType(synchResponse.getResponseType().name());
        result.setResponseDate(new Date());
        result.getMessages().addAll(synchResponse.getMessages());
        return result;
    }

    private static SynchronizationResponse<SabrePassiveSegmentsResponse> sendRequest(SabrePassiveSegmentsRequest requestData, String url, ValueHolder<String> traceHolder) {
        SynchronizationRequest<SabrePassiveSegmentsRequest> request = new SynchronizationRequest<SabrePassiveSegmentsRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(requestData);
        request.setOperationId(OPERATION);
        request.setUser("syncrobot");
        return SynchronizationHelper.execute(request, url, traceHolder);
    }

    static boolean checkAndAdjustParams(SabrePassiveSegmentsSettings passiveSegmentsSettings, SabrePassiveSegmentsConnectionSettings connectionSettings, List<Message> msgs) {
        if (connectionSettings == null) {
            log.error("No settings found to create passive segments in Sabre");
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.PassiveSegments_settingsNotFound, (Object[])new Object[0]), (Object[])new Object[0]));
            return false;
        }
        if (TextUtil.isBlank((String)connectionSettings.getServerURL())) {
            log.error("Server URL is not set for Sabre passive segments settings");
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)Messages.PassiveSegments_serverURLNotFound, (Object[])new Object[0]), (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static SabrePassiveSegmentsRequest prepareRequest(SabrePassiveSegmentsSettings settings, EntityContainer<BookingFile> bfCont, List<Message> messages) {
        SabrePassiveSegmentsRequest request = new SabrePassiveSegmentsRequest();
        request.setWeakerDkNumberValidation(true);
        request.setPnr(settings.getPnr());
        request.setPcc(settings.getPcc());
        request.setQueue(settings.getQueue());
        request.setBookingFileContainerUid(bfCont.getUid());
        request.getProductUids().addAll(settings.getProductUids());
        request.getAllowedPCCs().addAll(settings.getAllowedPCCs());
        request.setRequestType(settings.isNewReservation() ? SabrePassiveSegmentsRequestType.CREATE_PASSIVE_SEGMENTS_NEW_RESERVATION : SabrePassiveSegmentsRequestType.CREATE_PASSIVE_SEGMENTS_EXISTING_RESERVATION);
        request.setClientMode(SabrePassiveSegmentsClientMode.REGULAR);
        request.setSubagencyMode(settings.getSubagencyMode());
        BookingFile bf = (BookingFile)bfCont.getEntity();
        if (bf.getCustomerProfile() != null) {
            EntityContainer clientCont = EntityStorage.get().resolve(bf.getCustomerProfile());
            if (clientCont != null && ((Organization)clientCont.getEntity()).getCwtProfileData() != null && ((Organization)clientCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
                request.setClientMode(SabrePassiveSegmentsClientMode.CWT);
            }
            if (request.getClientMode() == SabrePassiveSegmentsClientMode.REGULAR && SabrePassiveSegmentsHelper.hasAnyProductWithCWTAgencyOrSubagency(bf, settings.getProductUids())) {
                request.setClientMode(SabrePassiveSegmentsClientMode.CWT);
            }
        }
        HashMap productMap = new HashMap();
        for (Reservation res : bf.getReservations()) {
            for (BaseProduct baseProduct : res.getProducts()) {
                if (!settings.getProductUids().contains(baseProduct.getUid())) continue;
                ProductPassiveSegmentsHandler handler = HandlersRegistry.get().findProductPassiveSegmentsHandler(baseProduct.getClass());
                if (!productMap.containsKey(handler)) {
                    productMap.put(handler, new ArrayList());
                }
                List list = (List)productMap.get(handler);
                list.add(baseProduct);
            }
        }
        HashSet<String> travellerUids = new HashSet<String>();
        int trvNumber = 1;
        for (Map.Entry entry : productMap.entrySet()) {
            request.getPassiveDataList().add(((ProductPassiveSegmentsHandler)entry.getKey()).getSabrePassiveData((List)entry.getValue(), request.getClientMode(), request.getSubagencyMode(), messages, true));
            List travellers = ((ProductPassiveSegmentsHandler)entry.getKey()).getTravellers((List)entry.getValue());
            for (SabrePassivePassengerData trv : travellers) {
                if (travellerUids.contains(trv.getUid())) continue;
                trv.setNameNumber(String.format("%s.1", Integer.toString(trvNumber)));
                request.getTravellers().add(trv);
                travellerUids.add(trv.getUid());
                ++trvNumber;
            }
        }
        SabrePassiveSegmentsUtil.verifySegmentsAndRemarks(request.getPassiveDataList());
        request.getCommunications().addAll(SabrePassiveSegmentsUtil.getAgentPhones((BookingFile)bf));
        request.setDkNumber(Optional.ofNullable(bf.getCustomerProfile()).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(BaseProfile::getCode).orElse(null));
        return request;
    }

    private static boolean hasAnyProductWithCWTAgencyOrSubagency(BookingFile bf, List<String> productUids) {
        return bf.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(bp -> productUids.contains(bp.getUid())).anyMatch(bp -> {
            ProductPassiveSegmentsHandler handler = HandlersRegistry.get().findProductPassiveSegmentsHandler(bp.getClass());
            return handler.getClientMode(bp) == SabrePassiveSegmentsClientMode.CWT;
        });
    }

    private static boolean hasContractWithAgencyWithCWTScheme(EntityReference<Organization> org) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), org));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)new Date())}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)new Date())}));
        List indices = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        for (ContractCustomerIndex ind : indices) {
            EntityContainer agencyCont;
            if (ind.getSupplier() == null || (agencyCont = EntityStorage.get().resolve(ind.getSupplier())) == null || agencyCont.getEntity() == null || ((Organization)agencyCont.getEntity()).getCwtProfileData() == null || !((Organization)agencyCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) continue;
            return true;
        }
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)TripartiteContractType.AVIA));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)org.getUid()));
        List tripCtrIndices = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        for (TripartiteContractIndex tci : tripCtrIndices) {
            EntityReference tcRef = tci.getSource();
            EntityContainer tcCont = EntityStorage.get().resolve(tcRef);
            if (tcCont == null) continue;
            TripartiteContract tc = (TripartiteContract)tcCont.getEntity();
            for (TripartiteContractCustomerInfo tcci : tc.getCustomers()) {
                EntityContainer agencyCont;
                if (tcci.getCustomer() == null || !tcci.getCustomer().equals(org) || tcci.getStartDate() != null && !tcci.getStartDate().before(new Date()) || tcci.getEndDate() != null && !tcci.getEndDate().after(new Date()) || (agencyCont = EntityStorage.get().resolve(tc.getAgency())) == null || agencyCont.getEntity() == null || ((Organization)agencyCont.getEntity()).getCwtProfileData() == null || !((Organization)agencyCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) continue;
                return true;
            }
        }
        return false;
    }
}

