/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class SabreProfilesDictionaryData
implements XSerializable {
    private Map<Class<? extends BaseDictionary>, Map<String, BaseDictionary>> dictionaries = new HashMap<Class<? extends BaseDictionary>, Map<String, BaseDictionary>>();

    public <D extends BaseDictionary> void add(D dict) {
        if (dict == null) {
            return;
        }
        this.dictionaries.computeIfAbsent(dict.getClass(), d -> new HashMap()).putIfAbsent(dict.getCode(), dict);
    }

    public <D extends BaseDictionary> void addRef(DictionaryReference<D> dictRef) {
        if (dictRef == null) {
            return;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(dictRef);
        this.add(dict);
    }

    public void addAll(Iterable<BaseDictionary> dicts) {
        if (dicts == null) {
            return;
        }
        for (BaseDictionary dict : dicts) {
            this.add(dict);
        }
    }

    public void addAllRefs(Iterable<DictionaryReference<? extends BaseDictionary>> dictRefs) {
        if (dictRefs == null) {
            return;
        }
        for (DictionaryReference<? extends BaseDictionary> dictRef : dictRefs) {
            this.addRef(dictRef);
        }
    }

    public <D extends BaseDictionary> D resolve(DictionaryReference<D> dictRef) {
        if (dictRef == null) {
            return null;
        }
        Map<String, BaseDictionary> dictionariesForClass = this.dictionaries.get(dictRef.getType());
        return (D)(dictionariesForClass == null ? null : dictionariesForClass.get(dictRef.getCode()));
    }

    public void toXML(Element elm) throws Exception {
        this.dictionaries.values().stream().flatMap(v -> v.values().stream()).forEach(dict -> XHelper.writeObject((Element)elm, (String)"dictionaries/item", (Object)dict));
    }

    public void fromXML(Element elm) throws Exception {
        this.dictionaries.clear();
        for (Element dictElement : XmlUtil.getElements((Element)elm, (String)"dictionaries/item")) {
            BaseDictionary dict = (BaseDictionary)XHelper.readObject((Element)dictElement, (String)".");
            this.add(dict);
        }
    }
}

