/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileInfo;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SabreProfilesLoadNewProfilesScheduledTask
extends BaseScheduledTask {
    private Map<String, SabreProfilesPccSettings> pccSettings;
    private int loadedProfilesCount;

    protected void doJob() throws Exception {
        if (!this.isLoadingProfilesActive()) {
            return;
        }
        if (!this.loadPccSettings()) {
            return;
        }
        this.setInitialParameters();
        List<String> templateIds = this.getTemplateIds();
        if (templateIds.isEmpty()) {
            this.log.warn("Template ids not found");
            return;
        }
        List<SabreProfilesProfileInfo> foundProfiles = SabreProfilesSynchronizationHelper.searchPersonsByTemplates(templateIds);
        if (foundProfiles.isEmpty()) {
            this.log.warn("Profiles not found");
            return;
        }
        if (this.log.isDebugEnabled()) {
            String profilesInfo = foundProfiles.stream().filter(Objects::nonNull).map(p -> String.format("%s (%s:%s)", p.getName(), p.getPcc(), p.getUniqueId())).collect(Collectors.joining(", "));
            this.log.debug(String.format("found %s profiles: %s", foundProfiles.size(), profilesInfo));
        } else {
            this.log.info(String.format("found %s profiles", foundProfiles.size()));
        }
        for (SabreProfilesProfileInfo profile : foundProfiles) {
            if (this.isToBeStopped()) {
                this.log.info("task is interrupted");
                break;
            }
            this.loadTraveller(profile);
        }
        this.logResult();
    }

    private boolean isLoadingProfilesActive() {
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (settings == null || !settings.isLoadActive()) {
            this.log.warn(this.getMessage("SabreProfiles_ReturnSynchronizationIsInactive", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean loadPccSettings() {
        this.pccSettings = Collections.unmodifiableMap(ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings().stream().filter(Objects::nonNull).filter(settings -> TextUtil.nonBlank((String)settings.getPcc())).collect(Collectors.toMap(SabreProfilesPccSettings::getPcc, Function.identity(), (first, second) -> first)));
        if (this.pccSettings.isEmpty()) {
            this.log.warn(this.getMessage("SabreProfileLoadProfilesTask_pccSettingsNotFound", new Object[0]));
            return false;
        }
        return true;
    }

    private void setInitialParameters() {
        this.loadedProfilesCount = 0;
    }

    private List<String> getTemplateIds() {
        String templateIdsString = this.getParameter("TEMPLATE_IDS", "");
        return Arrays.stream(templateIdsString.split(",")).filter(TextUtil::nonBlank).map(String::trim).collect(Collectors.toList());
    }

    private void loadTraveller(SabreProfilesProfileInfo profile) {
        if (!this.validateTraveller(profile)) {
            return;
        }
        SabreProfilesPccSettings pccAndPassword = this.pccSettings.get(profile.getPcc());
        if (pccAndPassword == null) {
            this.log.warn(this.getMessage("SabreProfileLoadProfilesTask_pccNotFound", profile.getPcc(), profile.getName(), profile.getUniqueId()));
            return;
        }
        EntityReference<Person> existTraveller = this.searchAlreadyExistTraveller(profile);
        this.loadProfile(existTraveller, profile, pccAndPassword);
    }

    private void loadProfile(EntityReference<Person> existPerson, SabreProfilesProfileInfo profile, SabreProfilesPccSettings pccAndPassword) {
        if (existPerson == null) {
            this.safeLoadNewTraveller(profile, pccAndPassword);
        }
    }

    private boolean validateTraveller(SabreProfilesProfileInfo profile) {
        if (TextUtil.isBlank((String)profile.getUniqueId())) {
            this.log.info(this.getMessage("SabreProfileLoadProfilesTask_idAbsent", profile.getName()));
            return false;
        }
        if (TextUtil.isBlank((String)profile.getPcc())) {
            this.log.info(this.getMessage("SabreProfileLoadProfilesTask_pccAbsent", profile.getName(), profile.getUniqueId()));
            return false;
        }
        return true;
    }

    private EntityReference<Person> searchAlreadyExistTraveller(SabreProfilesProfileInfo profile) {
        return SabreProfilesSynchronizationUtil.searchPersonByPccAndUniqueId(profile.getPcc(), profile.getUniqueId());
    }

    private void safeLoadNewTraveller(SabreProfilesProfileInfo profile, SabreProfilesPccSettings pccAndPassword) {
        try {
            ValueHolder profileHolder = new ValueHolder();
            SabreProfilesLoadResult result = SabreProfilesSynchronizationHelper.loadNewPerson(profile.getUniqueId(), pccAndPassword, (ValueHolder<EntityReference<Person>>)profileHolder, new ArrayList<Message>());
            EntityReference loadedProfile = (EntityReference)profileHolder.getValue();
            switch (result) {
                case OK: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.getMessage("SabreProfileLoadProfilesTask_profileWasLoaded", profile.getName(), profile.getUniqueId(), loadedProfile, loadedProfile.getUid()));
                    }
                    ++this.loadedProfilesCount;
                    break;
                }
                case EMPLOYMENTS_NOT_FOUND: {
                    this.log.warn(this.getMessage("SabreProfileLoadProfilesTask_employmentsNotFound", profile.getName(), profile.getUniqueId()));
                    break;
                }
                case LOAD_NOT_ALLOWED: {
                    this.log.warn(this.getMessage("SabreProfileLoadProfilesTask_profileLoadingNotAllowed", profile.getName(), profile.getUniqueId()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported result: " + result);
                }
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Error during load profile %s (id %s)", profile.getName(), profile.getUniqueId()), (Throwable)e);
        }
    }

    private String getMessage(String key, Object ... parameters) {
        L10nResourcesManager l10nManager = LocaleManager.get().getL10nResourceManager();
        return l10nManager.getMessage(Locale.ENGLISH, key, parameters);
    }

    private void logResult() {
        this.log.info("loaded profiles: " + this.loadedProfilesCount);
    }
}

