/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileValidationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.EmploymentInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfileLoadOperationType;
import com.gridnine.xtrip.common.model.profile.SabreProfileOperationType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadStatus;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSearchInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSearchTemplateInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResultType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationStatus;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesAssociatedProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequestType;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationResponseType;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SynchronizationParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreProfilesSynchronizationHelper {
    public static final String DATA_SOURCE = "sabre-profiles-sync";
    public static final String VERSION_NOTES_SYNC = "sync";
    public static final String VERSION_NOTES_DELETE = "delete";
    public static final String VERSION_NOTES_LOAD = "load";
    public static final String DELETED_PROFILE_ERROR = "(.*567.*Cannot read object with status DL.*)|(.*298.*No profile is found which match your selection criteria.*)";
    static final transient Logger log = LoggerFactory.getLogger(SabreProfilesSynchronizationHelper.class);

    public static int sendOrganizations(Map<EntityContainer<Organization>, SabreProfilesValidationResult> orgConts, SabreProfilesPccSettings pccSettings) {
        int numSuccess = 0;
        for (Map.Entry<EntityContainer<Organization>, SabreProfilesValidationResult> entry : orgConts.entrySet()) {
            EntityContainer<Organization> orgCont = entry.getKey();
            SabreProfilesValidationResult validationResult = entry.getValue();
            try {
                SabreProfilesSynchronizationResult syncResult = SabreProfilesSynchronizationHelper.sendOrganization(orgCont, pccSettings, validationResult);
                if (syncResult.getType() == SabreProfilesSynchronizationResultType.ERROR) continue;
                ++numSuccess;
            }
            catch (Exception e) {
                log.error("SabreProfiles organizations list synchronization error", (Throwable)e);
            }
        }
        return numSuccess;
    }

    public static SabreProfilesSynchronizationResult sendOrganization(EntityContainer<Organization> orgCont, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult) throws ServiceException {
        Organization org = (Organization)orgCont.getEntity();
        org.getSabreProfilesMessages().clear();
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        boolean originalCwtSchemeValue = org.getCwtProfileData() != null && org.getCwtProfileData().isUseCwtPassiveSegmentScheme();
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        MiscUtil.Pair cirToken = CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, (EntityReference)orgCont.toReference());
        String agencyToken = Optional.ofNullable(cirToken).map(MiscUtil.Pair::getSecond).orElse(null);
        SabreProfilesSynchronizationHelper.updateCardsFromCir(settings, agencyToken, ((Organization)orgCont.getEntity()).getCards());
        EntityReference cirTokenAgencyRef = Optional.ofNullable(cirToken).map(MiscUtil.Pair::getFirst).orElse(null);
        SabreProfilesSynchronizationRequest request = SabreProfilesSynchronizationUtil.updateOrganizationRequest(parameters, orgCont, (EntityReference<Organization>)cirTokenAgencyRef);
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        SabreProfilesSynchronizationResponse synchResponse = response.getData();
        Date currentDate = new Date();
        org.setSabreProfilesLastSyncAttemptDate(currentDate);
        if (synchResponse != null && (synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.SUCCESS || synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.WARNING)) {
            ProfileSynchronizationUtil.setSabreProfilesUniqueID((Organization)org, (String)pccSettings.getPcc(), (String)synchResponse.getUniqueID());
            ProfileSynchronizationUtil.updatePnrBuildersFromSabreProfile((List)org.getPnrBuildersFromSabreProfile(), synchResponse.getPnrBuilders(), (String)request.getPcc());
            org.setSabreProfilesLastSyncDate(currentDate);
            org.setSabreProfilesLastOperationType(SabreProfileOperationType.SYNCHRONIZATION);
            SabreProfilesSynchronizationStatus status = validationResult != null ? validationResult.getStatus() : SabreProfilesSynchronizationStatus.OK;
            org.setSabreProfilesLastSyncStatus(status);
        } else {
            org.setSabreProfilesLastSyncStatus(SabreProfilesSynchronizationStatus.SYNC_ERROR);
        }
        if (validationResult != null) {
            org.getSabreProfilesMessages().addAll(validationResult.getMessages());
        }
        org.getSabreProfilesMessages().addAll(response.getMessages());
        if (org.getCwtProfileData() != null) {
            org.getCwtProfileData().setUseCwtPassiveSegmentScheme(originalCwtSchemeValue);
        }
        ArrayList<Message> savingMessages = new ArrayList<Message>();
        SabreProfilesSynchronizationHelper.saveOrganization(orgCont, VERSION_NOTES_SYNC, savingMessages);
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        return SabreProfilesSynchronizationHelper.createResult(response, savingMessages);
    }

    public static List<Integer> deleteOrganizations(List<EntityReference<Organization>> orgRefs, SabreProfilesPccSettings pccSettings) {
        ArrayList orgConts = new ArrayList();
        orgRefs.forEach(orgRef -> {
            boolean isValid = false;
            EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
            if (orgCont != null && orgCont.getEntity() != null) {
                for (SabreProfilesUniqueIDSettings sett : ((Organization)orgCont.getEntity()).getSabreProfilesUniqueIDs()) {
                    if (!TextUtil.isSame((String)sett.getPcc(), (String)pccSettings.getPcc()) || TextUtil.isBlank((String)sett.getUniqueID())) continue;
                    isValid = true;
                    break;
                }
            }
            if (isValid) {
                orgConts.add(orgCont);
            }
        });
        int numSuccess = 0;
        for (EntityContainer orgCont : orgConts) {
            try {
                SabreProfilesSynchronizationResult syncResult = SabreProfilesSynchronizationHelper.deleteOrganization((EntityReference<Organization>)orgCont.toReference(), pccSettings);
                if (syncResult.getType() == SabreProfilesSynchronizationResultType.ERROR) continue;
                ++numSuccess;
            }
            catch (Exception e) {
                log.error("SabreProfiles organizations list synchronization error", (Throwable)e);
            }
        }
        return SabreProfilesSynchronizationHelper.calcResultNumbers(orgRefs.size(), orgConts.size(), numSuccess);
    }

    public static SabreProfilesSynchronizationResult deleteOrganization(EntityReference<Organization> orgRef, SabreProfilesPccSettings pccSettings) throws ServiceException {
        EntityContainer<Organization> orgCont = SabreProfilesSynchronizationHelper.resolveOrganizationOrThrowException(orgRef);
        return SabreProfilesSynchronizationHelper.deleteOrganization(orgCont, pccSettings);
    }

    private static SabreProfilesSynchronizationResult deleteOrganization(EntityContainer<Organization> orgCont, SabreProfilesPccSettings pccSettings) throws ServiceException {
        Organization org = (Organization)orgCont.getEntity();
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        SabreProfilesSynchronizationRequest request = new SabreProfilesSynchronizationRequest();
        request.setPcc(parameters.getPcc());
        request.setPassword(parameters.getPassword());
        request.setCurrentUser(UserData.get().getCurrentUser());
        request.setRequestType(SabreProfilesSynchronizationRequestType.DELETE_ORGANIZATION);
        request.setOrganization(org);
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        SabreProfilesSynchronizationResponse synchResponse = response.getData();
        ArrayList<Message> savingMessages = new ArrayList<Message>();
        if (synchResponse != null && (synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.SUCCESS || synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.WARNING)) {
            ProfileSynchronizationUtil.clearSabreProfilesUniqueID((List)org.getSabreProfilesUniqueIDs(), (String)pccSettings.getPcc());
            org.getPnrBuildersFromSabreProfile().clear();
            org.setSabreProfilesLastSyncDate(null);
            org.setSabreProfilesLastSyncAttemptDate(new Date());
            org.getSabreProfilesMessages().clear();
            org.setSabreProfilesLastOperationType(SabreProfileOperationType.DELETE);
            SabreProfilesSynchronizationHelper.saveOrganization(orgCont, VERSION_NOTES_DELETE, savingMessages);
        }
        return SabreProfilesSynchronizationHelper.createResult(response, savingMessages);
    }

    public static SabreProfilesSynchronizationStatus validateAndSendPerson(EntityReference<Person> perRef, List<SabreProfilesPccSettings> pccSettings, List<Message> messages) throws ServiceException {
        CollectionUtil.requireNonEmpty(pccSettings, (String)"pcc settings absent");
        EntityContainer<Person> perCont = SabreProfilesSynchronizationHelper.resolvePersonOrThrowException(perRef);
        SabreProfilesValidationResult validationResult = ProfileValidationUtil.validatePersonForSabreProfiles(perCont);
        if (validationResult.isError()) {
            messages.addAll(SabreProfilesSynchronizationHelper.getPersonErrorMessages(perCont));
            return SabreProfilesSynchronizationStatus.VALIDATION_ERROR;
        }
        messages.addAll(validationResult.getMessages());
        int successCount = 0;
        for (SabreProfilesPccSettings sabreProfilesPccSettings : pccSettings) {
            successCount += SabreProfilesSynchronizationHelper.sendPersons(Collections.singletonMap(perCont, validationResult), sabreProfilesPccSettings, messages);
        }
        if (successCount > 0) {
            return validationResult.getStatus();
        }
        return SabreProfilesSynchronizationStatus.SYNC_ERROR;
    }

    public static SabreProfilesSynchronizationResult sendPerson(EntityContainer<Person> perCont, EntityReference<Organization> orgRef, List<EntityReference<Organization>> workPlaces, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult) throws Exception {
        Person per = (Person)perCont.getEntity();
        per.getSabreProfilesMessages().clear();
        long startTime = System.currentTimeMillis();
        EntityContainer<Organization> orgCont = SabreProfilesSynchronizationHelper.resolveOrganizationOrThrowException(orgRef);
        SabreProfilesSynchronizationHelper.logTime("sendPerson: organization resolved", startTime);
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        startTime = System.currentTimeMillis();
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        MiscUtil.Pair cirToken = CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, orgRef);
        String agencyToken = Optional.ofNullable(cirToken).map(MiscUtil.Pair::getSecond).orElse(null);
        SabreProfilesSynchronizationHelper.updateCardsFromCir(settings, agencyToken, ((Organization)orgCont.getEntity()).getCards());
        SabreProfilesSynchronizationHelper.logTime("sendPerson: cards updated from cir", startTime);
        startTime = System.currentTimeMillis();
        EntityReference cirTokenAgencyRef = Optional.ofNullable(cirToken).map(MiscUtil.Pair::getFirst).orElse(null);
        SabreProfilesSynchronizationRequest request = SabreProfilesSynchronizationUtil.updatePersonRequest(parameters, perCont, orgCont, workPlaces, (EntityReference<Organization>)cirTokenAgencyRef);
        SabreProfilesSynchronizationHelper.logTime("sendPerson: request prepared", startTime);
        ValueHolder traceHolder = new ValueHolder();
        startTime = System.currentTimeMillis();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        SabreProfilesSynchronizationHelper.logTime("sendPerson: request sent", startTime);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        SabreProfilesSynchronizationResponse synchResponse = response.getData();
        Date currentDate = new Date();
        per.setSabreProfilesLastSyncAttemptDate(currentDate);
        if (validationResult != null) {
            per.getSabreProfilesMessages().addAll(validationResult.getMessages());
        }
        per.getSabreProfilesMessages().addAll(response.getMessages());
        if (synchResponse != null && (synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.SUCCESS || synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.WARNING)) {
            ProfileSynchronizationUtil.setSabreProfilesUniqueID((Person)per, (String)pccSettings.getPcc(), (String)synchResponse.getUniqueID());
            ProfileSynchronizationUtil.setSabreProfilesProfileName((Person)per, (String)pccSettings.getPcc(), (String)synchResponse.getProfileName());
            ProfileSynchronizationUtil.updatePnrBuildersFromSabreProfile((List)per.getPnrBuildersFromSabreProfile(), synchResponse.getPnrBuilders(), (String)request.getPcc());
            per.setSabreProfilesLastSyncDate(currentDate);
            per.setSabreProfilesLastOperationType(SabreProfileOperationType.SYNCHRONIZATION);
            if (synchResponse.getUpdateDate() != null) {
                per.setSabreProfilesUpdateDate(synchResponse.getUpdateDate());
            }
            SabreProfilesSynchronizationStatus status = validationResult != null ? validationResult.getStatus() : SabreProfilesSynchronizationStatus.OK;
            per.setSabreProfilesLastSyncStatus(status);
        } else {
            per.setSabreProfilesLastSyncStatus(SabreProfilesSynchronizationStatus.SYNC_ERROR);
        }
        startTime = System.currentTimeMillis();
        ArrayList<Message> savingMessages = new ArrayList<Message>();
        SabreProfilesSynchronizationHelper.savePerson(perCont, VERSION_NOTES_SYNC, savingMessages);
        SabreProfilesSynchronizationHelper.logTime("sendPerson: person was saved", startTime);
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        return SabreProfilesSynchronizationHelper.createResult(response, savingMessages);
    }

    @Deprecated
    public static SabreProfilesSynchronizationResult sendPerson(EntityContainer<Person> perCont) throws Exception {
        List orgRefs = ProfileHelper.getOrganizationForPerson((Person)((Person)perCont.getEntity()));
        SabreProfilesPccSettings pccSettings = (SabreProfilesPccSettings)CollectionUtil.head((Iterable)ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings());
        if (pccSettings == null) {
            log.error("Unable to find pccSettings");
            return null;
        }
        return SabreProfilesSynchronizationHelper.sendPerson(perCont, (EntityReference<Organization>)((EntityReference)CollectionUtil.head((Iterable)orgRefs)), orgRefs, pccSettings, null);
    }

    public static List<Integer> deletePersons(List<EntityReference<Person>> perRefs, SabreProfilesPccSettings pccSettings) {
        ArrayList perConts = new ArrayList();
        perRefs.forEach(perRef -> {
            boolean isValid = false;
            EntityContainer perCont = EntityStorage.get().resolve(perRef);
            if (perCont != null && perCont.getEntity() != null) {
                for (SabreProfilesUniqueIDSettings sett : ((Person)perCont.getEntity()).getSabreProfilesUniqueIDs()) {
                    if (!TextUtil.isSame((String)sett.getPcc(), (String)pccSettings.getPcc()) || TextUtil.isBlank((String)sett.getUniqueID())) continue;
                    isValid = true;
                    break;
                }
            }
            if (isValid) {
                perConts.add(perCont);
            }
        });
        int numSuccess = 0;
        for (EntityContainer perCont : perConts) {
            try {
                SabreProfilesSynchronizationResult syncResult = SabreProfilesSynchronizationHelper.deleteTraveler((EntityReference<Person>)perCont.toReference(), pccSettings);
                if (syncResult.getType() == SabreProfilesSynchronizationResultType.ERROR) continue;
                ++numSuccess;
            }
            catch (Exception e) {
                log.error("SabreProfiles persons list synchronization error", (Throwable)e);
            }
        }
        return SabreProfilesSynchronizationHelper.calcResultNumbers(perRefs.size(), perConts.size(), numSuccess);
    }

    public static SabreProfilesSynchronizationResult deleteTraveler(EntityReference<Person> perRef, SabreProfilesPccSettings pccSettings) throws ServiceException {
        EntityContainer<Person> perCont = SabreProfilesSynchronizationHelper.resolvePersonOrThrowException(perRef);
        Person per = (Person)perCont.getEntity();
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        SabreProfilesSynchronizationRequest request = new SabreProfilesSynchronizationRequest();
        request.setPcc(parameters.getPcc());
        request.setPassword(parameters.getPassword());
        request.setCurrentUser(UserData.get().getCurrentUser());
        request.setPerson(per);
        request.setRequestType(SabreProfilesSynchronizationRequestType.DELETE_PERSON);
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        SabreProfilesSynchronizationResponse synchResponse = response.getData();
        ArrayList<Message> savingMessages = new ArrayList<Message>();
        if (synchResponse != null && (synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.SUCCESS || synchResponse.getResponseType() == SabreProfilesSynchronizationResponseType.WARNING)) {
            ProfileSynchronizationUtil.clearSabreProfilesUniqueID((List)per.getSabreProfilesUniqueIDs(), (String)pccSettings.getPcc());
            per.setSabreProfilesLastOperationType(SabreProfileOperationType.DELETE);
            per.setSabreProfilesLastSyncDate(null);
            per.setSabreProfilesLastSyncAttemptDate(new Date());
            per.getSabreProfilesMessages().clear();
            SabreProfilesSynchronizationHelper.savePerson(perCont, VERSION_NOTES_DELETE, savingMessages);
        }
        return SabreProfilesSynchronizationHelper.createResult(response, savingMessages);
    }

    private static Map<EntityContainer<Organization>, SabreProfilesValidationResult> validateOrganizations(List<EntityReference<Organization>> orgRefs, List<Message> messages) {
        HashMap<EntityContainer<Organization>, SabreProfilesValidationResult> result = new HashMap<EntityContainer<Organization>, SabreProfilesValidationResult>();
        orgRefs.forEach(orgRef -> {
            EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
            if (EntityStorageHelper.isEmpty((EntityContainer)orgCont)) {
                return;
            }
            SabreProfilesValidationResult validationResult = ProfileValidationUtil.validateOrganizationForSabreProfiles((EntityContainer)orgCont);
            if (validationResult.isError()) {
                messages.addAll(SabreProfilesSynchronizationHelper.getOrganizationErrorMessages((EntityContainer<Organization>)orgCont));
                ((Organization)orgCont.getEntity()).setSabreProfilesLastSyncAttemptDate(new Date());
                SabreProfilesSynchronizationHelper.saveOrganization((EntityContainer<Organization>)orgCont, VERSION_NOTES_SYNC, messages);
            } else {
                result.put(orgCont, validationResult);
            }
        });
        return result;
    }

    private static Map<EntityContainer<Person>, SabreProfilesValidationResult> validatePersons(List<EntityReference<Person>> perRefs, List<Message> messages) {
        HashMap<EntityContainer<Person>, SabreProfilesValidationResult> result = new HashMap<EntityContainer<Person>, SabreProfilesValidationResult>();
        perRefs.forEach(perRef -> {
            EntityContainer perCont = EntityStorage.get().resolve(perRef);
            if (EntityStorageHelper.isEmpty((EntityContainer)perCont)) {
                return;
            }
            SabreProfilesValidationResult validationResult = ProfileValidationUtil.validatePersonForSabreProfiles((EntityContainer)perCont);
            if (validationResult.isError()) {
                messages.addAll(SabreProfilesSynchronizationHelper.getPersonErrorMessages((EntityContainer<Person>)perCont));
                ((Person)perCont.getEntity()).setSabreProfilesLastSyncAttemptDate(new Date());
                SabreProfilesSynchronizationHelper.savePerson((EntityContainer<Person>)perCont, VERSION_NOTES_SYNC, messages);
            } else {
                result.put(perCont, validationResult);
            }
        });
        return result;
    }

    private static List<Message> getPersonErrorMessages(EntityContainer<Person> perCont) {
        String firstName = ProfileSynchronizationUtil.getSabreLocale((L10nString)((Person)perCont.getEntity()).getFirstName());
        String lastName = ProfileSynchronizationUtil.getSabreLocale((L10nString)((Person)perCont.getEntity()).getLastName());
        String name = lastName + " " + firstName;
        return SabreProfilesSynchronizationHelper.getErrorMessages(name, ((Person)perCont.getEntity()).getSabreProfilesMessages());
    }

    private static List<Message> getOrganizationErrorMessages(EntityContainer<Organization> orgCont) {
        String shortName = ProfileSynchronizationUtil.getSabreLocale((L10nString)((Organization)orgCont.getEntity()).getShortName());
        return SabreProfilesSynchronizationHelper.getErrorMessages(shortName, ((Organization)orgCont.getEntity()).getSabreProfilesMessages());
    }

    private static List<Message> getErrorMessages(String profileName, Collection<Message> sabreProfileMessages) {
        L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
        return sabreProfileMessages.stream().filter(msg -> msg.getType() == MessageType.ERROR).map(msg -> l10nResourcesManager.getMessage(msg.getMessage(), LocaleUtil.LOCALE_EN)).map(msg -> MessageHelper.createErrorMessage((String)(profileName + ": " + msg), (Object[])new Object[0])).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int sendPersons(Map<EntityContainer<Person>, SabreProfilesValidationResult> perConts, SabreProfilesPccSettings pccSettings, List<Message> messages) {
        int numSuccess = 0;
        for (Map.Entry<EntityContainer<Person>, SabreProfilesValidationResult> entry : perConts.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"c\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430", (Object[])new Object[0]));
                break;
            }
            EntityContainer<Person> perCont = entry.getKey();
            SabreProfilesValidationResult validationResult = entry.getValue();
            List employments = ProfileValidationUtil.getOrganizationsForPerson((Person)((Person)perCont.getEntity()));
            try {
                SabreProfilesSynchronizationResult syncResult = SabreProfilesSynchronizationHelper.sendPerson(perCont, (EntityReference<Organization>)((EntityReference)employments.get(0)), employments, pccSettings, validationResult);
                if (syncResult.getType() == SabreProfilesSynchronizationResultType.ERROR) continue;
                ++numSuccess;
            }
            catch (Exception e) {
                log.error("SabreProfiles persons list synchronization error", (Throwable)e);
            }
            finally {
                messages.addAll(SabreProfilesSynchronizationHelper.getPersonErrorMessages(perCont));
            }
        }
        return numSuccess;
    }

    static List<Integer> validateAndSendFilteredOrganizations(List<EntityReference<Organization>> orgRefs, List<SabreProfilesPccSettings> globalPccSettings, List<Message> messages) {
        log.debug("validating Organizations list before sending to Sabre Profiles. Amount of profiles: " + orgRefs.size());
        Map<EntityContainer<Organization>, SabreProfilesValidationResult> orgConts = SabreProfilesSynchronizationHelper.validateOrganizations(orgRefs, messages);
        log.debug("synchronizing Organizations list to Sabre Profiles. Amount of profiles: " + orgConts.size());
        int numSuccess = 0;
        for (Map.Entry<EntityContainer<Organization>, SabreProfilesValidationResult> entry : orgConts.entrySet()) {
            EntityContainer<Organization> orgCont = entry.getKey();
            SabreProfilesValidationResult validationResult = entry.getValue();
            boolean isSuccess = false;
            List filteredPccSettings = ProfileSynchronizationUtil.filterPccsSettings((List)ProfileSynchronizationUtil.getPccSettingsFromProfiles(orgCont), globalPccSettings);
            if (filteredPccSettings.size() > 2 && filteredPccSettings.size() == globalPccSettings.size()) {
                log.warn("PCC settings for organization " + ((Organization)orgCont.getEntity()).toString() + " were not filtered, size = " + filteredPccSettings.size());
            }
            for (SabreProfilesPccSettings sabreProfilesPccSettings : filteredPccSettings) {
                int succeededProfiles = SabreProfilesSynchronizationHelper.sendOrganizations(Collections.singletonMap(orgCont, validationResult), sabreProfilesPccSettings);
                if (succeededProfiles <= 0) continue;
                isSuccess = true;
            }
            if (!isSuccess) continue;
            ++numSuccess;
        }
        for (EntityContainer entityContainer : orgConts.keySet()) {
            messages.addAll(SabreProfilesSynchronizationHelper.getOrganizationErrorMessages((EntityContainer<Organization>)entityContainer));
        }
        return SabreProfilesSynchronizationHelper.calcResultNumbers(orgRefs.size(), orgConts.size(), numSuccess);
    }

    public static List<Integer> validateAndSendOrganizations(List<EntityReference<Organization>> orgRefs, SabreProfilesPccSettings pccSettings, List<Message> messages) {
        log.debug("validating Organizations list before sending to Sabre Profiles. Amount of profiles: " + orgRefs.size());
        Map<EntityContainer<Organization>, SabreProfilesValidationResult> orgConts = SabreProfilesSynchronizationHelper.validateOrganizations(orgRefs, messages);
        log.debug("synchronizing Organizations list to Sabre Profiles. Amount of profiles: " + orgConts.size());
        int numSuccess = SabreProfilesSynchronizationHelper.sendOrganizations(orgConts, pccSettings);
        if (numSuccess < orgConts.size()) {
            for (EntityContainer<Organization> orgCont : orgConts.keySet()) {
                messages.addAll(SabreProfilesSynchronizationHelper.getOrganizationErrorMessages(orgCont));
            }
        }
        return SabreProfilesSynchronizationHelper.calcResultNumbers(orgRefs.size(), orgConts.size(), numSuccess);
    }

    public static List<Integer> validateAndSendFilteredPersons(List<EntityReference<Person>> perRefs, List<SabreProfilesPccSettings> globalPccSettings, List<Message> messages) {
        log.debug("validating Persons list before sending to Sabre Profiles. Amount of profiles: " + perRefs.size());
        Map<EntityContainer<Person>, SabreProfilesValidationResult> perConts = SabreProfilesSynchronizationHelper.validatePersons(perRefs, messages);
        log.debug("synchronizing Persons list to Sabre Profiles. Amount of profiles: " + perConts.size());
        int numSuccess = 0;
        for (Map.Entry<EntityContainer<Person>, SabreProfilesValidationResult> entry : perConts.entrySet()) {
            EntityContainer<Person> perCont = entry.getKey();
            SabreProfilesValidationResult validationResult = entry.getValue();
            boolean isSuccess = false;
            long startTime = System.currentTimeMillis();
            List filteredPccSettings = ProfileSynchronizationUtil.filterPccsSettings((List)ProfileSynchronizationUtil.getPccSettingsFromProfile(perCont), globalPccSettings);
            filteredPccSettings.removeIf(setting -> ProfileValidationUtil.getOrganizationsForPerson((Person)((Person)perCont.getEntity())).stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).filter(ctr -> !((Organization)ctr.getEntity()).isNotSynchronizeWithSabreProfile()).flatMap(ctr -> ((Organization)ctr.getEntity()).getSabreProfilesPccSettings().isEmpty() ? globalPccSettings.stream() : ((Organization)ctr.getEntity()).getSabreProfilesPccSettings().stream()).noneMatch(item -> TextUtil.equals((String)item.getPcc(), (String)setting.getPcc(), (boolean)false)));
            if (filteredPccSettings.size() > 2 && filteredPccSettings.size() == globalPccSettings.size()) {
                log.warn("PCC settings for person " + ((Person)perCont.getEntity()).toString() + " were not filtered, size = " + filteredPccSettings.size());
            }
            for (SabreProfilesPccSettings sabreProfilesPccSettings : filteredPccSettings) {
                int succeededProfiles = SabreProfilesSynchronizationHelper.sendPersons(Collections.singletonMap(perCont, validationResult), sabreProfilesPccSettings, messages);
                if (succeededProfiles <= 0) continue;
                isSuccess = true;
            }
            SabreProfilesSynchronizationHelper.logTime("validateAndSendFilteredPersons: person was synchronized", startTime, perCont.getEntity());
            if (!isSuccess) continue;
            ++numSuccess;
        }
        return SabreProfilesSynchronizationHelper.calcResultNumbers(perRefs.size(), perConts.size(), numSuccess);
    }

    public static List<Integer> validateAndSendPersons(List<EntityReference<Person>> perRefs, SabreProfilesPccSettings pccSettings, List<Message> messages) {
        log.debug("validating Persons list before sending to Sabre Profiles. Amount of profiles: " + perRefs.size());
        Map<EntityContainer<Person>, SabreProfilesValidationResult> perConts = SabreProfilesSynchronizationHelper.validatePersons(perRefs, messages);
        log.debug("synchronizing Persons list to Sabre Profiles. Amount of profiles: " + perConts.size());
        int numSuccess = SabreProfilesSynchronizationHelper.sendPersons(perConts, pccSettings, messages);
        return SabreProfilesSynchronizationHelper.calcResultNumbers(perRefs.size(), perConts.size(), numSuccess);
    }

    public static SabreProfilesLoadResult loadNewPerson(String uniqueId, SabreProfilesPccSettings pccSettings, ValueHolder<EntityReference<Person>> profileHolder, List<Message> messages) throws ServiceException {
        TextUtil.requireNonBlank((String)uniqueId, (String)"Unique id is absent");
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        EntityReference cirTokenAgencyRef = cirSettings != null ? (EntityReference)cirSettings.getAgencyTokens().stream().map(CirToken::getAgencyProfile).findFirst().orElse(null) : null;
        ArrayList<Message> localMessages = new ArrayList<Message>();
        Person loadedPerson = SabreProfilesSynchronizationHelper.loadAndUpdateNewPerson(uniqueId, pccSettings, cirSettings, (EntityReference<Organization>)cirTokenAgencyRef, false, localMessages);
        if (ProfileHelper.getEmployments((Person)loadedPerson).isEmpty()) {
            return SabreProfilesLoadResult.EMPLOYMENTS_NOT_FOUND;
        }
        if (!SabreProfilesSynchronizationUtil.isLoadAllowedByEmployments(loadedPerson)) {
            return SabreProfilesLoadResult.LOAD_NOT_ALLOWED;
        }
        cirTokenAgencyRef = Optional.ofNullable(CirHelper.findAuthTokenByPersonJobs((PCIDSSServerExchangeSettings)cirSettings, (Person)loadedPerson)).map(MiscUtil.Pair::getFirst).orElse(null);
        if (cirTokenAgencyRef != null && CirHelper.cirEnabled((PCIDSSServerExchangeSettings)cirSettings)) {
            loadedPerson = SabreProfilesSynchronizationHelper.loadAndUpdateNewPerson(uniqueId, pccSettings, cirSettings, (EntityReference<Organization>)cirTokenAgencyRef, true, localMessages);
            if (ProfileHelper.getEmployments((Person)loadedPerson).isEmpty()) {
                return SabreProfilesLoadResult.EMPLOYMENTS_NOT_FOUND;
            }
            if (!SabreProfilesSynchronizationUtil.isLoadAllowedByEmployments(loadedPerson)) {
                return SabreProfilesLoadResult.LOAD_NOT_ALLOWED;
            }
        }
        localMessages = new ArrayList<Message>(new LinkedHashSet<Message>(localMessages));
        messages.addAll(localMessages);
        loadedPerson.getSabreProfilesLoadMessages().addAll(localMessages);
        loadedPerson.setSabreProfilesLastLoadStatus(SabreProfilesLoadStatus.OK);
        loadedPerson.setSabreProfilesLastLoadOperationType(SabreProfileLoadOperationType.LOAD);
        Date currentDate = new Date();
        loadedPerson.setSabreProfilesLastLoadDate(currentDate);
        loadedPerson.setSabreProfilesLastLoadAttemptDate(currentDate);
        EntityContainer personContainer = EntityContainer.create((BaseEntity)loadedPerson);
        SabreProfilesSynchronizationHelper.saveEntity((EntityContainer<? extends BaseEntity>)personContainer, VERSION_NOTES_LOAD);
        profileHolder.setValue((Object)personContainer.toReference());
        return SabreProfilesLoadResult.OK;
    }

    private static Person loadAndUpdateNewPerson(String uniqueId, SabreProfilesPccSettings pccSettings, PCIDSSServerExchangeSettings cirSettings, EntityReference<Organization> cirTokenAgencyRef, boolean readCards, List<Message> messages) throws ServiceException {
        Person fakePerson = new Person();
        ProfileSynchronizationUtil.setSabreProfilesUniqueID((Person)fakePerson, (String)pccSettings.getPcc(), (String)uniqueId);
        ValueHolder profileHolder = new ValueHolder();
        ArrayList<SabreProfilesAssociatedProfileData> associatedProfiles = new ArrayList<SabreProfilesAssociatedProfileData>();
        ArrayList<CostCodeInfo> udidValues = new ArrayList<CostCodeInfo>();
        ArrayList<EmploymentInfo> employmentInfo = new ArrayList<EmploymentInfo>();
        ValueHolder profileNameHolder = new ValueHolder();
        SabreProfilesSynchronizationResult result = SabreProfilesSynchronizationHelper.loadPerson(fakePerson, pccSettings, cirSettings, cirTokenAgencyRef, readCards, (ValueHolder<Person>)profileHolder, associatedProfiles, udidValues, employmentInfo, (ValueHolder<String>)profileNameHolder, null);
        Person loadedPerson = (Person)profileHolder.getValue();
        messages.addAll(result.getMessages());
        SabreProfilesSynchronizationUtil.updateLoadedNewPerson(loadedPerson, pccSettings.getPcc(), uniqueId, (String)profileNameHolder.getValue(), associatedProfiles, udidValues, employmentInfo, messages);
        return loadedPerson;
    }

    public static SabreProfilesLoadResult loadExistPerson(EntityReference<Person> personRef, SabreProfilesPccSettings pccSettings, boolean checkSPUpdateDate, boolean saveIfNotSuccess, List<Message> messages) throws ServiceException {
        boolean success;
        EntityContainer<Person> personContainer = SabreProfilesSynchronizationHelper.resolvePersonOrThrowException(personRef);
        Person existPerson = (Person)personContainer.getEntity();
        if (!SabreProfilesSynchronizationUtil.isLoadAllowedByEmployments(existPerson)) {
            return SabreProfilesLoadResult.LOAD_NOT_ALLOWED;
        }
        TextUtil.requireNonBlank((String)ProfileSynchronizationUtil.getSabreProfilesUniqueID((Person)existPerson, (String)pccSettings.getPcc()), () -> "person doesn't have unique id for pcc " + pccSettings.getPcc());
        existPerson.getSabreProfilesLoadMessages().clear();
        try {
            PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
            MiscUtil.Pair cirTokenAndOrg = CirHelper.findAuthTokenByPersonJobs((PCIDSSServerExchangeSettings)cirSettings, personRef);
            EntityReference cirTokenAgencyRef = cirTokenAndOrg != null ? (EntityReference)cirTokenAndOrg.getFirst() : null;
            ValueHolder profileHolder = new ValueHolder();
            ArrayList<SabreProfilesAssociatedProfileData> associatedProfiles = new ArrayList<SabreProfilesAssociatedProfileData>();
            ArrayList<CostCodeInfo> udidValues = new ArrayList<CostCodeInfo>();
            ArrayList<EmploymentInfo> employmentInfo = new ArrayList<EmploymentInfo>();
            ValueHolder profileNameHolder = new ValueHolder();
            ValueHolder deleteHolder = new ValueHolder();
            SabreProfilesSynchronizationResult result = SabreProfilesSynchronizationHelper.loadPerson(existPerson, pccSettings, cirSettings, (EntityReference<Organization>)cirTokenAgencyRef, true, (ValueHolder<Person>)profileHolder, associatedProfiles, udidValues, employmentInfo, (ValueHolder<String>)profileNameHolder, (ValueHolder<Boolean>)deleteHolder);
            ArrayList<Message> localMessages = new ArrayList<Message>(result.getMessages());
            if (deleteHolder.getValue() == Boolean.TRUE) {
                messages.addAll(localMessages);
                SabreProfilesSynchronizationHelper.setSabreProfilesLoadDataNotFoundError(existPerson, pccSettings, localMessages);
                SabreProfilesSynchronizationHelper.saveEntity(personContainer, VERSION_NOTES_DELETE);
                return SabreProfilesLoadResult.LOAD_ERROR;
            }
            Person loadedPerson = (Person)profileHolder.getValue();
            if (checkSPUpdateDate && MiscUtil.equals((Object)existPerson.getSabreProfilesUpdateDate(), (Object)loadedPerson.getSabreProfilesUpdateDate())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Profile %s (%s) was not updated in SP", personRef, personRef.getUid()));
                }
                messages.addAll(localMessages);
                return SabreProfilesLoadResult.PROFILE_NOT_CHANGED;
            }
            String cirToken = cirTokenAndOrg != null ? (String)cirTokenAndOrg.getSecond() : null;
            SabreProfilesSynchronizationUtil.updateLoadedExistPerson(existPerson, loadedPerson, pccSettings.getPcc(), (String)profileNameHolder.getValue(), associatedProfiles, udidValues, employmentInfo, cirSettings, cirToken, localMessages);
            messages.addAll(localMessages);
            existPerson.getSabreProfilesLoadMessages().addAll(localMessages);
            existPerson.setSabreProfilesLastLoadStatus(SabreProfilesLoadStatus.OK);
            existPerson.setSabreProfilesLastLoadOperationType(SabreProfileLoadOperationType.LOAD);
            Date currentDate = new Date();
            existPerson.setSabreProfilesLastLoadDate(currentDate);
            existPerson.setSabreProfilesLastLoadAttemptDate(currentDate);
            success = true;
        }
        catch (Throwable t) {
            Message errorMessage = MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"SabreProfiles_ProfileLoadError", (Throwable)t, (Object[])new Object[]{personRef});
            log.error(errorMessage.getMessage().toString(), t);
            messages.add(errorMessage);
            existPerson.getSabreProfilesLoadMessages().add(errorMessage);
            existPerson.setSabreProfilesLastLoadStatus(SabreProfilesLoadStatus.LOAD_ERROR);
            existPerson.setSabreProfilesLastLoadAttemptDate(new Date());
            success = false;
        }
        if (success || saveIfNotSuccess) {
            SabreProfilesSynchronizationHelper.saveEntity(personContainer, VERSION_NOTES_LOAD);
        }
        return success ? SabreProfilesLoadResult.OK : SabreProfilesLoadResult.LOAD_ERROR;
    }

    public static Date getUpdateDateInSabreProfiles(EntityReference<Person> personReference, SabreProfilesPccSettings pccSettings) throws ServiceException {
        EntityContainer<Person> personContainer = SabreProfilesSynchronizationHelper.resolvePersonOrThrowException(personReference);
        TextUtil.requireNonBlank((String)ProfileSynchronizationUtil.getSabreProfilesUniqueID((Person)((Person)personContainer.getEntity()), (String)pccSettings.getPcc()), () -> "person doesn't have unique id for pcc " + pccSettings.getPcc());
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        EntityReference cirTokenAgencyRef = cirSettings != null ? (EntityReference)cirSettings.getAgencyTokens().stream().map(CirToken::getAgencyProfile).findFirst().orElse(null) : null;
        ValueHolder profileHolder = new ValueHolder();
        SabreProfilesSynchronizationHelper.loadPerson((Person)personContainer.getEntity(), pccSettings, cirSettings, (EntityReference<Organization>)cirTokenAgencyRef, false, (ValueHolder<Person>)profileHolder, new ArrayList<SabreProfilesAssociatedProfileData>(), new ArrayList<CostCodeInfo>(), new ArrayList<EmploymentInfo>(), (ValueHolder<String>)new ValueHolder(), null);
        Person loadedPerson = (Person)profileHolder.getValue();
        return loadedPerson.getSabreProfilesUpdateDate();
    }

    private static SabreProfilesSynchronizationResult loadPerson(Person person, SabreProfilesPccSettings pccSettings, PCIDSSServerExchangeSettings cirSettings, EntityReference<Organization> cirTokenAgencyRef, boolean readCards, ValueHolder<Person> readProfileHolder, List<SabreProfilesAssociatedProfileData> associatedProfiles, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo, ValueHolder<String> profileNameHolder, ValueHolder<Boolean> deleteHolder) throws ServiceException {
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        SabreProfilesSynchronizationRequest request = new SabreProfilesSynchronizationRequest();
        request.setPcc(parameters.getPcc());
        request.setPassword(parameters.getPassword());
        request.setCurrentUser(UserData.get().getCurrentUser());
        request.setRequestType(SabreProfilesSynchronizationRequestType.READ_PERSON);
        request.setCirSettings(cirSettings);
        request.setCirTokenAgencyRef(cirTokenAgencyRef);
        request.setReadCards(readCards);
        request.setPerson(person);
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        request.setLoadProfilesEnabled(settings != null && settings.isLoadActive());
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        if (deleteHolder != null && errors.matches(DELETED_PROFILE_ERROR)) {
            deleteHolder.setValue((Object)Boolean.TRUE);
            return SabreProfilesSynchronizationHelper.createResult(response, Collections.emptyList());
        }
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        Objects.requireNonNull(response.getData().getLoadProfileData(), "Profile data was not returned in response");
        Objects.requireNonNull(response.getData().getLoadProfileData().getPerson(), "Profile was not returned in response");
        readProfileHolder.setValue((Object)response.getData().getLoadProfileData().getPerson());
        associatedProfiles.addAll(response.getData().getLoadProfileData().getAssociatedProfiles());
        udidValues.addAll(response.getData().getLoadProfileData().getUdidValues());
        employmentInfo.addAll(response.getData().getLoadProfileData().getEmploymentInfo());
        profileNameHolder.setValue((Object)response.getData().getProfileName());
        return SabreProfilesSynchronizationHelper.createResult(response, Collections.emptyList());
    }

    static List<SabreProfilesProfileInfo> searchPersonsByTemplates(List<String> templateIds) throws ServiceException {
        List allPccSettings = ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings();
        SabreProfilesPccSettings firstPccSettings = (SabreProfilesPccSettings)allPccSettings.get(0);
        SabreProfilesSearchInfo searchInfo = new SabreProfilesSearchInfo();
        templateIds.stream().filter(TextUtil::nonBlank).map(t -> {
            SabreProfilesSearchTemplateInfo template = new SabreProfilesSearchTemplateInfo();
            template.setTemplateId(t);
            return template;
        }).forEach(searchInfo.getTemplates()::add);
        allPccSettings.stream().filter(Objects::nonNull).map(SabreProfilesPccSettings::getPcc).filter(TextUtil::nonBlank).forEach(searchInfo.getProfilesPcc()::add);
        CollectionUtil.requireNonEmpty((Collection)searchInfo.getTemplates(), (String)"template ids are not found");
        CollectionUtil.requireNonEmpty((Collection)searchInfo.getProfilesPcc(), (String)"profiles pcc are not found");
        ArrayList<SabreProfilesProfileInfo> foundProfiles = new ArrayList<SabreProfilesProfileInfo>();
        SabreProfilesSynchronizationResult result = SabreProfilesSynchronizationHelper.searchPersons(firstPccSettings, searchInfo, foundProfiles);
        return foundProfiles;
    }

    private static SabreProfilesSynchronizationResult searchPersons(SabreProfilesPccSettings pccSettings, SabreProfilesSearchInfo searchInfo, List<SabreProfilesProfileInfo> foundProfiles) throws ServiceException {
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        EntityReference cirTokenAgencyRef = cirSettings != null ? (EntityReference)cirSettings.getAgencyTokens().stream().map(CirToken::getAgencyProfile).findFirst().orElse(null) : null;
        SynchronizationParameters parameters = SabreProfilesSynchronizationHelper.getSynchronizationParameters(pccSettings);
        SabreProfilesSynchronizationRequest request = new SabreProfilesSynchronizationRequest();
        request.setPcc(parameters.getPcc());
        request.setPassword(parameters.getPassword());
        request.setCurrentUser(UserData.get().getCurrentUser());
        request.setRequestType(SabreProfilesSynchronizationRequestType.SEARCH_PERSONS);
        request.setCirSettings(cirSettings);
        request.setCirTokenAgencyRef((EntityReference<Organization>)cirTokenAgencyRef);
        request.setSearchInfo(searchInfo);
        ValueHolder traceHolder = new ValueHolder();
        SynchronizationResponse<SabreProfilesSynchronizationResponse> response = SabreProfilesSynchronizationHelper.sendRequest(request, parameters.getServerUrl(), (ValueHolder<String>)traceHolder);
        String errors = SabreProfilesSynchronizationHelper.getErrors(response);
        if (!errors.isEmpty()) {
            throw new ServiceException(errors);
        }
        foundProfiles.addAll(response.getData().getFoundProfiles());
        return SabreProfilesSynchronizationHelper.createResult(response, Collections.emptyList());
    }

    private static SynchronizationParameters getSynchronizationParameters(SabreProfilesPccSettings pccSettings) throws ServiceException {
        ArrayList<Message> messages = new ArrayList<Message>();
        SynchronizationParameters params = SabreProfilesSynchronizationUtil.getSynchronizationParameters(pccSettings, messages);
        if (params == null) {
            if (messages.isEmpty()) {
                throw new ServiceException("Unable to get synchronization params");
            }
            String message = messages.stream().filter(Objects::nonNull).map(Message::getMessage).filter(Objects::nonNull).map(L10nMessage::toString).collect(Collectors.joining(", "));
            throw new ServiceException(message);
        }
        return params;
    }

    private static String getErrors(SynchronizationResponse<SabreProfilesSynchronizationResponse> response) {
        StringBuilder errors = new StringBuilder();
        for (Message msg : response.getMessages()) {
            if (msg.getType() != MessageType.ERROR) continue;
            log.warn("Sabre Profiles request returned with error: " + msg.getMessage());
            if (errors.length() > 0) {
                errors.append("     \\n");
            }
            errors.append(msg.getMessage());
            if (!TextUtil.nonBlank((String)msg.getDetails())) continue;
            errors.append(msg.getDetails());
        }
        return errors.toString();
    }

    private static SynchronizationResponse<SabreProfilesSynchronizationResponse> sendRequest(SabreProfilesSynchronizationRequest requestData, String url, ValueHolder<String> trace) {
        if (CirHelper.cirEnabled((PCIDSSServerExchangeSettings)requestData.getCirSettings()) && requestData.getCirTokenAgencyRef() == null) {
            throw Xeption.forEndUser((String)"sabreProfilesSynchNoCirToken", (Object[])new Object[0]);
        }
        SynchronizationRequest<SabreProfilesSynchronizationRequest> request = new SynchronizationRequest<SabreProfilesSynchronizationRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(requestData);
        request.setOperationId("sabre-profiles-synch");
        request.setUser("syncrobot");
        return SynchronizationHelper.execute(request, url, trace);
    }

    private static void updateCardsFromCir(PCIDSSServerExchangeSettings settings, String agencyToken, Collection<Card> cards) throws ServiceException {
        for (Card card : cards) {
            try {
                CirHelper.updateCard((Card)card, (PCIDSSServerExchangeSettings)settings, (String)agencyToken);
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to synchronize card with CIR", t);
                }
                throw new ServiceException("Unable to synchronize card with CIR", t);
            }
        }
    }

    private static void savePerson(EntityContainer<Person> person, String versionNotes, List<Message> messages) {
        SabreProfilesSynchronizationHelper.saveEntitySafe(person, Messages.SabreProfiles_failedToSavePerson, versionNotes, messages);
    }

    private static void saveOrganization(EntityContainer<Organization> organization, String versionNotes, List<Message> messages) {
        SabreProfilesSynchronizationHelper.saveEntitySafe(organization, Messages.SabreProfiles_failedToSaveOrganization, versionNotes, messages);
    }

    private static void saveEntitySafe(EntityContainer<? extends BaseEntity> entityCont, String errorMessageKey, String versionNotes, List<Message> messages) {
        block2: {
            try {
                SabreProfilesSynchronizationHelper.saveEntity(entityCont, versionNotes);
            }
            catch (StorageException e) {
                if (messages == null) break block2;
                messages.add(MessageHelper.createErrorMessage((String)L10nResourcesManager.getStr((String)errorMessageKey, (Object[])new Object[0]), null, (Object[])new Object[]{entityCont, TextUtil.getExceptionStackTrace((Throwable)e)}));
            }
        }
    }

    private static void saveEntity(EntityContainer<? extends BaseEntity> entityCont, String versionNotes) {
        entityCont.getVersionInfo().setDataSource(DATA_SOURCE);
        entityCont.getVersionInfo().setVersionNotes(versionNotes);
        EntityStorage.get().save(entityCont, true);
    }

    private static List<Integer> calcResultNumbers(int refs, int conts, int numSuccess) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.add(refs);
        res.add(numSuccess);
        res.add(refs - conts);
        res.add(conts - numSuccess);
        return res;
    }

    private static EntityContainer<Organization> resolveOrganizationOrThrowException(EntityReference<Organization> orgRef) throws ServiceException {
        EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)orgCont)) {
            log.error("Failed to resolve organization reference: " + orgRef);
            throw new ServiceException(L10nResourcesManager.createL10nMessage((String)Messages.SabreProfiles_failedToResolveOrganization, (Object[])new Object[]{orgRef}).toString());
        }
        return orgCont;
    }

    private static EntityContainer<Person> resolvePersonOrThrowException(EntityReference<Person> perRef) throws ServiceException {
        EntityContainer perCont = EntityStorage.get().resolve(perRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)perCont)) {
            log.error("Failed to resolve person reference: " + perRef);
            throw new ServiceException(L10nResourcesManager.createL10nMessage((String)Messages.SabreProfiles_failedToResolvePerson, (Object[])new Object[]{perRef}).toString());
        }
        return perCont;
    }

    private static SabreProfilesSynchronizationResult createResult(SynchronizationResponse<SabreProfilesSynchronizationResponse> response, List<Message> additionalMessages) {
        SabreProfilesSynchronizationResponse syncResponse = response.getData();
        SabreProfilesSynchronizationResult result = new SabreProfilesSynchronizationResult();
        if (syncResponse.getResponseType() == SabreProfilesSynchronizationResponseType.SUCCESS) {
            result.setType(SabreProfilesSynchronizationResultType.OK);
        } else if (syncResponse.getResponseType() == SabreProfilesSynchronizationResponseType.WARNING) {
            result.setType(SabreProfilesSynchronizationResultType.WARNING);
        } else {
            result.setType(SabreProfilesSynchronizationResultType.ERROR);
        }
        result.getMessages().addAll(response.getMessages());
        result.getMessages().addAll(additionalMessages);
        return result;
    }

    private static void setSabreProfilesLoadDataNotFoundError(Person person, SabreProfilesPccSettings pccSettings, List<Message> messages) {
        Date currentDate = new Date();
        person.getSabreProfilesUniqueIDs().removeIf(item -> item.getPcc() != null && item.getPcc().equals(pccSettings.getPcc()));
        person.getEmployments().stream().filter(personEmployment -> personEmployment.getClosed() == null || personEmployment.getClosed().after(currentDate)).forEach(personEmployment -> personEmployment.setClosed(currentDate));
        person.setSabreProfilesLastLoadStatus(SabreProfilesLoadStatus.NOT_FOUND_ERROR);
        person.setSabreProfilesLastLoadOperationType(SabreProfileLoadOperationType.DELETE);
        person.setSabreProfilesLastLoadDate(null);
        person.setSabreProfilesLastLoadAttemptDate(currentDate);
        person.getSabreProfilesLoadMessages().addAll(messages);
    }

    private static void logTime(String description, long startTime) {
        SabreProfilesSynchronizationHelper.logTime(description, startTime, null);
    }

    private static void logTime(String description, long startTime, BaseEntity profile) {
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            StringBuilder message = new StringBuilder();
            if (profile != null) {
                message.append(profile);
                message.append(": ");
            }
            message.append(description);
            message.append(" in ");
            message.append(endTime - startTime);
            message.append(" ms");
            log.debug(message.toString());
        }
    }
}

