/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SabreProfileOperationType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.dbproperties.LogicalDBPropertiesStorage;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreProfilesSynchronizationTask
extends BaseScheduledTask {
    private static final transient Logger log = LoggerFactory.getLogger(SabreProfilesSynchronizationTask.class);
    private static final String DB_LAST_SP_SYNC_DATE_KEY = "com.gridnine.xtrip.server.model.synchronization.sabreprofiles.LAST_SP_SYNC_TASK_DATE";
    private static final String DB_LAST_SP_ORG_SYNC_DATE_KEY = "com.gridnine.xtrip.server.model.synchronization.sabreprofiles.LAST_SP_ORGANIZATIONS_SYNC_TASK_DATE";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS a");
    private static final String[] allowableSyncErrors = new String[]{"connection refused", "\u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442"};
    private final LogicalDBPropertiesStorage dbProps = LogicalStorage.get().getDbPropertiesStorage();
    private static final long SYNC_CHANGE_DELTA = 1000L;

    protected void doJob() throws Exception {
        List<Object> perIndexes;
        Date taskStartDate = new Date();
        Date lastPerSyncDate = this.getLastSyncDate();
        Date lastOrgSyncDate = this.getLastOrgSyncDate();
        if (lastOrgSyncDate == null) {
            lastOrgSyncDate = lastPerSyncDate;
        }
        int limit = this.getLimit();
        Date lastOrgIndexDate = null;
        Date lastPerIndexDate = null;
        boolean isOrgsOverLimit = false;
        boolean isPersOverLimit = false;
        List<OrganizationIndex> orgIndexes = this.searchOrgIndexes(lastOrgSyncDate, limit);
        log.info("Organization indexes found: " + orgIndexes.size());
        if (orgIndexes.size() > 0) {
            lastOrgIndexDate = ((OrganizationIndex)CollectionUtil.getLastElement(orgIndexes)).getModified();
            if (orgIndexes.size() >= limit) {
                log.info(String.format("Organization indexes count %s equals to limit %s", orgIndexes.size(), limit));
                isOrgsOverLimit = true;
            }
            orgIndexes = this.filterOrgIndexes(orgIndexes);
            log.info("Organization filtered indexes count: " + orgIndexes.size());
        }
        if (isOrgsOverLimit) {
            perIndexes = Collections.emptyList();
        } else {
            perIndexes = this.searchPerIndexes(lastPerSyncDate, limit - orgIndexes.size());
            log.info("Person indexes found: " + perIndexes.size());
            if (perIndexes.size() > 0) {
                lastPerIndexDate = ((PersonIndex)CollectionUtil.getLastElement(perIndexes)).getModified();
                if (perIndexes.size() >= limit - orgIndexes.size()) {
                    log.info(String.format("Organization and person indexes size %s equals to limit %s", perIndexes.size() + orgIndexes.size(), limit));
                    isPersOverLimit = true;
                }
                perIndexes = this.filterPerIndexes(perIndexes);
                log.info("Person filtered indexes count: " + perIndexes.size());
            }
        }
        if (orgIndexes.isEmpty() && perIndexes.isEmpty()) {
            log.info("No modified organizations and persons found. Task stopped.");
            this.updateDBProperties(isPersOverLimit, isOrgsOverLimit, taskStartDate, lastPerIndexDate, lastOrgIndexDate, lastPerSyncDate);
            return;
        }
        List<EntityReference<Organization>> orgRefs = this.getRefs(orgIndexes);
        List<EntityReference<Person>> perRefs = this.getRefs(perIndexes);
        if (!orgRefs.isEmpty()) {
            log.info("Organizations to sync: " + this.getOrgNames(orgRefs));
        }
        if (!perIndexes.isEmpty()) {
            log.info("Persons to sync: " + this.getPerNames(perIndexes));
        }
        List<SabreProfilesPccSettings> pccSettings = this.getPccSettings();
        if (!orgRefs.isEmpty()) {
            ArrayList<Message> orgErrors = new ArrayList<Message>();
            List<Integer> orgSyncResult = SabreProfilesSynchronizationHelper.validateAndSendFilteredOrganizations(orgRefs, pccSettings, orgErrors);
            log.info(String.format("Synchronization finished for organizations. Total: %d, success: %d, not validated: %d, errors: %d", orgSyncResult.get(0), orgSyncResult.get(1), orgSyncResult.get(2), orgSyncResult.get(3)));
            this.logErrors(orgErrors);
        }
        if (!perRefs.isEmpty()) {
            ArrayList<Message> perErrors = new ArrayList<Message>();
            List<Integer> perSyncResult = SabreProfilesSynchronizationHelper.validateAndSendFilteredPersons(perRefs, pccSettings, perErrors);
            log.info(String.format("Synchronization finished for persons. Total: %d, success: %d, not validated: %d, errors: %d", perSyncResult.get(0), perSyncResult.get(1), perSyncResult.get(2), perSyncResult.get(3)));
            this.logErrors(perErrors);
        }
        this.updateDBProperties(isPersOverLimit, isOrgsOverLimit, taskStartDate, lastPerIndexDate, lastOrgIndexDate, lastPerSyncDate);
    }

    private Date getLastSyncDate() throws ParseException {
        String lastSyncDateStr = this.dbProps.getValue(DB_LAST_SP_SYNC_DATE_KEY);
        log.info("Previous task date: " + lastSyncDateStr);
        if (TextUtil.isBlank((String)lastSyncDateStr)) {
            Calendar cal = Calendar.getInstance();
            cal.add(12, -5);
            return cal.getTime();
        }
        if (lastSyncDateStr.length() == 23) {
            lastSyncDateStr = lastSyncDateStr + " AM";
        }
        return MiscUtil.getBeforeTime((Date)this.sdf.parse(lastSyncDateStr));
    }

    private Date getLastOrgSyncDate() throws ParseException {
        String lastSyncDateStr = this.dbProps.getValue(DB_LAST_SP_ORG_SYNC_DATE_KEY);
        if (TextUtil.isBlank((String)lastSyncDateStr)) {
            return null;
        }
        log.info("Previous task date (for organizations): " + lastSyncDateStr);
        return MiscUtil.getBeforeTime((Date)this.sdf.parse(lastSyncDateStr));
    }

    private List<OrganizationIndex> searchOrgIndexes(Date lastSyncDate, int limit) {
        SearchQuery queryOrg = new SearchQuery();
        queryOrg.getCriteria().getCriterions().add(SearchCriterion.ge((String)"modified", (Object)lastSyncDate));
        queryOrg.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)OrganizationIndex.Property.sabreProfilesLastOperationType.name(), (Object)SabreProfileOperationType.DELETE), SearchCriterion.isNotEmpty((String)OrganizationIndex.Property.sabreProfilesPccUniqueIds.name())}));
        queryOrg.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.notSynchronizeWithSabreProfile.name(), (Object)Boolean.FALSE));
        queryOrg.getCriteria().getOrders().put("modified", SortOrder.ASC);
        queryOrg.getPreferredProperties().add("modified");
        queryOrg.getPreferredProperties().add(OrganizationIndex.Property.dataSource.name());
        queryOrg.getPreferredProperties().add(OrganizationIndex.Property.sabreProfilesLastSyncDate.name());
        queryOrg.getPreferredProperties().add(OrganizationIndex.Property.sabreProfilesLastSyncAttemptDate.name());
        queryOrg.getPreferredProperties().add(OrganizationIndex.Property.sabreProfilesLastSyncStatus.name());
        queryOrg.getPreferredProperties().add(OrganizationIndex.Property.sabreProfilesMessages.name());
        queryOrg.setLimit(limit);
        return EntityStorage.get().search(OrganizationIndex.class, queryOrg).getData();
    }

    private List<PersonIndex> searchPerIndexes(Date lastSyncDate, int limit) {
        SearchQuery queryPer = new SearchQuery();
        queryPer.getCriteria().getCriterions().add(SearchCriterion.ge((String)"modified", (Object)lastSyncDate));
        queryPer.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)PersonIndex.Property.sabreProfilesLastOperationType.name(), (Object)SabreProfileOperationType.DELETE), SearchCriterion.isNotEmpty((String)PersonIndex.Property.sabreProfilesPccUniqueIds.name())}));
        queryPer.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER));
        queryPer.getCriteria().getCriterions().add(SearchCriterion.ne((String)PersonIndex.Property.draftState.name(), (Object)Boolean.TRUE));
        queryPer.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.sabreProfilesHasEmployerSynchronized.name(), (Object)Boolean.TRUE));
        queryPer.getCriteria().getOrders().put("modified", SortOrder.ASC);
        queryPer.getPreferredProperties().add("modified");
        queryPer.getPreferredProperties().add(PersonIndex.Property.dataSource.name());
        queryPer.getPreferredProperties().add(PersonIndex.Property.name.name());
        queryPer.getPreferredProperties().add(PersonIndex.Property.sabreProfilesLastSyncDate.name());
        queryPer.getPreferredProperties().add(PersonIndex.Property.sabreProfilesLastSyncAttemptDate.name());
        queryPer.getPreferredProperties().add(PersonIndex.Property.sabreProfilesLastSyncStatus.name());
        queryPer.getPreferredProperties().add(PersonIndex.Property.sabreProfilesMessages.name());
        queryPer.setLimit(limit);
        return EntityStorage.get().search(PersonIndex.class, queryPer).getData();
    }

    private List<OrganizationIndex> filterOrgIndexes(List<OrganizationIndex> orgIndexes) {
        return orgIndexes.stream().filter(idx -> this.checkIndex(idx.getSabreProfilesLastSyncAttemptDate(), idx.getSabreProfilesLastSyncDate(), idx.getModified(), idx.getSabreProfilesLastSyncStatus(), idx.getSabreProfilesMessages(), idx.getDataSource())).collect(Collectors.toList());
    }

    private List<PersonIndex> filterPerIndexes(List<PersonIndex> perIndexes) {
        return perIndexes.stream().filter(idx -> this.checkIndex(idx.getSabreProfilesLastSyncAttemptDate(), idx.getSabreProfilesLastSyncDate(), idx.getModified(), idx.getSabreProfilesLastSyncStatus(), idx.getSabreProfilesMessages(), idx.getDataSource())).collect(Collectors.toList());
    }

    private boolean checkIndex(Date sabreProfilesLastSyncAttemptDate, Date sabreProfilesLastSyncDate, Date modified, SabreProfilesSynchronizationStatus status, Collection<String> sabreProfilesMessages, String dataSource) {
        if (!"sabre-profiles-sync".equals(dataSource)) {
            Date syncDate;
            Date date = syncDate = sabreProfilesLastSyncAttemptDate != null ? sabreProfilesLastSyncAttemptDate : sabreProfilesLastSyncDate;
            if (syncDate == null || modified.getTime() - syncDate.getTime() > 1000L) {
                return true;
            }
        }
        if (status == SabreProfilesSynchronizationStatus.SYNC_ERROR) {
            return sabreProfilesMessages.stream().filter(Objects::nonNull).anyMatch(message -> {
                for (String error : allowableSyncErrors) {
                    if (!message.contains(error)) continue;
                    return true;
                }
                return false;
            });
        }
        return false;
    }

    private int getLimit() {
        String taskParam = this.getParameter("LIMIT", null);
        int res = 1000;
        if (TextUtil.nonBlank((String)taskParam)) {
            try {
                int tempRes = Integer.parseInt(taskParam);
                if (tempRes > 0) {
                    res = tempRes;
                }
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
        return res;
    }

    private List<SabreProfilesPccSettings> getPccSettings() {
        List globalPccSettings = ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings();
        String taskParam = this.getParameter("PCC", null);
        if (TextUtil.isBlank((String)taskParam)) {
            return globalPccSettings;
        }
        List<String> taskParams = Arrays.asList(taskParam.split(","));
        return globalPccSettings.stream().filter(pccSetting -> taskParams.contains(pccSetting.getPcc())).collect(Collectors.toList());
    }

    private String getOrgNames(List<EntityReference<Organization>> refs) {
        return refs.stream().map(EntityReference::getCaption).collect(Collectors.joining(","));
    }

    private String getPerNames(List<PersonIndex> refs) {
        return refs.stream().map(PersonIndex::getName).collect(Collectors.joining(","));
    }

    private <T extends BaseEntity> List<EntityReference<T>> getRefs(List<? extends EntityIndex<T>> indexes) {
        return indexes.stream().map(EntityIndex::getSource).collect(Collectors.toList());
    }

    private void logErrors(List<Message> errors) {
        errors.stream().filter(Objects::nonNull).map(Message::getMessage).filter(Objects::nonNull).map(L10nMessage::toString).forEach(arg_0 -> ((Logger)log).error(arg_0));
    }

    private void updateDBProperties(boolean isPersOverLimit, boolean isOrgsOverLimit, Date taskStartDate, Date lastPerIndexDate, Date lastOrgIndexDate, Date lastPerSyncDate) {
        if (isPersOverLimit) {
            this.dbProps.putValue(DB_LAST_SP_SYNC_DATE_KEY, this.sdf.format(lastPerIndexDate));
            this.dbProps.putValue(DB_LAST_SP_ORG_SYNC_DATE_KEY, this.sdf.format(taskStartDate));
        } else if (isOrgsOverLimit) {
            this.dbProps.putValue(DB_LAST_SP_SYNC_DATE_KEY, this.sdf.format(lastPerSyncDate));
            this.dbProps.putValue(DB_LAST_SP_ORG_SYNC_DATE_KEY, this.sdf.format(lastOrgIndexDate));
        } else {
            this.dbProps.putValue(DB_LAST_SP_SYNC_DATE_KEY, this.sdf.format(taskStartDate));
            this.dbProps.putValue(DB_LAST_SP_ORG_SYNC_DATE_KEY, null);
        }
    }
}

