/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ContractSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.CostCodesHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.TripartiteContractSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.l10n.Messages;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.CwtOrganizationData;
import com.gridnine.xtrip.common.model.profile.EmploymentInfo;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.ResponsiblePerson;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreProfilesCostCodeType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.model.system.config.RegionalVariation;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesAssociatedProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesDictionaryData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesDiscountData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesPersonInCharge;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesPersonKeyContact;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequestType;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SynchronizationParameters;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.UdidRemark;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SabreProfilesSynchronizationUtil {
    public static final String OPERATION = "sabre-profiles-synch";
    public static final String GET_THERE_ADDITIONAL_PASSPORT_NUMBER = "addl_passport_no";
    public static final String GET_THERE_ADDITIONAL_PASSPORT_EXPIRATION_DATE = "addl_passport_exp";
    public static final String GET_THERE_ADDITIONAL_PASSPORT_COUNTRY = "addl_passport_co";

    public static ScheduledTaskSettings getScheduledTaskSetting() {
        ScheduledTaskSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.enabled.name(), (Object)Boolean.TRUE));
        List indices = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, query).getData();
        if (indices == null) {
            return res;
        }
        for (ScheduledTaskSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !"system-settings-sabre-profiles-synchronization-task".equals(setCont.getUid())) continue;
            res = (ScheduledTaskSettings)setCont.getEntity();
            break;
        }
        return res;
    }

    static SabreProfilesSynchronizationRequest updatePersonRequest(SynchronizationParameters parameters, EntityContainer<Person> perCont, EntityContainer<Organization> orgCont, List<EntityReference<Organization>> workPlaces, EntityReference<Organization> cirTokenAgencyRef) throws Exception {
        SabreProfilesAssociatedProfileData assoc;
        Person person = (Person)XCloneHelper.clone((XCloneable)perCont.getEntity());
        SabreProfilesSynchronizationRequest request = SabreProfilesSynchronizationUtil.createRequest(parameters, orgCont, cirTokenAgencyRef);
        request.setRequestType(SabreProfilesSynchronizationRequestType.UPDATE_PERSON);
        request.setPerson(person);
        if (((Organization)orgCont.getEntity()).getExternalSystem() != null) {
            ArrayList<CostCodeInfo> udidValues = new ArrayList<CostCodeInfo>();
            ProfileSynchronizationUtil.createUdidPersonList((Person)person, (EntityReference)orgCont.toReference(), udidValues);
            CostCodesHelper.addEmptyCostCodesIfNecessary(orgCont, udidValues);
            SabreProfilesSynchronizationUtil.updatePassports(person, udidValues, ((Organization)orgCont.getEntity()).getExternalSystem());
            request.getUdidValues().addAll(udidValues);
        }
        request.setRemarksMap(ProfileSynchronizationUtil.createPersonRemarksMap(perCont, (String)"AAA", (boolean)false));
        request.getDictionaryData().addAllRefs(SabreProfilesSynchronizationUtil.collectDictionaries(person));
        String targetPCC = request.getPcc();
        List<EntityContainer<Organization>> employers = workPlaces.stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).filter(employer -> ProfileSynchronizationUtil.hasSabreProfilesUniqueID((Organization)((Organization)employer.getEntity()), (String)targetPCC)).collect(Collectors.toList());
        Map<EntityContainer<Organization>, Set<Organization>> employerToAgencies = SabreProfilesSynchronizationUtil.getAssociatedAgencies(employers, request.getPcc());
        HashMap<String, String> orgIdToName = new HashMap<String, String>();
        for (EntityContainer<Organization> employer2 : employers) {
            SabreProfilesProfileType profileType = ((Organization)employer2.getEntity()).getTypes().contains(OrganizationType.AGENCY) && !((Organization)employer2.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) ? SabreProfilesProfileType.AGY : SabreProfilesProfileType.CRP;
            SabreProfilesAssociatedProfileData assoc2 = SabreProfilesSynchronizationUtil.getOrganizationAssociatedProfile((Organization)employer2.getEntity(), profileType, false, targetPCC);
            if (assoc2 != null) {
                request.getAssociatedProfiles().add(assoc2);
            }
            ArrayList<PNRBuilderSettings> pnrBuilderSettings = new ArrayList<PNRBuilderSettings>();
            try {
                String employerId = ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)((Organization)employer2.getEntity()), (String)targetPCC);
                orgIdToName.put(employerId, SabreProfilesSynchronizationUtil.getEnglishValue(((Organization)employer2.getEntity()).getShortName()));
                if (employerToAgencies.get(employer2).isEmpty()) {
                    if (profileType == SabreProfilesProfileType.AGY) {
                        pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuilderSettingsForPerson(person.getPnrBuildersSettings(), Collections.emptyList(), ((Organization)employer2.getEntity()).getPnrBuildersSettings(), null, employerId));
                    } else {
                        pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuilderSettingsForPerson(person.getPnrBuildersSettings(), ((Organization)employer2.getEntity()).getPnrBuildersSettings(), Collections.emptyList(), employerId, null));
                    }
                } else {
                    for (Organization ag : employerToAgencies.get(employer2)) {
                        String agencyId = ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)ag, (String)targetPCC);
                        orgIdToName.put(agencyId, SabreProfilesSynchronizationUtil.getEnglishValue(ag.getShortName()));
                        pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuilderSettingsForPerson(person.getPnrBuildersSettings(), ((Organization)employer2.getEntity()).getPnrBuildersSettings(), ag.getPnrBuildersSettings(), employerId, agencyId));
                    }
                }
            }
            catch (Exception e) {
                SabreProfilesSynchronizationHelper.log.error("", (Throwable)e);
            }
            List udidRemarks = ProfileSynchronizationUtil.createUdidPersonList((Person)person, (EntityReference)employer2.toReference(), new ArrayList()).stream().filter(TextUtil::nonBlank).collect(Collectors.toList());
            request.getUdidRemarks().addAll(udidRemarks);
            List udidRemarkValues = udidRemarks.stream().map(udid -> {
                UdidRemark udidRemark = new UdidRemark();
                udidRemark.setValue((String)udid);
                return udidRemark;
            }).collect(Collectors.toList());
            request.getUdidRemarkValues().addAll(udidRemarkValues);
            pnrBuilderSettings.forEach(settings -> udidRemarkValues.forEach(remark -> settings.getUdidRemarks().add(remark.getUid())));
            request.getPnrBuildersSettings().addAll(pnrBuilderSettings);
        }
        EntityContainer retailCont = ProfileHelper.getRetailProfileContainer();
        if (retailCont != null && retailCont.getEntity() != null && ProfileSynchronizationUtil.hasSabreProfilesUniqueID((Organization)((Organization)retailCont.getEntity()), (String)targetPCC) && (assoc = SabreProfilesSynchronizationUtil.getOrganizationAssociatedProfile((Organization)retailCont.getEntity(), ((Organization)retailCont.getEntity()).getTypes().contains(OrganizationType.AGENCY) && !((Organization)retailCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) ? SabreProfilesProfileType.AGY : SabreProfilesProfileType.CRP, true, targetPCC)) != null) {
            request.getAssociatedProfiles().add(assoc);
        }
        SabreProfilesSynchronizationUtil.checkForDuplicateNamesInBuilders(request.getPnrBuildersSettings(), orgIdToName);
        if (employers.size() > 1) {
            for (PNRBuilderSettings pnrBuildersSetting : request.getPnrBuildersSettings()) {
                SabreProfilesSynchronizationUtil.addOrgNameToBuilderName(pnrBuildersSetting, orgIdToName, true, pnrBuildersSetting.getAssociatedOrgUniqueID(), pnrBuildersSetting.getAssociatedAgencyUniqueID());
            }
        }
        SabreProfilesSynchronizationUtil.updateOrganizationData(request, employerToAgencies);
        SabreProfilesSynchronizationUtil.updateAssociatedProfiles(request);
        return request;
    }

    static SabreProfilesSynchronizationRequest updateOrganizationRequest(SynchronizationParameters parameters, EntityContainer<Organization> orgCont, EntityReference<Organization> cirTokenAgencyRef) {
        SabreProfilesSynchronizationRequest request = SabreProfilesSynchronizationUtil.createRequest(parameters, orgCont, cirTokenAgencyRef);
        request.setRequestType(SabreProfilesSynchronizationRequestType.UPDATE_ORGANIZATION);
        Map<EntityContainer<Organization>, Set<Organization>> agencies = ((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) ? SabreProfilesSynchronizationUtil.getAssociatedAgencies(Collections.singletonList(orgCont), request.getPcc()) : Collections.emptyMap();
        request.getAccountManagerRemarks().addAll(ProfileSynchronizationUtil.createAccountManagersList((List)((Organization)orgCont.getEntity()).getMetadata()));
        List udidRemarks = ProfileSynchronizationUtil.createUdidList((Organization)((Organization)orgCont.getEntity()), (EntityReference)orgCont.toReference());
        request.getUdidRemarks().addAll(udidRemarks);
        List udidRemarkValues = udidRemarks.stream().map(udid -> {
            UdidRemark udidRemark = new UdidRemark();
            udidRemark.setValue((String)udid);
            return udidRemark;
        }).collect(Collectors.toList());
        request.getUdidRemarkValues().addAll(udidRemarkValues);
        request.getDiscountsData().addAll(SabreProfilesSynchronizationUtil.createTripartiteDiscountList(orgCont));
        ArrayList messages = new ArrayList();
        request.setRemarksMap(ProfileSynchronizationUtil.createOrganizationRemarksMap(orgCont, (String)"AAA", (boolean)true, messages));
        ((Organization)orgCont.getEntity()).getSabreProfilesMessages().addAll(messages);
        ArrayList<MiscUtil.Pair<RuleTarget, String>> transactionFeesForGeneralInfoSection = new ArrayList<MiscUtil.Pair<RuleTarget, String>>();
        request.setContractRemarksMap(ContractSynchronizationUtil.createContractList((EntityReference)orgCont.toReference(), transactionFeesForGeneralInfoSection));
        request.getTransactionFeesForGeneralInfoSection().addAll(SabreProfilesSynchronizationUtil.convertPairs2TransactionFeeGeneralRemark(transactionFeesForGeneralInfoSection));
        HashMap<String, String> orgIdToName = new HashMap<String, String>();
        request.getPaymentsRemarks().addAll(ProfileSynchronizationUtil.createPaymentList((List)((Organization)orgCont.getEntity()).getPayers(), (EntityReference)orgCont.toReference()));
        ArrayList<PNRBuilderSettings> pnrBuilderSettings = new ArrayList<PNRBuilderSettings>();
        if (((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.AGENCY) && !((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuildersSettingsForAgency(((Organization)orgCont.getEntity()).getPnrBuildersSettings()));
        } else if (((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            try {
                if (!((Set)agencies.get(orgCont)).isEmpty()) {
                    for (Organization ag : (Set)agencies.get(orgCont)) {
                        String organizationId = ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)ag, (String)request.getPcc());
                        pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuilderSettingsForOrganization(((Organization)orgCont.getEntity()).getPnrBuildersSettings(), ag.getPnrBuildersSettings(), organizationId));
                        orgIdToName.put(organizationId, SabreProfilesSynchronizationUtil.getEnglishValue(ag.getShortName()));
                    }
                } else {
                    pnrBuilderSettings.addAll(SabreProfilesSynchronizationUtil.getPNRBuilderSettingsForOrganization(((Organization)orgCont.getEntity()).getPnrBuildersSettings(), Collections.emptyList(), null));
                }
            }
            catch (Exception e) {
                SabreProfilesSynchronizationHelper.log.error("", (Throwable)e);
            }
        }
        pnrBuilderSettings.forEach(settings -> udidRemarkValues.forEach(remark -> settings.getUdidRemarks().add(remark.getUid())));
        request.getPnrBuildersSettings().addAll(pnrBuilderSettings);
        SabreProfilesSynchronizationUtil.updateOrganizationData(request, agencies);
        return request;
    }

    private static SabreProfilesSynchronizationRequest createRequest(SynchronizationParameters parameters, EntityContainer<Organization> organizationCtr, EntityReference<Organization> cirTokenAgencyRef) {
        SabreProfilesSynchronizationRequest request = new SabreProfilesSynchronizationRequest();
        request.setPcc(parameters.getPcc());
        request.setPassword(parameters.getPassword());
        request.setCurrentUser(UserData.get().getCurrentUser());
        request.setOrganization((Organization)organizationCtr.getEntity());
        request.getPersonsInCharge().addAll(SabreProfilesSynchronizationUtil.getPersonsInCharge((Organization)organizationCtr.getEntity()));
        request.getKeyContacts().addAll(SabreProfilesSynchronizationUtil.getKeyContacts((Organization)organizationCtr.getEntity()));
        request.setCirSettings(CirHelper.getSettings());
        request.setCirTokenAgencyRef(cirTokenAgencyRef);
        request.setDictionaryData(new SabreProfilesDictionaryData());
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (settings != null) {
            request.setLoadProfilesEnabled(settings.isLoadActive());
            request.getISuiteCostCodesSettings().addAll(settings.getISuiteCostCodesSettings());
        }
        return request;
    }

    private static Map<EntityContainer<Organization>, Set<Organization>> getAssociatedAgencies(List<EntityContainer<Organization>> organizations, String pcc) {
        Map<EntityContainer<Organization>, Set<Organization>> result = SabreProfilesSynchronizationUtil.mapAgencies2OrgsByContracts(organizations);
        Organization defaultAgency = SabreProfilesSynchronizationUtil.getDefaultAgencyForPcc(pcc);
        if (defaultAgency != null) {
            result.values().stream().filter(Collection::isEmpty).forEach(v -> v.add(defaultAgency));
        }
        return result;
    }

    private static Organization getDefaultAgencyForPcc(String pcc) {
        EntityContainer defaultAgencyCont = EntityStorageHelper.resolve((EntityReference)ProfileDao.findMainAgency((String)pcc, org -> ProfileSynchronizationUtil.hasSabreProfilesUniqueID((Organization)org, (String)pcc)));
        if (EntityStorageHelper.isEmpty((EntityContainer)defaultAgencyCont)) {
            return null;
        }
        return (Organization)defaultAgencyCont.getEntity();
    }

    private static void updateOrganizationData(SabreProfilesSynchronizationRequest request, Map<EntityContainer<Organization>, Set<Organization>> agencies) {
        boolean hasAgencyWithCWTScheme = false;
        Set assocAgencies = agencies.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (Organization agency : assocAgencies) {
            SabreProfilesAssociatedProfileData agencyAssocData = SabreProfilesSynchronizationUtil.getOrganizationAssociatedProfile(agency, SabreProfilesProfileType.AGY, false, request.getPcc());
            if (agencyAssocData == null) continue;
            agencyAssocData.setSabreProfilesCTP(agency.getSabreProfileCTP());
            request.getAssociatedProfiles().add(agencyAssocData);
            if (agency.getCwtProfileData() == null || !agency.getCwtProfileData().isUseCwtPassiveSegmentScheme()) continue;
            hasAgencyWithCWTScheme = true;
        }
        if (hasAgencyWithCWTScheme) {
            CwtOrganizationData cwtData = request.getOrganization().getCwtProfileData();
            if (cwtData == null) {
                cwtData = new CwtOrganizationData();
                request.getOrganization().setCwtProfileData(cwtData);
            }
            cwtData.setUseCwtPassiveSegmentScheme(true);
        }
    }

    static void updateAssociatedProfiles(SabreProfilesSynchronizationRequest request) {
        List<PNRBuilderSettings> pnrBuildersSettings = request.getPnrBuildersSettings();
        if (pnrBuildersSettings.isEmpty()) {
            return;
        }
        request.getAssociatedProfiles().removeIf(profile -> pnrBuildersSettings.stream().noneMatch(settings -> SabreProfilesSynchronizationUtil.acceptProfile(profile, settings)));
    }

    public static boolean acceptProfile(SabreProfilesAssociatedProfileData profile, PNRBuilderSettings filterSettings) {
        if (filterSettings.isAssociateWithAgency() && (OrganizationType.CORPORATE_CLIENT.name().equals(filterSettings.getApplicableTo()) || PersonType.PASSENGER.name().equals(filterSettings.getApplicableTo())) && SabreProfilesProfileType.AGY == profile.getProfileType() && TextUtil.isSame((String)filterSettings.getAssociatedAgencyUniqueID(), (String)profile.getUniqueID())) {
            return true;
        }
        if (filterSettings.isAssociateWithOrganization() && PersonType.PASSENGER.name().equals(filterSettings.getApplicableTo()) && SabreProfilesProfileType.CRP == profile.getProfileType() && TextUtil.isSame((String)filterSettings.getAssociatedOrgUniqueID(), (String)profile.getUniqueID()) && !profile.isRetailClient()) {
            return true;
        }
        return filterSettings.isAssociateWithRetailClient() && PersonType.PASSENGER.name().equals(filterSettings.getApplicableTo()) && SabreProfilesProfileType.CRP == profile.getProfileType() && profile.isRetailClient();
    }

    private static List<SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark> convertPairs2TransactionFeeGeneralRemark(List<MiscUtil.Pair<RuleTarget, String>> transactionFeesForGeneralInfoSection) {
        ArrayList<SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark> res = new ArrayList<SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark>();
        for (MiscUtil.Pair<RuleTarget, String> pair : transactionFeesForGeneralInfoSection) {
            SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark remark = new SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark();
            remark.setTarget(((RuleTarget)pair.getFirst()).getId());
            remark.setRemark((String)pair.getSecond());
            res.add(remark);
        }
        return res;
    }

    private static List<SabreProfilesDiscountData> createTripartiteDiscountList(EntityContainer<Organization> orgRef) {
        ArrayList<SabreProfilesDiscountData> res = new ArrayList<SabreProfilesDiscountData>();
        List tripartiteContracts = TripartiteContractSynchronizationUtil.findTripartiteContracts((EntityReference)orgRef.toReference(), (TripartiteContractType)TripartiteContractType.AVIA);
        Date today = new Date();
        for (TripartiteContract tripartiteContract : tripartiteContracts) {
            for (DictionaryReference airline : tripartiteContract.getAviaVendorData().getAirlines()) {
                String airlineCode = DictHelper.getCodeVariant((DictionaryReference)airline, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA});
                if (TextUtil.isBlank((String)airlineCode) || airlineCode.length() > 2) continue;
                for (RuleSettings rule : tripartiteContract.getRuleSet().getRules()) {
                    for (RuleResult result : rule.getResults()) {
                        SabreProfilesDiscountData.AirPreferencesDiscountType type;
                        if (!MiscUtil.isBetween((Date)rule.getPeriodBegin(), (Date)rule.getPeriodEnd(), (Date)today)) continue;
                        if (AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE == result.getAction()) {
                            type = SabreProfilesDiscountData.AirPreferencesDiscountType.DIS;
                        } else if (AviaTripartiteContractActions.AVIA_CORPORATE_ID == result.getAction()) {
                            type = SabreProfilesDiscountData.AirPreferencesDiscountType.CNT;
                        } else {
                            if (AviaTripartiteContractActions.AVIA_TOUR_CODE != result.getAction()) continue;
                            type = SabreProfilesDiscountData.AirPreferencesDiscountType.TRC;
                        }
                        List bonusCodes = (List)result.getValue();
                        if (bonusCodes == null) continue;
                        for (String bonusCode : bonusCodes) {
                            if (TextUtil.isBlank((String)bonusCode)) continue;
                            SabreProfilesDiscountData data = new SabreProfilesDiscountData();
                            data.setVendorCode(airlineCode);
                            data.setDiscountCode(bonusCode);
                            data.setDiscountType(type);
                            data.setEffectiveDate(rule.getPeriodBegin());
                            data.setExpiryDate(rule.getPeriodEnd());
                            if (type == SabreProfilesDiscountData.AirPreferencesDiscountType.TRC) {
                                data.setInformationText("U" + (String)ProfileSynchronizationConstants.CalculatiionIndicator2String.get(TripartiteContractSynchronizationUtil.getCalculationIndicator((TripartiteContract)tripartiteContract, (String)bonusCode)) + "*");
                            }
                            res.add(data);
                        }
                    }
                }
            }
        }
        return res;
    }

    private static Map<EntityContainer<Organization>, Set<Organization>> mapAgencies2OrgsByContracts(List<EntityContainer<Organization>> orgs) {
        HashMap<EntityContainer<Organization>, Set<Organization>> res = new HashMap<EntityContainer<Organization>, Set<Organization>>();
        for (EntityContainer<Organization> org : orgs) {
            res.put(org, new HashSet());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)org.toReference()));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)new Date())}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)new Date())}));
            List indices = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
            for (ContractCustomerIndex ind : indices) {
                EntityContainer agencyCont;
                if (ind.getSupplier() == null || (agencyCont = EntityStorage.get().resolve(ind.getSupplier())) == null || agencyCont.getEntity() == null) continue;
                ((Set)res.get(org)).add(agencyCont.getEntity());
            }
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)TripartiteContractType.AVIA));
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)org.getUid()));
            List tripCtrIndices = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
            for (TripartiteContractIndex tci : tripCtrIndices) {
                EntityReference tcRef = tci.getSource();
                EntityContainer tcCont = EntityStorage.get().resolve(tcRef);
                if (tcCont == null) continue;
                TripartiteContract tc = (TripartiteContract)tcCont.getEntity();
                for (TripartiteContractCustomerInfo tcci : tc.getCustomers()) {
                    EntityContainer agencyCont;
                    if (tcci.getCustomer() == null || !tcci.getCustomer().equals((Object)org.toReference()) || tcci.getStartDate() != null && !tcci.getStartDate().before(new Date()) || tcci.getEndDate() != null && !tcci.getEndDate().after(new Date()) || (agencyCont = EntityStorage.get().resolve(tc.getAgency())) == null || agencyCont.getEntity() == null) continue;
                    ((Set)res.get(org)).add(agencyCont.getEntity());
                }
            }
        }
        return res;
    }

    private static void checkForDuplicateNamesInBuilders(List<PNRBuilderSettings> pnrBuildersSettings, Map<String, String> orgIdToName) {
        HashMap<String, PNRBuilderSettings> filterNames = new HashMap<String, PNRBuilderSettings>();
        ArrayList<String> namesToDetalize = new ArrayList<String>();
        for (PNRBuilderSettings set : pnrBuildersSettings) {
            if (!filterNames.containsKey(set.getName())) {
                filterNames.put(set.getName(), set);
                continue;
            }
            namesToDetalize.add(set.getName());
        }
        Iterator<PNRBuilderSettings> iter = pnrBuildersSettings.iterator();
        while (iter.hasNext()) {
            PNRBuilderSettings cur = iter.next();
            PNRBuilderSettings other = (PNRBuilderSettings)filterNames.get(cur.getName());
            if (!namesToDetalize.contains(cur.getName()) || !SabreProfilesSynchronizationUtil.isEqualButNotTheSame(cur, other)) continue;
            namesToDetalize.remove(cur.getName());
            iter.remove();
        }
        for (PNRBuilderSettings set : pnrBuildersSettings) {
            if (!namesToDetalize.contains(set.getName()) || set.getAssociatedOrgUniqueID() == null) continue;
            SabreProfilesSynchronizationUtil.addOrgNameToBuilderName(set, orgIdToName, false, set.getAssociatedOrgUniqueID());
        }
        filterNames.clear();
        namesToDetalize.clear();
        for (PNRBuilderSettings set : pnrBuildersSettings) {
            if (!filterNames.containsKey(set.getName())) {
                filterNames.put(set.getName(), set);
                continue;
            }
            namesToDetalize.add(set.getName());
        }
        for (PNRBuilderSettings set : pnrBuildersSettings) {
            if (!namesToDetalize.contains(set.getName()) || set.getAssociatedAgencyUniqueID() == null) continue;
            SabreProfilesSynchronizationUtil.addOrgNameToBuilderName(set, orgIdToName, false, set.getAssociatedAgencyUniqueID());
        }
    }

    private static void addOrgNameToBuilderName(PNRBuilderSettings settings, Map<String, String> orgIdToName, boolean checkPresence, String ... orgIds) {
        for (String orgId : orgIds) {
            if (orgId == null) continue;
            String orgName = orgIdToName.get(orgId);
            if (!checkPresence || settings.getName() == null || !settings.getName().contains(orgName)) {
                settings.setName(settings.getName() + "-" + orgIdToName.get(orgId));
            }
            return;
        }
    }

    private static boolean isEqualButNotTheSame(PNRBuilderSettings cur, PNRBuilderSettings other) {
        if (TextUtil.isSame((String)cur.getUid(), (String)other.getUid())) {
            return false;
        }
        if (cur.isAssociateWithOrganization() || other.isAssociateWithOrganization()) {
            return false;
        }
        return cur.isAssociateWithAgency() == other.isAssociateWithAgency() && cur.isAssociateWithRetailClient() == other.isAssociateWithRetailClient() && cur.isNeedAddresses() == other.isNeedAddresses() && cur.isNeedAllRemarks() == other.isNeedAllRemarks() && cur.isNeedCID() == other.isNeedCID() && cur.isNeedDeliveryAddresses() == other.isNeedDeliveryAddresses() && cur.isNeedDK() == other.isNeedDK() && cur.isNeedDOCS() == other.isNeedDOCS() && cur.isNeedEmails() == other.isNeedEmails() && cur.isNeedFrequentFlyer() == other.isNeedFrequentFlyer() && cur.isNeedNoRemarks() == other.isNeedNoRemarks() && cur.isNeedOnlyAlwaysMoveRemarks() == other.isNeedOnlyAlwaysMoveRemarks() && cur.isNeedPayers() == other.isNeedPayers() && cur.isNeedPhones() == other.isNeedPhones() && cur.isNeedCreditCards() == other.isNeedCreditCards() && cur.isNeedTravelerName() == other.isNeedTravelerName() && TextUtil.isSame((String)cur.getApplicableTo(), (String)other.getApplicableTo(), (boolean)true) && TextUtil.isSame((String)cur.getName(), (String)other.getName(), (boolean)true) && TextUtil.isSame((String)cur.getType(), (String)other.getType(), (boolean)true);
    }

    private static List<PNRBuilderSettings> getPNRBuildersSettingsForAgency(List<PNRBuilderSettings> pnrBuildersSettings) {
        ArrayList<PNRBuilderSettings> res = new ArrayList<PNRBuilderSettings>();
        for (PNRBuilderSettings set : pnrBuildersSettings) {
            if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !OrganizationType.AGENCY.name().equals(set.getApplicableTo())) continue;
            res.add(set);
        }
        return res;
    }

    private static List<PNRBuilderSettings> getPNRBuilderSettingsForOrganization(List<PNRBuilderSettings> pnrBuildersSettingsFromOrganization, List<PNRBuilderSettings> pnrBuildersSettingsFromAgency, String agUniqueID) throws Exception {
        PNRBuilderSettings newSettings;
        ArrayList<PNRBuilderSettings> res = new ArrayList<PNRBuilderSettings>();
        for (PNRBuilderSettings set : pnrBuildersSettingsFromOrganization) {
            if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !OrganizationType.CORPORATE_CLIENT.name().equals(set.getApplicableTo())) continue;
            newSettings = (PNRBuilderSettings)XCloneHelper.clone((XCloneable)set, (boolean)true);
            newSettings.setAssociatedAgencyUniqueID(agUniqueID);
            res.add(newSettings);
        }
        if (res.isEmpty()) {
            for (PNRBuilderSettings set : pnrBuildersSettingsFromAgency) {
                if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !OrganizationType.CORPORATE_CLIENT.name().equals(set.getApplicableTo())) continue;
                newSettings = (PNRBuilderSettings)XCloneHelper.clone((XCloneable)set, (boolean)true);
                newSettings.setAssociatedAgencyUniqueID(agUniqueID);
                res.add(newSettings);
            }
        }
        return res;
    }

    private static List<PNRBuilderSettings> getPNRBuilderSettingsForPerson(List<PNRBuilderSettings> pnrBuildersSettingsFromPerson, List<PNRBuilderSettings> pnrBuildersSettingsFromOrganization, List<PNRBuilderSettings> pnrBuildersSettingsFromAgency, String orgUniqueID, String agUniqueID) throws Exception {
        PNRBuilderSettings newSettings;
        ArrayList<PNRBuilderSettings> res = new ArrayList<PNRBuilderSettings>();
        for (PNRBuilderSettings set : pnrBuildersSettingsFromPerson) {
            if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !PersonType.PASSENGER.name().equals(set.getApplicableTo())) continue;
            newSettings = (PNRBuilderSettings)XCloneHelper.clone((XCloneable)set, (boolean)true);
            newSettings.setAssociatedOrgUniqueID(orgUniqueID);
            newSettings.setAssociatedAgencyUniqueID(agUniqueID);
            res.add(newSettings);
        }
        if (res.isEmpty()) {
            for (PNRBuilderSettings set : pnrBuildersSettingsFromOrganization) {
                if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !PersonType.PASSENGER.name().equals(set.getApplicableTo())) continue;
                newSettings = (PNRBuilderSettings)XCloneHelper.clone((XCloneable)set, (boolean)true);
                newSettings.setAssociatedOrgUniqueID(orgUniqueID);
                newSettings.setAssociatedAgencyUniqueID(agUniqueID);
                res.add(newSettings);
            }
        }
        if (res.isEmpty()) {
            for (PNRBuilderSettings set : pnrBuildersSettingsFromAgency) {
                if (SabreProfilesSynchronizationUtil.isEmptyPNRBuilderSettings(set) || !PersonType.PASSENGER.name().equals(set.getApplicableTo())) continue;
                newSettings = (PNRBuilderSettings)XCloneHelper.clone((XCloneable)set, (boolean)true);
                newSettings.setAssociatedOrgUniqueID(orgUniqueID);
                newSettings.setAssociatedAgencyUniqueID(agUniqueID);
                res.add(newSettings);
            }
        }
        return res;
    }

    private static List<DictionaryReference<? extends BaseDictionary>> collectDictionaries(Person person) {
        ArrayList<DictionaryReference<? extends BaseDictionary>> res = new ArrayList<DictionaryReference<? extends BaseDictionary>>();
        person.getAirlineBonusCards().stream().map(AirlineBonusCard::getAirline).filter(Objects::nonNull).distinct().forEach(res::add);
        return res;
    }

    private static List<BaseDictionary> collectDictionaries(Organization organization) {
        ArrayList<BaseDictionary> res = new ArrayList<BaseDictionary>();
        return res;
    }

    private static boolean isEmptyPNRBuilderSettings(PNRBuilderSettings sett) {
        return sett == null || TextUtil.isBlank((String)sett.getApplicableTo()) || TextUtil.isBlank((String)sett.getType()) || TextUtil.isBlank((String)sett.getName());
    }

    private static SabreProfilesAssociatedProfileData getOrganizationAssociatedProfile(Organization org, SabreProfilesProfileType profileType, boolean isRetailClient, String targetPCC) {
        SabreProfilesAssociatedProfileData assoc = null;
        if (org != null && ProfileSynchronizationUtil.hasSabreProfilesUniqueID((Organization)org, (String)targetPCC) && (org.getSabreProfilesPccSettings().isEmpty() || org.getSabreProfilesPccSettings().stream().anyMatch(settings -> TextUtil.equals((String)targetPCC, (String)settings.getPcc(), (boolean)false))) && !org.isNotSynchronizeWithSabreProfile()) {
            List orgPcc = org.getSabreProfilesUniqueIDs().stream().map(SabreProfilesUniqueIDSettings::getPcc).filter(TextUtil::nonBlank).collect(Collectors.toList());
            assoc = new SabreProfilesAssociatedProfileData();
            assoc.setName(SabreProfilesSynchronizationUtil.getEnglishValue(org.getShortName()));
            assoc.setDescription(SabreProfilesSynchronizationUtil.getEnglishValue(org.getFullName()));
            assoc.setUniqueID(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)targetPCC));
            assoc.setProfileType(profileType);
            assoc.getPnrBuilders().addAll(org.getPnrBuildersFromSabreProfile().stream().filter(item -> item.getBuilderUniqueIDs().stream().map(SabreProfilesUniqueIDSettings::getPcc).anyMatch(orgPcc::contains)).collect(Collectors.toList()));
            assoc.setRetailClient(isRetailClient);
        }
        return assoc;
    }

    private static List<SabreProfilesPersonKeyContact> getKeyContacts(Organization org) {
        ArrayList<SabreProfilesPersonKeyContact> res = new ArrayList<SabreProfilesPersonKeyContact>();
        if (org == null) {
            return res;
        }
        for (ProfileKeyContactPerson p : org.getKeyContacts()) {
            SabreProfilesPersonKeyContact contact = new SabreProfilesPersonKeyContact();
            EntityContainer perCont = EntityStorage.get().resolve(p.getPerson());
            if (perCont == null || perCont.getEntity() == null) continue;
            Person per = (Person)perCont.getEntity();
            contact.setFirstName(L10nStringHelper.getEnglishValue((L10nString)per.getFirstName()));
            contact.setLastName(L10nStringHelper.getEnglishValue((L10nString)per.getLastName()));
            for (Communication c : per.getCommunications()) {
                if (c == null || TextUtil.isBlank((String)c.getSense())) continue;
                if (contact.getEmail() == null && c.getType() == CommunicationType.EMAIL) {
                    contact.setEmail(c.getSense());
                }
                if ((contact.getPhone() != null || c.getType() != CommunicationType.MOBILE) && c.getType() != CommunicationType.WORK_PHONE) continue;
                contact.setPhone(ProfileHelper.buildFullPhoneNumber((Communication)c));
            }
            contact.setEmailType(p.getEmailType());
            contact.setPhoneType(CommunicationType.MOBILE);
            contact.setPosition(SabreProfilesSynchronizationUtil.getPositionString(org.getUid(), per.getEmployments()));
            res.add(contact);
        }
        return res;
    }

    private static String getPositionString(String orgUid, List<PersonEmployment> employments) {
        for (PersonEmployment pe : employments) {
            String employerUid;
            EntityContainer orgCont = EntityStorage.get().resolve(pe.getOrganization());
            String string = employerUid = orgCont != null && orgCont.getEntity() != null ? ((Organization)orgCont.getEntity()).getUid() : null;
            if (pe.getOrganization() == null || !TextUtil.isSame((String)employerUid, (String)orgUid) || pe.getPosition() == null) continue;
            return pe.getPosition().getCaption();
        }
        return null;
    }

    private static List<SabreProfilesPersonInCharge> getPersonsInCharge(Organization org) {
        ArrayList<SabreProfilesPersonInCharge> res = new ArrayList<SabreProfilesPersonInCharge>();
        if (org == null) {
            return res;
        }
        for (ResponsiblePerson responsiblePerson : org.getResponsiblePersons()) {
            EntityContainer perCont = EntityStorage.get().resolve(responsiblePerson.getPerson());
            if (perCont == null || perCont.getEntity() == null) continue;
            Person per = (Person)perCont.getEntity();
            SabreProfilesPersonInCharge personInCharge = new SabreProfilesPersonInCharge();
            personInCharge.setFirstName(L10nStringHelper.getEnglishValue((L10nString)per.getFirstName()));
            personInCharge.setLastName(L10nStringHelper.getEnglishValue((L10nString)per.getLastName()));
            if (per.getTitle() != null) {
                personInCharge.setTitle(per.getTitle().toString());
            } else if (per.getGender() != null && per.getGender().equals((Object)Gender.MALE)) {
                personInCharge.setTitle("Mr");
            } else if (per.getGender() != null && per.getGender().equals((Object)Gender.FEMALE)) {
                personInCharge.setTitle("Mrs");
            } else {
                personInCharge.setTitle(" ");
            }
            personInCharge.setPosition(SabreProfilesSynchronizationUtil.getPositionString(org.getUid(), per.getEmployments()));
            res.add(personInCharge);
        }
        return res;
    }

    static SynchronizationParameters getSynchronizationParameters(SabreProfilesPccSettings pccAndPassword, List<Message> messages) {
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (settings == null) {
            SabreProfilesSynchronizationHelper.log.error("No settings found for synchronizing profiles to Sabre Profiles");
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)"SabreProfilesConnectionSettings_settingsNotFound", (Object[])new Object[0]), (Object[])new Object[0]));
            return null;
        }
        String serverUrl = settings.getServerURL();
        if (TextUtil.isBlank((String)serverUrl)) {
            SabreProfilesSynchronizationHelper.log.error("Server URL is not set for Sabre Profiles synchronization settings");
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)"SabreProfilesConnectionSettings_serverURLNotFound", (Object[])new Object[0]), (Object[])new Object[0]));
            return null;
        }
        String pcc = pccAndPassword.getPcc();
        if (TextUtil.isBlank((String)pcc)) {
            SabreProfilesSynchronizationHelper.log.error("PCC is not set for Sabre Profiles synchronization settings");
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)"SabreProfilesConnectionSettings_pccNotFound", (Object[])new Object[0]), (Object[])new Object[0]));
            return null;
        }
        String password = pccAndPassword.getPassword();
        if (TextUtil.isBlank((String)password)) {
            SabreProfilesSynchronizationHelper.log.error("Password is not set for Sabre Profiles synchronization settings");
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)"SabreProfilesConnectionSettings_passwordNotFound", (Object[])new Object[0]), (Object[])new Object[0]));
            return null;
        }
        return new SynchronizationParameters(serverUrl, pcc, password);
    }

    public static String getEnglishValue(L10nString str) {
        if (str == null || str.getValues().size() == 0) {
            return null;
        }
        if (str.getValues().containsKey(LocaleUtil.LOCALE_EN)) {
            return (String)str.getValues().get(LocaleUtil.LOCALE_EN);
        }
        if (str.getValues().containsKey(null)) {
            return (String)str.getValues().get(null);
        }
        return (String)str.getValues().values().iterator().next();
    }

    static void updateLoadedNewPerson(Person person, String pcc, String uniqueId, String profileName, List<SabreProfilesAssociatedProfileData> associatedProfiles, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo, List<Message> messages) {
        person.getTypes().clear();
        person.getTypes().add(PersonType.PASSENGER);
        ProfileSynchronizationUtil.setSabreProfilesUniqueID((Person)person, (String)pcc, (String)uniqueId);
        ProfileSynchronizationUtil.setSabreProfilesProfileName((Person)person, (String)pcc, (String)profileName);
        person.getEmployments().clear();
        person.getEmployments().addAll(SabreProfilesSynchronizationUtil.parseEmployments(associatedProfiles, employmentInfo, messages));
        person.getCostCodes().clear();
        SabreProfilesSynchronizationUtil.mergeCostCodes(person, udidValues, messages);
        SabreProfilesSynchronizationUtil.updateDictionaryReferences(person, messages);
        person.getPassports().forEach(SabreProfilesSynchronizationUtil::updateNewPassport);
        SabreProfilesSynchronizationUtil.parseAdditionalPassport(person, person, udidValues, messages);
        person.setLoadedFromSabreProfiles(true);
    }

    static void updateLoadedExistPerson(Person existPerson, Person loadedPerson, String pcc, String profileName, List<SabreProfilesAssociatedProfileData> associatedProfiles, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo, PCIDSSServerExchangeSettings cirSettings, String cirToken, List<Message> messages) {
        ProfileSynchronizationUtil.setSabreProfilesProfileName((Person)existPerson, (String)pcc, (String)profileName);
        SabreProfilesSynchronizationUtil.updateDictionaryReferences(loadedPerson, messages);
        if (loadedPerson.getTitle() != existPerson.getTitle()) {
            existPerson.setTitle(loadedPerson.getTitle());
        }
        SabreProfilesSynchronizationUtil.replaceEnglishValue(loadedPerson.getLastName(), existPerson.getLastName(), true, 29, null);
        SabreProfilesSynchronizationUtil.replaceEnglishValue(loadedPerson.getMiddleName(), existPerson.getMiddleName(), true, null, 1);
        SabreProfilesSynchronizationUtil.parseFirstAndSecondNameNames(existPerson, loadedPerson.getFirstName());
        existPerson.setBirthday(loadedPerson.getBirthday());
        existPerson.setGender(loadedPerson.getGender());
        if (loadedPerson.getResourceIdForGetThere() != null) {
            existPerson.setResourceIdForGetThere(loadedPerson.getResourceIdForGetThere());
        }
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getEmployments(), SabreProfilesSynchronizationUtil.parseEmployments(associatedProfiles, employmentInfo, messages), (first, second) -> MiscUtil.equals((Object)first.getOrganization(), (Object)second.getOrganization()), SabreProfilesSynchronizationUtil::mergeEmployments);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getCommunications(), loadedPerson.getCommunications(), (first, second) -> TextUtil.isSame((String)first.getSense(), (String)second.getSense()), SabreProfilesSynchronizationUtil::mergeCommunication, SabreProfilesSynchronizationUtil::remainCommunication);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getAddresses(), loadedPerson.getAddresses(), SabreProfilesSynchronizationUtil::isSame, SabreProfilesSynchronizationUtil::mergeAddresses, SabreProfilesSynchronizationUtil::remainAddress);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getSabrePhoneContacts(), loadedPerson.getSabrePhoneContacts(), (first, second) -> TextUtil.isSame((String)ProfileSynchronizationUtil.getFullNumber((SabreContactPhone)first), (String)ProfileSynchronizationUtil.getFullNumber((SabreContactPhone)second)), SabreProfilesSynchronizationUtil::mergeSabreContactPhone);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getSabreEmailContacts(), loadedPerson.getSabreEmailContacts(), (first, second) -> TextUtil.isSame((String)first.getSense(), (String)second.getSense()), SabreProfilesSynchronizationUtil::mergeSabreContactEmail);
        loadedPerson.getPassports().forEach(SabreProfilesSynchronizationUtil::updateNewPassport);
        SabreProfilesSynchronizationUtil.parseAdditionalPassport(existPerson, loadedPerson, udidValues, messages);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getPassports(), loadedPerson.getPassports(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergePassport);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getVisas(), loadedPerson.getVisas(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergeVisa);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getAirlineBonusCards(), loadedPerson.getAirlineBonusCards(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergeAirlineBonusCard);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getHotelBonusCards(), loadedPerson.getHotelBonusCards(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergeHotelBonusCard);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getCarBonusCards(), loadedPerson.getCarBonusCards(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergeCarBonusCard);
        SabreProfilesSynchronizationUtil.mergeCollection(existPerson.getRailwayBonusCards(), loadedPerson.getRailwayBonusCards(), (first, second) -> TextUtil.isSame((String)first.getNumber(), (String)second.getNumber()), SabreProfilesSynchronizationUtil::mergeRailwayBonusCard);
        existPerson.setSabreProfileCTP(loadedPerson.getSabreProfileCTP());
        SabreProfilesSynchronizationUtil.mergeCostCodes(existPerson, udidValues, messages);
        SabreProfilesSynchronizationUtil.updateCostCodes(existPerson);
        SabreProfilesSynchronizationUtil.updateCards(existPerson, loadedPerson, cirSettings, cirToken, messages);
        existPerson.setSabreProfilesUpdateDate(loadedPerson.getSabreProfilesUpdateDate());
    }

    public static boolean isLoadAllowedByEmployments(EntityReference<Person> personReference) {
        EntityContainer personContainer = EntityStorage.get().resolve(personReference);
        if (EntityStorageHelper.isEmpty((EntityContainer)personContainer)) {
            throw new IllegalArgumentException("Profile not found");
        }
        return SabreProfilesSynchronizationUtil.isLoadAllowedByEmployments((Person)personContainer.getEntity());
    }

    public static boolean isLoadAllowedByEmployments(Person person) {
        return ProfileHelper.getEmployments((Person)person).stream().map(EntityContainer::getEntity).anyMatch(Organization::isSabreProfilesLoadAllowed);
    }

    private static List<PersonEmployment> parseEmployments(List<SabreProfilesAssociatedProfileData> associatedProfiles, List<EmploymentInfo> employmentInfo, List<Message> messages) {
        List<PersonEmployment> employments = associatedProfiles.stream().map(profile -> SabreProfilesSynchronizationUtil.findEmployer(profile, messages)).filter(Objects::nonNull).map(employer -> {
            PersonEmployment employment = new PersonEmployment();
            employment.setOrganization(employer);
            return employment;
        }).collect(Collectors.toList());
        if (!employmentInfo.isEmpty()) {
            for (PersonEmployment employment : employments) {
                LazyValueHolder employer2 = new LazyValueHolder(() -> EntityStorage.get().resolve(employment.getOrganization()));
                String title = employments.size() == 1 && employmentInfo.size() == 1 ? employmentInfo.get(0).getEmployeeTitle() : (employer2.get() != null ? (String)employmentInfo.stream().filter(info -> TextUtil.nonBlank((String)info.getCompany())).filter(info -> ((Organization)((EntityContainer)employer2.get()).getEntity()).getShortName().getValues().values().stream().anyMatch(name -> TextUtil.isSame((String)name, (String)info.getCompany(), (boolean)true)) || ((Organization)((EntityContainer)employer2.get()).getEntity()).getFullName().getValues().values().stream().anyMatch(name -> TextUtil.isSame((String)name, (String)info.getCompany(), (boolean)true))).map(EmploymentInfo::getEmployeeTitle).filter(TextUtil::nonBlank).findFirst().orElse(null) : null);
                if (!TextUtil.nonBlank(title)) continue;
                PersonPosition position = DictionaryCache.get().getAll(PersonPosition.class).values().stream().filter(dict -> dict.getTranslations().values().stream().anyMatch(name -> TextUtil.isSame((String)name, (String)title, (boolean)true))).findFirst().orElse(null);
                if (position == null && employer2.get() != null && ((Organization)((EntityContainer)employer2.get()).getEntity()).getExternalSystem() == ExternalSystem.GET_THERE) {
                    position = new PersonPosition();
                    Locale locale = TextUtil.containsCyrillicLetter((String)title) ? LocaleUtil.LOCALE_RU : LocaleUtil.LOCALE_EN;
                    position.getTranslations().put(locale, title);
                    try {
                        position.setDataSource("sabre-profiles-sync-util");
                        DictionaryStorage.get().save((BaseDictionary)position);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to save position " + title, e);
                    }
                }
                if (position == null) continue;
                employment.setPosition((DictionaryReference)position.toReference());
            }
        }
        return employments;
    }

    private static List<PersonCostCode> parseCostCodes(EntityContainer<Organization> organization, List<CostCodeInfo> udidValues, List<Message> messages) {
        return udidValues.stream().map(entry -> CostCodesHelper.createPersonCostCode((CostCodeInfo)entry, (EntityContainer)organization, (List)messages)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void updateDictionaryReferences(Person person, List<Message> messages) {
        for (AirlineBonusCard bonusCard : person.getAirlineBonusCards()) {
            if (bonusCard.getAirline() == null) continue;
            Airline airline = DictHelper.findAirlineByAnyCode((String)bonusCard.getAirline().getCode(), (Date)new Date());
            if (airline == null) {
                airline = DictHelper.findAirlineByAnyCode((String)bonusCard.getAirline().getCode(), null);
            }
            if (airline == null) {
                messages.add(MessageHelper.createWarningMessage((String)"SabreProfiles_BonusCardAirlineNotFoundByCode", null, (Object[])new Object[]{bonusCard.getAirline().getCode(), bonusCard.getNumber(), person.toString()}));
                continue;
            }
            bonusCard.setAirline((DictionaryReference)airline.toReference());
        }
    }

    private static EntityReference<Organization> findEmployer(SabreProfilesAssociatedProfileData associatedProfile, List<Message> messages) {
        if (associatedProfile == null) {
            return null;
        }
        if (associatedProfile.getProfileType() != SabreProfilesProfileType.CRP) {
            return null;
        }
        if (TextUtil.isBlank((String)associatedProfile.getUniqueID())) {
            messages.add(MessageHelper.createWarningMessage((String)"SabreProfiles_AssociatedProfileUniqueIdAbsent", null, (Object[])new Object[]{associatedProfile.getName()}));
            return null;
        }
        if (TextUtil.isBlank((String)associatedProfile.getPcc())) {
            messages.add(MessageHelper.createWarningMessage((String)"SabreProfiles_AssociatedProfilePccAbsent", null, (Object[])new Object[]{associatedProfile.getName()}));
            return null;
        }
        EntityReference<Organization> employer = SabreProfilesSynchronizationUtil.searchOrganizationByPccAndUniqueId(associatedProfile.getPcc(), associatedProfile.getUniqueID());
        if (employer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"SabreProfiles_AssociatedProfileNotFound", null, (Object[])new Object[]{associatedProfile.getName(), associatedProfile.getPcc(), associatedProfile.getUniqueID()}));
            return null;
        }
        return employer;
    }

    private static void parseFirstAndSecondNameNames(Person existPerson, L10nString loadedL10nName) {
        String secondName;
        String firstName;
        String loadedName = ProfileSynchronizationUtil.getEnglishValue((L10nString)loadedL10nName);
        String existSecondName = ProfileSynchronizationUtil.getEnglishValue((L10nString)existPerson.getSecondName());
        if (TextUtil.isBlank((String)loadedName)) {
            firstName = null;
            secondName = null;
        } else if (!loadedName.contains(" ") || TextUtil.isBlank((String)existSecondName)) {
            firstName = loadedName;
            secondName = null;
        } else if (loadedName.endsWith(" " + existSecondName)) {
            firstName = loadedName.substring(0, loadedName.length() - existSecondName.length()).trim();
            secondName = existSecondName;
        } else {
            String lastWord = Arrays.stream(loadedName.split(" ")).filter(TextUtil::nonBlank).reduce((first, second) -> second).orElse(null);
            if (lastWord != null && existSecondName.startsWith(lastWord)) {
                firstName = loadedName.substring(0, loadedName.length() - lastWord.length()).trim();
                secondName = existSecondName;
            } else {
                firstName = loadedName;
                secondName = null;
            }
        }
        ProfileSynchronizationUtil.setEnglishValue((L10nString)existPerson.getFirstName(), (String)firstName);
        ProfileSynchronizationUtil.setEnglishValue((L10nString)existPerson.getSecondName(), secondName);
    }

    private static void replaceEnglishValue(L10nString from, L10nString to) {
        SabreProfilesSynchronizationUtil.replaceEnglishValue(from, to, false, null, null);
    }

    private static void replaceEnglishValue(L10nString from, L10nString to, boolean checkStartsWith, Integer valueToLength, Integer valueFromLength) {
        String valueTo;
        String valueFrom = ProfileSynchronizationUtil.getEnglishValue((L10nString)from);
        if (TextUtil.isSame((String)valueFrom, (String)(valueTo = ProfileSynchronizationUtil.getEnglishValue((L10nString)to)))) {
            return;
        }
        if (checkStartsWith && TextUtil.nonBlank((String)valueTo) && TextUtil.nonBlank((String)valueFrom) && (valueToLength == null || valueTo.trim().length() > valueToLength) && (valueFromLength == null || valueFrom.trim().length() == valueFromLength.intValue()) && valueTo.startsWith(valueFrom)) {
            return;
        }
        ProfileSynchronizationUtil.setEnglishValue((L10nString)to, (String)valueFrom);
    }

    private static <E> void mergeCollection(List<E> copyTo, List<E> copyFrom, CollectionUtil.Equator<E, E> equator, Merger<E> merger) {
        SabreProfilesSynchronizationUtil.mergeCollection(copyTo, copyFrom, equator, merger, e -> false);
    }

    private static <E> void mergeCollection(List<E> copyTo, List<E> copyFrom, CollectionUtil.Equator<E, E> equator, Merger<E> merger, Predicate<E> remainPredicate) {
        ArrayList<Object> temp = new ArrayList<Object>();
        for (E elementFrom : copyFrom) {
            Object elementTo = CollectionUtil.find(copyTo, elementFrom, equator);
            if (elementTo != null) {
                merger.merge(elementFrom, elementTo);
                copyTo.remove(elementTo);
                temp.add(elementTo);
                continue;
            }
            temp.add(elementFrom);
        }
        for (E unmatchedElement : copyTo) {
            if (!remainPredicate.test(unmatchedElement)) continue;
            temp.add(unmatchedElement);
        }
        copyTo.clear();
        copyTo.addAll(temp);
    }

    private static void updateNewPassport(Passport newPassport) {
        if ("NTID".equals(newPassport.getSabreProfilesType())) {
            if (newPassport.getCitizenship() != null) {
                if ("RU".equals(newPassport.getCitizenship().getCode())) {
                    newPassport.setType(PassportType.INTERNAL);
                } else {
                    newPassport.setType(PassportType.PASSPORT);
                }
            } else {
                RegionalVariation regionalVariation = AppConfiguration.get().getRegionalVariation();
                if (regionalVariation == null || regionalVariation == RegionalVariation.RU) {
                    newPassport.setType(PassportType.INTERNAL);
                } else {
                    newPassport.setType(PassportType.PASSPORT);
                }
            }
        }
    }

    private static void mergePassport(Passport from, Passport to) {
        if (ProfileSynchronizationUtil.checkForLatinSymbols((String)to.getLastName(), (boolean)true)) {
            to.setLastName(from.getLastName());
        }
        if (ProfileSynchronizationUtil.checkForLatinSymbols((String)to.getFirstName(), (boolean)true)) {
            String secondName;
            String firstName;
            String loadedName = from.getFirstName();
            String existSecondName = to.getSecondName();
            if (TextUtil.isBlank((String)loadedName)) {
                firstName = null;
                secondName = null;
            } else if (!loadedName.contains(" ") || TextUtil.isBlank((String)existSecondName)) {
                firstName = loadedName;
                secondName = null;
            } else if (loadedName.toUpperCase().endsWith(" " + existSecondName.toUpperCase())) {
                firstName = loadedName.substring(0, loadedName.length() - existSecondName.length()).trim();
                secondName = existSecondName;
            } else {
                firstName = loadedName;
                secondName = null;
            }
            to.setFirstName(firstName);
            to.setSecondName(secondName);
        }
        to.setMiddleName(from.getMiddleName());
        to.setIssueCity(from.getIssueCity());
        to.setOriginCountry(from.getOriginCountry());
        to.setNumber(from.getNumber());
        to.setRemarks(from.getRemarks());
        String birthPlace = TextUtil.nonBlank((String)from.getBirthPlace()) ? (to.getBirthPlace() != null && to.getBirthPlace().startsWith(from.getBirthPlace()) ? to.getBirthPlace() : from.getBirthPlace()) : null;
        to.setBirthPlace(birthPlace);
        to.setBirthday(from.getBirthday());
        to.setIssued(from.getIssued());
        to.setExpired(from.getExpired());
        to.setGender(from.getGender());
        if (from.getType() != PassportType.OTHER || !"OTHR".equals(from.getSabreProfilesType()) || !"OTHR".equals(ProfileSynchronizationUtil.getCodeByDocType((PassportType)to.getType()))) {
            if ("PSPT".equals(from.getSabreProfilesType())) {
                if (from.getType() != PassportType.PASSPORT || to.getType() != PassportType.FOREIGN) {
                    if (from.getType() == PassportType.FOREIGN && to.getType() == PassportType.PASSPORT && "NTID".equals(to.getSabreProfilesType())) {
                        to.setType(from.getType());
                    } else {
                        to.setType(from.getType());
                    }
                }
            } else if ("NTID".equals(from.getSabreProfilesType()) && (from.getType() == PassportType.PASSPORT && to.getType() == PassportType.INTERNAL || from.getType() == PassportType.INTERNAL && to.getType() == PassportType.PASSPORT)) {
                if (!MiscUtil.equals((Object)from.getCitizenship(), (Object)to.getCitizenship())) {
                    to.setType(from.getType());
                }
            } else {
                to.setType(from.getType());
            }
        }
        to.setCitizenship(from.getCitizenship());
        to.setSabreProfilesType(from.getSabreProfilesType());
    }

    private static void mergeVisa(Visa from, Visa to) {
        if (from.getIssueCity() != null) {
            to.setIssueCity(from.getIssueCity());
        }
        to.setNumber(from.getNumber());
        to.setCountry(from.getCountry());
        to.setStartDate(from.getStartDate());
        to.setEndDate(from.getEndDate());
        to.setBirthPlace(from.getBirthPlace());
    }

    private static void mergeCommunication(Communication from, Communication to) {
        if (to.getType() != CommunicationType.HOTEL || from.getType() != null) {
            to.setType(from.getType());
        }
        to.setRemarks(from.getRemarks());
        to.setSense(from.getSense());
        to.setCountryCode(from.getCountryCode());
        to.setCityCode(from.getCityCode());
        to.setInternalNumber(from.getInternalNumber());
    }

    private static boolean remainCommunication(Communication communication) {
        if (communication.getType() != null && communication.getType() != CommunicationType.EMAIL && communication.getType() != CommunicationType.WEB) {
            return false;
        }
        return communication.getCountryCode() != null && !communication.getCountryCode().matches("[0-9]{1,5}");
    }

    private static void mergeSabreContactPhone(SabreContactPhone from, SabreContactPhone to) {
        if (!TextUtil.isSame((String)from.getSense(), (String)ProfileSynchronizationUtil.getFullNumber((SabreContactPhone)to))) {
            to.setCountryCode(from.getCountryCode());
            to.setCityCode(from.getCityCode());
            to.setSense(from.getSense());
            to.setInternalNumber(from.getInternalNumber());
        }
        to.setType(from.getType());
        to.setContactFirstName(from.getContactFirstName());
        to.setContactName(from.getContactName());
    }

    private static void mergeSabreContactEmail(SabreContactEmail from, SabreContactEmail to) {
        to.setSense(from.getSense());
        to.setContactFirstName(from.getContactFirstName());
        to.setContactName(from.getContactName());
    }

    private static void mergeAirlineBonusCard(AirlineBonusCard from, AirlineBonusCard to) {
        to.setNumber(from.getNumber());
        to.setAirline(from.getAirline());
    }

    private static void mergeHotelBonusCard(HotelBonusCard from, HotelBonusCard to) {
        to.setNumber(from.getNumber());
        to.setHotelBrand(from.getHotelBrand());
    }

    private static void mergeCarBonusCard(CarBonusCard from, CarBonusCard to) {
        to.setNumber(from.getNumber());
        to.setCarSupplier(from.getCarSupplier());
    }

    private static void mergeRailwayBonusCard(RailwayBonusCard from, RailwayBonusCard to) {
        to.setNumber(from.getNumber());
        to.setRailwayCarrierCode(from.getRailwayCarrierCode());
    }

    private static void mergePersonCostCodes(PersonCostCode from, PersonCostCode to) {
        to.setOrganization(from.getOrganization());
        to.setCostCodeProperties(from.getCostCodeProperties());
        to.setValue(from.getValue());
    }

    private static boolean isSame(Address first, Address second) {
        List addressLinesSecond;
        if (!TextUtil.isSame((String)ProfileSynchronizationUtil.removeIllegalSymbols((String)ProfileSynchronizationUtil.createCityLine((Address)first), (boolean)true), (String)ProfileSynchronizationUtil.removeIllegalSymbols((String)ProfileSynchronizationUtil.createCityLine((Address)second), (boolean)true))) {
            return false;
        }
        List addressLinesFirst = ProfileSynchronizationUtil.removeIllegalSymbols((List)ProfileSynchronizationUtil.createAddressLines((Address)first), (boolean)true);
        if (CollectionUtil.equals((Collection)addressLinesFirst, (Collection)(addressLinesSecond = ProfileSynchronizationUtil.removeIllegalSymbols((List)ProfileSynchronizationUtil.createAddressLines((Address)second), (boolean)true)), (boolean)true)) {
            return true;
        }
        return TextUtil.isSame((String)TextUtil.join((String)" ", (Iterable)addressLinesFirst, (boolean)true), (String)TextUtil.join((String)" ", (Iterable)addressLinesSecond, (boolean)true), (boolean)true);
    }

    private static void mergeAddresses(Address from, Address to) {
        to.setAddressType(from.getAddressType());
        to.setCountry(from.getCountry());
        to.setZip(from.getZip());
        to.setNotes(from.getNotes());
        if (!TextUtil.isSame((String)ProfileSynchronizationUtil.createCityLine((Address)to), (String)SabreProfilesSynchronizationUtil.getEnglishValue(from.getTown()))) {
            to.setRegion(from.getRegion());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getDistrict(), to.getDistrict());
            to.setCity(from.getCity());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getTown(), to.getTown());
        }
        if (!TextUtil.isSame((String)TextUtil.join((String)" ", (Iterable)ProfileSynchronizationUtil.createAddressLines((Address)to), (boolean)true), (String)SabreProfilesSynchronizationUtil.getEnglishValue(from.getAddress()))) {
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getHouse(), to.getHouse());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getHousing(), to.getHousing());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getBuilding(), to.getBuilding());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getPavilion(), to.getPavilion());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getOffice(), to.getOffice());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getFlat(), to.getFlat());
            SabreProfilesSynchronizationUtil.replaceEnglishValue(from.getAddress(), to.getAddress());
        }
    }

    private static boolean remainAddress(PersonAddress address) {
        return address.getAddressType() != AddressType.FACTUAL && address.getAddressType() != AddressType.DELIVERY && address.getAddressType() != AddressType.BUSINESS;
    }

    private static void mergeEmployments(PersonEmployment from, PersonEmployment to) {
        to.setOrganization(from.getOrganization());
        if (from.getPosition() != null) {
            to.setPosition(from.getPosition());
        }
    }

    private static void parseAdditionalPassport(Person existPerson, Person loadedPerson, List<CostCodeInfo> udidValues, List<Message> messages) {
        EntityContainer organization = (EntityContainer)CollectionUtil.head((Iterable)ProfileHelper.getEmployments((Person)existPerson));
        if (organization == null) {
            return;
        }
        ExternalSystem externalSystem = ((Organization)organization.getEntity()).getExternalSystem();
        if (externalSystem != ExternalSystem.GET_THERE) {
            return;
        }
        String additionalPassportNumber = null;
        String additionalPassportExpirationDate = null;
        String additionalPassportCountry = null;
        Iterator<CostCodeInfo> iterator = udidValues.iterator();
        while (iterator.hasNext()) {
            CostCodeInfo udid = iterator.next();
            if (udid.getType() != SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE) continue;
            if (TextUtil.isSame((String)udid.getName(), (String)GET_THERE_ADDITIONAL_PASSPORT_NUMBER)) {
                additionalPassportNumber = udid.getValue();
                iterator.remove();
                continue;
            }
            if (TextUtil.isSame((String)udid.getName(), (String)GET_THERE_ADDITIONAL_PASSPORT_EXPIRATION_DATE)) {
                additionalPassportExpirationDate = udid.getValue();
                iterator.remove();
                continue;
            }
            if (!TextUtil.isSame((String)udid.getName(), (String)GET_THERE_ADDITIONAL_PASSPORT_COUNTRY)) continue;
            additionalPassportCountry = udid.getValue();
            iterator.remove();
        }
        if (TextUtil.isBlank(additionalPassportNumber)) {
            return;
        }
        String passportNumber = additionalPassportNumber;
        Passport passport = loadedPerson.getPassports().stream().filter(p -> p.getType() == PassportType.FOREIGN).filter(p -> TextUtil.isSame((String)p.getNumber(), (String)passportNumber, (boolean)true)).findFirst().orElse(null);
        if (passport == null) {
            passport = new Passport();
            passport.setType(PassportType.FOREIGN);
            passport.setNumber(passportNumber);
            passport.setBirthday(ProfileHelper.getPersonBirthday((Person)loadedPerson));
            passport.setGender(loadedPerson.getGender());
            passport.setLastName(loadedPerson.getLastName().toString(Locale.ENGLISH));
            passport.setFirstName(loadedPerson.getFirstName().toString(Locale.ENGLISH));
            passport.setMiddleName(loadedPerson.getMiddleName().toString(Locale.ENGLISH));
            passport.setSecondName(loadedPerson.getSecondName().toString(Locale.ENGLISH));
            loadedPerson.getPassports().add(passport);
        }
        if (TextUtil.nonBlank((String)additionalPassportExpirationDate)) {
            try {
                passport.setExpired(SabreProfilesSynchronizationUtil.getAdditionalPassportDateFormat().parse(additionalPassportExpirationDate));
            }
            catch (ParseException e) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"SabreProfiles_AdditionalPassportExpirationDateError", (Throwable)e, (Object[])new Object[0]));
            }
        }
        if (TextUtil.nonBlank(additionalPassportCountry)) {
            DictHelper.findCountryByCode((String)additionalPassportCountry).stream().map(Country::toReference).findFirst().ifPresent(arg_0 -> ((Passport)passport).setCitizenship(arg_0));
        }
    }

    private static void updatePassports(Person personToSync, List<CostCodeInfo> udidValues, ExternalSystem externalSystem) {
        if (externalSystem != ExternalSystem.GET_THERE) {
            return;
        }
        personToSync.getPassports().sort(Comparator.comparing(passport -> passport.getType() != PassportType.FOREIGN));
        List passportWrappers = PersonPassportWrapper.wrap((List)personToSync.getPassports());
        passportWrappers.stream().filter(passport -> passport.getType() == PassportType.FOREIGN).skip(1L).findFirst().ifPresent(secondForeignPassport -> {
            CostCodeInfo numberCostCode = new CostCodeInfo();
            numberCostCode.setType(SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE);
            numberCostCode.setName(GET_THERE_ADDITIONAL_PASSPORT_NUMBER);
            numberCostCode.setValue(secondForeignPassport.getNumber());
            udidValues.add(numberCostCode);
            CostCodeInfo expirationDateCostCode = new CostCodeInfo();
            expirationDateCostCode.setType(SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE);
            expirationDateCostCode.setName(GET_THERE_ADDITIONAL_PASSPORT_EXPIRATION_DATE);
            if (secondForeignPassport.getExpired() != null) {
                expirationDateCostCode.setValue(SabreProfilesSynchronizationUtil.getAdditionalPassportDateFormat().format(secondForeignPassport.getExpired()).toUpperCase());
            }
            udidValues.add(expirationDateCostCode);
            CostCodeInfo countryCostCode = new CostCodeInfo();
            countryCostCode.setType(SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE);
            countryCostCode.setName(GET_THERE_ADDITIONAL_PASSPORT_COUNTRY);
            countryCostCode.setValue(DictHelper.getCodeVariant((DictionaryReference)secondForeignPassport.getCitizenship(), (CodeSystem[])new CodeSystem[]{CodeSystem.ISO_ALPHA3}));
            udidValues.add(countryCostCode);
        });
    }

    private static DateFormat getAdditionalPassportDateFormat() {
        return new SimpleDateFormat("ddMMMyyyy", Locale.ENGLISH);
    }

    private static void mergeCostCodes(Person person, List<CostCodeInfo> udidValues, List<Message> messages) {
        EntityContainer organization = (EntityContainer)CollectionUtil.head((Iterable)ProfileHelper.getEmployments((Person)person));
        if (organization == null) {
            return;
        }
        ExternalSystem externalSystem = ((Organization)organization.getEntity()).getExternalSystem();
        if (externalSystem == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.noExternalSystem), (Object[])new Object[]{organization.toReference()}));
            return;
        }
        SabreProfilesSynchronizationUtil.mergeCollection(person.getCostCodes(), SabreProfilesSynchronizationUtil.parseCostCodes((EntityContainer<Organization>)organization, udidValues, messages), (first, second) -> MiscUtil.equals((Object)first.getOrganization(), (Object)second.getOrganization()) && TextUtil.isSame((String)first.getValue(), (String)second.getValue()) && MiscUtil.equals((Object)first.getCostCodeProperties(), (Object)second.getCostCodeProperties()), SabreProfilesSynchronizationUtil::mergePersonCostCodes, costCode -> CostCodesHelper.isRemainCostCode((EntityContainer)organization, (PersonCostCode)costCode));
    }

    private static void updateCards(Person existPerson, Person loadedPerson, PCIDSSServerExchangeSettings cirSettings, String cirToken, List<Message> messages) {
        ArrayList oldCards = new ArrayList(existPerson.getCards());
        existPerson.getCards().clear();
        existPerson.getCards().addAll(loadedPerson.getCards());
        for (Card newCard : existPerson.getCards()) {
            Card oldCard = (Card)CollectionUtil.find(oldCards, (Object)newCard, (c1, c2) -> TextUtil.isSame((String)c1.getNumber(), (String)c2.getNumber()));
            if (oldCard == null || TextUtil.isSame((String)newCard.getRemarks(), (String)oldCard.getRemarks(), (boolean)true)) continue;
            newCard.setRemarks(oldCard.getRemarks());
        }
        if (CirHelper.isEnabled()) {
            for (Card card : oldCards) {
                if (!TextUtil.nonBlank((String)card.getCirUid())) continue;
                try {
                    CirHelper.deleteCard((Card)card, (PCIDSSServerExchangeSettings)cirSettings, (String)cirToken);
                }
                catch (Exception e) {
                    SabreProfilesSynchronizationHelper.log.error("Unable to delete card", (Throwable)e);
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"SabreProfiles_CreditCardWasNotDeletedInCir", (Throwable)e, (Object[])new Object[]{card.getNumber(), card.getCirUid()}));
                }
            }
        }
    }

    private static void updateCostCodes(Person person) {
        List personEmploymentOrganizations = person.getEmployments().stream().map(PersonEmployment::getOrganization).filter(Objects::nonNull).collect(Collectors.toList());
        person.getCostCodes().removeIf(personCostCode -> personCostCode.getOrganization() != null && !personEmploymentOrganizations.contains(personCostCode.getOrganization()));
    }

    public static EntityReference<Person> searchPersonByPccAndUniqueId(String pcc, String uniqueId) {
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.sabreProfilesPccUniqueIds.name(), (Object)ProfileHelper.createPccAndUniqueIdIndexItem((String)pcc, (String)uniqueId)));
        return EntityStorage.get().search(PersonIndex.class, query).getData().stream().filter(Objects::nonNull).map(PersonIndex::getSource).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static EntityReference<Organization> searchOrganizationByPccAndUniqueId(String pcc, String uniqueId) {
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.sabreProfilesPccUniqueIds.name(), (Object)ProfileHelper.createPccAndUniqueIdIndexItem((String)pcc, (String)uniqueId)));
        return EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().filter(Objects::nonNull).map(OrganizationIndex::getSource).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static interface Merger<T> {
        public void merge(T var1, T var2);
    }
}

