/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfileOperationType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreProfilesTripartiteContractsSynchronizationTask
extends BaseScheduledTask {
    static final transient Logger log = LoggerFactory.getLogger(SabreProfilesTripartiteContractsSynchronizationTask.class);
    private static final int MAX_PROFILES_AMOUNT = 1000;

    protected void doJob() throws Exception {
        SabreProfilesConnectionSettings connectionSettings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (connectionSettings == null) {
            log.error("SabreProfilesConnectionSettings not found. Task stopped");
            return;
        }
        List settings = connectionSettings.getPccSettings();
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        Date previousDayEnd = MiscUtil.setDayEndTime((Date)cal.getTime());
        Date previousDayStart = MiscUtil.clearTime((Date)cal.getTime());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)TripartiteContractIndex.Property.lastEndDate.name(), (Object)previousDayStart), SearchCriterion.le((String)TripartiteContractIndex.Property.lastEndDate.name(), (Object)previousDayEnd)}));
        List tripCtrIndexes = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        ArrayList<EntityReference<Organization>> orgRefs = new ArrayList<EntityReference<Organization>>();
        for (TripartiteContractIndex tci : tripCtrIndexes) {
            EntityReference tcRef = tci.getSource();
            EntityContainer tcCont = EntityStorage.get().resolve(tcRef);
            if (tcCont == null) continue;
            for (TripartiteContractCustomerInfo tcci : ((TripartiteContract)tcCont.getEntity()).getCustomers()) {
                EntityContainer orgCont = EntityStorage.get().resolve(tcci.getCustomer());
                if (orgCont == null || ((Organization)orgCont.getEntity()).getSabreProfilesLastOperationType() == SabreProfileOperationType.DELETE) continue;
                orgRefs.add(orgCont.toReference());
            }
        }
        log.debug("Organizations found: " + orgRefs.size());
        if (orgRefs.isEmpty()) {
            log.debug("No organizations from tripartite contracts found. Task stopped.");
            return;
        }
        String orgNames = String.join((CharSequence)",", orgRefs.stream().map(obj -> obj.getCaption()).collect(Collectors.toList()));
        if (orgRefs.size() > 1000) {
            log.warn("More than 1000 profiles found, too many to be automatically synchronized! Only first 1000 will be synchronized");
            orgRefs.subList(1000, orgRefs.size()).clear();
        }
        List<SabreProfilesPccSettings> filteredSettings = this.filterPccs(settings);
        if (!orgRefs.isEmpty()) {
            log.info("Organizations to sync: " + orgNames);
            ArrayList<Message> orgErrors = new ArrayList<Message>();
            List<Integer> orgSyncResult = SabreProfilesSynchronizationHelper.validateAndSendFilteredOrganizations(orgRefs, filteredSettings, orgErrors);
            log.info(String.format("Synchronization finished for organizations. Total: %d, success: %d, not validated: %d, errors: %d", orgSyncResult.get(0), orgSyncResult.get(1), orgSyncResult.get(2), orgSyncResult.get(3)));
            if (!orgErrors.isEmpty()) {
                L10nResourcesManager l10nResourcesManager = LocaleManager.get().getL10nResourceManager();
                orgErrors.stream().map(obj -> l10nResourcesManager.getMessage(obj.getMessage(), LocaleUtil.LOCALE_EN)).forEach(arg_0 -> ((Logger)log).error(arg_0));
            }
        }
    }

    private List<SabreProfilesPccSettings> filterPccs(List<SabreProfilesPccSettings> pccSettings) {
        String value = this.getParameter("PCC", null);
        if (value == null) {
            return pccSettings;
        }
        List<String> values = Arrays.asList(value.split(","));
        return pccSettings.stream().filter(pccSetting -> values.contains(pccSetting.getPcc())).collect(Collectors.toList());
    }
}

