/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.sabreprofiles;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SabreProfilesUpdateExistProfilesScheduledTask
extends BaseScheduledTask {
    private Map<String, SabreProfilesPccSettings> pccSettings;
    private int updatedProfilesCount;

    private void setInitialParameters() {
        this.updatedProfilesCount = 0;
    }

    private void logResult() {
        this.log.info("updated profiles: " + this.updatedProfilesCount);
    }

    protected void doJob() throws Exception {
        if (!this.isLoadingProfilesActive()) {
            return;
        }
        if (!this.loadPccSettings()) {
            return;
        }
        this.setInitialParameters();
        List<EntityReference<Organization>> organizations = this.searchOrganizationsSabreProfilesLoadAllowed();
        List<PersonIndex> personIndices = this.searchPersonIndicesByOrganizations(organizations);
        for (PersonIndex personIndex : personIndices) {
            EntityReference existPerson = personIndex.getSource();
            if (existPerson == null) continue;
            List sabreProfilesPcc = personIndex.getSabreProfilesPccUniqueIds().stream().filter(Objects::nonNull).map(ProfileHelper::getPccBySabreProfilesPccUniqueIds).collect(Collectors.toList());
            for (String pcc : sabreProfilesPcc) {
                SabreProfilesPccSettings pccAndPassword = this.pccSettings.get(pcc);
                if (pccAndPassword == null) continue;
                try {
                    SabreProfilesLoadResult result = SabreProfilesSynchronizationHelper.loadExistPerson((EntityReference<Person>)existPerson, pccAndPassword, true, true, new ArrayList<Message>());
                    if (result != SabreProfilesLoadResult.OK) continue;
                    this.log.info(this.getMessage("SabreProfileLoadProfilesTask_profileWasUpdatedFromSP", new Object[0]));
                    ++this.updatedProfilesCount;
                }
                catch (Exception e) {
                    this.log.error(String.format("Error during update profile (uid %s)", existPerson.getUid()), (Throwable)e);
                }
            }
        }
        this.logResult();
    }

    private boolean isLoadingProfilesActive() {
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (settings == null || !settings.isLoadActive()) {
            this.log.warn(this.getMessage("SabreProfiles_ReturnSynchronizationIsInactive", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean loadPccSettings() {
        this.pccSettings = Collections.unmodifiableMap(ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings().stream().filter(Objects::nonNull).filter(settings -> TextUtil.nonBlank((String)settings.getPcc())).collect(Collectors.toMap(SabreProfilesPccSettings::getPcc, Function.identity(), (first, second) -> first)));
        if (this.pccSettings.isEmpty()) {
            this.log.warn(this.getMessage("SabreProfileLoadProfilesTask_pccSettingsNotFound", new Object[0]));
            return false;
        }
        return true;
    }

    private String getMessage(String key, Object ... parameters) {
        L10nResourcesManager l10nManager = LocaleManager.get().getL10nResourceManager();
        return l10nManager.getMessage(Locale.ENGLISH, key, parameters);
    }

    private List<EntityReference<Organization>> searchOrganizationsSabreProfilesLoadAllowed() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.sabreProfilesLoadAllowed.name(), (Object)Boolean.TRUE));
        return EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().filter(Objects::nonNull).map(OrganizationIndex::getSource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<PersonIndex> searchPersonIndicesByOrganizations(List<EntityReference<Organization>> organizations) {
        List organizationsUids = organizations.stream().filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(PersonIndex.Property.sabreProfilesPccUniqueIds.name());
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.employmentsUids.name(), organizationsUids));
        return EntityStorage.get().search(PersonIndex.class, query).getData().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

