/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.standard;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationResponse;
import java.util.Date;

public class CurrencyRateSynchronizationHandler
implements SynchronizationHandler<CurrencyRateSynchronizationRequest, CurrencyRateSynchronizationResponse> {
    public static final String OPERATION = "currency-rate-synchronization";

    @Override
    public String getOperationId() {
        return OPERATION;
    }

    @Override
    public SynchronizationResponse<CurrencyRateSynchronizationResponse> process(SynchronizationRequest<CurrencyRateSynchronizationRequest> request) throws Exception {
        CurrencyRateSynchronizationRequest data = request.getData();
        Date startDate = data.getStartDate();
        if (startDate != null) {
            startDate = new Date(startDate.getTime() + 1L);
        }
        SynchronizationResponse<CurrencyRateSynchronizationResponse> result = new SynchronizationResponse<CurrencyRateSynchronizationResponse>();
        CurrencyRateSynchronizationResponse response = new CurrencyRateSynchronizationResponse();
        result.setData(response);
        for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            if (startDate != null && startDate.after(rate.getModified()) || rate.getCurrency() == null || !data.getCurrencyCodes().isEmpty() && !data.getCurrencyCodes().contains(rate.getCurrency()) || !data.getBaseCurrencyCodes().isEmpty() && rate.getBaseCurrency() != null && !data.getBaseCurrencyCodes().contains(rate.getBaseCurrency()) || !data.getRateTypes().isEmpty() && rate.getType() != null && !data.getRateTypes().contains(rate.getType())) continue;
            response.getCurrencyRates().add(rate);
        }
        return result;
    }
}

