/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class CurrencyRateSynchronizationTask
extends BaseScheduledTask {
    private final List<String> currencyCodes = new ArrayList<String>();
    private final List<String> baseCurrencyCodes = new ArrayList<String>();
    private final List<CurrencyRateType> rateTypes = new ArrayList<CurrencyRateType>();
    private String currencySynchronizationUrl;

    public void configure(Properties config) throws Exception {
        String str;
        this.currencySynchronizationUrl = config.getProperty("currencySynchronizationUrl");
        if (TextUtil.isBlank((String)this.currencySynchronizationUrl) || "http://ibe.gridnine.com:9090/sync/".contains(this.currencySynchronizationUrl)) {
            this.currencySynchronizationUrl = "http://ibe.gridnine.com:9090/sync/";
        }
        if (TextUtil.nonBlank((String)(str = config.getProperty("currencyCodes")))) {
            for (String string : str.split("[,.]")) {
                if (!TextUtil.nonBlank((String)string)) continue;
                this.currencyCodes.add(string.trim().toUpperCase());
            }
        }
        if (this.currencyCodes.isEmpty()) {
            for (CurrencyInfo info : DictionaryCache.get().getAll(CurrencyInfo.class).values()) {
                try {
                    this.currencyCodes.add(info.getCode());
                }
                catch (Throwable e) {
                    this.log.error("unable to get currency for currency info " + info, e);
                }
            }
        }
        if (TextUtil.nonBlank((String)(str = config.getProperty("baseCurrencyCodes")))) {
            for (String string : str.split("[,.]")) {
                if (!TextUtil.nonBlank((String)string)) continue;
                this.baseCurrencyCodes.add(string.trim().toUpperCase());
            }
        }
        if (this.baseCurrencyCodes.isEmpty()) {
            this.baseCurrencyCodes.add(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        }
        if (!TextUtil.isBlank((String)(str = config.getProperty("rateTypes")))) {
            for (String string : str.split("[,.]")) {
                if (!TextUtil.nonBlank((String)string)) continue;
                try {
                    this.rateTypes.add(CurrencyRateType.valueOf((String)string.trim().toUpperCase()));
                }
                catch (Exception e) {
                    this.log.error("unable to read currency rate type", (Throwable)e);
                }
            }
        }
        if (this.rateTypes.isEmpty()) {
            this.rateTypes.addAll(Arrays.asList(CurrencyRateType.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() throws Exception {
        Date date = SynchronizationHelper.getLastSynchronizationDate("currency-rate-synchronization");
        if (date == null) {
            for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
                if (date != null && !rate.getModified().after(date)) continue;
                date = rate.getModified();
            }
        }
        CurrencyRateSynchronizationRequest data = new CurrencyRateSynchronizationRequest();
        data.setStartDate(date);
        data.getCurrencyCodes().addAll(this.currencyCodes);
        data.getBaseCurrencyCodes().addAll(this.baseCurrencyCodes);
        data.getRateTypes().addAll(this.rateTypes);
        SynchronizationRequest<CurrencyRateSynchronizationRequest> request = new SynchronizationRequest<CurrencyRateSynchronizationRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        ValueHolder trace = new ValueHolder();
        SynchronizationResponse<CurrencyRateSynchronizationResponse> response = this.execute(data, "currency-rate-synchronization", (ValueHolder<String>)trace);
        StringBuilder sb = new StringBuilder((String)trace.getValue());
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                this.log.warn("synchronization was unsuccessfull: " + msg.getMessage());
                sb.append("\r\n\u043f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + msg.getMessage());
                return;
            }
            for (CurrencyRate rate : response.getData().getCurrencyRates()) {
                if (rate.getBaseCurrency() != null && !this.baseCurrencyCodes.isEmpty() && !this.baseCurrencyCodes.contains(rate.getBaseCurrency())) {
                    this.log.debug(String.format("base currency for currency rate of type %s for %s(%s) at %s is not present in config list, skipping save", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    sb.append(String.format("\r\n\u0431\u0430\u0437\u043e\u0432\u0430\u044f \u0432\u0430\u043b\u044e\u0442\u0430 \u0434\u043b\u044f \u043a\u0443\u0440\u0441\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 %s \u0434\u043b\u044f %s (%s) \u043d\u0430 \u0434\u0430\u0442\u0443 %s \u043d\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    continue;
                }
                if (rate.getType() != null && !this.rateTypes.isEmpty() && !this.rateTypes.contains(rate.getType())) {
                    this.log.debug(String.format("rate type for currency rate of type %s for %s(%s) at %s is not present in config list, skipping save", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    sb.append(String.format("\r\n\u0442\u0438\u043f \u043a\u0443\u0440\u0441\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 %s \u0434\u043b\u044f %s (%s) \u043d\u0430 \u0434\u0430\u0442\u0443 %s \u043d\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d \u0432 \u0444\u0430\u0439\u043b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    continue;
                }
                if (this.isPresent(rate)) {
                    this.log.debug(String.format("currency rate of type %s for %s(%s) at %s is already present, skipping save", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    sb.append(String.format("\r\n\u043a\u0443\u0440\u0441 \u043e\u0431\u043c\u0435\u043d\u0430 %s \u0434\u043b\u044f %s(%s) \u043d\u0430 \u0434\u0430\u0442\u0443 %s \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                    continue;
                }
                rate.setCode(null);
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)rate);
                this.log.debug(String.format("currency rate of type %s for %s(%s) at %s was saved", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
                sb.append(String.format("\r\n\u043a\u0443\u0440\u0441 \u043e\u0431\u043c\u0435\u043d\u0430 %s \u0434\u043b\u044f %s(%s) \u043d\u0430 \u0434\u0430\u0442\u0443 %s \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d", rate.getType(), rate.getCurrency(), rate.getBaseCurrency(), rate.getDate()));
            }
            SynchronizationHelper.setLastSynchronizationDate(response.getDate(), "currency-rate-synchronization");
            sb.append(String.format("\r\n\u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 %s", response.getDate()));
        }
        catch (Exception e) {
            this.log.error("unable to synchronize currency rates", (Throwable)e);
            sb.append(String.format("\r\n\u043f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(sb.toString(), "currency-rate-synchronization");
        }
    }

    private boolean isPresent(CurrencyRate rate) {
        if (rate.getDate() == null) {
            return false;
        }
        Date date = MiscUtil.clearTime((Date)rate.getDate());
        for (CurrencyRate dbRate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            Date dbDate;
            if (dbRate.getCurrency() == null || !dbRate.getCurrency().equals(rate.getCurrency()) || dbRate.getBaseCurrency() == null || !dbRate.getBaseCurrency().equals(rate.getBaseCurrency()) || !MiscUtil.equals((Object)rate.getTariffType(), (Object)dbRate.getTariffType()) || !MiscUtil.equals((Object)rate.getBlankOwner(), (Object)dbRate.getBlankOwner()) || !MiscUtil.equals((Object)rate.getType(), (Object)dbRate.getType()) || (dbDate = dbRate.getDate()) == null || !MiscUtil.equals((Object)date, (Object)MiscUtil.clearTime((Date)dbDate))) continue;
            return true;
        }
        return false;
    }

    private SynchronizationResponse<CurrencyRateSynchronizationResponse> execute(CurrencyRateSynchronizationRequest data, String operationId, ValueHolder<String> traceHolder) {
        SynchronizationRequest<CurrencyRateSynchronizationRequest> request = new SynchronizationRequest<CurrencyRateSynchronizationRequest>();
        request.setOperationId(operationId);
        request.setData(data);
        request.setUser(data.getUser());
        request.setClientId(Environment.getApplicationId());
        return SynchronizationHelper.execute(request, this.currencySynchronizationUrl, traceHolder);
    }
}

