/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.synchronization.technicalFee;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.BaseCategorizedCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.technicalFee.RulesSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.technicalFee.RulesSynchronizationResponse;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RulesSynchronizationTask
extends BaseScheduledTask {
    private static final String OPERATION_ID = "rules-synchronization";
    private static final String USER = "RulesSynchronizationTaskUser";

    protected void doJob() throws Exception {
        if (!AppConfiguration.get().isCollectTechnicalFee()) {
            return;
        }
        List<String> modelContractsUids = Arrays.asList("technical_fee_system_model_contract");
        List<String> feeProperties = Arrays.asList("technical_fee_fee_properties");
        List<String> commissionProperties = Arrays.asList("agency_bonus_commission_properties");
        RulesSynchronizationRequest request = new RulesSynchronizationRequest();
        for (String uid : modelContractsUids) {
            EntityReference modelContractRef = new EntityReference(uid, ModelContract.class, null);
            EntityContainer modelContractCtr = EntityStorageHelper.resolve((EntityReference)modelContractRef);
            if (modelContractCtr == null) continue;
            request.getModelContracts().put(modelContractCtr.getUid(), modelContractCtr.getModified());
        }
        this.createCommissionProperties(feeProperties, request.getFeeProperties(), FeeProperties.class);
        this.createCommissionProperties(commissionProperties, request.getCommissionProperties(), CommissionProperties.class);
        SynchronizationResponse<RulesSynchronizationResponse> syncResponse = this.processRequest(request);
        boolean hasErrors = false;
        for (Message msg : syncResponse.getMessages()) {
            if (msg.getType() == MessageType.ERROR) {
                this.log.error("Request to licence server had error: " + msg.getMessage());
                hasErrors = true;
                continue;
            }
            this.log.info("Request to licence server had message: " + msg.getMessage());
        }
        if (hasErrors) {
            return;
        }
        RulesSynchronizationResponse response = syncResponse.getData();
        for (Map.Entry<String, ModelContract> entry : response.getModelContracts().entrySet()) {
            EntityReference modelContractRef = new EntityReference(entry.getKey(), ModelContract.class, null);
            EntityContainer modelContractCtr = EntityStorageHelper.resolve((EntityReference)modelContractRef);
            if (modelContractCtr == null) continue;
            ModelContract modelContract = (ModelContract)modelContractCtr.getEntity();
            modelContract.copyFrom((BaseEntity)entry.getValue(), false, new HashMap());
            modelContractCtr.getVersionInfo().setDataSource(OPERATION_ID);
            EntityStorage.get().save(modelContractCtr, true);
        }
        this.getCommissionProperties(response.getFeeProperties(), FeeProperties.class);
        this.getCommissionProperties(response.getCommissionProperties(), CommissionProperties.class);
    }

    private <T extends BaseCategorizedCommissionProperties> void createCommissionProperties(List<String> commissionProperties, Map<String, Date> requestMap, Class<T> clazz) {
        for (String uid : commissionProperties) {
            EntityReference commissionPropertiesRef = new EntityReference(uid, clazz, null);
            EntityContainer commissionPropertiesCtr = EntityStorageHelper.resolve((EntityReference)commissionPropertiesRef);
            if (commissionPropertiesCtr == null) continue;
            requestMap.put(commissionPropertiesCtr.getUid(), commissionPropertiesCtr.getModified());
        }
    }

    private <T extends BaseCategorizedCommissionProperties> void getCommissionProperties(Map<String, BaseCategorizedCommissionProperties> responseMap, Class<T> clazz) throws Exception {
        for (Map.Entry<String, BaseCategorizedCommissionProperties> entry : responseMap.entrySet()) {
            EntityReference commissionPropertiesRef = new EntityReference(entry.getKey(), clazz, null);
            EntityContainer commissionPropertiesCtr = EntityStorageHelper.resolve((EntityReference)commissionPropertiesRef);
            if (commissionPropertiesCtr == null) continue;
            BaseCategorizedCommissionProperties commissionProperties = (BaseCategorizedCommissionProperties)commissionPropertiesCtr.getEntity();
            commissionProperties.copyFrom((BaseEntity)entry.getValue(), false, new HashMap());
            commissionPropertiesCtr.getVersionInfo().setDataSource(OPERATION_ID);
            EntityStorage.get().save(commissionPropertiesCtr, true);
        }
    }

    private SynchronizationResponse<RulesSynchronizationResponse> processRequest(RulesSynchronizationRequest data) {
        SynchronizationRequest<RulesSynchronizationRequest> request = new SynchronizationRequest<RulesSynchronizationRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId(OPERATION_ID);
        request.setUser(USER);
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
    }
}

