/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.AsyncServerTaskData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncServerTasksManager
implements Disposable {
    private static final String tag = "uncontrolled-task-data";
    final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AsyncServerTask> processes = Collections.synchronizedMap(new HashMap());
    private boolean disposing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startProcess(String processClassName, final Object parameters) throws Exception {
        AsyncServerTasksManager asyncServerTasksManager = this;
        synchronized (asyncServerTasksManager) {
            if (this.disposing) {
                throw new Exception("Server is disposing");
            }
        }
        final AsyncServerTask process = (AsyncServerTask)Class.forName(processClassName).newInstance();
        TemporalObject to = new TemporalObject();
        to.setExpired(new Date(new Date().getTime() + 86400000L));
        to.setTag(tag);
        AsyncServerTaskData processData = new AsyncServerTaskData();
        processData.setUid(to.getUid());
        processData.setProgress((byte)0);
        this.setProcessData(to, processData);
        AssetsStorage.get().save((BaseAsset)to);
        final String toUid = to.getUid();
        new Thread("server-side-process-" + process.getClass().getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    Object result = process.execute(new AsyncServerTask.Callback(){

                        @Override
                        public void updateProgress(byte progress, String message) {
                            try {
                                TemporalObject to2 = AsyncServerTasksManager.this.getTemporalObject(toUid);
                                AsyncServerTaskData data = AsyncServerTasksManager.this.getProcessData(to2);
                                data.setProgress(progress);
                                data.setProgressMessage(message);
                                AsyncServerTasksManager.this.setProcessData(to2, data);
                                AssetsStorage.get().save((BaseAsset)to2);
                            }
                            catch (Exception e2) {
                                AsyncServerTasksManager.this.log.error("unable to update progress", (Throwable)e2);
                            }
                        }

                        @Override
                        public void addMessage(Message message) {
                            try {
                                TemporalObject to2 = AsyncServerTasksManager.this.getTemporalObject(toUid);
                                AsyncServerTaskData data = AsyncServerTasksManager.this.getProcessData(to2);
                                data.getMessages().add(message);
                                AsyncServerTasksManager.this.setProcessData(to2, data);
                                AssetsStorage.get().save((BaseAsset)to2);
                            }
                            catch (Exception e2) {
                                AsyncServerTasksManager.this.log.error("unable to add message", (Throwable)e2);
                            }
                        }
                    }, parameters);
                    TemporalObject to2 = AsyncServerTasksManager.this.getTemporalObject(toUid);
                    AsyncServerTaskData data = AsyncServerTasksManager.this.getProcessData(to2);
                    if (result != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeObject(result);
                        oos.flush();
                        oos.close();
                        data.setResult(baos.toByteArray());
                    } else {
                        data.setResult(null);
                    }
                    AsyncServerTasksManager.this.setProcessData(to2, data);
                    AssetsStorage.get().save((BaseAsset)to2);
                }
                catch (Exception e) {
                    AsyncServerTasksManager.this.log.error("unable execute task", (Throwable)e);
                    try {
                        TemporalObject to2 = AsyncServerTasksManager.this.getTemporalObject(toUid);
                        AsyncServerTaskData data = AsyncServerTasksManager.this.getProcessData(to2);
                        data.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AsyncServerTasksManager_unexpectedErrorOccurred, (Throwable)e, (Object[])new Object[0]));
                        AsyncServerTasksManager.this.setProcessData(to2, data);
                        AssetsStorage.get().save((BaseAsset)to2);
                    }
                    catch (Exception e2) {
                        AsyncServerTasksManager.this.log.error("unable to update temporal object", (Throwable)e2);
                    }
                }
                finally {
                    try {
                        AsyncServerTasksManager.this.processes.remove(toUid);
                        TemporalObject to2 = AsyncServerTasksManager.this.getTemporalObject(toUid);
                        AsyncServerTaskData data = AsyncServerTasksManager.this.getProcessData(to2);
                        data.setCompleted(true);
                        AsyncServerTasksManager.this.setProcessData(to2, data);
                        AssetsStorage.get().save((BaseAsset)to2);
                    }
                    catch (Exception e2) {
                        AsyncServerTasksManager.this.log.error("unable to update temporal object", (Throwable)e2);
                    }
                }
            }
        }.start();
        return to.getUid();
    }

    public AsyncServerTaskData getProcessData(String uid) throws Exception {
        return this.getProcessData(this.getTemporalObject(uid));
    }

    public void deleteProcessData(String uid) throws Exception {
        if (this.processes.containsKey(uid)) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.AsyncServerTasksManager_taskRunning, (Object[])new Object[0]));
        }
        AssetsStorage.get().delete((BaseAsset)this.getTemporalObject(uid));
    }

    void setProcessData(TemporalObject to, AsyncServerTaskData processData) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)processData, (OutputStream)baos);
        to.setData(baos.toByteArray());
    }

    AsyncServerTaskData getProcessData(TemporalObject to2) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(to2.getData());
        AsyncServerTaskData processData = new AsyncServerTaskData();
        processData.fromXML(DocumentBuilderHelper.parse((InputStream)bis).getDocumentElement());
        return processData;
    }

    TemporalObject getTemporalObject(String uid) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseAsset.Property.uid.name(), (Object)uid));
        List data = AssetsStorage.get().search(TemporalObject.class, query).getData();
        if (data.isEmpty()) {
            throw new Exception("unable to find temporal object");
        }
        return (TemporalObject)data.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AsyncServerTasksManager asyncServerTasksManager = this;
        synchronized (asyncServerTasksManager) {
            this.disposing = true;
        }
        for (Map.Entry entry : this.processes.entrySet()) {
            try {
                AssetsStorage.get().delete((BaseAsset)this.getTemporalObject((String)entry.getKey()));
                ((AsyncServerTask)entry.getValue()).stop();
            }
            catch (Exception e) {
                this.log.error("unable to stop process", (Throwable)e);
            }
        }
        this.processes.clear();
    }

    AsyncServerTasksManager() {
    }
}

