/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.model.tasks.BulkLongRunningTaskEntry;
import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class BulkLongRunningTaskEntryData
extends BaseAssetData<BulkLongRunningTaskEntry> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="BulkLongRunningTaskEntryData_modified")
    private Date modified;
    @Index(name="BulkLongRunningTaskEntryData_instanceUid")
    private String instanceUid;
    private String entryClass;
    private String entryUid;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public BulkLongRunningTaskEntry toAsset(Set<String> preferredProperties) throws Exception {
        BulkLongRunningTaskEntry result = new BulkLongRunningTaskEntry(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        result.setInstanceUid(this.instanceUid);
        result.setEntryClass(Class.forName(this.entryClass));
        result.setEntryUid(this.entryUid);
        return result;
    }

    public void fromAsset(BulkLongRunningTaskEntry asset) throws Exception {
        this.setUid(asset.getUid());
        this.setModified(asset.getModified());
        this.instanceUid = asset.getInstanceUid();
        this.entryClass = asset.getEntryClass().getName();
        this.entryUid = asset.getEntryUid();
    }
}

