/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class CurrencyRateCleanupTask
extends BaseScheduledTask {
    private int daysToKeep;

    protected void configure(Properties properties) throws Exception {
        this.daysToKeep = Integer.parseInt(properties.getProperty("daysToKeep"));
    }

    protected void doJob() throws Exception {
        Date threshold = MiscUtil.addDaysToDate((Date)new Date(), (int)(-this.daysToKeep));
        List toDelete = DictionaryCache.get().getAll(CurrencyRate.class).values().stream().filter(rate -> rate.getDate() != null && rate.getDate().before(threshold)).collect(Collectors.toList());
        for (CurrencyRate rate2 : toDelete) {
            DictionaryStorage.get().delete((BaseDictionary)rate2);
        }
    }
}

