/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.model.tasks.Feedback;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class FeedbackImpl
implements Feedback {
    private LongRunningTask.EventsCallback callback;
    private final Logger log;
    private final AtomicInteger errorCount = new AtomicInteger();

    public FeedbackImpl(Logger log) {
        this.log = log;
    }

    @Override
    public void complete(String message) {
        if (this.callback != null) {
            this.callback.updateProgress((byte)100);
            if (message != null) {
                this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)message, (Object[])new Object[0]));
            }
            this.callback.taskFinished();
        }
        if (message != null) {
            this.log.debug(message);
        }
    }

    @Override
    public void failure(String message) {
        if (this.callback != null) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)message, (Object[])new Object[0]));
            this.callback.taskFinished();
        }
        this.log.error(message);
    }

    @Override
    public void inform(String message) {
        this.log.info(message);
        if (this.callback != null) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)message, (Object[])new Object[0]));
        }
    }

    @Override
    public void warn(String message) {
        this.log.warn(message);
        if (this.callback != null) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)message, (Object[])new Object[0]));
        }
    }

    @Override
    public void error(String message) {
        this.errorCount.incrementAndGet();
        this.log.error(message);
        if (this.callback != null) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)message, (Object[])new Object[0]));
        }
    }

    @Override
    public void error(String message, Throwable t) {
        this.errorCount.incrementAndGet();
        this.log.error(message, t);
        if (this.callback != null) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)message, (Throwable)t, (Object[])new Object[0]));
        }
    }

    @Override
    public void setErrorCount(int value) {
        this.errorCount.set(value);
    }

    @Override
    public int getErrorCount() {
        return this.errorCount.get();
    }

    public void setCallback(LongRunningTask.EventsCallback value) {
        this.callback = value;
    }

    public LongRunningTask.EventsCallback getCallback() {
        return this.callback;
    }
}

