/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profiling.RunningProcessDescription;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.RunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.StopTaskData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class LongRunningTasksManager
implements Disposable {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());
    boolean disposed = false;
    private static final String LOCK_ID_PREFFIX = "LRT_";
    private static final String stopTopicId = "LRT_STOP_TASK";
    private final int stopWaitPeriodInSeconds = 30;
    private final int maxEventCount = 100;
    final RunningTasksManager rtm;
    private static final int DATE_EXPIRE_MOTHS = 6;

    LongRunningTasksManager(RunningTasksManager tasksManager) {
        this.rtm = tasksManager;
    }

    public void init() {
        try {
            this.fixIncorrectlyStoppedTasks();
            this.deleteExpiredTasksAsync();
        }
        catch (Throwable e) {
            this.log.error("error fixing incorrectly stopped tasks", e);
        }
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerTopic(stopTopicId);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerTopicListener(stopTopicId, (JMSTopicListener)new JMSTopicListener<StopTaskData>(){

            public void onMessage(StopTaskData message) {
                if (Environment.getApplicationId().equals(message.taskInfo.getServerId())) {
                    try {
                        LongRunningTasksManager.this.stopTaskInternal(message.taskInfo, message.taskState);
                    }
                    catch (Exception e) {
                        LongRunningTasksManager.this.log.error("unable to stop task", (Throwable)e);
                    }
                }
            }
        });
    }

    private void fixIncorrectlyStoppedTasks() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.RUNNING));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)LongRunningTaskInfo.Property.serverId.name(), (Object)Environment.getApplicationId()), SearchCriterion.eq((String)LongRunningTaskInfo.Property.serverId.name(), null)}));
        for (LongRunningTaskInfo info : AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData()) {
            TemporalObject obj = this.findTemporalObject(info.getUid());
            if (obj == null) {
                info.setState(LongRunningTaskInfo.State.COMPLETED);
                info.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.LongRunningTasksManager_cantRestoreConfigurationTasks, (Object[])new Object[]{LongRunningTaskInfo.State.COMPLETED}), LogicalStorage.get().getUser());
                AssetsStorage.get().save((BaseAsset)info);
                this.log.debug(String.format("status of task %s with uid %s was changed to completed", info.getDescription(), info.getUid()));
                continue;
            }
            info.setState(LongRunningTaskInfo.State.STOPPED);
            info.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskStateChanged, (Object[])new Object[]{LongRunningTaskInfo.State.STOPPED}), LogicalStorage.get().getUser());
            AssetsStorage.get().save((BaseAsset)info);
            this.log.debug(String.format("status of task %s with uid %s was changed to stopped", info.getDescription(), info.getUid()));
        }
    }

    private void deleteExpiredTasksAsync() {
        AsyncExecutor.get().execute("lrt-delete-expired-tasks", (AsyncCommand & Serializable)() -> {
            LocalDateTime expireLDT = LocalDateTime.now().minusMonths(6L);
            Date expireDate = Date.from(expireLDT.atZone(ZoneId.systemDefault()).toInstant());
            Date expireDateEndDay = MiscUtil.setDayEndTime((Date)expireDate);
            SearchQuery query = new SearchQuery();
            List criterions = query.getCriteria().getCriterions();
            criterions.add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.COMPLETED));
            criterions.add(SearchCriterion.le((String)LongRunningTaskInfo.Property.endDate.name(), (Object)expireDateEndDay));
            List result = AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData();
            result.forEach(info -> AssetsStorage.get().delete((BaseAsset)info));
        }, new AsyncCommandOption[0]);
    }

    void updateRunningTasks() {
        if (this.disposed) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.NEW), SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.PAUSED), SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.RUNNING)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)LongRunningTaskInfo.Property.startDate.name(), null), SearchCriterion.le((String)LongRunningTaskInfo.Property.startDate.name(), (Object)new Date())}));
        query.getPreferredProperties().add(BaseAsset.Property.uid.name());
        ArrayList<LongRunningTaskInfo> newOrPausedTasks = new ArrayList<LongRunningTaskInfo>();
        final String appId = Environment.getApplicationId();
        for (LongRunningTaskInfo task : AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData()) {
            task = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, task.getUid());
            if (!TextUtil.isBlank((String)task.getInstance()) && !task.getInstance().equals(appId) || task.getState() != LongRunningTaskInfo.State.NEW && task.getState() != LongRunningTaskInfo.State.PAUSED) continue;
            newOrPausedTasks.add(task);
        }
        block3: for (final LongRunningTaskInfo taskInfo : newOrPausedTasks) {
            try {
                ArrayList runningTasks = new ArrayList();
                for (LongRunningTaskInfo task : AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData()) {
                    this.withLock(task, () -> {
                        LongRunningTaskInfo task2 = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, task.getUid());
                        if (!TextUtil.isBlank((String)task2.getInstance()) && !task2.getInstance().equals(appId)) {
                            return null;
                        }
                        if (task2.getState() == LongRunningTaskInfo.State.RUNNING) {
                            runningTasks.add(task2);
                        }
                        return null;
                    });
                }
                for (LongRunningTaskInfo runningTask : runningTasks) {
                    if (!taskInfo.getTaskClassName().equals(runningTask.getTaskClassName())) continue;
                    if (taskInfo.isSingleton()) {
                        this.log.warn(String.format("task %s is postponed because it is singleton and quee already contains task %s of the same type", taskInfo.getDescription(), runningTask.getDescription()));
                        continue block3;
                    }
                    if (!runningTask.isSingleton()) continue;
                    this.log.warn(String.format("task %s is postponed because quee already contains singleton task %s of the same type", taskInfo.getDescription(), runningTask.getDescription()));
                }
                this.withLock(taskInfo, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        final LongRunningTaskInfo taskInfoClone = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskInfo.getUid());
                        if (taskInfoClone == null || taskInfoClone.getState() != LongRunningTaskInfo.State.NEW && taskInfoClone.getState() != LongRunningTaskInfo.State.PAUSED) {
                            LongRunningTasksManager.this.log.warn(String.format("task  %s: %s is not new", taskInfo.getDescription(), taskInfo.getUid()));
                            return null;
                        }
                        SearchQuery searchQuery = new SearchQuery();
                        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.referenceUid.name(), (Object)taskInfoClone.getUid()));
                        List data = AssetsStorage.get().search(TemporalObject.class, searchQuery).getData();
                        if (data.isEmpty()) {
                            LongRunningTasksManager.this.log.error(String.format("unable to load data for task %s, it will be checked as completed", taskInfoClone.getDescription()));
                            taskInfoClone.setState(LongRunningTaskInfo.State.COMPLETED);
                            taskInfoClone.setEndDate(new Date());
                            taskInfoClone.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.LongRunningTasksManager_cantLoadDataForTask, (Object[])new Object[0]), LogicalStorage.get().getUser());
                            AssetsStorage.get().save((BaseAsset)taskInfoClone);
                            return null;
                        }
                        LongRunningTask task = (LongRunningTask)Class.forName(taskInfoClone.getTaskClassName()).newInstance();
                        task.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(GZIPUtil.gunzip((byte[])((TemporalObject)data.get(0)).getData())))).getDocumentElement());
                        taskInfoClone.setState(LongRunningTaskInfo.State.RUNNING);
                        taskInfoClone.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskRunned, (Object[])new Object[]{Environment.getApplicationId()}), LogicalStorage.get().getUser());
                        taskInfoClone.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_serverId, (Object[])new Object[]{Environment.getApplicationId()}), LogicalStorage.get().getUser());
                        taskInfoClone.setServerId(appId);
                        AssetsStorage.get().save((BaseAsset)taskInfoClone);
                        RunningProcessDescription monitoredTask = new RunningProcessDescription();
                        monitoredTask.setUid(taskInfoClone.getUid());
                        monitoredTask.setProgress((byte)0);
                        monitoredTask.setTaskName(taskInfoClone.getTaskClassName());
                        monitoredTask.setStartDate(new Date());
                        LongRunningTasksManager.this.rtm.startLocalTask(taskInfoClone, task, new LongRunningTask.EventsCallback(){
                            private boolean wasFinished = false;

                            @Override
                            public boolean wasFinished() {
                                return this.wasFinished;
                            }

                            @Override
                            public void taskFinishedWithError(Throwable e) {
                                taskInfoClone.setState(LongRunningTaskInfo.State.ERROR);
                                try {
                                    AssetsStorage.get().save((BaseAsset)taskInfoClone);
                                }
                                catch (Exception e2) {
                                    LongRunningTasksManager.this.log.error("unable to update info " + taskInfoClone.getUid(), (Throwable)e2);
                                }
                                LongRunningTask<?> task = LongRunningTasksManager.this.rtm.getTask(taskInfoClone.getUid());
                                try {
                                    TemporalObject obj = LongRunningTasksManager.this.findTemporalObject(taskInfoClone.getUid());
                                    if (obj != null) {
                                        ByteArrayOutputStream strm = new ByteArrayOutputStream();
                                        XUtil.serialize(task, (OutputStream)strm);
                                        obj.setData(GZIPUtil.gzip((byte[])strm.toByteArray()));
                                        AssetsStorage.get().save((BaseAsset)obj);
                                    } else {
                                        LongRunningTasksManager.this.log.warn("unable to find temporal object for task " + taskInfoClone.getUid());
                                    }
                                }
                                catch (Exception e2) {
                                    LongRunningTasksManager.this.log.error("unable to serialize state of task " + taskInfoClone.getUid(), (Throwable)e2);
                                }
                                this.wasFinished = true;
                            }

                            @Override
                            public void addEvent(String eventId, Message description) {
                                try {
                                    if (taskInfoClone.getEvents().size() < 100) {
                                        taskInfoClone.getEvents().add(eventId, description, LogicalStorage.get().getUser());
                                        AssetsStorage.get().save((BaseAsset)taskInfoClone);
                                    } else {
                                        if (taskInfoClone.getEvents().size() == 100) {
                                            taskInfoClone.getEvents().add(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"see more events in the log", (Object[])new Object[0]), LogicalStorage.get().getUser());
                                            AssetsStorage.get().save((BaseAsset)taskInfoClone);
                                        }
                                        switch (description.getType()) {
                                            case WARNING: {
                                                LongRunningTasksManager.this.log.warn(this.format(taskInfoClone, description));
                                                break;
                                            }
                                            case ERROR: {
                                                LongRunningTasksManager.this.log.error(this.format(taskInfoClone, description));
                                                break;
                                            }
                                            default: {
                                                LongRunningTasksManager.this.log.debug(this.format(taskInfoClone, description));
                                            }
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    LoggerFactory.getLogger(LongRunningTasksManager.class).error("unable to update message", e);
                                }
                            }

                            private String format(LongRunningTaskInfo task, Message description) {
                                if (TextUtil.isBlank((String)description.getDetails())) {
                                    return task.getTaskClassName() + ": " + description.getMessage().toString();
                                }
                                return String.format("%s: %s, details:\n%s", task.getTaskClassName(), description.getMessage().toString(), description.getDetails());
                            }

                            @Override
                            public void updateProgress(byte progress) {
                                try {
                                    if (taskInfoClone.getProgress() == progress) {
                                        return;
                                    }
                                    taskInfoClone.setProgress(progress);
                                    AssetsStorage.get().save((BaseAsset)taskInfoClone);
                                }
                                catch (Throwable e) {
                                    LoggerFactory.getLogger(LongRunningTasksManager.class).error("unable to update message", e);
                                }
                            }

                            @Override
                            public void taskFinished() {
                                taskInfoClone.setState(LongRunningTaskInfo.State.COMPLETED);
                                taskInfoClone.setProgress((byte)100);
                                taskInfoClone.setEndDate(new Date());
                                taskInfoClone.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskFinished, (Object[])new Object[0]), LogicalStorage.get().getUser());
                                try {
                                    AssetsStorage.get().save((BaseAsset)taskInfoClone);
                                }
                                catch (Exception e) {
                                    LongRunningTasksManager.this.log.error("unable to update info", (Throwable)e);
                                }
                                try {
                                    LongRunningTasksManager.this.deleteTemporalObject(taskInfoClone.getUid());
                                }
                                catch (Exception e) {
                                    LongRunningTasksManager.this.log.error("unable to delete temporal object", (Throwable)e);
                                }
                                this.wasFinished = true;
                            }
                        });
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LongRunningTaskInfo taskInfoClone = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskInfo.getUid());
                this.log.error(String.format("an unexpected error has occurred for task %s", taskInfoClone.getDescription()), (Throwable)e);
                taskInfoClone.setState(LongRunningTaskInfo.State.STOPPED);
                taskInfoClone.setEndDate(new Date());
                taskInfoClone.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)e.getMessage(), (Throwable)e, (Object[])new Object[0]), LogicalStorage.get().getUser());
                AssetsStorage.get().save((BaseAsset)taskInfoClone);
            }
        }
    }

    public <S extends Serializable, T extends LongRunningTask<S>> LongRunningTaskInfo addTask(Class<T> cls, Date startDate, S configuration) throws Exception {
        return this.addTask(cls, startDate, null, configuration);
    }

    public <S extends Serializable, T extends LongRunningTask<S>> LongRunningTaskInfo addTask(Class<T> cls, Date startDate, String instance, S configuration) throws Exception {
        return this.addTask(cls, startDate, instance, configuration, false);
    }

    public <S extends Serializable, T extends LongRunningTask<S>> LongRunningTaskInfo addTask(Class<T> cls, Date startDate, String instance, S configuration, boolean startImmediately) throws Exception {
        this.log.debug(String.format("adding task %s: startDate = %s", cls.getName(), startDate));
        LongRunningTask task = (LongRunningTask)cls.newInstance();
        task.configure(configuration);
        LongRunningTaskInfo info = new LongRunningTaskInfo();
        info.setCreated(new Date());
        info.setDescription(task.getDescription());
        info.setIndefinite(task.isIndefinite());
        info.setSingleton(task.isSingleton());
        if (configuration instanceof XSerializable) {
            info.setConfiguration((XSerializable)configuration);
        }
        info.setProgress((byte)0);
        info.setStartDate(startDate);
        info.setInstance(instance);
        info.setState(LongRunningTaskInfo.State.NEW);
        info.setTaskClassName(cls.getName());
        info.setCreatedBy(LogicalStorage.get().getUser());
        info.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskAdded, (Object[])new Object[0]), LogicalStorage.get().getUser());
        TemporalObject obj = new TemporalObject();
        obj.setExpired(new Date((startDate != null ? startDate.getTime() : info.getCreated().getTime()) + 2592000000L));
        obj.setReferenceUid(info.getUid());
        obj.setTag("long-running-task");
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)task, (OutputStream)strm);
        obj.setData(GZIPUtil.gzip((byte[])strm.toByteArray()));
        AssetsStorage.get().save((BaseAsset)obj);
        AssetsStorage.get().save((BaseAsset)info);
        this.log.debug(String.format("added task %s: startDate = %s", cls.getName(), startDate));
        if (startImmediately) {
            this.updateRunningTasks();
        }
        return info;
    }

    private void stopTask(String taskUid, LongRunningTaskInfo.State newState) throws Exception {
        this.log.debug(String.format("stopping task with uid = %s", taskUid));
        LongRunningTaskInfo taskInfo = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
        this.checkForStop(taskInfo, taskUid);
        if (Environment.getApplicationId().equals(taskInfo.getServerId())) {
            this.stopTaskInternal(taskInfo, newState);
            return;
        }
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(stopTopicId, (Object)new StopTaskData(taskInfo, newState));
        boolean stopped = this.isStopped(taskInfo.getUid());
        if (stopped) {
            return;
        }
        throw new Exception("unable to stop task " + taskUid);
    }

    private boolean isStopped(String taskUid) {
        long start = System.currentTimeMillis();
        int timeout = -1;
        do {
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1000L));
                LongRunningTaskInfo info = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
                if (info == null) {
                    this.log.warn(String.format("task with uid %s was not found", taskUid));
                    return true;
                }
                if (timeout == -1) {
                    try {
                        timeout = ((LongRunningTask)XHelper.getClass((String)info.getTaskClassName()).newInstance()).getStopTimeoutInSeconds();
                    }
                    catch (Exception e) {
                        this.log.error("unable to create instance of " + info.getClass().getName(), (Throwable)e);
                        timeout = 30;
                    }
                }
                if (info.getState() != LongRunningTaskInfo.State.RUNNING) {
                    return true;
                }
            }
            catch (InterruptedException e) {
                this.log.error("catched interrupted exception", (Throwable)e);
            }
        } while (TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) < (long)(2 * timeout));
        return true;
    }

    private void stopTaskInternal(LongRunningTaskInfo taskInfo, final LongRunningTaskInfo.State newState) throws Exception {
        final String taskUid = taskInfo.getUid();
        this.withLock(taskInfo, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LongRunningTaskInfo taskInfoCloned = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
                LongRunningTasksManager.this.checkForStop(taskInfoCloned, taskUid);
                LongRunningTask<?> task = LongRunningTasksManager.this.rtm.getTask(taskUid);
                int timeout = 30;
                try {
                    timeout = ((LongRunningTask)XHelper.getClass((String)taskInfoCloned.getTaskClassName()).newInstance()).getStopTimeoutInSeconds();
                }
                catch (Exception e) {
                    LongRunningTasksManager.this.log.error("unable to create instance of " + taskInfoCloned.getClass().getName(), (Throwable)e);
                }
                if (!LongRunningTasksManager.this.rtm.stopLocalTask(taskInfoCloned, timeout)) {
                    IncidentsLog.reportStackTrace((String)String.format("task scheduled by %s at %s is unstoppable: %s", taskInfoCloned.getCreatedBy(), taskInfoCloned.getCreated(), taskInfoCloned.getTaskClassName()));
                    throw new Exception("unable to stop task " + taskUid);
                }
                taskInfoCloned = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
                TemporalObject obj = LongRunningTasksManager.this.findTemporalObject(taskInfoCloned.getUid());
                if (obj == null || task == null) {
                    LongRunningTasksManager.this.log.warn("task runtime was not found");
                    taskInfoCloned.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.LongRunningTasksManager_taskNotFound, (Object[])new Object[0]), UserData.get().getCurrentUser());
                    taskInfoCloned.setState(LongRunningTaskInfo.State.COMPLETED);
                    taskInfoCloned.setProgress((byte)100);
                } else {
                    LongRunningTasksManager.this.log.warn("task is stopped");
                    taskInfoCloned.setState(newState);
                    taskInfoCloned.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskStoped, (Object[])new Object[0]), LogicalStorage.get().getUser());
                    ByteArrayOutputStream strm = new ByteArrayOutputStream();
                    XUtil.serialize(task, (OutputStream)strm);
                    obj.setData(GZIPUtil.gzip((byte[])strm.toByteArray()));
                    AssetsStorage.get().save((BaseAsset)obj);
                }
                AssetsStorage.get().save((BaseAsset)taskInfoCloned);
                return null;
            }
        });
    }

    public void stopTask(String taskUid) throws Exception {
        this.stopTask(taskUid, LongRunningTaskInfo.State.STOPPED);
    }

    void checkForStop(LongRunningTaskInfo taskInfo, String taskUid) throws Exception {
        if (taskInfo == null) {
            throw Xeption.forEndUser((String)Messages.LongRunningTasksManager_taskNotFound, (Object[])new Object[]{taskUid});
        }
        if (taskInfo.getState() != LongRunningTaskInfo.State.RUNNING) {
            throw Xeption.forEndUser((String)Messages.LongRunningTasksManager_tastNotRunned, (Object[])new Object[]{taskUid});
        }
    }

    TemporalObject findTemporalObject(String uid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.referenceUid.name(), (Object)uid));
        List data = AssetsStorage.get().search(TemporalObject.class, query).getData();
        return data.isEmpty() ? null : (TemporalObject)data.get(0);
    }

    public void resumeTask(final String taskUid) throws Exception {
        this.log.debug(String.format("resuming task with uid = %s", taskUid));
        LongRunningTaskInfo info = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
        this.checkForResume(info, taskUid);
        this.withLock(info, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LongRunningTaskInfo infoCloned = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
                LongRunningTasksManager.this.checkForResume(infoCloned, taskUid);
                LongRunningTasksManager.this.log.debug(String.format("task found: %s", infoCloned.getDescription()));
                infoCloned.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_taskRestarted, (Object[])new Object[0]), LogicalStorage.get().getUser());
                infoCloned.getEvents().add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.LongRunningTasksManager_serverId, (Object[])new Object[]{Environment.getApplicationId()}), LogicalStorage.get().getUser());
                infoCloned.setState(LongRunningTaskInfo.State.NEW);
                AssetsStorage.get().save((BaseAsset)infoCloned);
                return null;
            }
        });
    }

    void checkForResume(LongRunningTaskInfo info, String taskUid) throws Exception {
        if (info == null) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.LongRunningTasksManager_taskNotFound, (Object[])new Object[]{taskUid}));
        }
        if (info.getState() == LongRunningTaskInfo.State.RUNNING) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.LongRunningTasksManager_taskNotStopped, (Object[])new Object[]{taskUid}));
        }
        if (info.getState() == LongRunningTaskInfo.State.COMPLETED) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.LongRunningTasksManager_taskFinished, (Object[])new Object[]{taskUid}));
        }
    }

    public void deleteTask(final String taskUid) throws Exception {
        this.log.debug(String.format("deleting task with uid = %s", taskUid));
        LongRunningTaskInfo info = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
        this.checkForDelete(info, taskUid);
        this.withLock(info, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LongRunningTaskInfo infoCloned = (LongRunningTaskInfo)AssetsStorage.get().load(LongRunningTaskInfo.class, taskUid);
                LongRunningTasksManager.this.checkForDelete(infoCloned, taskUid);
                LongRunningTasksManager.this.log.debug(String.format("task found: %s", infoCloned.getDescription()));
                AssetsStorage.get().delete((BaseAsset)infoCloned);
                LongRunningTasksManager.this.deleteTemporalObject(taskUid);
                return null;
            }
        });
    }

    void checkForDelete(LongRunningTaskInfo info, String taskUid) throws Exception {
        if (info == null) {
            throw new Exception(L10nResourcesManager.getStr((String)Messages.LongRunningTasksManager_taskNotFound, (Object[])new Object[]{taskUid}));
        }
        if (info.getState() == LongRunningTaskInfo.State.RUNNING) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)Messages.LongRunningTasksManager_taskNotStopped, (Object[])new Object[]{info.getDescription()}), (Object[])new Object[0]);
        }
    }

    void deleteTemporalObject(String uid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.referenceUid.name(), (Object)uid));
        for (TemporalObject obj : AssetsStorage.get().search(TemporalObject.class, query).getData()) {
            AssetsStorage.get().delete((BaseAsset)obj);
        }
    }

    public void pauseAllTasks() throws Exception {
        this.log.debug("stoping all tasks");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.RUNNING));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.serverId.name(), (Object)Environment.getApplicationId()));
        for (LongRunningTaskInfo task : AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData()) {
            this.stopTask(task.getUid(), LongRunningTaskInfo.State.PAUSED);
        }
    }

    public void dispose() {
        this.log.debug("disposing");
        this.disposed = true;
        try {
            this.pauseAllTasks();
            this.rtm.dipose();
            this.log.info("disposed");
        }
        catch (Throwable e) {
            this.log.error("unable to stop tasks", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock(String taskUid) {
        boolean bl;
        LockManager lockManager = LockUtil.getLockManager();
        NamedLock lock = lockManager.getLock((Object)String.format("%s_%s", LOCK_ID_PREFFIX, taskUid), 60000L);
        try {
            bl = lock.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            try {
                lock.close();
                throw throwable;
            }
            catch (Exception e) {
                this.log.error("unable to get lock for task " + taskUid, (Throwable)e);
                return false;
            }
        }
        lock.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(String taskUid) {
        try {
            LockManager lockManager = LockUtil.getLockManager();
            try (NamedLock lock = lockManager.getLock((Object)String.format("%s_%s", LOCK_ID_PREFFIX, taskUid), 60000L);){
                lock.unlock();
            }
        }
        catch (Exception e) {
            this.log.error("unable to release lock for task " + taskUid, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(LongRunningTaskInfo taskInfo, Callable<T> executable) throws Exception {
        if (!this.tryLock(taskInfo.getUid())) {
            this.log.warn(String.format("unable to get lock for task %s: %s", taskInfo.getDescription(), taskInfo.getUid()));
            return null;
        }
        try {
            T t = executable.call();
            return t;
        }
        finally {
            this.releaseLock(taskInfo.getUid());
        }
    }
}

