/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.system.lrt.LongRunningTasksSettings;
import com.gridnine.xtrip.common.model.system.lrt.WorkingPeriod;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTaskLauncherTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import java.util.Calendar;
import java.util.List;

public class LongRunningTasksSchedulerTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        EntityContainer ctr = EntityStorage.get().resolve(new EntityReference("long-running-tasks-settings-uid", LongRunningTasksSettings.class, null));
        if (ctr == null) {
            this.log.warn("LRT settings is absent in db");
            return;
        }
        if (((LongRunningTasksSettings)ctr.getEntity()).getWorkingPeriods().isEmpty()) {
            return;
        }
        EntityContainer<ScheduledTaskSettings> taskSettingsCtr = this.getScheduledTaskSettings();
        if (taskSettingsCtr == null) {
            this.log.warn("unable to find task setting ctr");
            return;
        }
        boolean mustWork = this.isWorkingTime(((LongRunningTasksSettings)ctr.getEntity()).getWorkingPeriods());
        if (mustWork) {
            if (!((ScheduledTaskSettings)taskSettingsCtr.getEntity()).isEnabled()) {
                ((ScheduledTaskSettings)taskSettingsCtr.getEntity()).setEnabled(true);
                EntityStorage.get().save(taskSettingsCtr, false);
            }
            return;
        }
        if (((ScheduledTaskSettings)taskSettingsCtr.getEntity()).isEnabled()) {
            ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).pauseAllTasks();
            ((ScheduledTaskSettings)taskSettingsCtr.getEntity()).setEnabled(false);
            EntityStorage.get().save(taskSettingsCtr, false);
            return;
        }
        if (!this.needRecheck(((LongRunningTasksSettings)ctr.getEntity()).getWorkingPeriods())) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.serverId.name(), (Object)Environment.getApplicationId()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.RUNNING));
        query.setResultMode(ResultMode.COUNT_ONLY);
        if (AssetsStorage.get().search(LongRunningTaskInfo.class, query).getTotalCount() > 0) {
            ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).pauseAllTasks();
        }
    }

    private boolean needRecheck(List<WorkingPeriod> workingPeriods) {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        for (WorkingPeriod item : workingPeriods) {
            if (hour != item.getEndHour() - 1 || calendar.get(12) >= 5) continue;
            return true;
        }
        return false;
    }

    private EntityContainer<ScheduledTaskSettings> getScheduledTaskSettings() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        for (BasicSystemSettingsIndex idx : EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            if (ctr == null || !(ctr.getEntity() instanceof ScheduledTaskSettings)) continue;
            ScheduledTaskSettings new_name = (ScheduledTaskSettings)ctr.getEntity();
            if (!LongRunningTaskLauncherTask.class.getName().equals(new_name.getJobClass())) continue;
            return ctr;
        }
        return null;
    }

    private boolean isWorkingTime(List<WorkingPeriod> workingPeriods) {
        Calendar calendar = Calendar.getInstance();
        Integer day = this.toMidofficeDay(calendar.get(7));
        int hour = calendar.get(11);
        for (WorkingPeriod item : workingPeriods) {
            if (!item.getDaysOfWeek().contains(day) || item.getBeginHour() > hour || item.getEndHour() < hour) continue;
            return true;
        }
        return false;
    }

    private Integer toMidofficeDay(int i) {
        switch (i) {
            case 2: {
                return WeekDay.MONDAY.ordinal();
            }
            case 3: {
                return WeekDay.TUESDAY.ordinal();
            }
            case 4: {
                return WeekDay.WEDNESDAY.ordinal();
            }
            case 5: {
                return WeekDay.THURSDAY.ordinal();
            }
            case 6: {
                return WeekDay.FRIDAY.ordinal();
            }
            case 7: {
                return WeekDay.SATURDAY.ordinal();
            }
        }
        return WeekDay.SUNDAY.ordinal();
    }

    protected boolean isSystem() {
        return true;
    }
}

