/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks;

import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunningTasksManager {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, Thread> localRunningThreads = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LongRunningTask<?>> localRunningTasks = new ConcurrentHashMap();

    RunningTasksManager() {
    }

    public void startLocalTask(final LongRunningTaskInfo taskInfo, final LongRunningTask<?> task, final LongRunningTask.EventsCallback eventsCallback) {
        Thread thread = new Thread(String.format("LRT_%s", taskInfo.getDescription())){

            @Override
            public void run() {
                try {
                    RunningTasksManager.this.log.debug("task started " + taskInfo.getUid());
                    LogicalStorage.get().authorizeAsSystem();
                    task.start(eventsCallback);
                    RunningTasksManager.this.log.debug(String.format("task %s finished", task.getDescription()));
                }
                catch (Throwable e) {
                    RunningTasksManager.this.log.error("exception while executing task " + task.getDescription(), e);
                    eventsCallback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseLongRunningTask_onRunningTaskAppearError, (Throwable)e, (Object[])new Object[0]));
                    eventsCallback.taskFinishedWithError(e);
                }
                finally {
                    RunningTasksManager.this.removeTaskFromLocalRegistry(taskInfo.getUid());
                    LogicalStorage.reset();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.localRunningThreads.put(taskInfo.getUid(), thread);
        this.localRunningTasks.put(taskInfo.getUid(), task);
    }

    private void removeTaskFromLocalRegistry(String taskUid) {
        this.localRunningThreads.remove(taskUid);
        this.localRunningTasks.remove(taskUid);
    }

    public boolean stopLocalTask(LongRunningTaskInfo taskInfo, int stopWaitPeriodInSeconds) throws Exception {
        String uid = taskInfo.getUid();
        LongRunningTask<?> task = this.localRunningTasks.get(uid);
        if (task == null) {
            this.removeTaskFromLocalRegistry(uid);
            return true;
        }
        task.stop();
        this.isStopped(uid, stopWaitPeriodInSeconds);
        Thread thread = this.localRunningThreads.get(uid);
        if (thread == null) {
            this.removeTaskFromLocalRegistry(uid);
            return true;
        }
        try {
            thread.interrupt();
            Thread.sleep(1000L);
            if (thread.isAlive()) {
                this.log.debug(String.format("task scheduled by %s at %s is unstoppable: %s, stacktrace:\n%s", taskInfo.getCreatedBy(), taskInfo.getCreated(), taskInfo.getTaskClassName(), DebugUtil.getStackTrace((Thread)thread)));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.removeTaskFromLocalRegistry(uid);
            return true;
        }
    }

    private boolean isStopped(String uid, int period) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                if (this.localRunningTasks.get(uid) == null) {
                    return true;
                }
            }
            catch (InterruptedException e) {
                this.log.error("catched interrupted exception", (Throwable)e);
            }
        } while (TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) < (long)period);
        return false;
    }

    void dipose() {
        for (Thread item : this.localRunningThreads.values()) {
            try {
                item.interrupt();
            }
            catch (ThreadDeath e) {
                this.log.error("unable to stop thread " + item.getId(), (Throwable)e);
            }
        }
    }

    boolean isTaskAlive(String taskUid) {
        Thread thread = this.localRunningThreads.get(taskUid);
        return thread != null && thread.isAlive();
    }

    LongRunningTask<?> getTask(String taskUid) {
        return this.localRunningTasks.get(taskUid);
    }
}

