/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.tasks.geolocation.IataTZmapProviderConfig;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationTZdataProvider;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoNamesTzProvider
implements GeolocationTZdataProvider<IataTZmapProviderConfig> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    String url;
    String encoding;
    String splitRegex;

    public static void main(String[] argc) throws Exception {
        GeoNamesTzProvider p = new GeoNamesTzProvider();
        p.url = "file:///c:\\work\\cities15000.txt";
    }

    @Override
    public Map<String, String> getData() throws Exception {
        this.log.debug("begin");
        URLConnection connection = new URL(this.url).openConnection();
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.connect();
        List lines = IOUtils.readLines((InputStream)connection.getInputStream(), (String)this.encoding);
        ArrayList<Object> dd = new ArrayList<Object>();
        for (String line : lines) {
            String[] rawNames;
            char c;
            Data data = new Data();
            boolean fNumber = false;
            boolean bl = false;
            ArrayList<String> names = new ArrayList<String>();
            data.setNames(names);
            StringBuilder namesTokenBuilder = new StringBuilder();
            for (int i = 0; i < line.length(); ++i) {
                char c2 = line.charAt(i);
                if (Character.isDigit(c2) && !fNumber) continue;
                fNumber = true;
                if (!Character.isLetter(c2) && !bl) continue;
                bl = true;
                if (Character.isDigit(c2) || c2 == '-' && Character.isDigit(line.charAt(i + 1))) break;
                namesTokenBuilder.append(c2);
            }
            StringBuilder tzTokenBuilder = new StringBuilder();
            int i = line.length() - 11;
            while (!Character.isDigit(c = line.charAt(i))) {
                tzTokenBuilder.insert(0, c);
                --i;
            }
            for (String rawName : rawNames = namesTokenBuilder.toString().split(",")) {
                names.add(rawName.trim());
            }
            data.setTimeZoneId(tzTokenBuilder.toString().trim());
            dd.add(data);
        }
        Map<String, GeoLocation> all = this.getAll();
        HashMap<String, GeoLocation> trans = new HashMap<String, GeoLocation>();
        for (GeoLocation geo : all.values()) {
            for (String translation : geo.getTranslations().values()) {
                trans.put(translation, geo);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        block6: for (Data data : dd) {
            for (String name : data.getNames()) {
                GeoLocation geo = (GeoLocation)trans.get(name);
                if (geo == null) continue;
                this.log.debug("found geolocation for " + name);
                result.put(geo.getCode(), data.getTimeZoneId());
                continue block6;
            }
        }
        this.log.debug("end");
        return result;
    }

    protected Map<String, GeoLocation> getAll() {
        DictionaryCache cache = DictionaryCache.get();
        Map all = cache.getAll(GeoLocation.class);
        return all;
    }

    @Override
    public void configure(IataTZmapProviderConfig config) {
        this.url = config.getUrl();
        this.encoding = StringUtils.isBlank((String)config.getEncoding()) ? "utf-8" : config.getEncoding();
        this.splitRegex = StringUtils.isBlank((String)config.getSplitRegex()) ? "\t" : config.getSplitRegex();
    }

    static class Data {
        List<String> names;
        String timeZoneId;

        Data() {
        }

        public List<String> getNames() {
            return this.names;
        }

        public void setNames(List<String> names) {
            this.names = names;
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }
    }
}

