/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.model.setup.ModelSetupProcedure;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeoNamesTzProvider;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.setup.SetupHandler;
import com.gridnine.xtrip.server.setup.SetupManager;
import com.gridnine.xtrip.server.setup.primary.PrimarySetupProcedure;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class GeoNamesTzTest
extends ModelTestBase {
    Map<String, GeoLocation> getAll() throws IOException {
        List reportLines = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("report.txt"));
        DictionaryCache cache = DictionaryCache.get();
        HashMap<String, GeoLocation> result = new HashMap<String, GeoLocation>();
        int limit = 50;
        int c = 0;
        for (String line : reportLines) {
            if (++c < 3) continue;
            if (c >= limit) break;
            String code = line.substring(0, 15).trim();
            GeoLocation geo = (GeoLocation)cache.findByCode(GeoLocation.class, code);
            if (geo == null) continue;
            result.put(code, geo);
        }
        return result;
    }

    @Ignore
    @Test
    public void test() throws Exception {
        GeoNamesTzProvider p = (GeoNamesTzProvider)EasyMock.createMockBuilder(GeoNamesTzProvider.class).addMockedMethod("getAll").createMock();
        Field logField = GeoNamesTzProvider.class.getDeclaredField("log");
        logField.setAccessible(true);
        logField.set(p, LoggerFactory.getLogger(p.getClass()));
        EasyMock.expect(p.getAll()).andReturn(this.getAll());
        EasyMock.replay((Object[])new Object[]{p});
        p.url = "file:///c:\\work\\cities15000.txt";
        Map<String, String> data = p.getData();
        for (String key : data.keySet()) {
            String val = data.get(key);
            System.out.println(String.format("%s -> %s", key, val));
        }
        Assert.assertTrue((boolean)false);
    }

    URL getGeolocations() {
        try {
            return new URL("file:///c:\\work\\data.zip");
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
            return null;
        }
    }

    protected void registerSetupHandlers(SetupManager sm) {
        sm.registerHandler((SetupHandler)new PrimarySetupProcedure());
        sm.registerHandler((SetupHandler)new ModelSetupProcedure(){

            protected Collection<URL> getAssetSetupFiles() throws Exception {
                return Collections.singletonList(GeoNamesTzTest.this.getAssetsSetupFile());
            }

            protected Collection<URL> getDictionarySetupFiles() {
                return GeoNamesTzTest.this.collectURLs(GeoNamesTzTest.this.getGeolocations());
            }

            protected Collection<URL> getEntitySetupFiles() {
                return GeoNamesTzTest.this.collectURLs(GeoNamesTzTest.this.getEntitiesSetupFile());
            }
        });
    }
}

