/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.tasks.geolocation.GeolocationTZproviderConfig;
import com.gridnine.xtrip.common.model.tasks.geolocation.GeolocationTZproviderTypes;
import com.gridnine.xtrip.common.model.tasks.geolocation.GeolocationsTimeZoneTaskConfiguration;
import com.gridnine.xtrip.common.model.tasks.geolocation.IataTZmapProviderConfig;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationTZdataProvidersRegistry;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationsTimeZoneTask;
import com.gridnine.xtrip.server.model.tasks.geolocation.IataTZmapProvider;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class GeolocationTZtaskTest
extends ModelTestBase {
    private Map<String, String> getData() throws Exception {
        String splitRegex = "\t";
        List lines = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("iata.tzmap"));
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines) {
            String[] chunks = line.split(splitRegex);
            if (chunks.length != 2 || StringUtils.isBlank((String)chunks[0]) || StringUtils.isBlank((String)chunks[1])) continue;
            result.put(chunks[0], chunks[1]);
        }
        return result;
    }

    protected URL getDictionariesSetupFile() {
        return ResourceUtil.getResource(((Object)((Object)this)).getClass(), (String)"dict.xml");
    }

    public void setUp() throws Exception {
        super.setUp();
        IataTZmapProvider mock = (IataTZmapProvider)EasyMock.createMockBuilder(IataTZmapProvider.class).addMockedMethod("getData").createMock();
        EasyMock.expect(mock.getData()).andReturn(this.getData());
        GeolocationTZdataProvidersRegistry registry = new GeolocationTZdataProvidersRegistry();
        registry.registerProvider(GeolocationTZproviderTypes.IATA_TZMAP.name(), mock);
        Environment.publish((Object)registry);
        EasyMock.replay((Object[])new Object[]{mock});
    }

    @Test
    public void testNoOverwrite() throws Exception {
        GeolocationsTimeZoneTask task = new GeolocationsTimeZoneTask();
        GeolocationsTimeZoneTaskConfiguration cfg = new GeolocationsTimeZoneTaskConfiguration();
        IataTZmapProviderConfig providerCfg = new IataTZmapProviderConfig();
        cfg.setDataProviderConfig((GeolocationTZproviderConfig)providerCfg);
        cfg.setType(GeolocationTZproviderTypes.IATA_TZMAP.name());
        task.configure(cfg);
        task.doJob(new EventsCallbackStub());
        DictionaryCache cache = DictionaryCache.get();
        Map geos = cache.getAll(GeoLocation.class);
        TreeSet<String> result = new TreeSet<String>();
        for (Object geo : geos.values()) {
            result.add(String.format("%s-%s", geo.getCode(), StringUtils.defaultString((String)geo.getTimeZoneId())));
        }
        StringBuilder sb = new StringBuilder();
        for (String r : result) {
            sb.append(r).append("\r\n");
        }
        String exp = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("expectNoOverwrite.txt"));
        Assert.assertEquals((Object)exp, (Object)sb.toString().trim());
    }

    @Test
    public void testOverwrite() throws Exception {
        GeolocationsTimeZoneTask task = new GeolocationsTimeZoneTask();
        GeolocationsTimeZoneTaskConfiguration cfg = new GeolocationsTimeZoneTaskConfiguration();
        cfg.setOverwrite(true);
        IataTZmapProviderConfig providerCfg = new IataTZmapProviderConfig();
        cfg.setDataProviderConfig((GeolocationTZproviderConfig)providerCfg);
        cfg.setType(GeolocationTZproviderTypes.IATA_TZMAP.name());
        task.configure(cfg);
        task.doJob(new EventsCallbackStub());
        DictionaryCache cache = DictionaryCache.get();
        Map geos = cache.getAll(GeoLocation.class);
        TreeSet<String> result = new TreeSet<String>();
        for (Object geo : geos.values()) {
            result.add(String.format("%s-%s", geo.getCode(), StringUtils.defaultString((String)geo.getTimeZoneId())));
        }
        StringBuilder sb = new StringBuilder();
        for (String r : result) {
            sb.append(r).append("\r\n");
        }
        String exp = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("expectOverwrite.txt"));
        Assert.assertEquals((Object)exp, (Object)sb.toString().trim());
    }

    static class EventsCallbackStub
    implements LongRunningTask.EventsCallback {
        EventsCallbackStub() {
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }

        @Override
        public void taskFinished() {
        }
    }
}

