/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.geolocation.GeolocationsTimeZoneTaskConfiguration;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationTZdataProvider;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationTZdataProvidersRegistry;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class GeolocationsTimeZoneTask
extends BaseLongRunningTask<GeolocationsTimeZoneTaskConfiguration> {
    private GeolocationsTimeZoneTaskConfiguration configuration;

    @Override
    public void configure(GeolocationsTimeZoneTaskConfiguration cfg) throws Exception {
        this.configuration = cfg;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.geolocationsTimeZoneTaskDescription, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)XProperties.configuration.name(), (Object)this.configuration);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (GeolocationsTimeZoneTaskConfiguration)XHelper.readObject((Element)elm, (String)XProperties.configuration.name());
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("begin");
        if (this.configuration == null) {
            this.log.error("task is not configured");
            return;
        }
        if (this.configuration.getDataProviderConfig() == null) {
            this.log.error("data provider not configured");
            return;
        }
        GeolocationTZdataProvider<?> provider = ((GeolocationTZdataProvidersRegistry)Environment.getPublished(GeolocationTZdataProvidersRegistry.class)).getProvider(this.configuration.getType());
        if (provider == null) {
            this.log.error("tz data provider not found");
            return;
        }
        provider.configure(this.configuration.getDataProviderConfig());
        Map<String, String> data = provider.getData();
        if (data == null) {
            this.log.warn("data is null");
            return;
        }
        DictionaryCache cache = DictionaryCache.get();
        DictionaryStorage storage = DictionaryStorage.get();
        int count = data.size();
        int n = 0;
        int updated = 0;
        int notfound = 0;
        callback.updateProgress((byte)0);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            GeoLocation geo;
            Object geoLocation2;
            String locationCode = entry.getKey();
            String timeZoneId = entry.getValue();
            callback.updateProgress((byte)(100 * ++n / count));
            if (this.isToBeStopped()) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"stop task requested", (Object[])new Object[0]));
                break;
            }
            Set geoLocations = cache.lookup(GeoLocation.class, locationCode, new String[]{CodeSystem.IATA.name()});
            for (Object geoLocation2 : geoLocations) {
                if (geoLocation2.getType() != LocationType.CITY && geoLocation2.getType() != LocationType.AIRPORT) continue;
                if (!StringUtils.isBlank((String)geoLocation2.getTimeZoneId())) {
                    if (geoLocation2.getTimeZoneId().equals(timeZoneId) || !this.configuration.isOverwrite()) continue;
                    geoLocation2.setTimeZoneId(timeZoneId);
                    geoLocation2.setDataSource("GeolocationsTimeZoneTask");
                    storage.save((BaseDictionary)geoLocation2);
                    ++updated;
                    this.logUpdateLocation((GeoLocation)geoLocation2);
                    continue;
                }
                geoLocation2.setTimeZoneId(timeZoneId);
                geoLocation2.setDataSource("GeolocationsTimeZoneTask");
                storage.save((BaseDictionary)geoLocation2);
                ++updated;
                this.logUpdateLocation((GeoLocation)geoLocation2);
            }
            GeoLocation geoLocation3 = null;
            geoLocation2 = geoLocations.iterator();
            while (geoLocation2.hasNext()) {
                geo = (GeoLocation)geoLocation2.next();
                if (geo.getType() != LocationType.CITY) continue;
                geoLocation3 = geo;
                break;
            }
            if (geoLocation3 == null) {
                geoLocation2 = geoLocations.iterator();
                while (geoLocation2.hasNext()) {
                    geo = (GeoLocation)geoLocation2.next();
                    if (geo.getType() != LocationType.AIRPORT) continue;
                    geoLocation3 = geo;
                    break;
                }
            }
            if (null == geoLocation3) {
                ++notfound;
                this.logLocationNotFound(locationCode);
                continue;
            }
            GeoLocation parent = null;
            if (geoLocation3.getType() == LocationType.AIRPORT) {
                if (geoLocation3.getParent() != null) {
                    GeoLocation loc = (GeoLocation)cache.resolveReference(geoLocation3.getParent());
                    if (loc == null) {
                        ++notfound;
                        this.logLocationNotFound(geoLocation3.getParent().getCode());
                    } else {
                        parent = loc;
                        if (StringUtils.isBlank((String)parent.getTimeZoneId())) {
                            parent.setTimeZoneId(timeZoneId);
                            parent.setDataSource("GeolocationsTimeZoneTask");
                            storage.save((BaseDictionary)parent);
                            ++updated;
                            this.logUpdateLocation(parent);
                        }
                    }
                }
            } else if (geoLocation3.getType() == LocationType.CITY) {
                parent = geoLocation3;
            }
            if (parent == null) continue;
            List airports = DictHelper.findAirportsByCity((DictionaryReference)parent.toReference());
            for (DictionaryReference airportRef : airports) {
                if (airportRef == null || geoLocation3.getType() == LocationType.AIRPORT && airportRef.equals((Object)geoLocation3.toReference())) continue;
                GeoLocation airport = (GeoLocation)cache.resolveReference(airportRef);
                if (airport == null) {
                    ++notfound;
                    this.logLocationNotFound(airportRef.getCode());
                    continue;
                }
                if (!StringUtils.isBlank((String)airport.getTimeZoneId())) continue;
                airport.setTimeZoneId(timeZoneId);
                airport.setDataSource("GeolocationsTimeZoneTask");
                storage.save((BaseDictionary)airport);
                ++updated;
                this.logUpdateLocation(airport);
            }
        }
        String result = String.format("end. updated locations: %d, not found: %d", updated, notfound);
        callback.updateProgress((byte)100);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)result, (Object[])new Object[0]));
        this.log.debug(result);
    }

    private void logLocationNotFound(String locationCode) {
        this.log.warn(String.format("location with code %s not found", locationCode));
    }

    private void logUpdateLocation(GeoLocation loc) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("updated timeZoneId for " + loc.getCode());
        }
    }

    private static enum XProperties {
        configuration;

    }
}

