/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.model.tasks.geolocation.IataTZmapProviderConfig;
import com.gridnine.xtrip.server.model.tasks.geolocation.GeolocationTZdataProvider;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IataTZmapProvider
implements GeolocationTZdataProvider<IataTZmapProviderConfig> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    String url;
    String encoding;
    String splitRegex;

    @Override
    public Map<String, String> getData() throws Exception {
        this.log.debug("begin");
        URLConnection connection = new URL(this.url).openConnection();
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.connect();
        List lines = IOUtils.readLines((InputStream)connection.getInputStream(), (String)this.encoding);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines) {
            String[] chunks = line.split(this.splitRegex);
            if (chunks.length != 2) {
                this.log.error("invalid number of chunks");
                continue;
            }
            if (StringUtils.isBlank((String)chunks[0]) || StringUtils.isBlank((String)chunks[1])) {
                this.log.error("invalid chunks");
                continue;
            }
            result.put(chunks[0], chunks[1]);
        }
        this.log.debug("end");
        return result;
    }

    @Override
    public void configure(IataTZmapProviderConfig config) {
        this.url = config.getUrl();
        this.encoding = StringUtils.isBlank((String)config.getEncoding()) ? "utf-8" : config.getEncoding();
        this.splitRegex = StringUtils.isBlank((String)config.getSplitRegex()) ? "\t" : config.getSplitRegex();
    }
}

