/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.geolocation;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.UpdateGeoLocationRegionsTaskConfiguration;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Element;

public class UpdateGeoLocationRegionsTask
extends BaseLongRunningTask<UpdateGeoLocationRegionsTaskConfiguration> {
    @Override
    public void configure(UpdateGeoLocationRegionsTaskConfiguration configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(UpdateGeoLocationRegionsTaskConfiguration.class), (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        GeoRegionReference ruRef = this.checkRegion("RUE", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0438\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0420\u043e\u0441\u0441\u0438\u0438", "European region of Russia");
        GeoRegionReference xuRef = this.checkRegion("XU", "\u0410\u0437\u0438\u0430\u0442\u0441\u043a\u0438\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0420\u043e\u0441\u0441\u0438\u0438", "Asian region of Russia");
        int result = this.processFile("xu-geolocations.txt", xuRef, callback) + this.processFile("ru-geolocations.txt", ruRef, callback);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (Object[])new Object[]{result}));
        callback.taskFinished();
    }

    private int processFile(String fileName, GeoRegionReference regionRef, LongRunningTask.EventsCallback callback) throws Exception {
        File file = IoUtil.url2file((URL)this.getClass().getResource(fileName));
        List codes = FileUtils.readLines((File)file);
        int result = 0;
        for (String code : codes) {
            Set originalSet = DictionaryCache.get().lookup(GeoLocation.class, code, new String[]{CodeSystem.IATA.name()});
            HashSet<GeoLocation> locations = new HashSet<GeoLocation>(originalSet);
            if (locations.isEmpty()) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0443\u043d\u043a\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c {0}", (Object[])new Object[]{code}));
                continue;
            }
            for (GeoLocation loc : originalSet) {
                if (loc.getType() == LocationType.AIRPORT) {
                    GeoLocation parent = (GeoLocation)DictionaryCache.get().resolveReference(loc.getParent());
                    if (parent == null) continue;
                    locations.add(parent);
                    continue;
                }
                if (loc.getType() != LocationType.CITY) continue;
                List airportsRefs = DictHelper.findAirportsByCity((DictionaryReference)loc.toReference());
                for (DictionaryReference airportRef : airportsRefs) {
                    GeoLocation airport = (GeoLocation)DictionaryCache.get().resolveReference(airportRef);
                    if (airport == null) continue;
                    locations.add(airport);
                }
            }
            for (GeoLocation loc : locations) {
                loc.getRegions().clear();
                loc.getRegions().add(regionRef);
                loc.setDataSource("UpdateGeoLocationRegionsTask");
                DictionaryStorage.get().save((BaseDictionary)loc);
                ++result;
            }
        }
        return result;
    }

    private GeoRegionReference checkRegion(String code, String russianName, String englishName) throws Exception {
        GeoRegionReference ref = new GeoRegionReference(code);
        GeoRegion dict = (GeoRegion)DictionaryCache.get().resolveReference((DictionaryReference)ref);
        if (dict != null) {
            return ref;
        }
        dict = new GeoRegion();
        dict.setCode(code);
        dict.getTranslations().put(new Locale("ru"), russianName);
        dict.getTranslations().put(new Locale("en"), englishName);
        dict.getCodeVariants().put(CodeSystem.IATA.name(), code);
        dict.setDataSource("UpdateGeoLocationRegionsTask");
        DictionaryStorage.get().save((BaseDictionary)dict);
        return dict.toReference();
    }
}

