/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.helpers.erasure.ErasureHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.WontDoJobException;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import org.w3c.dom.Element;

public abstract class AbstractErasureTask
extends BaseLongRunningTask<EntityReference<ErasureRequest>> {
    public static final String TAG_ERROR = "task-fail";
    protected static final String REQUEST_NUMBER = "requestNumber";
    protected EntityReference<ErasureRequest> ref;
    protected String requestNumber;

    protected void logError(Throwable error, LongRunningTask.EventsCallback callback) {
        IncidentsLog.reportException((String)String.format("error with erasure request %s", this.requestNumber), (Throwable)error);
        Message msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"task {0} failed", (Throwable)error, (Object[])new Object[]{this.getClass().getName()});
        this.auditError(msg);
        callback.addEvent(null, msg);
    }

    protected void logError(String text, LongRunningTask.EventsCallback callback) {
        IncidentsLog.reportStackTrace((String)String.format("error with erasure request %s: %s", this.requestNumber, text));
        Message msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"task {0} failed: {1}", (Object[])new Object[]{this.getClass().getName(), text});
        this.auditError(msg);
        callback.addEvent(null, msg);
    }

    protected void logAbortion(LongRunningTask.EventsCallback callback) {
        Message msg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task {0} aborted", (Object[])new Object[]{this.getClass().getName()});
        this.auditInfo(msg);
        callback.addEvent(null, msg);
    }

    protected void log(WontDoJobException e, LongRunningTask.EventsCallback callback) {
        Message msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"task {0} rejected to do job", (Throwable)e, (Object[])new Object[]{this.getClass().getName()});
        this.auditInfo(msg);
        callback.addEvent(null, msg);
    }

    protected void auditInfo(String text) {
        this.auditInfo(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)text, (Object[])new Object[0]));
    }

    protected void auditInfo(Message msg) {
        SysLogHelper.audit(this.ref, null, msg);
    }

    protected void auditError(Message msg) {
        SysLogHelper.audit(this.ref, TAG_ERROR, msg);
    }

    protected void save(EntityContainer<ErasureRequest> ctr, String source, LongRunningTask.EventsCallback callback) {
        try {
            StorageUtil.save(ctr, (String)source, (boolean)true);
        }
        catch (Throwable t) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"failed to save erasure request", (Throwable)t, (Object[])new Object[0]));
        }
    }

    protected String description(BaseAsset activeTask) {
        return activeTask instanceof LongRunningTaskInfo ? ErasureHelper.toIndexValue((LongRunningTaskInfo)activeTask) : activeTask.getClass().getName();
    }

    @Override
    public void configure(EntityReference<ErasureRequest> configuration) throws Exception {
        this.ref = configuration;
    }

    public void toXML(Element elm) throws Exception {
        this.ref.toXML(elm);
        XHelper.writeString((Element)elm, (String)REQUEST_NUMBER, (String)this.requestNumber);
    }

    public void fromXML(Element elm) throws Exception {
        this.ref = new EntityReference();
        this.ref.fromXML(elm);
        this.requestNumber = XHelper.readString((Element)elm, (String)REQUEST_NUMBER);
    }
}

