/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.restriction.converter.RestrictionsConverter;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.asset.LogicalAssetStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class AclEntriesUpdateTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AclEntriesUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("acl entries update started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String aclEntryTitle = uid;
            try {
                AclEntry entry = (AclEntry)AssetsStorage.get().load(AclEntry.class, uid);
                if (entry == null) continue;
                aclEntryTitle = entry.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing acl entry %s, %s of %s (%s%%)", aclEntryTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                for (AclRule rule : entry.getRules()) {
                    if (rule.getPropertyRestrictionGroups().size() <= 0) continue;
                    this.log.debug(String.format("processing rule %s", rule));
                    rule.getRestrictionGroups().clear();
                    rule.getRestrictionGroups().addAll(RestrictionsConverter.toRestrictionGroups((Collection)rule.getPropertyRestrictionGroups()));
                    save = true;
                }
                if (save) {
                    AssetsStorage.get().save((BaseAsset)entry, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update acl entry %s", aclEntryTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AclEntriesUpdateTask_aclEntryUpdateFailed, (Throwable)e, (Object[])new Object[]{aclEntryTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("acl entries update finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalAssetStorage assetStorage = LogicalStorage.get().getAssetStorage();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        this.toProceed.addAll(assetStorage.search(AclEntry.class, query).getData().stream().map(item -> item.getUid()).collect(Collectors.toSet()));
    }
}

