/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.registry.AclRegistryAsset;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AclMigrationTask
extends BaseLongRunningTask<Serializable> {
    private static final int GROUPS_PROGRESS = 5;
    private static final int USERS_PROGRESS = 85;
    private static final int ENTRIES_PROGRESS = 10;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AclMigrationTask_createPermissions, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("acl migration started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interrupted");
            return;
        }
        int n = 0;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)"acl-registry"));
        List assets = AssetsStorage.get().search(AclRegistryAsset.class, query).getData();
        if (assets.size() == 1) {
            AclRegistryAsset asset = (AclRegistryAsset)assets.get(0);
            try (ByteArrayInputStream is = new ByteArrayInputStream(asset.getData());){
                Document document = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)is));
                Element[] groupItemElements = XmlUtil.getElements((Element)document.getDocumentElement(), (String)"aclRegistry/principals/groups/item");
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AclMigrationTask_processingGroups, (Object[])new Object[]{String.valueOf(groupItemElements.length)}));
                this.log.debug(String.format("processing groups (total: %s)", String.valueOf(groupItemElements.length)));
                n = 0;
                for (Element groupItemElement : groupItemElements) {
                    String id;
                    byte progress = (byte)(5 * ++n / groupItemElements.length);
                    this.log.debug(String.format("processing group item %s of %s (%s%%)", String.valueOf(n), String.valueOf(groupItemElements.length), String.valueOf(progress)));
                    if (n % 5 == 0) {
                        callback.updateProgress(progress);
                    }
                    if ((id = XHelper.readString((Element)groupItemElement, (String)"id")) == null || id.equals(AclHelper.all.getId()) || id.equals(AclHelper.administators.getId())) continue;
                    String name = XHelper.readString((Element)groupItemElement, (String)"name");
                    String description = XHelper.readString((Element)groupItemElement, (String)"description");
                    String groupId = XHelper.readString((Element)groupItemElement, (String)"parent");
                    AclGroup group = new AclGroup();
                    group.setId(id);
                    group.setName(name);
                    group.setDescription(description);
                    group.setParentId(groupId);
                    com.gridnine.xtrip.server.security.acl.helper.AclHelper.saveGroup((AclGroup)group);
                    this.log.debug(String.format("create group %s", id));
                }
                Element[] userItemElements = XmlUtil.getElements((Element)document.getDocumentElement(), (String)"aclRegistry/principals/users/item");
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AclMigrationTask_processingUsers, (Object[])new Object[]{String.valueOf(userItemElements.length)}));
                this.log.debug(String.format("processing users (total: %s)", String.valueOf(userItemElements.length)));
                n = 0;
                for (Element userItemElement : userItemElements) {
                    Element[] userGroupItemElements;
                    String id;
                    byte progress = (byte)(5 + 85 * ++n / userItemElements.length);
                    this.log.debug(String.format("processing user item %s of %s (%s%%)", String.valueOf(n), String.valueOf(userItemElements.length), String.valueOf(progress)));
                    if (n % 50 == 0) {
                        callback.updateProgress(progress);
                    }
                    if ((id = XHelper.readString((Element)userItemElement, (String)"id")) == null || id.equals(AclHelper.system.getId()) || id.equals(AclHelper.admin.getId())) continue;
                    String name = XHelper.readString((Element)userItemElement, (String)"name");
                    String description = XHelper.readString((Element)userItemElement, (String)"description");
                    ArrayList<String> userGroupIds = new ArrayList<String>();
                    for (Element userGroupItemElement : userGroupItemElements = XmlUtil.getElements((Element)userItemElement, (String)"groups/group")) {
                        String userGroupId = XmlUtil.getValue((Element)userGroupItemElement);
                        if (userGroupId == null || userGroupIds.contains(userGroupId)) continue;
                        userGroupIds.add(userGroupId);
                    }
                    AclUser user = new AclUser();
                    user.setId(id);
                    user.setName(!TextUtil.isBlank((String)name) ? name : id);
                    user.setDescription(description);
                    user.getGroupIds().clear();
                    user.getGroupIds().addAll(userGroupIds);
                    com.gridnine.xtrip.server.security.acl.helper.AclHelper.saveUser((AclUser)user);
                    this.log.debug(String.format("create user %s", id));
                }
                Element[] aclItemElements = XmlUtil.getElements((Element)document.getDocumentElement(), (String)"aclRegistry/acls/item");
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AclMigrationTask_processingRules, (Object[])new Object[]{String.valueOf(aclItemElements.length)}));
                this.log.debug(String.format("processing acls (total: %s)", String.valueOf(aclItemElements.length)));
                n = 0;
                for (Element aclItemElement : aclItemElements) {
                    Element[] aclEntryItemElements;
                    String resourceId;
                    byte progress = (byte)(90 + 10 * ++n / aclItemElements.length);
                    this.log.debug(String.format("processing acl item %s of %s (%s%%)", String.valueOf(n), String.valueOf(aclItemElements.length), String.valueOf(progress)));
                    if (n % 5 == 0) {
                        callback.updateProgress(progress);
                    }
                    if ((resourceId = XHelper.readString((Element)aclItemElement, (String)"resource")) == null) continue;
                    for (Element aclEntryItemElement : aclEntryItemElements = XmlUtil.getElements((Element)aclItemElement, (String)"entries/item")) {
                        Element[] aclEntryRuleItemElements;
                        String principalId = XHelper.readString((Element)aclEntryItemElement, (String)"principal");
                        if (principalId == null) continue;
                        ArrayList<AclRule> rules = new ArrayList<AclRule>();
                        for (Element aclEntryRuleItemElement : aclEntryRuleItemElements = XmlUtil.getElements((Element)aclEntryItemElement, (String)"rules/item")) {
                            AclRule rule = (AclRule)XHelper.readObject((Element)aclEntryRuleItemElement, (String)".");
                            if (rule == null) continue;
                            rules.add(rule);
                        }
                        if (rules.size() <= 0) continue;
                        AclEntry entry = new AclEntry();
                        entry.setResourceId(resourceId);
                        entry.setPrincipalId(principalId);
                        entry.getRules().clear();
                        entry.getRules().addAll(rules);
                        com.gridnine.xtrip.server.security.acl.helper.AclHelper.saveEntry((AclEntry)entry);
                        this.log.debug(String.format("create entry %s/%s", resourceId, principalId));
                    }
                }
            }
        } else {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AclMigrationTask_dataRregistryPermissionsNotFound, (Object[])new Object[0]));
            this.log.warn(String.format("acl registry asset not found", new Object[0]));
        }
        callback.taskFinished();
        this.log.debug("acl migration finished");
    }
}

