/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class AclRegistrySynchronizationTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AclRegistrySynchronizationTask_synchronizingAccountsWithUsers, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("user account with acl user synchronization started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interrupted");
            return;
        }
        SearchQuery query = new SearchQuery();
        List userAccounts = AssetsStorage.get().search(UserAccount.class, query).getData();
        for (UserAccount userAccount : userAccounts) {
            AclUser user;
            if (userAccount.getLoginName().equals(AclHelper.system.getId()) || userAccount.getLoginName().equals(AclHelper.admin.getId()) || (user = (AclUser)AssetsStorage.get().find(AclUser.class, AclUser.Property.id.name(), (Object)userAccount.getLoginName())) != null) continue;
            user = new AclUser();
            user.setId(userAccount.getLoginName());
            user.setName(!TextUtil.isBlank((String)userAccount.getFullName()) ? userAccount.getFullName().trim() : userAccount.getLoginName());
            if (!TextUtil.isBlank((String)userAccount.getNotes())) {
                user.setDescription(userAccount.getNotes().trim());
            }
            user.getGroupIds().add(AclHelper.all.getId());
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.AclRegistrySynchronizationTask_addedUserWithId, (Object[])new Object[]{user.getId()}), (Object[])new Object[0]));
            this.log.warn(String.format("user with id \"%s\" was added", user.getId()));
            AssetsStorage.get().save((BaseAsset)user);
        }
        callback.taskFinished();
        this.log.debug("user account with acl user synchronization finished");
    }
}

