/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddSpellingVariantsToAirlineDictTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.addSpellingVariantsToAirlineDict, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        try {
            HashMap airlineSpellings = new HashMap();
            File file = new File("config/xtrip/server/setup/dict/Airline.xml");
            if (!file.exists()) {
                file = new File("config/server/setup/dict/Airline.xml");
            }
            Document sourceDocument = AddSpellingVariantsToAirlineDictTask.getSourceDocument(file);
            Element root = sourceDocument.getDocumentElement();
            for (Element elm : XmlUtil.getElements((Element)root, (String)"object")) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                String code = XHelper.readString((Element)elm, (String)"code");
                ArrayList<String> spellVariants = new ArrayList<String>();
                for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"spellVariants/item")) {
                    spellVariants.add(XmlUtil.getValue((Element)itemElm));
                }
                airlineSpellings.put(code, spellVariants);
            }
            Collection airlines = DictionaryCache.get().getAll(Airline.class).values();
            int n = 0;
            int count = airlines.size();
            for (Airline airline : airlines) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (airlineSpellings.containsKey(airline.getCode())) {
                    boolean wasUpdated = false;
                    for (String spell : (List)airlineSpellings.get(airline.getCode())) {
                        if (airline.getSpellVariants().contains(spell)) continue;
                        airline.getSpellVariants().add(spell);
                        wasUpdated = true;
                    }
                    if (wasUpdated) {
                        airline.setDataSource("AddSpellingVariantsToAirlineDictTask");
                        DictionaryStorage.get().save((BaseDictionary)airline);
                    }
                }
                byte progress = (byte)(100 * ++n / count);
                if (n % 10 != 0) continue;
                callback.updateProgress(progress);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.addSpellingVariantsToAirlineDict_error, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.addSpellingVariantsToAirlineDict_success, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }

    private static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }
}

