/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class AfsSettingsTransformTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AfsSettingsTransformTask_resavingSettingsAFSStatistics, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("BEGIN AFS statistics transform task");
        try {
            List<EntityContainer<Organization>> profilesCont = this.getProfiles();
            int num = 0;
            for (EntityContainer<Organization> orgCont : profilesCont) {
                ++num;
                Organization org = (Organization)orgCont.getEntity();
                if (org == null) continue;
                boolean hasChanges = false;
                String afsSettings = org.getAfsSettings();
                if (afsSettings == null) {
                    afsSettings = "";
                }
                if (org.isSabreStatistics()) {
                    if (!afsSettings.contains(AFSType.AFSTKT.name())) {
                        afsSettings = AFSType.AFSTKT.name() + (afsSettings.length() > 0 ? "|" + afsSettings : "");
                        hasChanges = true;
                    }
                } else if (afsSettings.contains(AFSType.AFSTKT.name())) {
                    String[] afsSettingsParts = afsSettings.split("\\|");
                    if (afsSettingsParts.length == 1) {
                        afsSettings = "";
                    } else {
                        StringBuilder afsSettingsBuilder = new StringBuilder();
                        for (int i = 1; i < afsSettingsParts.length; ++i) {
                            afsSettingsBuilder.append((afsSettingsBuilder.length() > 0 ? "|" : "") + afsSettingsParts[i]);
                        }
                        afsSettings = afsSettingsBuilder.toString();
                    }
                    hasChanges = true;
                }
                if (num % 20 == 0) {
                    byte progress = (byte)(100 * num / profilesCont.size());
                    callback.updateProgress(progress);
                }
                if (!hasChanges) continue;
                org.setAfsSettings(afsSettings);
                EntityStorage.get().save(orgCont, false);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AfsSettingsTransformTask_errorResavingSettingsAFSStatistics, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            this.log.debug("END AFS statistics transform task");
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AfsSettingsTransformTask_completedResavingUDID, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EntityContainer<Organization>> getProfiles() throws Exception {
        ArrayList<EntityContainer<Organization>> res = new ArrayList<EntityContainer<Organization>>();
        LogicalSession managedSession = null;
        try {
            managedSession = LogicalStorage.get().beginUnitOfWork();
            List orgIndexes = EntityStorage.get().search(OrganizationIndex.class, new SearchQuery()).getData();
            for (OrganizationIndex orgIndex : orgIndexes) {
                EntityContainer orgCont = EntityStorage.get().resolve(orgIndex.getSource());
                if (orgCont == null) continue;
                res.add((EntityContainer<Organization>)orgCont);
            }
        }
        finally {
            if (managedSession != null) {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
            }
        }
        return res;
    }
}

